/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.fx.accruals;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.fx.accruals.FxAccrualSettlementPeriodPayoff;
import fpml.consolidated.fx.accruals.meta.FxAccrualSettlementPeriodMeta;
import fpml.consolidated.fx.targets.FxSettlementPeriodBarrier;
import fpml.consolidated.fx.targets.SettlementPeriod;
import fpml.consolidated.fx.targets.SettlementPeriodFixingDates;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="FxAccrualSettlementPeriod", builder=FxAccrualSettlementPeriodBuilderImpl.class, version="1.2.2")
@RuneDataType(value="FxAccrualSettlementPeriod", model="fpml", builder=FxAccrualSettlementPeriodBuilderImpl.class, version="1.2.2")
public interface FxAccrualSettlementPeriod
extends SettlementPeriod {
    public static final FxAccrualSettlementPeriodMeta metaData = new FxAccrualSettlementPeriodMeta();

    public List<? extends FxAccrualSettlementPeriodPayoff> getPayoff();

    public BigDecimal getAccrualFactor();

    public FxSettlementPeriodBarrier getBarrier();

    public SettlementPeriodFixingDates getAccrualFixingDates();

    @Override
    public FxAccrualSettlementPeriod build();

    @Override
    public FxAccrualSettlementPeriodBuilder toBuilder();

    public static FxAccrualSettlementPeriodBuilder builder() {
        return new FxAccrualSettlementPeriodBuilderImpl();
    }

    default public RosettaMetaData<? extends FxAccrualSettlementPeriod> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends FxAccrualSettlementPeriod> getType() {
        return FxAccrualSettlementPeriod.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("expiryDate"), ZonedDateTime.class, (Object)this.getExpiryDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("settlementDate"), ZonedDateTime.class, (Object)this.getSettlementDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("notionalAmount"), BigDecimal.class, (Object)this.getNotionalAmount(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("payoff"), processor, FxAccrualSettlementPeriodPayoff.class, this.getPayoff(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("accrualFactor"), BigDecimal.class, (Object)this.getAccrualFactor(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("barrier"), processor, FxSettlementPeriodBarrier.class, this.getBarrier(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("accrualFixingDates"), processor, SettlementPeriodFixingDates.class, this.getAccrualFixingDates(), new AttributeMeta[0]);
    }

    public static class FxAccrualSettlementPeriodBuilderImpl
    extends SettlementPeriod.SettlementPeriodBuilderImpl
    implements FxAccrualSettlementPeriodBuilder {
        protected List<FxAccrualSettlementPeriodPayoff.FxAccrualSettlementPeriodPayoffBuilder> payoff = new ArrayList<FxAccrualSettlementPeriodPayoff.FxAccrualSettlementPeriodPayoffBuilder>();
        protected BigDecimal accrualFactor;
        protected FxSettlementPeriodBarrier.FxSettlementPeriodBarrierBuilder barrier;
        protected SettlementPeriodFixingDates.SettlementPeriodFixingDatesBuilder accrualFixingDates;

        @Override
        @RosettaAttribute(value="payoff", isRequired=true)
        @RuneAttribute(value="payoff", isRequired=true)
        public List<? extends FxAccrualSettlementPeriodPayoff.FxAccrualSettlementPeriodPayoffBuilder> getPayoff() {
            return this.payoff;
        }

        @Override
        public FxAccrualSettlementPeriodPayoff.FxAccrualSettlementPeriodPayoffBuilder getOrCreatePayoff(int index) {
            if (this.payoff == null) {
                this.payoff = new ArrayList<FxAccrualSettlementPeriodPayoff.FxAccrualSettlementPeriodPayoffBuilder>();
            }
            return (FxAccrualSettlementPeriodPayoff.FxAccrualSettlementPeriodPayoffBuilder)this.getIndex(this.payoff, index, () -> {
                FxAccrualSettlementPeriodPayoff.FxAccrualSettlementPeriodPayoffBuilder newPayoff = FxAccrualSettlementPeriodPayoff.builder();
                return newPayoff;
            });
        }

        @Override
        @RosettaAttribute(value="accrualFactor")
        @RuneAttribute(value="accrualFactor")
        public BigDecimal getAccrualFactor() {
            return this.accrualFactor;
        }

        @Override
        @RosettaAttribute(value="barrier")
        @RuneAttribute(value="barrier")
        public FxSettlementPeriodBarrier.FxSettlementPeriodBarrierBuilder getBarrier() {
            return this.barrier;
        }

        @Override
        public FxSettlementPeriodBarrier.FxSettlementPeriodBarrierBuilder getOrCreateBarrier() {
            FxSettlementPeriodBarrier.FxSettlementPeriodBarrierBuilder result = this.barrier != null ? this.barrier : (this.barrier = FxSettlementPeriodBarrier.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="accrualFixingDates", isRequired=true)
        @RuneAttribute(value="accrualFixingDates", isRequired=true)
        public SettlementPeriodFixingDates.SettlementPeriodFixingDatesBuilder getAccrualFixingDates() {
            return this.accrualFixingDates;
        }

        @Override
        public SettlementPeriodFixingDates.SettlementPeriodFixingDatesBuilder getOrCreateAccrualFixingDates() {
            SettlementPeriodFixingDates.SettlementPeriodFixingDatesBuilder result = this.accrualFixingDates != null ? this.accrualFixingDates : (this.accrualFixingDates = SettlementPeriodFixingDates.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="expiryDate", isRequired=true)
        @RuneAttribute(value="expiryDate", isRequired=true)
        public FxAccrualSettlementPeriodBuilder setExpiryDate(ZonedDateTime _expiryDate) {
            this.expiryDate = _expiryDate == null ? null : _expiryDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="settlementDate", isRequired=true)
        @RuneAttribute(value="settlementDate", isRequired=true)
        public FxAccrualSettlementPeriodBuilder setSettlementDate(ZonedDateTime _settlementDate) {
            this.settlementDate = _settlementDate == null ? null : _settlementDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="notionalAmount", isRequired=true)
        @RuneAttribute(value="notionalAmount", isRequired=true)
        public FxAccrualSettlementPeriodBuilder setNotionalAmount(BigDecimal _notionalAmount) {
            this.notionalAmount = _notionalAmount == null ? null : _notionalAmount;
            return this;
        }

        @Override
        @RosettaAttribute(value="payoff", isRequired=true)
        @RuneAttribute(value="payoff", isRequired=true)
        public FxAccrualSettlementPeriodBuilder addPayoff(FxAccrualSettlementPeriodPayoff _payoff) {
            if (_payoff != null) {
                this.payoff.add(_payoff.toBuilder());
            }
            return this;
        }

        @Override
        public FxAccrualSettlementPeriodBuilder addPayoff(FxAccrualSettlementPeriodPayoff _payoff, int idx) {
            this.getIndex(this.payoff, idx, () -> _payoff.toBuilder());
            return this;
        }

        @Override
        public FxAccrualSettlementPeriodBuilder addPayoff(List<? extends FxAccrualSettlementPeriodPayoff> payoffs) {
            if (payoffs != null) {
                for (FxAccrualSettlementPeriodPayoff fxAccrualSettlementPeriodPayoff : payoffs) {
                    this.payoff.add(fxAccrualSettlementPeriodPayoff.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="payoff")
        public FxAccrualSettlementPeriodBuilder setPayoff(List<? extends FxAccrualSettlementPeriodPayoff> payoffs) {
            this.payoff = payoffs == null ? new ArrayList<FxAccrualSettlementPeriodPayoff.FxAccrualSettlementPeriodPayoffBuilder>() : (List)payoffs.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="accrualFactor")
        @RuneAttribute(value="accrualFactor")
        public FxAccrualSettlementPeriodBuilder setAccrualFactor(BigDecimal _accrualFactor) {
            this.accrualFactor = _accrualFactor == null ? null : _accrualFactor;
            return this;
        }

        @Override
        @RosettaAttribute(value="barrier")
        @RuneAttribute(value="barrier")
        public FxAccrualSettlementPeriodBuilder setBarrier(FxSettlementPeriodBarrier _barrier) {
            this.barrier = _barrier == null ? null : _barrier.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="accrualFixingDates", isRequired=true)
        @RuneAttribute(value="accrualFixingDates", isRequired=true)
        public FxAccrualSettlementPeriodBuilder setAccrualFixingDates(SettlementPeriodFixingDates _accrualFixingDates) {
            this.accrualFixingDates = _accrualFixingDates == null ? null : _accrualFixingDates.toBuilder();
            return this;
        }

        @Override
        public FxAccrualSettlementPeriod build() {
            return new FxAccrualSettlementPeriodImpl(this);
        }

        @Override
        public FxAccrualSettlementPeriodBuilder toBuilder() {
            return this;
        }

        @Override
        public FxAccrualSettlementPeriodBuilder prune() {
            super.prune();
            this.payoff = this.payoff.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.barrier != null && !this.barrier.prune().hasData()) {
                this.barrier = null;
            }
            if (this.accrualFixingDates != null && !this.accrualFixingDates.prune().hasData()) {
                this.accrualFixingDates = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getPayoff() != null && this.getPayoff().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getAccrualFactor() != null) {
                return true;
            }
            if (this.getBarrier() != null && this.getBarrier().hasData()) {
                return true;
            }
            return this.getAccrualFixingDates() != null && this.getAccrualFixingDates().hasData();
        }

        @Override
        public FxAccrualSettlementPeriodBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            FxAccrualSettlementPeriodBuilder o = (FxAccrualSettlementPeriodBuilder)other;
            merger.mergeRosetta(this.getPayoff(), o.getPayoff(), this::getOrCreatePayoff);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getBarrier(), (RosettaModelObjectBuilder)o.getBarrier(), this::setBarrier);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAccrualFixingDates(), (RosettaModelObjectBuilder)o.getAccrualFixingDates(), this::setAccrualFixingDates);
            merger.mergeBasic((Object)this.getAccrualFactor(), (Object)o.getAccrualFactor(), this::setAccrualFactor, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            FxAccrualSettlementPeriod _that = (FxAccrualSettlementPeriod)this.getType().cast(o);
            if (!ListEquals.listEquals(this.payoff, _that.getPayoff())) {
                return false;
            }
            if (!Objects.equals(this.accrualFactor, _that.getAccrualFactor())) {
                return false;
            }
            if (!Objects.equals(this.barrier, _that.getBarrier())) {
                return false;
            }
            return Objects.equals(this.accrualFixingDates, _that.getAccrualFixingDates());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.payoff != null ? this.payoff.hashCode() : 0);
            _result = 31 * _result + (this.accrualFactor != null ? this.accrualFactor.hashCode() : 0);
            _result = 31 * _result + (this.barrier != null ? this.barrier.hashCode() : 0);
            _result = 31 * _result + (this.accrualFixingDates != null ? this.accrualFixingDates.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "FxAccrualSettlementPeriodBuilder {payoff=" + String.valueOf(this.payoff) + ", accrualFactor=" + String.valueOf(this.accrualFactor) + ", barrier=" + String.valueOf(this.barrier) + ", accrualFixingDates=" + String.valueOf(this.accrualFixingDates) + "} " + super.toString();
        }
    }

    public static interface FxAccrualSettlementPeriodBuilder
    extends FxAccrualSettlementPeriod,
    SettlementPeriod.SettlementPeriodBuilder {
        public FxAccrualSettlementPeriodPayoff.FxAccrualSettlementPeriodPayoffBuilder getOrCreatePayoff(int var1);

        public List<? extends FxAccrualSettlementPeriodPayoff.FxAccrualSettlementPeriodPayoffBuilder> getPayoff();

        public FxSettlementPeriodBarrier.FxSettlementPeriodBarrierBuilder getOrCreateBarrier();

        @Override
        public FxSettlementPeriodBarrier.FxSettlementPeriodBarrierBuilder getBarrier();

        public SettlementPeriodFixingDates.SettlementPeriodFixingDatesBuilder getOrCreateAccrualFixingDates();

        @Override
        public SettlementPeriodFixingDates.SettlementPeriodFixingDatesBuilder getAccrualFixingDates();

        @Override
        public FxAccrualSettlementPeriodBuilder setExpiryDate(ZonedDateTime var1);

        @Override
        public FxAccrualSettlementPeriodBuilder setSettlementDate(ZonedDateTime var1);

        @Override
        public FxAccrualSettlementPeriodBuilder setNotionalAmount(BigDecimal var1);

        public FxAccrualSettlementPeriodBuilder addPayoff(FxAccrualSettlementPeriodPayoff var1);

        public FxAccrualSettlementPeriodBuilder addPayoff(FxAccrualSettlementPeriodPayoff var1, int var2);

        public FxAccrualSettlementPeriodBuilder addPayoff(List<? extends FxAccrualSettlementPeriodPayoff> var1);

        public FxAccrualSettlementPeriodBuilder setPayoff(List<? extends FxAccrualSettlementPeriodPayoff> var1);

        public FxAccrualSettlementPeriodBuilder setAccrualFactor(BigDecimal var1);

        public FxAccrualSettlementPeriodBuilder setBarrier(FxSettlementPeriodBarrier var1);

        public FxAccrualSettlementPeriodBuilder setAccrualFixingDates(SettlementPeriodFixingDates var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("expiryDate"), ZonedDateTime.class, (Object)this.getExpiryDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("settlementDate"), ZonedDateTime.class, (Object)this.getSettlementDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("notionalAmount"), BigDecimal.class, (Object)this.getNotionalAmount(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("payoff"), processor, FxAccrualSettlementPeriodPayoff.FxAccrualSettlementPeriodPayoffBuilder.class, this.getPayoff(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("accrualFactor"), BigDecimal.class, (Object)this.getAccrualFactor(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("barrier"), processor, FxSettlementPeriodBarrier.FxSettlementPeriodBarrierBuilder.class, this.getBarrier(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("accrualFixingDates"), processor, SettlementPeriodFixingDates.SettlementPeriodFixingDatesBuilder.class, this.getAccrualFixingDates(), new AttributeMeta[0]);
        }

        @Override
        public FxAccrualSettlementPeriodBuilder prune();
    }

    public static class FxAccrualSettlementPeriodImpl
    extends SettlementPeriod.SettlementPeriodImpl
    implements FxAccrualSettlementPeriod {
        private final List<? extends FxAccrualSettlementPeriodPayoff> payoff;
        private final BigDecimal accrualFactor;
        private final FxSettlementPeriodBarrier barrier;
        private final SettlementPeriodFixingDates accrualFixingDates;

        protected FxAccrualSettlementPeriodImpl(FxAccrualSettlementPeriodBuilder builder) {
            super(builder);
            this.payoff = Optional.ofNullable(builder.getPayoff()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.accrualFactor = builder.getAccrualFactor();
            this.barrier = Optional.ofNullable(builder.getBarrier()).map(f -> f.build()).orElse(null);
            this.accrualFixingDates = Optional.ofNullable(builder.getAccrualFixingDates()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="payoff", isRequired=true)
        @RuneAttribute(value="payoff", isRequired=true)
        public List<? extends FxAccrualSettlementPeriodPayoff> getPayoff() {
            return this.payoff;
        }

        @Override
        @RosettaAttribute(value="accrualFactor")
        @RuneAttribute(value="accrualFactor")
        public BigDecimal getAccrualFactor() {
            return this.accrualFactor;
        }

        @Override
        @RosettaAttribute(value="barrier")
        @RuneAttribute(value="barrier")
        public FxSettlementPeriodBarrier getBarrier() {
            return this.barrier;
        }

        @Override
        @RosettaAttribute(value="accrualFixingDates", isRequired=true)
        @RuneAttribute(value="accrualFixingDates", isRequired=true)
        public SettlementPeriodFixingDates getAccrualFixingDates() {
            return this.accrualFixingDates;
        }

        @Override
        public FxAccrualSettlementPeriod build() {
            return this;
        }

        @Override
        public FxAccrualSettlementPeriodBuilder toBuilder() {
            FxAccrualSettlementPeriodBuilder builder = FxAccrualSettlementPeriod.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(FxAccrualSettlementPeriodBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getPayoff()).ifPresent(builder::setPayoff);
            Optional.ofNullable(this.getAccrualFactor()).ifPresent(builder::setAccrualFactor);
            Optional.ofNullable(this.getBarrier()).ifPresent(builder::setBarrier);
            Optional.ofNullable(this.getAccrualFixingDates()).ifPresent(builder::setAccrualFixingDates);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            FxAccrualSettlementPeriod _that = (FxAccrualSettlementPeriod)this.getType().cast(o);
            if (!ListEquals.listEquals(this.payoff, _that.getPayoff())) {
                return false;
            }
            if (!Objects.equals(this.accrualFactor, _that.getAccrualFactor())) {
                return false;
            }
            if (!Objects.equals(this.barrier, _that.getBarrier())) {
                return false;
            }
            return Objects.equals(this.accrualFixingDates, _that.getAccrualFixingDates());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.payoff != null ? this.payoff.hashCode() : 0);
            _result = 31 * _result + (this.accrualFactor != null ? this.accrualFactor.hashCode() : 0);
            _result = 31 * _result + (this.barrier != null ? this.barrier.hashCode() : 0);
            _result = 31 * _result + (this.accrualFixingDates != null ? this.accrualFixingDates.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "FxAccrualSettlementPeriod {payoff=" + String.valueOf(this.payoff) + ", accrualFactor=" + String.valueOf(this.accrualFactor) + ", barrier=" + String.valueOf(this.barrier) + ", accrualFixingDates=" + String.valueOf(this.accrualFixingDates) + "} " + super.toString();
        }
    }
}

