/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.fx;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.fpmlenum.PayoutEnum;
import fpml.consolidated.fx.meta.FxOptionPayoutMeta;
import fpml.consolidated.shared.Currency;
import fpml.consolidated.shared.NonNegativeMoney;
import fpml.consolidated.shared.SettlementInformation;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="FxOptionPayout", builder=FxOptionPayoutBuilderImpl.class, version="1.2.2")
@RuneDataType(value="FxOptionPayout", model="fpml", builder=FxOptionPayoutBuilderImpl.class, version="1.2.2")
public interface FxOptionPayout
extends NonNegativeMoney {
    public static final FxOptionPayoutMeta metaData = new FxOptionPayoutMeta();

    public PayoutEnum getPayoutStyle();

    public SettlementInformation getSettlementInformation();

    @Override
    public FxOptionPayout build();

    @Override
    public FxOptionPayoutBuilder toBuilder();

    public static FxOptionPayoutBuilder builder() {
        return new FxOptionPayoutBuilderImpl();
    }

    default public RosettaMetaData<? extends FxOptionPayout> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends FxOptionPayout> getType() {
        return FxOptionPayout.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("currency"), processor, Currency.class, this.getCurrency(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("amount"), BigDecimal.class, (Object)this.getAmount(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("payoutStyle"), PayoutEnum.class, (Object)this.getPayoutStyle(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("settlementInformation"), processor, SettlementInformation.class, this.getSettlementInformation(), new AttributeMeta[0]);
    }

    public static class FxOptionPayoutBuilderImpl
    extends NonNegativeMoney.NonNegativeMoneyBuilderImpl
    implements FxOptionPayoutBuilder {
        protected PayoutEnum payoutStyle;
        protected SettlementInformation.SettlementInformationBuilder settlementInformation;

        @Override
        @RosettaAttribute(value="payoutStyle")
        @RuneAttribute(value="payoutStyle")
        public PayoutEnum getPayoutStyle() {
            return this.payoutStyle;
        }

        @Override
        @RosettaAttribute(value="settlementInformation")
        @RuneAttribute(value="settlementInformation")
        public SettlementInformation.SettlementInformationBuilder getSettlementInformation() {
            return this.settlementInformation;
        }

        @Override
        public SettlementInformation.SettlementInformationBuilder getOrCreateSettlementInformation() {
            SettlementInformation.SettlementInformationBuilder result = this.settlementInformation != null ? this.settlementInformation : (this.settlementInformation = SettlementInformation.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="currency", isRequired=true)
        @RuneAttribute(value="currency", isRequired=true)
        public FxOptionPayoutBuilder setCurrency(Currency _currency) {
            this.currency = _currency == null ? null : _currency.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public FxOptionPayoutBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="amount", isRequired=true)
        @RuneAttribute(value="amount", isRequired=true)
        public FxOptionPayoutBuilder setAmount(BigDecimal _amount) {
            this.amount = _amount == null ? null : _amount;
            return this;
        }

        @Override
        @RosettaAttribute(value="payoutStyle")
        @RuneAttribute(value="payoutStyle")
        public FxOptionPayoutBuilder setPayoutStyle(PayoutEnum _payoutStyle) {
            this.payoutStyle = _payoutStyle == null ? null : _payoutStyle;
            return this;
        }

        @Override
        @RosettaAttribute(value="settlementInformation")
        @RuneAttribute(value="settlementInformation")
        public FxOptionPayoutBuilder setSettlementInformation(SettlementInformation _settlementInformation) {
            this.settlementInformation = _settlementInformation == null ? null : _settlementInformation.toBuilder();
            return this;
        }

        @Override
        public FxOptionPayout build() {
            return new FxOptionPayoutImpl(this);
        }

        @Override
        public FxOptionPayoutBuilder toBuilder() {
            return this;
        }

        @Override
        public FxOptionPayoutBuilder prune() {
            super.prune();
            if (this.settlementInformation != null && !this.settlementInformation.prune().hasData()) {
                this.settlementInformation = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getPayoutStyle() != null) {
                return true;
            }
            return this.getSettlementInformation() != null && this.getSettlementInformation().hasData();
        }

        @Override
        public FxOptionPayoutBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            FxOptionPayoutBuilder o = (FxOptionPayoutBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getSettlementInformation(), (RosettaModelObjectBuilder)o.getSettlementInformation(), this::setSettlementInformation);
            merger.mergeBasic((Object)this.getPayoutStyle(), (Object)o.getPayoutStyle(), this::setPayoutStyle, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            FxOptionPayout _that = (FxOptionPayout)this.getType().cast(o);
            if (!Objects.equals((Object)this.payoutStyle, (Object)_that.getPayoutStyle())) {
                return false;
            }
            return Objects.equals(this.settlementInformation, _that.getSettlementInformation());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.payoutStyle != null ? ((Object)((Object)this.payoutStyle)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.settlementInformation != null ? this.settlementInformation.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "FxOptionPayoutBuilder {payoutStyle=" + String.valueOf((Object)this.payoutStyle) + ", settlementInformation=" + String.valueOf(this.settlementInformation) + "} " + super.toString();
        }
    }

    public static interface FxOptionPayoutBuilder
    extends FxOptionPayout,
    NonNegativeMoney.NonNegativeMoneyBuilder {
        public SettlementInformation.SettlementInformationBuilder getOrCreateSettlementInformation();

        @Override
        public SettlementInformation.SettlementInformationBuilder getSettlementInformation();

        @Override
        public FxOptionPayoutBuilder setCurrency(Currency var1);

        @Override
        public FxOptionPayoutBuilder setId(String var1);

        @Override
        public FxOptionPayoutBuilder setAmount(BigDecimal var1);

        public FxOptionPayoutBuilder setPayoutStyle(PayoutEnum var1);

        public FxOptionPayoutBuilder setSettlementInformation(SettlementInformation var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("currency"), processor, Currency.CurrencyBuilder.class, (RosettaModelObjectBuilder)this.getCurrency(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("amount"), BigDecimal.class, (Object)this.getAmount(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("payoutStyle"), PayoutEnum.class, (Object)this.getPayoutStyle(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("settlementInformation"), processor, SettlementInformation.SettlementInformationBuilder.class, this.getSettlementInformation(), new AttributeMeta[0]);
        }

        @Override
        public FxOptionPayoutBuilder prune();
    }

    public static class FxOptionPayoutImpl
    extends NonNegativeMoney.NonNegativeMoneyImpl
    implements FxOptionPayout {
        private final PayoutEnum payoutStyle;
        private final SettlementInformation settlementInformation;

        protected FxOptionPayoutImpl(FxOptionPayoutBuilder builder) {
            super(builder);
            this.payoutStyle = builder.getPayoutStyle();
            this.settlementInformation = Optional.ofNullable(builder.getSettlementInformation()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="payoutStyle")
        @RuneAttribute(value="payoutStyle")
        public PayoutEnum getPayoutStyle() {
            return this.payoutStyle;
        }

        @Override
        @RosettaAttribute(value="settlementInformation")
        @RuneAttribute(value="settlementInformation")
        public SettlementInformation getSettlementInformation() {
            return this.settlementInformation;
        }

        @Override
        public FxOptionPayout build() {
            return this;
        }

        @Override
        public FxOptionPayoutBuilder toBuilder() {
            FxOptionPayoutBuilder builder = FxOptionPayout.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(FxOptionPayoutBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getPayoutStyle()).ifPresent(builder::setPayoutStyle);
            Optional.ofNullable(this.getSettlementInformation()).ifPresent(builder::setSettlementInformation);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            FxOptionPayout _that = (FxOptionPayout)this.getType().cast(o);
            if (!Objects.equals((Object)this.payoutStyle, (Object)_that.getPayoutStyle())) {
                return false;
            }
            return Objects.equals(this.settlementInformation, _that.getSettlementInformation());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.payoutStyle != null ? ((Object)((Object)this.payoutStyle)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.settlementInformation != null ? this.settlementInformation.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "FxOptionPayout {payoutStyle=" + String.valueOf((Object)this.payoutStyle) + ", settlementInformation=" + String.valueOf(this.settlementInformation) + "} " + super.toString();
        }
    }
}

