/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.eq.shared;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.asset.ExchangeTradedContract;
import fpml.consolidated.eq.shared.BoundedVariance;
import fpml.consolidated.eq.shared.CalculationFromObservation;
import fpml.consolidated.eq.shared.CalculationFromObservationChoice;
import fpml.consolidated.eq.shared.meta.VarianceMeta;
import fpml.consolidated.shared.NonNegativeMoney;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="Variance", builder=VarianceBuilderImpl.class, version="1.2.2")
@RuneDataType(value="Variance", model="fpml", builder=VarianceBuilderImpl.class, version="1.2.2")
public interface Variance
extends CalculationFromObservation {
    public static final VarianceMeta metaData = new VarianceMeta();

    public NonNegativeMoney getVarianceAmount();

    public BigDecimal getVolatilityStrikePrice();

    public BigDecimal getVarianceStrikePrice();

    public Boolean getVarianceCap();

    public BigDecimal getUnadjustedVarianceCap();

    public BoundedVariance getBoundedVariance();

    public ExchangeTradedContract getExchangeTradedContractNearest();

    public BigDecimal getVegaNotionalAmount();

    @Override
    public Variance build();

    @Override
    public VarianceBuilder toBuilder();

    public static VarianceBuilder builder() {
        return new VarianceBuilderImpl();
    }

    default public RosettaMetaData<? extends Variance> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends Variance> getType() {
        return Variance.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("calculationFromObservationChoice"), processor, CalculationFromObservationChoice.class, this.getCalculationFromObservationChoice(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("closingLevel"), Boolean.class, (Object)this.getClosingLevel(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("expiringLevel"), Boolean.class, (Object)this.getExpiringLevel(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("expectedN"), Integer.class, (Object)this.getExpectedN(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("varianceAmount"), processor, NonNegativeMoney.class, this.getVarianceAmount(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("volatilityStrikePrice"), BigDecimal.class, (Object)this.getVolatilityStrikePrice(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("varianceStrikePrice"), BigDecimal.class, (Object)this.getVarianceStrikePrice(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("varianceCap"), Boolean.class, (Object)this.getVarianceCap(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("unadjustedVarianceCap"), BigDecimal.class, (Object)this.getUnadjustedVarianceCap(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("boundedVariance"), processor, BoundedVariance.class, this.getBoundedVariance(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("exchangeTradedContractNearest"), processor, ExchangeTradedContract.class, this.getExchangeTradedContractNearest(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("vegaNotionalAmount"), BigDecimal.class, (Object)this.getVegaNotionalAmount(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class VarianceBuilderImpl
    extends CalculationFromObservation.CalculationFromObservationBuilderImpl
    implements VarianceBuilder {
        protected NonNegativeMoney.NonNegativeMoneyBuilder varianceAmount;
        protected BigDecimal volatilityStrikePrice;
        protected BigDecimal varianceStrikePrice;
        protected Boolean varianceCap;
        protected BigDecimal unadjustedVarianceCap;
        protected BoundedVariance.BoundedVarianceBuilder boundedVariance;
        protected ExchangeTradedContract.ExchangeTradedContractBuilder exchangeTradedContractNearest;
        protected BigDecimal vegaNotionalAmount;

        @Override
        @RosettaAttribute(value="varianceAmount", isRequired=true)
        @RuneAttribute(value="varianceAmount", isRequired=true)
        public NonNegativeMoney.NonNegativeMoneyBuilder getVarianceAmount() {
            return this.varianceAmount;
        }

        @Override
        public NonNegativeMoney.NonNegativeMoneyBuilder getOrCreateVarianceAmount() {
            NonNegativeMoney.NonNegativeMoneyBuilder result = this.varianceAmount != null ? this.varianceAmount : (this.varianceAmount = NonNegativeMoney.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="volatilityStrikePrice")
        @RuneAttribute(value="volatilityStrikePrice")
        public BigDecimal getVolatilityStrikePrice() {
            return this.volatilityStrikePrice;
        }

        @Override
        @RosettaAttribute(value="varianceStrikePrice")
        @RuneAttribute(value="varianceStrikePrice")
        public BigDecimal getVarianceStrikePrice() {
            return this.varianceStrikePrice;
        }

        @Override
        @RosettaAttribute(value="varianceCap")
        @RuneAttribute(value="varianceCap")
        public Boolean getVarianceCap() {
            return this.varianceCap;
        }

        @Override
        @RosettaAttribute(value="unadjustedVarianceCap")
        @RuneAttribute(value="unadjustedVarianceCap")
        public BigDecimal getUnadjustedVarianceCap() {
            return this.unadjustedVarianceCap;
        }

        @Override
        @RosettaAttribute(value="boundedVariance")
        @RuneAttribute(value="boundedVariance")
        public BoundedVariance.BoundedVarianceBuilder getBoundedVariance() {
            return this.boundedVariance;
        }

        @Override
        public BoundedVariance.BoundedVarianceBuilder getOrCreateBoundedVariance() {
            BoundedVariance.BoundedVarianceBuilder result = this.boundedVariance != null ? this.boundedVariance : (this.boundedVariance = BoundedVariance.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="exchangeTradedContractNearest")
        @RuneAttribute(value="exchangeTradedContractNearest")
        public ExchangeTradedContract.ExchangeTradedContractBuilder getExchangeTradedContractNearest() {
            return this.exchangeTradedContractNearest;
        }

        @Override
        public ExchangeTradedContract.ExchangeTradedContractBuilder getOrCreateExchangeTradedContractNearest() {
            ExchangeTradedContract.ExchangeTradedContractBuilder result = this.exchangeTradedContractNearest != null ? this.exchangeTradedContractNearest : (this.exchangeTradedContractNearest = ExchangeTradedContract.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="vegaNotionalAmount")
        @RuneAttribute(value="vegaNotionalAmount")
        public BigDecimal getVegaNotionalAmount() {
            return this.vegaNotionalAmount;
        }

        @Override
        @RosettaAttribute(value="calculationFromObservationChoice")
        @RuneAttribute(value="calculationFromObservationChoice")
        public VarianceBuilder setCalculationFromObservationChoice(CalculationFromObservationChoice _calculationFromObservationChoice) {
            this.calculationFromObservationChoice = _calculationFromObservationChoice == null ? null : _calculationFromObservationChoice.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="closingLevel")
        @RuneAttribute(value="closingLevel")
        public VarianceBuilder setClosingLevel(Boolean _closingLevel) {
            this.closingLevel = _closingLevel == null ? null : _closingLevel;
            return this;
        }

        @Override
        @RosettaAttribute(value="expiringLevel")
        @RuneAttribute(value="expiringLevel")
        public VarianceBuilder setExpiringLevel(Boolean _expiringLevel) {
            this.expiringLevel = _expiringLevel == null ? null : _expiringLevel;
            return this;
        }

        @Override
        @RosettaAttribute(value="expectedN")
        @RuneAttribute(value="expectedN")
        public VarianceBuilder setExpectedN(Integer _expectedN) {
            this.expectedN = _expectedN == null ? null : _expectedN;
            return this;
        }

        @Override
        @RosettaAttribute(value="varianceAmount", isRequired=true)
        @RuneAttribute(value="varianceAmount", isRequired=true)
        public VarianceBuilder setVarianceAmount(NonNegativeMoney _varianceAmount) {
            this.varianceAmount = _varianceAmount == null ? null : _varianceAmount.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="volatilityStrikePrice")
        @RuneAttribute(value="volatilityStrikePrice")
        public VarianceBuilder setVolatilityStrikePrice(BigDecimal _volatilityStrikePrice) {
            this.volatilityStrikePrice = _volatilityStrikePrice == null ? null : _volatilityStrikePrice;
            return this;
        }

        @Override
        @RosettaAttribute(value="varianceStrikePrice")
        @RuneAttribute(value="varianceStrikePrice")
        public VarianceBuilder setVarianceStrikePrice(BigDecimal _varianceStrikePrice) {
            this.varianceStrikePrice = _varianceStrikePrice == null ? null : _varianceStrikePrice;
            return this;
        }

        @Override
        @RosettaAttribute(value="varianceCap")
        @RuneAttribute(value="varianceCap")
        public VarianceBuilder setVarianceCap(Boolean _varianceCap) {
            this.varianceCap = _varianceCap == null ? null : _varianceCap;
            return this;
        }

        @Override
        @RosettaAttribute(value="unadjustedVarianceCap")
        @RuneAttribute(value="unadjustedVarianceCap")
        public VarianceBuilder setUnadjustedVarianceCap(BigDecimal _unadjustedVarianceCap) {
            this.unadjustedVarianceCap = _unadjustedVarianceCap == null ? null : _unadjustedVarianceCap;
            return this;
        }

        @Override
        @RosettaAttribute(value="boundedVariance")
        @RuneAttribute(value="boundedVariance")
        public VarianceBuilder setBoundedVariance(BoundedVariance _boundedVariance) {
            this.boundedVariance = _boundedVariance == null ? null : _boundedVariance.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="exchangeTradedContractNearest")
        @RuneAttribute(value="exchangeTradedContractNearest")
        public VarianceBuilder setExchangeTradedContractNearest(ExchangeTradedContract _exchangeTradedContractNearest) {
            this.exchangeTradedContractNearest = _exchangeTradedContractNearest == null ? null : _exchangeTradedContractNearest.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="vegaNotionalAmount")
        @RuneAttribute(value="vegaNotionalAmount")
        public VarianceBuilder setVegaNotionalAmount(BigDecimal _vegaNotionalAmount) {
            this.vegaNotionalAmount = _vegaNotionalAmount == null ? null : _vegaNotionalAmount;
            return this;
        }

        @Override
        public Variance build() {
            return new VarianceImpl(this);
        }

        @Override
        public VarianceBuilder toBuilder() {
            return this;
        }

        @Override
        public VarianceBuilder prune() {
            super.prune();
            if (this.varianceAmount != null && !this.varianceAmount.prune().hasData()) {
                this.varianceAmount = null;
            }
            if (this.boundedVariance != null && !this.boundedVariance.prune().hasData()) {
                this.boundedVariance = null;
            }
            if (this.exchangeTradedContractNearest != null && !this.exchangeTradedContractNearest.prune().hasData()) {
                this.exchangeTradedContractNearest = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getVarianceAmount() != null && this.getVarianceAmount().hasData()) {
                return true;
            }
            if (this.getVolatilityStrikePrice() != null) {
                return true;
            }
            if (this.getVarianceStrikePrice() != null) {
                return true;
            }
            if (this.getVarianceCap() != null) {
                return true;
            }
            if (this.getUnadjustedVarianceCap() != null) {
                return true;
            }
            if (this.getBoundedVariance() != null && this.getBoundedVariance().hasData()) {
                return true;
            }
            if (this.getExchangeTradedContractNearest() != null && this.getExchangeTradedContractNearest().hasData()) {
                return true;
            }
            return this.getVegaNotionalAmount() != null;
        }

        @Override
        public VarianceBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            VarianceBuilder o = (VarianceBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getVarianceAmount(), (RosettaModelObjectBuilder)o.getVarianceAmount(), this::setVarianceAmount);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getBoundedVariance(), (RosettaModelObjectBuilder)o.getBoundedVariance(), this::setBoundedVariance);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getExchangeTradedContractNearest(), (RosettaModelObjectBuilder)o.getExchangeTradedContractNearest(), this::setExchangeTradedContractNearest);
            merger.mergeBasic((Object)this.getVolatilityStrikePrice(), (Object)o.getVolatilityStrikePrice(), this::setVolatilityStrikePrice, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getVarianceStrikePrice(), (Object)o.getVarianceStrikePrice(), this::setVarianceStrikePrice, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getVarianceCap(), (Object)o.getVarianceCap(), this::setVarianceCap, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getUnadjustedVarianceCap(), (Object)o.getUnadjustedVarianceCap(), this::setUnadjustedVarianceCap, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getVegaNotionalAmount(), (Object)o.getVegaNotionalAmount(), this::setVegaNotionalAmount, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Variance _that = (Variance)this.getType().cast(o);
            if (!Objects.equals(this.varianceAmount, _that.getVarianceAmount())) {
                return false;
            }
            if (!Objects.equals(this.volatilityStrikePrice, _that.getVolatilityStrikePrice())) {
                return false;
            }
            if (!Objects.equals(this.varianceStrikePrice, _that.getVarianceStrikePrice())) {
                return false;
            }
            if (!Objects.equals(this.varianceCap, _that.getVarianceCap())) {
                return false;
            }
            if (!Objects.equals(this.unadjustedVarianceCap, _that.getUnadjustedVarianceCap())) {
                return false;
            }
            if (!Objects.equals(this.boundedVariance, _that.getBoundedVariance())) {
                return false;
            }
            if (!Objects.equals(this.exchangeTradedContractNearest, _that.getExchangeTradedContractNearest())) {
                return false;
            }
            return Objects.equals(this.vegaNotionalAmount, _that.getVegaNotionalAmount());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.varianceAmount != null ? this.varianceAmount.hashCode() : 0);
            _result = 31 * _result + (this.volatilityStrikePrice != null ? this.volatilityStrikePrice.hashCode() : 0);
            _result = 31 * _result + (this.varianceStrikePrice != null ? this.varianceStrikePrice.hashCode() : 0);
            _result = 31 * _result + (this.varianceCap != null ? this.varianceCap.hashCode() : 0);
            _result = 31 * _result + (this.unadjustedVarianceCap != null ? this.unadjustedVarianceCap.hashCode() : 0);
            _result = 31 * _result + (this.boundedVariance != null ? this.boundedVariance.hashCode() : 0);
            _result = 31 * _result + (this.exchangeTradedContractNearest != null ? this.exchangeTradedContractNearest.hashCode() : 0);
            _result = 31 * _result + (this.vegaNotionalAmount != null ? this.vegaNotionalAmount.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "VarianceBuilder {varianceAmount=" + String.valueOf(this.varianceAmount) + ", volatilityStrikePrice=" + String.valueOf(this.volatilityStrikePrice) + ", varianceStrikePrice=" + String.valueOf(this.varianceStrikePrice) + ", varianceCap=" + this.varianceCap + ", unadjustedVarianceCap=" + String.valueOf(this.unadjustedVarianceCap) + ", boundedVariance=" + String.valueOf(this.boundedVariance) + ", exchangeTradedContractNearest=" + String.valueOf(this.exchangeTradedContractNearest) + ", vegaNotionalAmount=" + String.valueOf(this.vegaNotionalAmount) + "} " + super.toString();
        }
    }

    public static interface VarianceBuilder
    extends Variance,
    CalculationFromObservation.CalculationFromObservationBuilder {
        public NonNegativeMoney.NonNegativeMoneyBuilder getOrCreateVarianceAmount();

        @Override
        public NonNegativeMoney.NonNegativeMoneyBuilder getVarianceAmount();

        public BoundedVariance.BoundedVarianceBuilder getOrCreateBoundedVariance();

        @Override
        public BoundedVariance.BoundedVarianceBuilder getBoundedVariance();

        public ExchangeTradedContract.ExchangeTradedContractBuilder getOrCreateExchangeTradedContractNearest();

        @Override
        public ExchangeTradedContract.ExchangeTradedContractBuilder getExchangeTradedContractNearest();

        @Override
        public VarianceBuilder setCalculationFromObservationChoice(CalculationFromObservationChoice var1);

        @Override
        public VarianceBuilder setClosingLevel(Boolean var1);

        @Override
        public VarianceBuilder setExpiringLevel(Boolean var1);

        @Override
        public VarianceBuilder setExpectedN(Integer var1);

        public VarianceBuilder setVarianceAmount(NonNegativeMoney var1);

        public VarianceBuilder setVolatilityStrikePrice(BigDecimal var1);

        public VarianceBuilder setVarianceStrikePrice(BigDecimal var1);

        public VarianceBuilder setVarianceCap(Boolean var1);

        public VarianceBuilder setUnadjustedVarianceCap(BigDecimal var1);

        public VarianceBuilder setBoundedVariance(BoundedVariance var1);

        public VarianceBuilder setExchangeTradedContractNearest(ExchangeTradedContract var1);

        public VarianceBuilder setVegaNotionalAmount(BigDecimal var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("calculationFromObservationChoice"), processor, CalculationFromObservationChoice.CalculationFromObservationChoiceBuilder.class, (RosettaModelObjectBuilder)this.getCalculationFromObservationChoice(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("closingLevel"), Boolean.class, (Object)this.getClosingLevel(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("expiringLevel"), Boolean.class, (Object)this.getExpiringLevel(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("expectedN"), Integer.class, (Object)this.getExpectedN(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("varianceAmount"), processor, NonNegativeMoney.NonNegativeMoneyBuilder.class, this.getVarianceAmount(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("volatilityStrikePrice"), BigDecimal.class, (Object)this.getVolatilityStrikePrice(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("varianceStrikePrice"), BigDecimal.class, (Object)this.getVarianceStrikePrice(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("varianceCap"), Boolean.class, (Object)this.getVarianceCap(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("unadjustedVarianceCap"), BigDecimal.class, (Object)this.getUnadjustedVarianceCap(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("boundedVariance"), processor, BoundedVariance.BoundedVarianceBuilder.class, this.getBoundedVariance(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("exchangeTradedContractNearest"), processor, ExchangeTradedContract.ExchangeTradedContractBuilder.class, this.getExchangeTradedContractNearest(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("vegaNotionalAmount"), BigDecimal.class, (Object)this.getVegaNotionalAmount(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        @Override
        public VarianceBuilder prune();
    }

    public static class VarianceImpl
    extends CalculationFromObservation.CalculationFromObservationImpl
    implements Variance {
        private final NonNegativeMoney varianceAmount;
        private final BigDecimal volatilityStrikePrice;
        private final BigDecimal varianceStrikePrice;
        private final Boolean varianceCap;
        private final BigDecimal unadjustedVarianceCap;
        private final BoundedVariance boundedVariance;
        private final ExchangeTradedContract exchangeTradedContractNearest;
        private final BigDecimal vegaNotionalAmount;

        protected VarianceImpl(VarianceBuilder builder) {
            super(builder);
            this.varianceAmount = Optional.ofNullable(builder.getVarianceAmount()).map(f -> f.build()).orElse(null);
            this.volatilityStrikePrice = builder.getVolatilityStrikePrice();
            this.varianceStrikePrice = builder.getVarianceStrikePrice();
            this.varianceCap = builder.getVarianceCap();
            this.unadjustedVarianceCap = builder.getUnadjustedVarianceCap();
            this.boundedVariance = Optional.ofNullable(builder.getBoundedVariance()).map(f -> f.build()).orElse(null);
            this.exchangeTradedContractNearest = Optional.ofNullable(builder.getExchangeTradedContractNearest()).map(f -> f.build()).orElse(null);
            this.vegaNotionalAmount = builder.getVegaNotionalAmount();
        }

        @Override
        @RosettaAttribute(value="varianceAmount", isRequired=true)
        @RuneAttribute(value="varianceAmount", isRequired=true)
        public NonNegativeMoney getVarianceAmount() {
            return this.varianceAmount;
        }

        @Override
        @RosettaAttribute(value="volatilityStrikePrice")
        @RuneAttribute(value="volatilityStrikePrice")
        public BigDecimal getVolatilityStrikePrice() {
            return this.volatilityStrikePrice;
        }

        @Override
        @RosettaAttribute(value="varianceStrikePrice")
        @RuneAttribute(value="varianceStrikePrice")
        public BigDecimal getVarianceStrikePrice() {
            return this.varianceStrikePrice;
        }

        @Override
        @RosettaAttribute(value="varianceCap")
        @RuneAttribute(value="varianceCap")
        public Boolean getVarianceCap() {
            return this.varianceCap;
        }

        @Override
        @RosettaAttribute(value="unadjustedVarianceCap")
        @RuneAttribute(value="unadjustedVarianceCap")
        public BigDecimal getUnadjustedVarianceCap() {
            return this.unadjustedVarianceCap;
        }

        @Override
        @RosettaAttribute(value="boundedVariance")
        @RuneAttribute(value="boundedVariance")
        public BoundedVariance getBoundedVariance() {
            return this.boundedVariance;
        }

        @Override
        @RosettaAttribute(value="exchangeTradedContractNearest")
        @RuneAttribute(value="exchangeTradedContractNearest")
        public ExchangeTradedContract getExchangeTradedContractNearest() {
            return this.exchangeTradedContractNearest;
        }

        @Override
        @RosettaAttribute(value="vegaNotionalAmount")
        @RuneAttribute(value="vegaNotionalAmount")
        public BigDecimal getVegaNotionalAmount() {
            return this.vegaNotionalAmount;
        }

        @Override
        public Variance build() {
            return this;
        }

        @Override
        public VarianceBuilder toBuilder() {
            VarianceBuilder builder = Variance.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(VarianceBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getVarianceAmount()).ifPresent(builder::setVarianceAmount);
            Optional.ofNullable(this.getVolatilityStrikePrice()).ifPresent(builder::setVolatilityStrikePrice);
            Optional.ofNullable(this.getVarianceStrikePrice()).ifPresent(builder::setVarianceStrikePrice);
            Optional.ofNullable(this.getVarianceCap()).ifPresent(builder::setVarianceCap);
            Optional.ofNullable(this.getUnadjustedVarianceCap()).ifPresent(builder::setUnadjustedVarianceCap);
            Optional.ofNullable(this.getBoundedVariance()).ifPresent(builder::setBoundedVariance);
            Optional.ofNullable(this.getExchangeTradedContractNearest()).ifPresent(builder::setExchangeTradedContractNearest);
            Optional.ofNullable(this.getVegaNotionalAmount()).ifPresent(builder::setVegaNotionalAmount);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Variance _that = (Variance)this.getType().cast(o);
            if (!Objects.equals(this.varianceAmount, _that.getVarianceAmount())) {
                return false;
            }
            if (!Objects.equals(this.volatilityStrikePrice, _that.getVolatilityStrikePrice())) {
                return false;
            }
            if (!Objects.equals(this.varianceStrikePrice, _that.getVarianceStrikePrice())) {
                return false;
            }
            if (!Objects.equals(this.varianceCap, _that.getVarianceCap())) {
                return false;
            }
            if (!Objects.equals(this.unadjustedVarianceCap, _that.getUnadjustedVarianceCap())) {
                return false;
            }
            if (!Objects.equals(this.boundedVariance, _that.getBoundedVariance())) {
                return false;
            }
            if (!Objects.equals(this.exchangeTradedContractNearest, _that.getExchangeTradedContractNearest())) {
                return false;
            }
            return Objects.equals(this.vegaNotionalAmount, _that.getVegaNotionalAmount());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.varianceAmount != null ? this.varianceAmount.hashCode() : 0);
            _result = 31 * _result + (this.volatilityStrikePrice != null ? this.volatilityStrikePrice.hashCode() : 0);
            _result = 31 * _result + (this.varianceStrikePrice != null ? this.varianceStrikePrice.hashCode() : 0);
            _result = 31 * _result + (this.varianceCap != null ? this.varianceCap.hashCode() : 0);
            _result = 31 * _result + (this.unadjustedVarianceCap != null ? this.unadjustedVarianceCap.hashCode() : 0);
            _result = 31 * _result + (this.boundedVariance != null ? this.boundedVariance.hashCode() : 0);
            _result = 31 * _result + (this.exchangeTradedContractNearest != null ? this.exchangeTradedContractNearest.hashCode() : 0);
            _result = 31 * _result + (this.vegaNotionalAmount != null ? this.vegaNotionalAmount.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "Variance {varianceAmount=" + String.valueOf(this.varianceAmount) + ", volatilityStrikePrice=" + String.valueOf(this.volatilityStrikePrice) + ", varianceStrikePrice=" + String.valueOf(this.varianceStrikePrice) + ", varianceCap=" + this.varianceCap + ", unadjustedVarianceCap=" + String.valueOf(this.unadjustedVarianceCap) + ", boundedVariance=" + String.valueOf(this.boundedVariance) + ", exchangeTradedContractNearest=" + String.valueOf(this.exchangeTradedContractNearest) + ", vegaNotionalAmount=" + String.valueOf(this.vegaNotionalAmount) + "} " + super.toString();
        }
    }
}

