/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.eq.shared;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.asset.Underlyer;
import fpml.consolidated.eq.shared.Return;
import fpml.consolidated.eq.shared.ReturnLegValuation;
import fpml.consolidated.eq.shared.ReturnSwapAmount;
import fpml.consolidated.eq.shared.ReturnSwapLegUnderlyer;
import fpml.consolidated.eq.shared.ReturnSwapNotional;
import fpml.consolidated.eq.shared.meta.ReturnLegMeta;
import fpml.consolidated.fpmlenum.NotionalAdjustmentEnum;
import fpml.consolidated.option.shared.AveragingPeriod;
import fpml.consolidated.option.shared.FxFeature;
import fpml.consolidated.option.shared.OptionSettlementModel;
import fpml.consolidated.shared.AdjustableOrRelativeDate;
import fpml.consolidated.shared.LegIdentifier;
import fpml.consolidated.shared.PayerReceiverModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="ReturnLeg", builder=ReturnLegBuilderImpl.class, version="1.2.2")
@RuneDataType(value="ReturnLeg", model="fpml", builder=ReturnLegBuilderImpl.class, version="1.2.2")
public interface ReturnLeg
extends ReturnSwapLegUnderlyer {
    public static final ReturnLegMeta metaData = new ReturnLegMeta();

    public ReturnLegValuation getRateOfReturn();

    public ReturnSwapNotional getNotional();

    public ReturnSwapAmount getAmount();

    public Return getReturn();

    public NotionalAdjustmentEnum getNotionalAdjustments();

    public FxFeature getFxFeature();

    public AveragingPeriod getAveragingDates();

    @Override
    public ReturnLeg build();

    @Override
    public ReturnLegBuilder toBuilder();

    public static ReturnLegBuilder builder() {
        return new ReturnLegBuilderImpl();
    }

    default public RosettaMetaData<? extends ReturnLeg> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends ReturnLeg> getType() {
        return ReturnLeg.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("legIdentifier"), processor, LegIdentifier.class, this.getLegIdentifier(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("payerReceiverModel"), processor, PayerReceiverModel.class, this.getPayerReceiverModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("effectiveDate"), processor, AdjustableOrRelativeDate.class, this.getEffectiveDate(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("terminationDate"), processor, AdjustableOrRelativeDate.class, this.getTerminationDate(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("strikeDate"), processor, AdjustableOrRelativeDate.class, this.getStrikeDate(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("underlyer"), processor, Underlyer.class, this.getUnderlyer(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("optionSettlementModel"), processor, OptionSettlementModel.class, this.getOptionSettlementModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("rateOfReturn"), processor, ReturnLegValuation.class, this.getRateOfReturn(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("notional"), processor, ReturnSwapNotional.class, this.getNotional(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("amount"), processor, ReturnSwapAmount.class, this.getAmount(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("return"), processor, Return.class, this.getReturn(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("notionalAdjustments"), NotionalAdjustmentEnum.class, (Object)this.getNotionalAdjustments(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("fxFeature"), processor, FxFeature.class, this.getFxFeature(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("averagingDates"), processor, AveragingPeriod.class, this.getAveragingDates(), new AttributeMeta[0]);
    }

    public static class ReturnLegBuilderImpl
    extends ReturnSwapLegUnderlyer.ReturnSwapLegUnderlyerBuilderImpl
    implements ReturnLegBuilder {
        protected ReturnLegValuation.ReturnLegValuationBuilder rateOfReturn;
        protected ReturnSwapNotional.ReturnSwapNotionalBuilder notional;
        protected ReturnSwapAmount.ReturnSwapAmountBuilder amount;
        protected Return.ReturnBuilder _return;
        protected NotionalAdjustmentEnum notionalAdjustments;
        protected FxFeature.FxFeatureBuilder fxFeature;
        protected AveragingPeriod.AveragingPeriodBuilder averagingDates;

        @Override
        @RosettaAttribute(value="rateOfReturn", isRequired=true)
        @RuneAttribute(value="rateOfReturn", isRequired=true)
        public ReturnLegValuation.ReturnLegValuationBuilder getRateOfReturn() {
            return this.rateOfReturn;
        }

        @Override
        public ReturnLegValuation.ReturnLegValuationBuilder getOrCreateRateOfReturn() {
            ReturnLegValuation.ReturnLegValuationBuilder result = this.rateOfReturn != null ? this.rateOfReturn : (this.rateOfReturn = ReturnLegValuation.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="notional")
        @RuneAttribute(value="notional")
        public ReturnSwapNotional.ReturnSwapNotionalBuilder getNotional() {
            return this.notional;
        }

        @Override
        public ReturnSwapNotional.ReturnSwapNotionalBuilder getOrCreateNotional() {
            ReturnSwapNotional.ReturnSwapNotionalBuilder result = this.notional != null ? this.notional : (this.notional = ReturnSwapNotional.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="amount", isRequired=true)
        @RuneAttribute(value="amount", isRequired=true)
        public ReturnSwapAmount.ReturnSwapAmountBuilder getAmount() {
            return this.amount;
        }

        @Override
        public ReturnSwapAmount.ReturnSwapAmountBuilder getOrCreateAmount() {
            ReturnSwapAmount.ReturnSwapAmountBuilder result = this.amount != null ? this.amount : (this.amount = ReturnSwapAmount.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="return")
        @RuneAttribute(value="return")
        public Return.ReturnBuilder getReturn() {
            return this._return;
        }

        @Override
        public Return.ReturnBuilder getOrCreateReturn() {
            Return.ReturnBuilder result = this._return != null ? this._return : (this._return = Return.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="notionalAdjustments")
        @RuneAttribute(value="notionalAdjustments")
        public NotionalAdjustmentEnum getNotionalAdjustments() {
            return this.notionalAdjustments;
        }

        @Override
        @RosettaAttribute(value="fxFeature")
        @RuneAttribute(value="fxFeature")
        public FxFeature.FxFeatureBuilder getFxFeature() {
            return this.fxFeature;
        }

        @Override
        public FxFeature.FxFeatureBuilder getOrCreateFxFeature() {
            FxFeature.FxFeatureBuilder result = this.fxFeature != null ? this.fxFeature : (this.fxFeature = FxFeature.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="averagingDates")
        @RuneAttribute(value="averagingDates")
        public AveragingPeriod.AveragingPeriodBuilder getAveragingDates() {
            return this.averagingDates;
        }

        @Override
        public AveragingPeriod.AveragingPeriodBuilder getOrCreateAveragingDates() {
            AveragingPeriod.AveragingPeriodBuilder result = this.averagingDates != null ? this.averagingDates : (this.averagingDates = AveragingPeriod.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public ReturnLegBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="legIdentifier")
        @RuneAttribute(value="legIdentifier")
        public ReturnLegBuilder addLegIdentifier(LegIdentifier _legIdentifier) {
            if (_legIdentifier != null) {
                this.legIdentifier.add(_legIdentifier.toBuilder());
            }
            return this;
        }

        @Override
        public ReturnLegBuilder addLegIdentifier(LegIdentifier _legIdentifier, int idx) {
            this.getIndex(this.legIdentifier, idx, () -> _legIdentifier.toBuilder());
            return this;
        }

        @Override
        public ReturnLegBuilder addLegIdentifier(List<? extends LegIdentifier> legIdentifiers) {
            if (legIdentifiers != null) {
                for (LegIdentifier legIdentifier : legIdentifiers) {
                    this.legIdentifier.add(legIdentifier.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="legIdentifier")
        public ReturnLegBuilder setLegIdentifier(List<? extends LegIdentifier> legIdentifiers) {
            this.legIdentifier = legIdentifiers == null ? new ArrayList() : (List)legIdentifiers.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="payerReceiverModel", isRequired=true)
        @RuneAttribute(value="payerReceiverModel", isRequired=true)
        public ReturnLegBuilder setPayerReceiverModel(PayerReceiverModel _payerReceiverModel) {
            this.payerReceiverModel = _payerReceiverModel == null ? null : _payerReceiverModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="effectiveDate")
        @RuneAttribute(value="effectiveDate")
        public ReturnLegBuilder setEffectiveDate(AdjustableOrRelativeDate _effectiveDate) {
            this.effectiveDate = _effectiveDate == null ? null : _effectiveDate.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="terminationDate")
        @RuneAttribute(value="terminationDate")
        public ReturnLegBuilder setTerminationDate(AdjustableOrRelativeDate _terminationDate) {
            this.terminationDate = _terminationDate == null ? null : _terminationDate.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="strikeDate")
        @RuneAttribute(value="strikeDate")
        public ReturnLegBuilder setStrikeDate(AdjustableOrRelativeDate _strikeDate) {
            this.strikeDate = _strikeDate == null ? null : _strikeDate.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="underlyer", isRequired=true)
        @RuneAttribute(value="underlyer", isRequired=true)
        public ReturnLegBuilder setUnderlyer(Underlyer _underlyer) {
            this.underlyer = _underlyer == null ? null : _underlyer.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="optionSettlementModel", isRequired=true)
        @RuneAttribute(value="optionSettlementModel", isRequired=true)
        public ReturnLegBuilder setOptionSettlementModel(OptionSettlementModel _optionSettlementModel) {
            this.optionSettlementModel = _optionSettlementModel == null ? null : _optionSettlementModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="rateOfReturn", isRequired=true)
        @RuneAttribute(value="rateOfReturn", isRequired=true)
        public ReturnLegBuilder setRateOfReturn(ReturnLegValuation _rateOfReturn) {
            this.rateOfReturn = _rateOfReturn == null ? null : _rateOfReturn.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="notional")
        @RuneAttribute(value="notional")
        public ReturnLegBuilder setNotional(ReturnSwapNotional _notional) {
            this.notional = _notional == null ? null : _notional.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="amount", isRequired=true)
        @RuneAttribute(value="amount", isRequired=true)
        public ReturnLegBuilder setAmount(ReturnSwapAmount _amount) {
            this.amount = _amount == null ? null : _amount.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="return")
        @RuneAttribute(value="return")
        public ReturnLegBuilder setReturn(Return __return) {
            this._return = __return == null ? null : __return.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="notionalAdjustments")
        @RuneAttribute(value="notionalAdjustments")
        public ReturnLegBuilder setNotionalAdjustments(NotionalAdjustmentEnum _notionalAdjustments) {
            this.notionalAdjustments = _notionalAdjustments == null ? null : _notionalAdjustments;
            return this;
        }

        @Override
        @RosettaAttribute(value="fxFeature")
        @RuneAttribute(value="fxFeature")
        public ReturnLegBuilder setFxFeature(FxFeature _fxFeature) {
            this.fxFeature = _fxFeature == null ? null : _fxFeature.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="averagingDates")
        @RuneAttribute(value="averagingDates")
        public ReturnLegBuilder setAveragingDates(AveragingPeriod _averagingDates) {
            this.averagingDates = _averagingDates == null ? null : _averagingDates.toBuilder();
            return this;
        }

        @Override
        public ReturnLeg build() {
            return new ReturnLegImpl(this);
        }

        @Override
        public ReturnLegBuilder toBuilder() {
            return this;
        }

        @Override
        public ReturnLegBuilder prune() {
            super.prune();
            if (this.rateOfReturn != null && !this.rateOfReturn.prune().hasData()) {
                this.rateOfReturn = null;
            }
            if (this.notional != null && !this.notional.prune().hasData()) {
                this.notional = null;
            }
            if (this.amount != null && !this.amount.prune().hasData()) {
                this.amount = null;
            }
            if (this._return != null && !this._return.prune().hasData()) {
                this._return = null;
            }
            if (this.fxFeature != null && !this.fxFeature.prune().hasData()) {
                this.fxFeature = null;
            }
            if (this.averagingDates != null && !this.averagingDates.prune().hasData()) {
                this.averagingDates = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getRateOfReturn() != null && this.getRateOfReturn().hasData()) {
                return true;
            }
            if (this.getNotional() != null && this.getNotional().hasData()) {
                return true;
            }
            if (this.getAmount() != null && this.getAmount().hasData()) {
                return true;
            }
            if (this.getReturn() != null && this.getReturn().hasData()) {
                return true;
            }
            if (this.getNotionalAdjustments() != null) {
                return true;
            }
            if (this.getFxFeature() != null && this.getFxFeature().hasData()) {
                return true;
            }
            return this.getAveragingDates() != null && this.getAveragingDates().hasData();
        }

        @Override
        public ReturnLegBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            ReturnLegBuilder o = (ReturnLegBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getRateOfReturn(), (RosettaModelObjectBuilder)o.getRateOfReturn(), this::setRateOfReturn);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getNotional(), (RosettaModelObjectBuilder)o.getNotional(), this::setNotional);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAmount(), (RosettaModelObjectBuilder)o.getAmount(), this::setAmount);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getReturn(), (RosettaModelObjectBuilder)o.getReturn(), this::setReturn);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFxFeature(), (RosettaModelObjectBuilder)o.getFxFeature(), this::setFxFeature);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAveragingDates(), (RosettaModelObjectBuilder)o.getAveragingDates(), this::setAveragingDates);
            merger.mergeBasic((Object)this.getNotionalAdjustments(), (Object)o.getNotionalAdjustments(), this::setNotionalAdjustments, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ReturnLeg _that = (ReturnLeg)this.getType().cast(o);
            if (!Objects.equals(this.rateOfReturn, _that.getRateOfReturn())) {
                return false;
            }
            if (!Objects.equals(this.notional, _that.getNotional())) {
                return false;
            }
            if (!Objects.equals(this.amount, _that.getAmount())) {
                return false;
            }
            if (!Objects.equals(this._return, _that.getReturn())) {
                return false;
            }
            if (!Objects.equals((Object)this.notionalAdjustments, (Object)_that.getNotionalAdjustments())) {
                return false;
            }
            if (!Objects.equals(this.fxFeature, _that.getFxFeature())) {
                return false;
            }
            return Objects.equals(this.averagingDates, _that.getAveragingDates());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.rateOfReturn != null ? this.rateOfReturn.hashCode() : 0);
            _result = 31 * _result + (this.notional != null ? this.notional.hashCode() : 0);
            _result = 31 * _result + (this.amount != null ? this.amount.hashCode() : 0);
            _result = 31 * _result + (this._return != null ? this._return.hashCode() : 0);
            _result = 31 * _result + (this.notionalAdjustments != null ? ((Object)((Object)this.notionalAdjustments)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.fxFeature != null ? this.fxFeature.hashCode() : 0);
            _result = 31 * _result + (this.averagingDates != null ? this.averagingDates.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "ReturnLegBuilder {rateOfReturn=" + String.valueOf(this.rateOfReturn) + ", notional=" + String.valueOf(this.notional) + ", amount=" + String.valueOf(this.amount) + ", return=" + String.valueOf(this._return) + ", notionalAdjustments=" + String.valueOf((Object)this.notionalAdjustments) + ", fxFeature=" + String.valueOf(this.fxFeature) + ", averagingDates=" + String.valueOf(this.averagingDates) + "} " + super.toString();
        }
    }

    public static interface ReturnLegBuilder
    extends ReturnLeg,
    ReturnSwapLegUnderlyer.ReturnSwapLegUnderlyerBuilder {
        public ReturnLegValuation.ReturnLegValuationBuilder getOrCreateRateOfReturn();

        @Override
        public ReturnLegValuation.ReturnLegValuationBuilder getRateOfReturn();

        public ReturnSwapNotional.ReturnSwapNotionalBuilder getOrCreateNotional();

        @Override
        public ReturnSwapNotional.ReturnSwapNotionalBuilder getNotional();

        public ReturnSwapAmount.ReturnSwapAmountBuilder getOrCreateAmount();

        @Override
        public ReturnSwapAmount.ReturnSwapAmountBuilder getAmount();

        public Return.ReturnBuilder getOrCreateReturn();

        @Override
        public Return.ReturnBuilder getReturn();

        public FxFeature.FxFeatureBuilder getOrCreateFxFeature();

        @Override
        public FxFeature.FxFeatureBuilder getFxFeature();

        public AveragingPeriod.AveragingPeriodBuilder getOrCreateAveragingDates();

        @Override
        public AveragingPeriod.AveragingPeriodBuilder getAveragingDates();

        @Override
        public ReturnLegBuilder setId(String var1);

        @Override
        public ReturnLegBuilder addLegIdentifier(LegIdentifier var1);

        @Override
        public ReturnLegBuilder addLegIdentifier(LegIdentifier var1, int var2);

        @Override
        public ReturnLegBuilder addLegIdentifier(List<? extends LegIdentifier> var1);

        @Override
        public ReturnLegBuilder setLegIdentifier(List<? extends LegIdentifier> var1);

        @Override
        public ReturnLegBuilder setPayerReceiverModel(PayerReceiverModel var1);

        @Override
        public ReturnLegBuilder setEffectiveDate(AdjustableOrRelativeDate var1);

        @Override
        public ReturnLegBuilder setTerminationDate(AdjustableOrRelativeDate var1);

        @Override
        public ReturnLegBuilder setStrikeDate(AdjustableOrRelativeDate var1);

        @Override
        public ReturnLegBuilder setUnderlyer(Underlyer var1);

        @Override
        public ReturnLegBuilder setOptionSettlementModel(OptionSettlementModel var1);

        public ReturnLegBuilder setRateOfReturn(ReturnLegValuation var1);

        public ReturnLegBuilder setNotional(ReturnSwapNotional var1);

        public ReturnLegBuilder setAmount(ReturnSwapAmount var1);

        public ReturnLegBuilder setReturn(Return var1);

        public ReturnLegBuilder setNotionalAdjustments(NotionalAdjustmentEnum var1);

        public ReturnLegBuilder setFxFeature(FxFeature var1);

        public ReturnLegBuilder setAveragingDates(AveragingPeriod var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("legIdentifier"), processor, LegIdentifier.LegIdentifierBuilder.class, this.getLegIdentifier(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("payerReceiverModel"), processor, PayerReceiverModel.PayerReceiverModelBuilder.class, (RosettaModelObjectBuilder)this.getPayerReceiverModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("effectiveDate"), processor, AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder.class, (RosettaModelObjectBuilder)this.getEffectiveDate(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("terminationDate"), processor, AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder.class, (RosettaModelObjectBuilder)this.getTerminationDate(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("strikeDate"), processor, AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder.class, (RosettaModelObjectBuilder)this.getStrikeDate(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("underlyer"), processor, Underlyer.UnderlyerBuilder.class, (RosettaModelObjectBuilder)this.getUnderlyer(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("optionSettlementModel"), processor, OptionSettlementModel.OptionSettlementModelBuilder.class, (RosettaModelObjectBuilder)this.getOptionSettlementModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("rateOfReturn"), processor, ReturnLegValuation.ReturnLegValuationBuilder.class, this.getRateOfReturn(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("notional"), processor, ReturnSwapNotional.ReturnSwapNotionalBuilder.class, this.getNotional(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("amount"), processor, ReturnSwapAmount.ReturnSwapAmountBuilder.class, this.getAmount(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("return"), processor, Return.ReturnBuilder.class, this.getReturn(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("notionalAdjustments"), NotionalAdjustmentEnum.class, (Object)this.getNotionalAdjustments(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("fxFeature"), processor, FxFeature.FxFeatureBuilder.class, this.getFxFeature(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("averagingDates"), processor, AveragingPeriod.AveragingPeriodBuilder.class, this.getAveragingDates(), new AttributeMeta[0]);
        }

        @Override
        public ReturnLegBuilder prune();
    }

    public static class ReturnLegImpl
    extends ReturnSwapLegUnderlyer.ReturnSwapLegUnderlyerImpl
    implements ReturnLeg {
        private final ReturnLegValuation rateOfReturn;
        private final ReturnSwapNotional notional;
        private final ReturnSwapAmount amount;
        private final Return _return;
        private final NotionalAdjustmentEnum notionalAdjustments;
        private final FxFeature fxFeature;
        private final AveragingPeriod averagingDates;

        protected ReturnLegImpl(ReturnLegBuilder builder) {
            super(builder);
            this.rateOfReturn = Optional.ofNullable(builder.getRateOfReturn()).map(f -> f.build()).orElse(null);
            this.notional = Optional.ofNullable(builder.getNotional()).map(f -> f.build()).orElse(null);
            this.amount = Optional.ofNullable(builder.getAmount()).map(f -> f.build()).orElse(null);
            this._return = Optional.ofNullable(builder.getReturn()).map(f -> f.build()).orElse(null);
            this.notionalAdjustments = builder.getNotionalAdjustments();
            this.fxFeature = Optional.ofNullable(builder.getFxFeature()).map(f -> f.build()).orElse(null);
            this.averagingDates = Optional.ofNullable(builder.getAveragingDates()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="rateOfReturn", isRequired=true)
        @RuneAttribute(value="rateOfReturn", isRequired=true)
        public ReturnLegValuation getRateOfReturn() {
            return this.rateOfReturn;
        }

        @Override
        @RosettaAttribute(value="notional")
        @RuneAttribute(value="notional")
        public ReturnSwapNotional getNotional() {
            return this.notional;
        }

        @Override
        @RosettaAttribute(value="amount", isRequired=true)
        @RuneAttribute(value="amount", isRequired=true)
        public ReturnSwapAmount getAmount() {
            return this.amount;
        }

        @Override
        @RosettaAttribute(value="return")
        @RuneAttribute(value="return")
        public Return getReturn() {
            return this._return;
        }

        @Override
        @RosettaAttribute(value="notionalAdjustments")
        @RuneAttribute(value="notionalAdjustments")
        public NotionalAdjustmentEnum getNotionalAdjustments() {
            return this.notionalAdjustments;
        }

        @Override
        @RosettaAttribute(value="fxFeature")
        @RuneAttribute(value="fxFeature")
        public FxFeature getFxFeature() {
            return this.fxFeature;
        }

        @Override
        @RosettaAttribute(value="averagingDates")
        @RuneAttribute(value="averagingDates")
        public AveragingPeriod getAveragingDates() {
            return this.averagingDates;
        }

        @Override
        public ReturnLeg build() {
            return this;
        }

        @Override
        public ReturnLegBuilder toBuilder() {
            ReturnLegBuilder builder = ReturnLeg.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(ReturnLegBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getRateOfReturn()).ifPresent(builder::setRateOfReturn);
            Optional.ofNullable(this.getNotional()).ifPresent(builder::setNotional);
            Optional.ofNullable(this.getAmount()).ifPresent(builder::setAmount);
            Optional.ofNullable(this.getReturn()).ifPresent(builder::setReturn);
            Optional.ofNullable(this.getNotionalAdjustments()).ifPresent(builder::setNotionalAdjustments);
            Optional.ofNullable(this.getFxFeature()).ifPresent(builder::setFxFeature);
            Optional.ofNullable(this.getAveragingDates()).ifPresent(builder::setAveragingDates);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ReturnLeg _that = (ReturnLeg)this.getType().cast(o);
            if (!Objects.equals(this.rateOfReturn, _that.getRateOfReturn())) {
                return false;
            }
            if (!Objects.equals(this.notional, _that.getNotional())) {
                return false;
            }
            if (!Objects.equals(this.amount, _that.getAmount())) {
                return false;
            }
            if (!Objects.equals(this._return, _that.getReturn())) {
                return false;
            }
            if (!Objects.equals((Object)this.notionalAdjustments, (Object)_that.getNotionalAdjustments())) {
                return false;
            }
            if (!Objects.equals(this.fxFeature, _that.getFxFeature())) {
                return false;
            }
            return Objects.equals(this.averagingDates, _that.getAveragingDates());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.rateOfReturn != null ? this.rateOfReturn.hashCode() : 0);
            _result = 31 * _result + (this.notional != null ? this.notional.hashCode() : 0);
            _result = 31 * _result + (this.amount != null ? this.amount.hashCode() : 0);
            _result = 31 * _result + (this._return != null ? this._return.hashCode() : 0);
            _result = 31 * _result + (this.notionalAdjustments != null ? ((Object)((Object)this.notionalAdjustments)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.fxFeature != null ? this.fxFeature.hashCode() : 0);
            _result = 31 * _result + (this.averagingDates != null ? this.averagingDates.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "ReturnLeg {rateOfReturn=" + String.valueOf(this.rateOfReturn) + ", notional=" + String.valueOf(this.notional) + ", amount=" + String.valueOf(this.amount) + ", return=" + String.valueOf(this._return) + ", notionalAdjustments=" + String.valueOf((Object)this.notionalAdjustments) + ", fxFeature=" + String.valueOf(this.fxFeature) + ", averagingDates=" + String.valueOf(this.averagingDates) + "} " + super.toString();
        }
    }
}

