/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.eq.shared;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.eq.shared.CompoundingRate;
import fpml.consolidated.eq.shared.meta.CompoundingMeta;
import fpml.consolidated.fpmlenum.CompoundingMethodEnum;
import fpml.consolidated.shared.AdjustableRelativeOrPeriodicDates2;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="Compounding", builder=CompoundingBuilderImpl.class, version="1.2.2")
@RuneDataType(value="Compounding", model="fpml", builder=CompoundingBuilderImpl.class, version="1.2.2")
public interface Compounding
extends RosettaModelObject {
    public static final CompoundingMeta metaData = new CompoundingMeta();

    public CompoundingMethodEnum getCompoundingMethod();

    public CompoundingRate getCompoundingRate();

    public BigDecimal getCompoundingSpread();

    public AdjustableRelativeOrPeriodicDates2 getCompoundingDates();

    public Compounding build();

    public CompoundingBuilder toBuilder();

    public static CompoundingBuilder builder() {
        return new CompoundingBuilderImpl();
    }

    default public RosettaMetaData<? extends Compounding> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends Compounding> getType() {
        return Compounding.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("compoundingMethod"), CompoundingMethodEnum.class, (Object)this.getCompoundingMethod(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("compoundingRate"), processor, CompoundingRate.class, this.getCompoundingRate(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("compoundingSpread"), BigDecimal.class, (Object)this.getCompoundingSpread(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("compoundingDates"), processor, AdjustableRelativeOrPeriodicDates2.class, this.getCompoundingDates(), new AttributeMeta[0]);
    }

    public static class CompoundingBuilderImpl
    implements CompoundingBuilder {
        protected CompoundingMethodEnum compoundingMethod;
        protected CompoundingRate.CompoundingRateBuilder compoundingRate;
        protected BigDecimal compoundingSpread;
        protected AdjustableRelativeOrPeriodicDates2.AdjustableRelativeOrPeriodicDates2Builder compoundingDates;

        @Override
        @RosettaAttribute(value="compoundingMethod")
        @RuneAttribute(value="compoundingMethod")
        public CompoundingMethodEnum getCompoundingMethod() {
            return this.compoundingMethod;
        }

        @Override
        @RosettaAttribute(value="compoundingRate")
        @RuneAttribute(value="compoundingRate")
        public CompoundingRate.CompoundingRateBuilder getCompoundingRate() {
            return this.compoundingRate;
        }

        @Override
        public CompoundingRate.CompoundingRateBuilder getOrCreateCompoundingRate() {
            CompoundingRate.CompoundingRateBuilder result = this.compoundingRate != null ? this.compoundingRate : (this.compoundingRate = CompoundingRate.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="compoundingSpread")
        @RuneAttribute(value="compoundingSpread")
        public BigDecimal getCompoundingSpread() {
            return this.compoundingSpread;
        }

        @Override
        @RosettaAttribute(value="compoundingDates")
        @RuneAttribute(value="compoundingDates")
        public AdjustableRelativeOrPeriodicDates2.AdjustableRelativeOrPeriodicDates2Builder getCompoundingDates() {
            return this.compoundingDates;
        }

        @Override
        public AdjustableRelativeOrPeriodicDates2.AdjustableRelativeOrPeriodicDates2Builder getOrCreateCompoundingDates() {
            AdjustableRelativeOrPeriodicDates2.AdjustableRelativeOrPeriodicDates2Builder result = this.compoundingDates != null ? this.compoundingDates : (this.compoundingDates = AdjustableRelativeOrPeriodicDates2.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="compoundingMethod")
        @RuneAttribute(value="compoundingMethod")
        public CompoundingBuilder setCompoundingMethod(CompoundingMethodEnum _compoundingMethod) {
            this.compoundingMethod = _compoundingMethod == null ? null : _compoundingMethod;
            return this;
        }

        @Override
        @RosettaAttribute(value="compoundingRate")
        @RuneAttribute(value="compoundingRate")
        public CompoundingBuilder setCompoundingRate(CompoundingRate _compoundingRate) {
            this.compoundingRate = _compoundingRate == null ? null : _compoundingRate.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="compoundingSpread")
        @RuneAttribute(value="compoundingSpread")
        public CompoundingBuilder setCompoundingSpread(BigDecimal _compoundingSpread) {
            this.compoundingSpread = _compoundingSpread == null ? null : _compoundingSpread;
            return this;
        }

        @Override
        @RosettaAttribute(value="compoundingDates")
        @RuneAttribute(value="compoundingDates")
        public CompoundingBuilder setCompoundingDates(AdjustableRelativeOrPeriodicDates2 _compoundingDates) {
            this.compoundingDates = _compoundingDates == null ? null : _compoundingDates.toBuilder();
            return this;
        }

        @Override
        public Compounding build() {
            return new CompoundingImpl(this);
        }

        @Override
        public CompoundingBuilder toBuilder() {
            return this;
        }

        @Override
        public CompoundingBuilder prune() {
            if (this.compoundingRate != null && !this.compoundingRate.prune().hasData()) {
                this.compoundingRate = null;
            }
            if (this.compoundingDates != null && !this.compoundingDates.prune().hasData()) {
                this.compoundingDates = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getCompoundingMethod() != null) {
                return true;
            }
            if (this.getCompoundingRate() != null && this.getCompoundingRate().hasData()) {
                return true;
            }
            if (this.getCompoundingSpread() != null) {
                return true;
            }
            return this.getCompoundingDates() != null && this.getCompoundingDates().hasData();
        }

        public CompoundingBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            CompoundingBuilder o = (CompoundingBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCompoundingRate(), (RosettaModelObjectBuilder)o.getCompoundingRate(), this::setCompoundingRate);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCompoundingDates(), (RosettaModelObjectBuilder)o.getCompoundingDates(), this::setCompoundingDates);
            merger.mergeBasic((Object)this.getCompoundingMethod(), (Object)o.getCompoundingMethod(), this::setCompoundingMethod, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCompoundingSpread(), (Object)o.getCompoundingSpread(), this::setCompoundingSpread, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            Compounding _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.compoundingMethod, (Object)_that.getCompoundingMethod())) {
                return false;
            }
            if (!Objects.equals(this.compoundingRate, _that.getCompoundingRate())) {
                return false;
            }
            if (!Objects.equals(this.compoundingSpread, _that.getCompoundingSpread())) {
                return false;
            }
            return Objects.equals(this.compoundingDates, _that.getCompoundingDates());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.compoundingMethod != null ? ((Object)((Object)this.compoundingMethod)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.compoundingRate != null ? this.compoundingRate.hashCode() : 0);
            _result = 31 * _result + (this.compoundingSpread != null ? this.compoundingSpread.hashCode() : 0);
            _result = 31 * _result + (this.compoundingDates != null ? this.compoundingDates.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CompoundingBuilder {compoundingMethod=" + String.valueOf((Object)this.compoundingMethod) + ", compoundingRate=" + String.valueOf(this.compoundingRate) + ", compoundingSpread=" + String.valueOf(this.compoundingSpread) + ", compoundingDates=" + String.valueOf(this.compoundingDates) + "}";
        }
    }

    public static interface CompoundingBuilder
    extends Compounding,
    RosettaModelObjectBuilder {
        public CompoundingRate.CompoundingRateBuilder getOrCreateCompoundingRate();

        @Override
        public CompoundingRate.CompoundingRateBuilder getCompoundingRate();

        public AdjustableRelativeOrPeriodicDates2.AdjustableRelativeOrPeriodicDates2Builder getOrCreateCompoundingDates();

        @Override
        public AdjustableRelativeOrPeriodicDates2.AdjustableRelativeOrPeriodicDates2Builder getCompoundingDates();

        public CompoundingBuilder setCompoundingMethod(CompoundingMethodEnum var1);

        public CompoundingBuilder setCompoundingRate(CompoundingRate var1);

        public CompoundingBuilder setCompoundingSpread(BigDecimal var1);

        public CompoundingBuilder setCompoundingDates(AdjustableRelativeOrPeriodicDates2 var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("compoundingMethod"), CompoundingMethodEnum.class, (Object)this.getCompoundingMethod(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("compoundingRate"), processor, CompoundingRate.CompoundingRateBuilder.class, this.getCompoundingRate(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("compoundingSpread"), BigDecimal.class, (Object)this.getCompoundingSpread(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("compoundingDates"), processor, AdjustableRelativeOrPeriodicDates2.AdjustableRelativeOrPeriodicDates2Builder.class, this.getCompoundingDates(), new AttributeMeta[0]);
        }

        public CompoundingBuilder prune();
    }

    public static class CompoundingImpl
    implements Compounding {
        private final CompoundingMethodEnum compoundingMethod;
        private final CompoundingRate compoundingRate;
        private final BigDecimal compoundingSpread;
        private final AdjustableRelativeOrPeriodicDates2 compoundingDates;

        protected CompoundingImpl(CompoundingBuilder builder) {
            this.compoundingMethod = builder.getCompoundingMethod();
            this.compoundingRate = Optional.ofNullable(builder.getCompoundingRate()).map(f -> f.build()).orElse(null);
            this.compoundingSpread = builder.getCompoundingSpread();
            this.compoundingDates = Optional.ofNullable(builder.getCompoundingDates()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="compoundingMethod")
        @RuneAttribute(value="compoundingMethod")
        public CompoundingMethodEnum getCompoundingMethod() {
            return this.compoundingMethod;
        }

        @Override
        @RosettaAttribute(value="compoundingRate")
        @RuneAttribute(value="compoundingRate")
        public CompoundingRate getCompoundingRate() {
            return this.compoundingRate;
        }

        @Override
        @RosettaAttribute(value="compoundingSpread")
        @RuneAttribute(value="compoundingSpread")
        public BigDecimal getCompoundingSpread() {
            return this.compoundingSpread;
        }

        @Override
        @RosettaAttribute(value="compoundingDates")
        @RuneAttribute(value="compoundingDates")
        public AdjustableRelativeOrPeriodicDates2 getCompoundingDates() {
            return this.compoundingDates;
        }

        @Override
        public Compounding build() {
            return this;
        }

        @Override
        public CompoundingBuilder toBuilder() {
            CompoundingBuilder builder = Compounding.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CompoundingBuilder builder) {
            Optional.ofNullable(this.getCompoundingMethod()).ifPresent(builder::setCompoundingMethod);
            Optional.ofNullable(this.getCompoundingRate()).ifPresent(builder::setCompoundingRate);
            Optional.ofNullable(this.getCompoundingSpread()).ifPresent(builder::setCompoundingSpread);
            Optional.ofNullable(this.getCompoundingDates()).ifPresent(builder::setCompoundingDates);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            Compounding _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.compoundingMethod, (Object)_that.getCompoundingMethod())) {
                return false;
            }
            if (!Objects.equals(this.compoundingRate, _that.getCompoundingRate())) {
                return false;
            }
            if (!Objects.equals(this.compoundingSpread, _that.getCompoundingSpread())) {
                return false;
            }
            return Objects.equals(this.compoundingDates, _that.getCompoundingDates());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.compoundingMethod != null ? ((Object)((Object)this.compoundingMethod)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.compoundingRate != null ? this.compoundingRate.hashCode() : 0);
            _result = 31 * _result + (this.compoundingSpread != null ? this.compoundingSpread.hashCode() : 0);
            _result = 31 * _result + (this.compoundingDates != null ? this.compoundingDates.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "Compounding {compoundingMethod=" + String.valueOf((Object)this.compoundingMethod) + ", compoundingRate=" + String.valueOf(this.compoundingRate) + ", compoundingSpread=" + String.valueOf(this.compoundingSpread) + ", compoundingDates=" + String.valueOf(this.compoundingDates) + "}";
        }
    }
}

