/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.doc;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.doc.meta.InstrumentTradeQuantityMeta;
import fpml.consolidated.shared.Money;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="InstrumentTradeQuantity", builder=InstrumentTradeQuantityBuilderImpl.class, version="1.2.2")
@RuneDataType(value="InstrumentTradeQuantity", model="fpml", builder=InstrumentTradeQuantityBuilderImpl.class, version="1.2.2")
public interface InstrumentTradeQuantity
extends RosettaModelObject {
    public static final InstrumentTradeQuantityMeta metaData = new InstrumentTradeQuantityMeta();

    public BigDecimal getNumber();

    public Money getNominal();

    public InstrumentTradeQuantity build();

    public InstrumentTradeQuantityBuilder toBuilder();

    public static InstrumentTradeQuantityBuilder builder() {
        return new InstrumentTradeQuantityBuilderImpl();
    }

    default public RosettaMetaData<? extends InstrumentTradeQuantity> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends InstrumentTradeQuantity> getType() {
        return InstrumentTradeQuantity.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("number"), BigDecimal.class, (Object)this.getNumber(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("nominal"), processor, Money.class, this.getNominal(), new AttributeMeta[0]);
    }

    public static class InstrumentTradeQuantityBuilderImpl
    implements InstrumentTradeQuantityBuilder {
        protected BigDecimal number;
        protected Money.MoneyBuilder nominal;

        @Override
        @RosettaAttribute(value="number")
        @RuneAttribute(value="number")
        public BigDecimal getNumber() {
            return this.number;
        }

        @Override
        @RosettaAttribute(value="nominal")
        @RuneAttribute(value="nominal")
        public Money.MoneyBuilder getNominal() {
            return this.nominal;
        }

        @Override
        public Money.MoneyBuilder getOrCreateNominal() {
            Money.MoneyBuilder result = this.nominal != null ? this.nominal : (this.nominal = Money.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="number")
        @RuneAttribute(value="number")
        public InstrumentTradeQuantityBuilder setNumber(BigDecimal _number) {
            this.number = _number == null ? null : _number;
            return this;
        }

        @Override
        @RosettaAttribute(value="nominal")
        @RuneAttribute(value="nominal")
        public InstrumentTradeQuantityBuilder setNominal(Money _nominal) {
            this.nominal = _nominal == null ? null : _nominal.toBuilder();
            return this;
        }

        @Override
        public InstrumentTradeQuantity build() {
            return new InstrumentTradeQuantityImpl(this);
        }

        @Override
        public InstrumentTradeQuantityBuilder toBuilder() {
            return this;
        }

        @Override
        public InstrumentTradeQuantityBuilder prune() {
            if (this.nominal != null && !this.nominal.prune().hasData()) {
                this.nominal = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getNumber() != null) {
                return true;
            }
            return this.getNominal() != null && this.getNominal().hasData();
        }

        public InstrumentTradeQuantityBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            InstrumentTradeQuantityBuilder o = (InstrumentTradeQuantityBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getNominal(), (RosettaModelObjectBuilder)o.getNominal(), this::setNominal);
            merger.mergeBasic((Object)this.getNumber(), (Object)o.getNumber(), this::setNumber, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            InstrumentTradeQuantity _that = this.getType().cast(o);
            if (!Objects.equals(this.number, _that.getNumber())) {
                return false;
            }
            return Objects.equals(this.nominal, _that.getNominal());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.number != null ? this.number.hashCode() : 0);
            _result = 31 * _result + (this.nominal != null ? this.nominal.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "InstrumentTradeQuantityBuilder {number=" + String.valueOf(this.number) + ", nominal=" + String.valueOf(this.nominal) + "}";
        }
    }

    public static interface InstrumentTradeQuantityBuilder
    extends InstrumentTradeQuantity,
    RosettaModelObjectBuilder {
        public Money.MoneyBuilder getOrCreateNominal();

        @Override
        public Money.MoneyBuilder getNominal();

        public InstrumentTradeQuantityBuilder setNumber(BigDecimal var1);

        public InstrumentTradeQuantityBuilder setNominal(Money var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("number"), BigDecimal.class, (Object)this.getNumber(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("nominal"), processor, Money.MoneyBuilder.class, this.getNominal(), new AttributeMeta[0]);
        }

        public InstrumentTradeQuantityBuilder prune();
    }

    public static class InstrumentTradeQuantityImpl
    implements InstrumentTradeQuantity {
        private final BigDecimal number;
        private final Money nominal;

        protected InstrumentTradeQuantityImpl(InstrumentTradeQuantityBuilder builder) {
            this.number = builder.getNumber();
            this.nominal = Optional.ofNullable(builder.getNominal()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="number")
        @RuneAttribute(value="number")
        public BigDecimal getNumber() {
            return this.number;
        }

        @Override
        @RosettaAttribute(value="nominal")
        @RuneAttribute(value="nominal")
        public Money getNominal() {
            return this.nominal;
        }

        @Override
        public InstrumentTradeQuantity build() {
            return this;
        }

        @Override
        public InstrumentTradeQuantityBuilder toBuilder() {
            InstrumentTradeQuantityBuilder builder = InstrumentTradeQuantity.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(InstrumentTradeQuantityBuilder builder) {
            Optional.ofNullable(this.getNumber()).ifPresent(builder::setNumber);
            Optional.ofNullable(this.getNominal()).ifPresent(builder::setNominal);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            InstrumentTradeQuantity _that = this.getType().cast(o);
            if (!Objects.equals(this.number, _that.getNumber())) {
                return false;
            }
            return Objects.equals(this.nominal, _that.getNominal());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.number != null ? this.number.hashCode() : 0);
            _result = 31 * _result + (this.nominal != null ? this.nominal.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "InstrumentTradeQuantity {number=" + String.valueOf(this.number) + ", nominal=" + String.valueOf(this.nominal) + "}";
        }
    }
}

