/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.doc;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.asset.Asset;
import fpml.consolidated.doc.InstrumentTradePricing;
import fpml.consolidated.doc.InstrumentTradePrincipal;
import fpml.consolidated.doc.InstrumentTradeQuantity;
import fpml.consolidated.doc.meta.InstrumentTradeDetailsMeta;
import fpml.consolidated.shared.BuyerSellerModel;
import fpml.consolidated.shared.Product;
import fpml.consolidated.shared.ProductModel;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="InstrumentTradeDetails", builder=InstrumentTradeDetailsBuilderImpl.class, version="1.2.2")
@RuneDataType(value="InstrumentTradeDetails", model="fpml", builder=InstrumentTradeDetailsBuilderImpl.class, version="1.2.2")
public interface InstrumentTradeDetails
extends Product {
    public static final InstrumentTradeDetailsMeta metaData = new InstrumentTradeDetailsMeta();

    public BuyerSellerModel getBuyerSellerModel();

    public Asset getUnderlyingAsset();

    public InstrumentTradeQuantity getQuantity();

    public InstrumentTradePricing getPricing();

    public InstrumentTradePrincipal getPrincipal();

    @Override
    public InstrumentTradeDetails build();

    @Override
    public InstrumentTradeDetailsBuilder toBuilder();

    public static InstrumentTradeDetailsBuilder builder() {
        return new InstrumentTradeDetailsBuilderImpl();
    }

    default public RosettaMetaData<? extends InstrumentTradeDetails> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends InstrumentTradeDetails> getType() {
        return InstrumentTradeDetails.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("productModel"), processor, ProductModel.class, this.getProductModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("buyerSellerModel"), processor, BuyerSellerModel.class, this.getBuyerSellerModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("underlyingAsset"), processor, Asset.class, this.getUnderlyingAsset(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("quantity"), processor, InstrumentTradeQuantity.class, this.getQuantity(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("pricing"), processor, InstrumentTradePricing.class, this.getPricing(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("principal"), processor, InstrumentTradePrincipal.class, this.getPrincipal(), new AttributeMeta[0]);
    }

    public static class InstrumentTradeDetailsBuilderImpl
    extends Product.ProductBuilderImpl
    implements InstrumentTradeDetailsBuilder {
        protected BuyerSellerModel.BuyerSellerModelBuilder buyerSellerModel;
        protected Asset.AssetBuilder underlyingAsset;
        protected InstrumentTradeQuantity.InstrumentTradeQuantityBuilder quantity;
        protected InstrumentTradePricing.InstrumentTradePricingBuilder pricing;
        protected InstrumentTradePrincipal.InstrumentTradePrincipalBuilder principal;

        @Override
        @RosettaAttribute(value="buyerSellerModel", isRequired=true)
        @RuneAttribute(value="buyerSellerModel", isRequired=true)
        public BuyerSellerModel.BuyerSellerModelBuilder getBuyerSellerModel() {
            return this.buyerSellerModel;
        }

        @Override
        public BuyerSellerModel.BuyerSellerModelBuilder getOrCreateBuyerSellerModel() {
            BuyerSellerModel.BuyerSellerModelBuilder result = this.buyerSellerModel != null ? this.buyerSellerModel : (this.buyerSellerModel = BuyerSellerModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="underlyingAsset")
        @RuneAttribute(value="underlyingAsset")
        public Asset.AssetBuilder getUnderlyingAsset() {
            return this.underlyingAsset;
        }

        @Override
        public Asset.AssetBuilder getOrCreateUnderlyingAsset() {
            Asset.AssetBuilder result = this.underlyingAsset != null ? this.underlyingAsset : (this.underlyingAsset = Asset.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="quantity")
        @RuneAttribute(value="quantity")
        public InstrumentTradeQuantity.InstrumentTradeQuantityBuilder getQuantity() {
            return this.quantity;
        }

        @Override
        public InstrumentTradeQuantity.InstrumentTradeQuantityBuilder getOrCreateQuantity() {
            InstrumentTradeQuantity.InstrumentTradeQuantityBuilder result = this.quantity != null ? this.quantity : (this.quantity = InstrumentTradeQuantity.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="pricing")
        @RuneAttribute(value="pricing")
        public InstrumentTradePricing.InstrumentTradePricingBuilder getPricing() {
            return this.pricing;
        }

        @Override
        public InstrumentTradePricing.InstrumentTradePricingBuilder getOrCreatePricing() {
            InstrumentTradePricing.InstrumentTradePricingBuilder result = this.pricing != null ? this.pricing : (this.pricing = InstrumentTradePricing.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="principal")
        @RuneAttribute(value="principal")
        public InstrumentTradePrincipal.InstrumentTradePrincipalBuilder getPrincipal() {
            return this.principal;
        }

        @Override
        public InstrumentTradePrincipal.InstrumentTradePrincipalBuilder getOrCreatePrincipal() {
            InstrumentTradePrincipal.InstrumentTradePrincipalBuilder result = this.principal != null ? this.principal : (this.principal = InstrumentTradePrincipal.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="productModel")
        @RuneAttribute(value="productModel")
        public InstrumentTradeDetailsBuilder setProductModel(ProductModel _productModel) {
            this.productModel = _productModel == null ? null : _productModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public InstrumentTradeDetailsBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="buyerSellerModel", isRequired=true)
        @RuneAttribute(value="buyerSellerModel", isRequired=true)
        public InstrumentTradeDetailsBuilder setBuyerSellerModel(BuyerSellerModel _buyerSellerModel) {
            this.buyerSellerModel = _buyerSellerModel == null ? null : _buyerSellerModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="underlyingAsset")
        @RuneAttribute(value="underlyingAsset")
        public InstrumentTradeDetailsBuilder setUnderlyingAsset(Asset _underlyingAsset) {
            this.underlyingAsset = _underlyingAsset == null ? null : _underlyingAsset.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="quantity")
        @RuneAttribute(value="quantity")
        public InstrumentTradeDetailsBuilder setQuantity(InstrumentTradeQuantity _quantity) {
            this.quantity = _quantity == null ? null : _quantity.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="pricing")
        @RuneAttribute(value="pricing")
        public InstrumentTradeDetailsBuilder setPricing(InstrumentTradePricing _pricing) {
            this.pricing = _pricing == null ? null : _pricing.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="principal")
        @RuneAttribute(value="principal")
        public InstrumentTradeDetailsBuilder setPrincipal(InstrumentTradePrincipal _principal) {
            this.principal = _principal == null ? null : _principal.toBuilder();
            return this;
        }

        @Override
        public InstrumentTradeDetails build() {
            return new InstrumentTradeDetailsImpl(this);
        }

        @Override
        public InstrumentTradeDetailsBuilder toBuilder() {
            return this;
        }

        @Override
        public InstrumentTradeDetailsBuilder prune() {
            super.prune();
            if (this.buyerSellerModel != null && !this.buyerSellerModel.prune().hasData()) {
                this.buyerSellerModel = null;
            }
            if (this.underlyingAsset != null && !this.underlyingAsset.prune().hasData()) {
                this.underlyingAsset = null;
            }
            if (this.quantity != null && !this.quantity.prune().hasData()) {
                this.quantity = null;
            }
            if (this.pricing != null && !this.pricing.prune().hasData()) {
                this.pricing = null;
            }
            if (this.principal != null && !this.principal.prune().hasData()) {
                this.principal = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getBuyerSellerModel() != null && this.getBuyerSellerModel().hasData()) {
                return true;
            }
            if (this.getUnderlyingAsset() != null && this.getUnderlyingAsset().hasData()) {
                return true;
            }
            if (this.getQuantity() != null && this.getQuantity().hasData()) {
                return true;
            }
            if (this.getPricing() != null && this.getPricing().hasData()) {
                return true;
            }
            return this.getPrincipal() != null && this.getPrincipal().hasData();
        }

        @Override
        public InstrumentTradeDetailsBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            InstrumentTradeDetailsBuilder o = (InstrumentTradeDetailsBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getBuyerSellerModel(), (RosettaModelObjectBuilder)o.getBuyerSellerModel(), this::setBuyerSellerModel);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getUnderlyingAsset(), (RosettaModelObjectBuilder)o.getUnderlyingAsset(), this::setUnderlyingAsset);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getQuantity(), (RosettaModelObjectBuilder)o.getQuantity(), this::setQuantity);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPricing(), (RosettaModelObjectBuilder)o.getPricing(), this::setPricing);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPrincipal(), (RosettaModelObjectBuilder)o.getPrincipal(), this::setPrincipal);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            InstrumentTradeDetails _that = (InstrumentTradeDetails)this.getType().cast(o);
            if (!Objects.equals(this.buyerSellerModel, _that.getBuyerSellerModel())) {
                return false;
            }
            if (!Objects.equals(this.underlyingAsset, _that.getUnderlyingAsset())) {
                return false;
            }
            if (!Objects.equals(this.quantity, _that.getQuantity())) {
                return false;
            }
            if (!Objects.equals(this.pricing, _that.getPricing())) {
                return false;
            }
            return Objects.equals(this.principal, _that.getPrincipal());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.buyerSellerModel != null ? this.buyerSellerModel.hashCode() : 0);
            _result = 31 * _result + (this.underlyingAsset != null ? this.underlyingAsset.hashCode() : 0);
            _result = 31 * _result + (this.quantity != null ? this.quantity.hashCode() : 0);
            _result = 31 * _result + (this.pricing != null ? this.pricing.hashCode() : 0);
            _result = 31 * _result + (this.principal != null ? this.principal.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "InstrumentTradeDetailsBuilder {buyerSellerModel=" + String.valueOf(this.buyerSellerModel) + ", underlyingAsset=" + String.valueOf(this.underlyingAsset) + ", quantity=" + String.valueOf(this.quantity) + ", pricing=" + String.valueOf(this.pricing) + ", principal=" + String.valueOf(this.principal) + "} " + super.toString();
        }
    }

    public static interface InstrumentTradeDetailsBuilder
    extends InstrumentTradeDetails,
    Product.ProductBuilder {
        public BuyerSellerModel.BuyerSellerModelBuilder getOrCreateBuyerSellerModel();

        @Override
        public BuyerSellerModel.BuyerSellerModelBuilder getBuyerSellerModel();

        public Asset.AssetBuilder getOrCreateUnderlyingAsset();

        @Override
        public Asset.AssetBuilder getUnderlyingAsset();

        public InstrumentTradeQuantity.InstrumentTradeQuantityBuilder getOrCreateQuantity();

        @Override
        public InstrumentTradeQuantity.InstrumentTradeQuantityBuilder getQuantity();

        public InstrumentTradePricing.InstrumentTradePricingBuilder getOrCreatePricing();

        @Override
        public InstrumentTradePricing.InstrumentTradePricingBuilder getPricing();

        public InstrumentTradePrincipal.InstrumentTradePrincipalBuilder getOrCreatePrincipal();

        @Override
        public InstrumentTradePrincipal.InstrumentTradePrincipalBuilder getPrincipal();

        @Override
        public InstrumentTradeDetailsBuilder setProductModel(ProductModel var1);

        @Override
        public InstrumentTradeDetailsBuilder setId(String var1);

        public InstrumentTradeDetailsBuilder setBuyerSellerModel(BuyerSellerModel var1);

        public InstrumentTradeDetailsBuilder setUnderlyingAsset(Asset var1);

        public InstrumentTradeDetailsBuilder setQuantity(InstrumentTradeQuantity var1);

        public InstrumentTradeDetailsBuilder setPricing(InstrumentTradePricing var1);

        public InstrumentTradeDetailsBuilder setPrincipal(InstrumentTradePrincipal var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("productModel"), processor, ProductModel.ProductModelBuilder.class, (RosettaModelObjectBuilder)this.getProductModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("buyerSellerModel"), processor, BuyerSellerModel.BuyerSellerModelBuilder.class, this.getBuyerSellerModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("underlyingAsset"), processor, Asset.AssetBuilder.class, this.getUnderlyingAsset(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("quantity"), processor, InstrumentTradeQuantity.InstrumentTradeQuantityBuilder.class, this.getQuantity(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("pricing"), processor, InstrumentTradePricing.InstrumentTradePricingBuilder.class, this.getPricing(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("principal"), processor, InstrumentTradePrincipal.InstrumentTradePrincipalBuilder.class, this.getPrincipal(), new AttributeMeta[0]);
        }

        @Override
        public InstrumentTradeDetailsBuilder prune();
    }

    public static class InstrumentTradeDetailsImpl
    extends Product.ProductImpl
    implements InstrumentTradeDetails {
        private final BuyerSellerModel buyerSellerModel;
        private final Asset underlyingAsset;
        private final InstrumentTradeQuantity quantity;
        private final InstrumentTradePricing pricing;
        private final InstrumentTradePrincipal principal;

        protected InstrumentTradeDetailsImpl(InstrumentTradeDetailsBuilder builder) {
            super(builder);
            this.buyerSellerModel = Optional.ofNullable(builder.getBuyerSellerModel()).map(f -> f.build()).orElse(null);
            this.underlyingAsset = Optional.ofNullable(builder.getUnderlyingAsset()).map(f -> f.build()).orElse(null);
            this.quantity = Optional.ofNullable(builder.getQuantity()).map(f -> f.build()).orElse(null);
            this.pricing = Optional.ofNullable(builder.getPricing()).map(f -> f.build()).orElse(null);
            this.principal = Optional.ofNullable(builder.getPrincipal()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="buyerSellerModel", isRequired=true)
        @RuneAttribute(value="buyerSellerModel", isRequired=true)
        public BuyerSellerModel getBuyerSellerModel() {
            return this.buyerSellerModel;
        }

        @Override
        @RosettaAttribute(value="underlyingAsset")
        @RuneAttribute(value="underlyingAsset")
        public Asset getUnderlyingAsset() {
            return this.underlyingAsset;
        }

        @Override
        @RosettaAttribute(value="quantity")
        @RuneAttribute(value="quantity")
        public InstrumentTradeQuantity getQuantity() {
            return this.quantity;
        }

        @Override
        @RosettaAttribute(value="pricing")
        @RuneAttribute(value="pricing")
        public InstrumentTradePricing getPricing() {
            return this.pricing;
        }

        @Override
        @RosettaAttribute(value="principal")
        @RuneAttribute(value="principal")
        public InstrumentTradePrincipal getPrincipal() {
            return this.principal;
        }

        @Override
        public InstrumentTradeDetails build() {
            return this;
        }

        @Override
        public InstrumentTradeDetailsBuilder toBuilder() {
            InstrumentTradeDetailsBuilder builder = InstrumentTradeDetails.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(InstrumentTradeDetailsBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getBuyerSellerModel()).ifPresent(builder::setBuyerSellerModel);
            Optional.ofNullable(this.getUnderlyingAsset()).ifPresent(builder::setUnderlyingAsset);
            Optional.ofNullable(this.getQuantity()).ifPresent(builder::setQuantity);
            Optional.ofNullable(this.getPricing()).ifPresent(builder::setPricing);
            Optional.ofNullable(this.getPrincipal()).ifPresent(builder::setPrincipal);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            InstrumentTradeDetails _that = (InstrumentTradeDetails)this.getType().cast(o);
            if (!Objects.equals(this.buyerSellerModel, _that.getBuyerSellerModel())) {
                return false;
            }
            if (!Objects.equals(this.underlyingAsset, _that.getUnderlyingAsset())) {
                return false;
            }
            if (!Objects.equals(this.quantity, _that.getQuantity())) {
                return false;
            }
            if (!Objects.equals(this.pricing, _that.getPricing())) {
                return false;
            }
            return Objects.equals(this.principal, _that.getPrincipal());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.buyerSellerModel != null ? this.buyerSellerModel.hashCode() : 0);
            _result = 31 * _result + (this.underlyingAsset != null ? this.underlyingAsset.hashCode() : 0);
            _result = 31 * _result + (this.quantity != null ? this.quantity.hashCode() : 0);
            _result = 31 * _result + (this.pricing != null ? this.pricing.hashCode() : 0);
            _result = 31 * _result + (this.principal != null ? this.principal.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "InstrumentTradeDetails {buyerSellerModel=" + String.valueOf(this.buyerSellerModel) + ", underlyingAsset=" + String.valueOf(this.underlyingAsset) + ", quantity=" + String.valueOf(this.quantity) + ", pricing=" + String.valueOf(this.pricing) + ", principal=" + String.valueOf(this.principal) + "} " + super.toString();
        }
    }
}

