/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.doc;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.doc.Approvals;
import fpml.consolidated.doc.meta.AllocationContentModelMeta;
import fpml.consolidated.shared.Collateral;
import fpml.consolidated.shared.Money;
import fpml.consolidated.shared.RelatedParty;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="AllocationContentModel", builder=AllocationContentModelBuilderImpl.class, version="1.2.2")
@RuneDataType(value="AllocationContentModel", model="fpml", builder=AllocationContentModelBuilderImpl.class, version="1.2.2")
public interface AllocationContentModel
extends RosettaModelObject {
    public static final AllocationContentModelMeta metaData = new AllocationContentModelMeta();

    public Collateral getCollateral();

    public Money getCreditChargeAmount();

    public Approvals getApprovals();

    public ZonedDateTime getMasterConfirmationDate();

    public List<? extends RelatedParty> getRelatedParty();

    public AllocationContentModel build();

    public AllocationContentModelBuilder toBuilder();

    public static AllocationContentModelBuilder builder() {
        return new AllocationContentModelBuilderImpl();
    }

    default public RosettaMetaData<? extends AllocationContentModel> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends AllocationContentModel> getType() {
        return AllocationContentModel.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("collateral"), processor, Collateral.class, this.getCollateral(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("creditChargeAmount"), processor, Money.class, this.getCreditChargeAmount(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("approvals"), processor, Approvals.class, this.getApprovals(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("masterConfirmationDate"), ZonedDateTime.class, (Object)this.getMasterConfirmationDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("relatedParty"), processor, RelatedParty.class, this.getRelatedParty(), new AttributeMeta[0]);
    }

    public static class AllocationContentModelBuilderImpl
    implements AllocationContentModelBuilder {
        protected Collateral.CollateralBuilder collateral;
        protected Money.MoneyBuilder creditChargeAmount;
        protected Approvals.ApprovalsBuilder approvals;
        protected ZonedDateTime masterConfirmationDate;
        protected List<RelatedParty.RelatedPartyBuilder> relatedParty = new ArrayList<RelatedParty.RelatedPartyBuilder>();

        @Override
        @RosettaAttribute(value="collateral")
        @RuneAttribute(value="collateral")
        public Collateral.CollateralBuilder getCollateral() {
            return this.collateral;
        }

        @Override
        public Collateral.CollateralBuilder getOrCreateCollateral() {
            Collateral.CollateralBuilder result = this.collateral != null ? this.collateral : (this.collateral = Collateral.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="creditChargeAmount")
        @RuneAttribute(value="creditChargeAmount")
        public Money.MoneyBuilder getCreditChargeAmount() {
            return this.creditChargeAmount;
        }

        @Override
        public Money.MoneyBuilder getOrCreateCreditChargeAmount() {
            Money.MoneyBuilder result = this.creditChargeAmount != null ? this.creditChargeAmount : (this.creditChargeAmount = Money.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="approvals")
        @RuneAttribute(value="approvals")
        public Approvals.ApprovalsBuilder getApprovals() {
            return this.approvals;
        }

        @Override
        public Approvals.ApprovalsBuilder getOrCreateApprovals() {
            Approvals.ApprovalsBuilder result = this.approvals != null ? this.approvals : (this.approvals = Approvals.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="masterConfirmationDate")
        @RuneAttribute(value="masterConfirmationDate")
        public ZonedDateTime getMasterConfirmationDate() {
            return this.masterConfirmationDate;
        }

        @Override
        @RosettaAttribute(value="relatedParty")
        @RuneAttribute(value="relatedParty")
        public List<? extends RelatedParty.RelatedPartyBuilder> getRelatedParty() {
            return this.relatedParty;
        }

        @Override
        public RelatedParty.RelatedPartyBuilder getOrCreateRelatedParty(int index) {
            if (this.relatedParty == null) {
                this.relatedParty = new ArrayList<RelatedParty.RelatedPartyBuilder>();
            }
            return (RelatedParty.RelatedPartyBuilder)this.getIndex(this.relatedParty, index, () -> {
                RelatedParty.RelatedPartyBuilder newRelatedParty = RelatedParty.builder();
                return newRelatedParty;
            });
        }

        @Override
        @RosettaAttribute(value="collateral")
        @RuneAttribute(value="collateral")
        public AllocationContentModelBuilder setCollateral(Collateral _collateral) {
            this.collateral = _collateral == null ? null : _collateral.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="creditChargeAmount")
        @RuneAttribute(value="creditChargeAmount")
        public AllocationContentModelBuilder setCreditChargeAmount(Money _creditChargeAmount) {
            this.creditChargeAmount = _creditChargeAmount == null ? null : _creditChargeAmount.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="approvals")
        @RuneAttribute(value="approvals")
        public AllocationContentModelBuilder setApprovals(Approvals _approvals) {
            this.approvals = _approvals == null ? null : _approvals.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="masterConfirmationDate")
        @RuneAttribute(value="masterConfirmationDate")
        public AllocationContentModelBuilder setMasterConfirmationDate(ZonedDateTime _masterConfirmationDate) {
            this.masterConfirmationDate = _masterConfirmationDate == null ? null : _masterConfirmationDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="relatedParty")
        @RuneAttribute(value="relatedParty")
        public AllocationContentModelBuilder addRelatedParty(RelatedParty _relatedParty) {
            if (_relatedParty != null) {
                this.relatedParty.add(_relatedParty.toBuilder());
            }
            return this;
        }

        @Override
        public AllocationContentModelBuilder addRelatedParty(RelatedParty _relatedParty, int idx) {
            this.getIndex(this.relatedParty, idx, () -> _relatedParty.toBuilder());
            return this;
        }

        @Override
        public AllocationContentModelBuilder addRelatedParty(List<? extends RelatedParty> relatedPartys) {
            if (relatedPartys != null) {
                for (RelatedParty relatedParty : relatedPartys) {
                    this.relatedParty.add(relatedParty.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="relatedParty")
        public AllocationContentModelBuilder setRelatedParty(List<? extends RelatedParty> relatedPartys) {
            this.relatedParty = relatedPartys == null ? new ArrayList<RelatedParty.RelatedPartyBuilder>() : (List)relatedPartys.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public AllocationContentModel build() {
            return new AllocationContentModelImpl(this);
        }

        @Override
        public AllocationContentModelBuilder toBuilder() {
            return this;
        }

        @Override
        public AllocationContentModelBuilder prune() {
            if (this.collateral != null && !this.collateral.prune().hasData()) {
                this.collateral = null;
            }
            if (this.creditChargeAmount != null && !this.creditChargeAmount.prune().hasData()) {
                this.creditChargeAmount = null;
            }
            if (this.approvals != null && !this.approvals.prune().hasData()) {
                this.approvals = null;
            }
            this.relatedParty = this.relatedParty.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getCollateral() != null && this.getCollateral().hasData()) {
                return true;
            }
            if (this.getCreditChargeAmount() != null && this.getCreditChargeAmount().hasData()) {
                return true;
            }
            if (this.getApprovals() != null && this.getApprovals().hasData()) {
                return true;
            }
            if (this.getMasterConfirmationDate() != null) {
                return true;
            }
            return this.getRelatedParty() != null && this.getRelatedParty().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        public AllocationContentModelBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            AllocationContentModelBuilder o = (AllocationContentModelBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCollateral(), (RosettaModelObjectBuilder)o.getCollateral(), this::setCollateral);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCreditChargeAmount(), (RosettaModelObjectBuilder)o.getCreditChargeAmount(), this::setCreditChargeAmount);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getApprovals(), (RosettaModelObjectBuilder)o.getApprovals(), this::setApprovals);
            merger.mergeRosetta(this.getRelatedParty(), o.getRelatedParty(), this::getOrCreateRelatedParty);
            merger.mergeBasic((Object)this.getMasterConfirmationDate(), (Object)o.getMasterConfirmationDate(), this::setMasterConfirmationDate, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            AllocationContentModel _that = this.getType().cast(o);
            if (!Objects.equals(this.collateral, _that.getCollateral())) {
                return false;
            }
            if (!Objects.equals(this.creditChargeAmount, _that.getCreditChargeAmount())) {
                return false;
            }
            if (!Objects.equals(this.approvals, _that.getApprovals())) {
                return false;
            }
            if (!Objects.equals(this.masterConfirmationDate, _that.getMasterConfirmationDate())) {
                return false;
            }
            return ListEquals.listEquals(this.relatedParty, _that.getRelatedParty());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.collateral != null ? this.collateral.hashCode() : 0);
            _result = 31 * _result + (this.creditChargeAmount != null ? this.creditChargeAmount.hashCode() : 0);
            _result = 31 * _result + (this.approvals != null ? this.approvals.hashCode() : 0);
            _result = 31 * _result + (this.masterConfirmationDate != null ? this.masterConfirmationDate.hashCode() : 0);
            _result = 31 * _result + (this.relatedParty != null ? this.relatedParty.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "AllocationContentModelBuilder {collateral=" + String.valueOf(this.collateral) + ", creditChargeAmount=" + String.valueOf(this.creditChargeAmount) + ", approvals=" + String.valueOf(this.approvals) + ", masterConfirmationDate=" + String.valueOf(this.masterConfirmationDate) + ", relatedParty=" + String.valueOf(this.relatedParty) + "}";
        }
    }

    public static interface AllocationContentModelBuilder
    extends AllocationContentModel,
    RosettaModelObjectBuilder {
        public Collateral.CollateralBuilder getOrCreateCollateral();

        @Override
        public Collateral.CollateralBuilder getCollateral();

        public Money.MoneyBuilder getOrCreateCreditChargeAmount();

        @Override
        public Money.MoneyBuilder getCreditChargeAmount();

        public Approvals.ApprovalsBuilder getOrCreateApprovals();

        @Override
        public Approvals.ApprovalsBuilder getApprovals();

        public RelatedParty.RelatedPartyBuilder getOrCreateRelatedParty(int var1);

        public List<? extends RelatedParty.RelatedPartyBuilder> getRelatedParty();

        public AllocationContentModelBuilder setCollateral(Collateral var1);

        public AllocationContentModelBuilder setCreditChargeAmount(Money var1);

        public AllocationContentModelBuilder setApprovals(Approvals var1);

        public AllocationContentModelBuilder setMasterConfirmationDate(ZonedDateTime var1);

        public AllocationContentModelBuilder addRelatedParty(RelatedParty var1);

        public AllocationContentModelBuilder addRelatedParty(RelatedParty var1, int var2);

        public AllocationContentModelBuilder addRelatedParty(List<? extends RelatedParty> var1);

        public AllocationContentModelBuilder setRelatedParty(List<? extends RelatedParty> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("collateral"), processor, Collateral.CollateralBuilder.class, this.getCollateral(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("creditChargeAmount"), processor, Money.MoneyBuilder.class, this.getCreditChargeAmount(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("approvals"), processor, Approvals.ApprovalsBuilder.class, this.getApprovals(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("masterConfirmationDate"), ZonedDateTime.class, (Object)this.getMasterConfirmationDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("relatedParty"), processor, RelatedParty.RelatedPartyBuilder.class, this.getRelatedParty(), new AttributeMeta[0]);
        }

        public AllocationContentModelBuilder prune();
    }

    public static class AllocationContentModelImpl
    implements AllocationContentModel {
        private final Collateral collateral;
        private final Money creditChargeAmount;
        private final Approvals approvals;
        private final ZonedDateTime masterConfirmationDate;
        private final List<? extends RelatedParty> relatedParty;

        protected AllocationContentModelImpl(AllocationContentModelBuilder builder) {
            this.collateral = Optional.ofNullable(builder.getCollateral()).map(f -> f.build()).orElse(null);
            this.creditChargeAmount = Optional.ofNullable(builder.getCreditChargeAmount()).map(f -> f.build()).orElse(null);
            this.approvals = Optional.ofNullable(builder.getApprovals()).map(f -> f.build()).orElse(null);
            this.masterConfirmationDate = builder.getMasterConfirmationDate();
            this.relatedParty = Optional.ofNullable(builder.getRelatedParty()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="collateral")
        @RuneAttribute(value="collateral")
        public Collateral getCollateral() {
            return this.collateral;
        }

        @Override
        @RosettaAttribute(value="creditChargeAmount")
        @RuneAttribute(value="creditChargeAmount")
        public Money getCreditChargeAmount() {
            return this.creditChargeAmount;
        }

        @Override
        @RosettaAttribute(value="approvals")
        @RuneAttribute(value="approvals")
        public Approvals getApprovals() {
            return this.approvals;
        }

        @Override
        @RosettaAttribute(value="masterConfirmationDate")
        @RuneAttribute(value="masterConfirmationDate")
        public ZonedDateTime getMasterConfirmationDate() {
            return this.masterConfirmationDate;
        }

        @Override
        @RosettaAttribute(value="relatedParty")
        @RuneAttribute(value="relatedParty")
        public List<? extends RelatedParty> getRelatedParty() {
            return this.relatedParty;
        }

        @Override
        public AllocationContentModel build() {
            return this;
        }

        @Override
        public AllocationContentModelBuilder toBuilder() {
            AllocationContentModelBuilder builder = AllocationContentModel.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(AllocationContentModelBuilder builder) {
            Optional.ofNullable(this.getCollateral()).ifPresent(builder::setCollateral);
            Optional.ofNullable(this.getCreditChargeAmount()).ifPresent(builder::setCreditChargeAmount);
            Optional.ofNullable(this.getApprovals()).ifPresent(builder::setApprovals);
            Optional.ofNullable(this.getMasterConfirmationDate()).ifPresent(builder::setMasterConfirmationDate);
            Optional.ofNullable(this.getRelatedParty()).ifPresent(builder::setRelatedParty);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            AllocationContentModel _that = this.getType().cast(o);
            if (!Objects.equals(this.collateral, _that.getCollateral())) {
                return false;
            }
            if (!Objects.equals(this.creditChargeAmount, _that.getCreditChargeAmount())) {
                return false;
            }
            if (!Objects.equals(this.approvals, _that.getApprovals())) {
                return false;
            }
            if (!Objects.equals(this.masterConfirmationDate, _that.getMasterConfirmationDate())) {
                return false;
            }
            return ListEquals.listEquals(this.relatedParty, _that.getRelatedParty());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.collateral != null ? this.collateral.hashCode() : 0);
            _result = 31 * _result + (this.creditChargeAmount != null ? this.creditChargeAmount.hashCode() : 0);
            _result = 31 * _result + (this.approvals != null ? this.approvals.hashCode() : 0);
            _result = 31 * _result + (this.masterConfirmationDate != null ? this.masterConfirmationDate.hashCode() : 0);
            _result = 31 * _result + (this.relatedParty != null ? this.relatedParty.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "AllocationContentModel {collateral=" + String.valueOf(this.collateral) + ", creditChargeAmount=" + String.valueOf(this.creditChargeAmount) + ", approvals=" + String.valueOf(this.approvals) + ", masterConfirmationDate=" + String.valueOf(this.masterConfirmationDate) + ", relatedParty=" + String.valueOf(this.relatedParty) + "}";
        }
    }
}

