/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.doc;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.doc.AlgorithmRole;
import fpml.consolidated.doc.meta.AlgorithmMeta;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="Algorithm", builder=AlgorithmBuilderImpl.class, version="1.2.2")
@RuneDataType(value="Algorithm", model="fpml", builder=AlgorithmBuilderImpl.class, version="1.2.2")
public interface Algorithm
extends RosettaModelObject {
    public static final AlgorithmMeta metaData = new AlgorithmMeta();

    public String getName();

    public AlgorithmRole getRole();

    public Algorithm build();

    public AlgorithmBuilder toBuilder();

    public static AlgorithmBuilder builder() {
        return new AlgorithmBuilderImpl();
    }

    default public RosettaMetaData<? extends Algorithm> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends Algorithm> getType() {
        return Algorithm.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("name"), String.class, (Object)this.getName(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("role"), processor, AlgorithmRole.class, this.getRole(), new AttributeMeta[0]);
    }

    public static class AlgorithmBuilderImpl
    implements AlgorithmBuilder {
        protected String name;
        protected AlgorithmRole.AlgorithmRoleBuilder role;

        @Override
        @RosettaAttribute(value="name", isRequired=true)
        @RuneAttribute(value="name", isRequired=true)
        public String getName() {
            return this.name;
        }

        @Override
        @RosettaAttribute(value="role", isRequired=true)
        @RuneAttribute(value="role", isRequired=true)
        public AlgorithmRole.AlgorithmRoleBuilder getRole() {
            return this.role;
        }

        @Override
        public AlgorithmRole.AlgorithmRoleBuilder getOrCreateRole() {
            AlgorithmRole.AlgorithmRoleBuilder result = this.role != null ? this.role : (this.role = AlgorithmRole.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="name", isRequired=true)
        @RuneAttribute(value="name", isRequired=true)
        public AlgorithmBuilder setName(String _name) {
            this.name = _name == null ? null : _name;
            return this;
        }

        @Override
        @RosettaAttribute(value="role", isRequired=true)
        @RuneAttribute(value="role", isRequired=true)
        public AlgorithmBuilder setRole(AlgorithmRole _role) {
            this.role = _role == null ? null : _role.toBuilder();
            return this;
        }

        @Override
        public Algorithm build() {
            return new AlgorithmImpl(this);
        }

        @Override
        public AlgorithmBuilder toBuilder() {
            return this;
        }

        @Override
        public AlgorithmBuilder prune() {
            if (this.role != null && !this.role.prune().hasData()) {
                this.role = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getName() != null) {
                return true;
            }
            return this.getRole() != null && this.getRole().hasData();
        }

        public AlgorithmBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            AlgorithmBuilder o = (AlgorithmBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getRole(), (RosettaModelObjectBuilder)o.getRole(), this::setRole);
            merger.mergeBasic((Object)this.getName(), (Object)o.getName(), this::setName, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            Algorithm _that = this.getType().cast(o);
            if (!Objects.equals(this.name, _that.getName())) {
                return false;
            }
            return Objects.equals(this.role, _that.getRole());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.name != null ? this.name.hashCode() : 0);
            _result = 31 * _result + (this.role != null ? this.role.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "AlgorithmBuilder {name=" + this.name + ", role=" + String.valueOf(this.role) + "}";
        }
    }

    public static interface AlgorithmBuilder
    extends Algorithm,
    RosettaModelObjectBuilder {
        public AlgorithmRole.AlgorithmRoleBuilder getOrCreateRole();

        @Override
        public AlgorithmRole.AlgorithmRoleBuilder getRole();

        public AlgorithmBuilder setName(String var1);

        public AlgorithmBuilder setRole(AlgorithmRole var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("name"), String.class, (Object)this.getName(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("role"), processor, AlgorithmRole.AlgorithmRoleBuilder.class, this.getRole(), new AttributeMeta[0]);
        }

        public AlgorithmBuilder prune();
    }

    public static class AlgorithmImpl
    implements Algorithm {
        private final String name;
        private final AlgorithmRole role;

        protected AlgorithmImpl(AlgorithmBuilder builder) {
            this.name = builder.getName();
            this.role = Optional.ofNullable(builder.getRole()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="name", isRequired=true)
        @RuneAttribute(value="name", isRequired=true)
        public String getName() {
            return this.name;
        }

        @Override
        @RosettaAttribute(value="role", isRequired=true)
        @RuneAttribute(value="role", isRequired=true)
        public AlgorithmRole getRole() {
            return this.role;
        }

        @Override
        public Algorithm build() {
            return this;
        }

        @Override
        public AlgorithmBuilder toBuilder() {
            AlgorithmBuilder builder = Algorithm.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(AlgorithmBuilder builder) {
            Optional.ofNullable(this.getName()).ifPresent(builder::setName);
            Optional.ofNullable(this.getRole()).ifPresent(builder::setRole);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            Algorithm _that = this.getType().cast(o);
            if (!Objects.equals(this.name, _that.getName())) {
                return false;
            }
            return Objects.equals(this.role, _that.getRole());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.name != null ? this.name.hashCode() : 0);
            _result = 31 * _result + (this.role != null ? this.role.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "Algorithm {name=" + this.name + ", role=" + String.valueOf(this.role) + "}";
        }
    }
}

