/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.credit.event.notification;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.credit.event.notification.CreditEvent;
import fpml.consolidated.credit.event.notification.meta.RestructuringEventMeta;
import fpml.consolidated.shared.Money;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="RestructuringEvent", builder=RestructuringEventBuilderImpl.class, version="1.2.2")
@RuneDataType(value="RestructuringEvent", model="fpml", builder=RestructuringEventBuilderImpl.class, version="1.2.2")
public interface RestructuringEvent
extends CreditEvent {
    public static final RestructuringEventMeta metaData = new RestructuringEventMeta();

    public Money getPartialExerciseAmount();

    @Override
    public RestructuringEvent build();

    @Override
    public RestructuringEventBuilder toBuilder();

    public static RestructuringEventBuilder builder() {
        return new RestructuringEventBuilderImpl();
    }

    default public RosettaMetaData<? extends RestructuringEvent> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends RestructuringEvent> getType() {
        return RestructuringEvent.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("partialExerciseAmount"), processor, Money.class, this.getPartialExerciseAmount(), new AttributeMeta[0]);
    }

    public static class RestructuringEventBuilderImpl
    extends CreditEvent.CreditEventBuilderImpl
    implements RestructuringEventBuilder {
        protected Money.MoneyBuilder partialExerciseAmount;

        @Override
        @RosettaAttribute(value="partialExerciseAmount")
        @RuneAttribute(value="partialExerciseAmount")
        public Money.MoneyBuilder getPartialExerciseAmount() {
            return this.partialExerciseAmount;
        }

        @Override
        public Money.MoneyBuilder getOrCreatePartialExerciseAmount() {
            Money.MoneyBuilder result = this.partialExerciseAmount != null ? this.partialExerciseAmount : (this.partialExerciseAmount = Money.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="partialExerciseAmount")
        @RuneAttribute(value="partialExerciseAmount")
        public RestructuringEventBuilder setPartialExerciseAmount(Money _partialExerciseAmount) {
            this.partialExerciseAmount = _partialExerciseAmount == null ? null : _partialExerciseAmount.toBuilder();
            return this;
        }

        @Override
        public RestructuringEvent build() {
            return new RestructuringEventImpl(this);
        }

        @Override
        public RestructuringEventBuilder toBuilder() {
            return this;
        }

        @Override
        public RestructuringEventBuilder prune() {
            super.prune();
            if (this.partialExerciseAmount != null && !this.partialExerciseAmount.prune().hasData()) {
                this.partialExerciseAmount = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            return this.getPartialExerciseAmount() != null && this.getPartialExerciseAmount().hasData();
        }

        @Override
        public RestructuringEventBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            RestructuringEventBuilder o = (RestructuringEventBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPartialExerciseAmount(), (RosettaModelObjectBuilder)o.getPartialExerciseAmount(), this::setPartialExerciseAmount);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            RestructuringEvent _that = (RestructuringEvent)this.getType().cast(o);
            return Objects.equals(this.partialExerciseAmount, _that.getPartialExerciseAmount());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.partialExerciseAmount != null ? this.partialExerciseAmount.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "RestructuringEventBuilder {partialExerciseAmount=" + String.valueOf(this.partialExerciseAmount) + "} " + super.toString();
        }
    }

    public static interface RestructuringEventBuilder
    extends RestructuringEvent,
    CreditEvent.CreditEventBuilder {
        public Money.MoneyBuilder getOrCreatePartialExerciseAmount();

        @Override
        public Money.MoneyBuilder getPartialExerciseAmount();

        public RestructuringEventBuilder setPartialExerciseAmount(Money var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("partialExerciseAmount"), processor, Money.MoneyBuilder.class, this.getPartialExerciseAmount(), new AttributeMeta[0]);
        }

        @Override
        public RestructuringEventBuilder prune();
    }

    public static class RestructuringEventImpl
    extends CreditEvent.CreditEventImpl
    implements RestructuringEvent {
        private final Money partialExerciseAmount;

        protected RestructuringEventImpl(RestructuringEventBuilder builder) {
            super(builder);
            this.partialExerciseAmount = Optional.ofNullable(builder.getPartialExerciseAmount()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="partialExerciseAmount")
        @RuneAttribute(value="partialExerciseAmount")
        public Money getPartialExerciseAmount() {
            return this.partialExerciseAmount;
        }

        @Override
        public RestructuringEvent build() {
            return this;
        }

        @Override
        public RestructuringEventBuilder toBuilder() {
            RestructuringEventBuilder builder = RestructuringEvent.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(RestructuringEventBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getPartialExerciseAmount()).ifPresent(builder::setPartialExerciseAmount);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            RestructuringEvent _that = (RestructuringEvent)this.getType().cast(o);
            return Objects.equals(this.partialExerciseAmount, _that.getPartialExerciseAmount());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.partialExerciseAmount != null ? this.partialExerciseAmount.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "RestructuringEvent {partialExerciseAmount=" + String.valueOf(this.partialExerciseAmount) + "} " + super.toString();
        }
    }
}

