/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.confirmation.processes;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.confirmation.processes.TradeWrapper;
import fpml.consolidated.confirmation.processes.meta.ClearingMeta;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="Clearing", builder=ClearingBuilderImpl.class, version="1.2.2")
@RuneDataType(value="Clearing", model="fpml", builder=ClearingBuilderImpl.class, version="1.2.2")
public interface Clearing
extends RosettaModelObject {
    public static final ClearingMeta metaData = new ClearingMeta();

    public TradeWrapper getSubmitted();

    public List<? extends TradeWrapper> getCleared();

    public Clearing build();

    public ClearingBuilder toBuilder();

    public static ClearingBuilder builder() {
        return new ClearingBuilderImpl();
    }

    default public RosettaMetaData<? extends Clearing> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends Clearing> getType() {
        return Clearing.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("submitted"), processor, TradeWrapper.class, this.getSubmitted(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("cleared"), processor, TradeWrapper.class, this.getCleared(), new AttributeMeta[0]);
    }

    public static class ClearingBuilderImpl
    implements ClearingBuilder {
        protected TradeWrapper.TradeWrapperBuilder submitted;
        protected List<TradeWrapper.TradeWrapperBuilder> cleared = new ArrayList<TradeWrapper.TradeWrapperBuilder>();

        @Override
        @RosettaAttribute(value="submitted", isRequired=true)
        @RuneAttribute(value="submitted", isRequired=true)
        public TradeWrapper.TradeWrapperBuilder getSubmitted() {
            return this.submitted;
        }

        @Override
        public TradeWrapper.TradeWrapperBuilder getOrCreateSubmitted() {
            TradeWrapper.TradeWrapperBuilder result = this.submitted != null ? this.submitted : (this.submitted = TradeWrapper.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="cleared", isRequired=true)
        @RuneAttribute(value="cleared", isRequired=true)
        public List<? extends TradeWrapper.TradeWrapperBuilder> getCleared() {
            return this.cleared;
        }

        @Override
        public TradeWrapper.TradeWrapperBuilder getOrCreateCleared(int index) {
            if (this.cleared == null) {
                this.cleared = new ArrayList<TradeWrapper.TradeWrapperBuilder>();
            }
            return (TradeWrapper.TradeWrapperBuilder)this.getIndex(this.cleared, index, () -> {
                TradeWrapper.TradeWrapperBuilder newCleared = TradeWrapper.builder();
                return newCleared;
            });
        }

        @Override
        @RosettaAttribute(value="submitted", isRequired=true)
        @RuneAttribute(value="submitted", isRequired=true)
        public ClearingBuilder setSubmitted(TradeWrapper _submitted) {
            this.submitted = _submitted == null ? null : _submitted.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="cleared", isRequired=true)
        @RuneAttribute(value="cleared", isRequired=true)
        public ClearingBuilder addCleared(TradeWrapper _cleared) {
            if (_cleared != null) {
                this.cleared.add(_cleared.toBuilder());
            }
            return this;
        }

        @Override
        public ClearingBuilder addCleared(TradeWrapper _cleared, int idx) {
            this.getIndex(this.cleared, idx, () -> _cleared.toBuilder());
            return this;
        }

        @Override
        public ClearingBuilder addCleared(List<? extends TradeWrapper> cleareds) {
            if (cleareds != null) {
                for (TradeWrapper tradeWrapper : cleareds) {
                    this.cleared.add(tradeWrapper.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="cleared")
        public ClearingBuilder setCleared(List<? extends TradeWrapper> cleareds) {
            this.cleared = cleareds == null ? new ArrayList<TradeWrapper.TradeWrapperBuilder>() : (List)cleareds.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public Clearing build() {
            return new ClearingImpl(this);
        }

        @Override
        public ClearingBuilder toBuilder() {
            return this;
        }

        @Override
        public ClearingBuilder prune() {
            if (this.submitted != null && !this.submitted.prune().hasData()) {
                this.submitted = null;
            }
            this.cleared = this.cleared.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getSubmitted() != null && this.getSubmitted().hasData()) {
                return true;
            }
            return this.getCleared() != null && this.getCleared().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        public ClearingBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            ClearingBuilder o = (ClearingBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getSubmitted(), (RosettaModelObjectBuilder)o.getSubmitted(), this::setSubmitted);
            merger.mergeRosetta(this.getCleared(), o.getCleared(), this::getOrCreateCleared);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            Clearing _that = this.getType().cast(o);
            if (!Objects.equals(this.submitted, _that.getSubmitted())) {
                return false;
            }
            return ListEquals.listEquals(this.cleared, _that.getCleared());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.submitted != null ? this.submitted.hashCode() : 0);
            _result = 31 * _result + (this.cleared != null ? this.cleared.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ClearingBuilder {submitted=" + String.valueOf(this.submitted) + ", cleared=" + String.valueOf(this.cleared) + "}";
        }
    }

    public static interface ClearingBuilder
    extends Clearing,
    RosettaModelObjectBuilder {
        public TradeWrapper.TradeWrapperBuilder getOrCreateSubmitted();

        @Override
        public TradeWrapper.TradeWrapperBuilder getSubmitted();

        public TradeWrapper.TradeWrapperBuilder getOrCreateCleared(int var1);

        public List<? extends TradeWrapper.TradeWrapperBuilder> getCleared();

        public ClearingBuilder setSubmitted(TradeWrapper var1);

        public ClearingBuilder addCleared(TradeWrapper var1);

        public ClearingBuilder addCleared(TradeWrapper var1, int var2);

        public ClearingBuilder addCleared(List<? extends TradeWrapper> var1);

        public ClearingBuilder setCleared(List<? extends TradeWrapper> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("submitted"), processor, TradeWrapper.TradeWrapperBuilder.class, this.getSubmitted(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("cleared"), processor, TradeWrapper.TradeWrapperBuilder.class, this.getCleared(), new AttributeMeta[0]);
        }

        public ClearingBuilder prune();
    }

    public static class ClearingImpl
    implements Clearing {
        private final TradeWrapper submitted;
        private final List<? extends TradeWrapper> cleared;

        protected ClearingImpl(ClearingBuilder builder) {
            this.submitted = Optional.ofNullable(builder.getSubmitted()).map(f -> f.build()).orElse(null);
            this.cleared = Optional.ofNullable(builder.getCleared()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="submitted", isRequired=true)
        @RuneAttribute(value="submitted", isRequired=true)
        public TradeWrapper getSubmitted() {
            return this.submitted;
        }

        @Override
        @RosettaAttribute(value="cleared", isRequired=true)
        @RuneAttribute(value="cleared", isRequired=true)
        public List<? extends TradeWrapper> getCleared() {
            return this.cleared;
        }

        @Override
        public Clearing build() {
            return this;
        }

        @Override
        public ClearingBuilder toBuilder() {
            ClearingBuilder builder = Clearing.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(ClearingBuilder builder) {
            Optional.ofNullable(this.getSubmitted()).ifPresent(builder::setSubmitted);
            Optional.ofNullable(this.getCleared()).ifPresent(builder::setCleared);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            Clearing _that = this.getType().cast(o);
            if (!Objects.equals(this.submitted, _that.getSubmitted())) {
                return false;
            }
            return ListEquals.listEquals(this.cleared, _that.getCleared());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.submitted != null ? this.submitted.hashCode() : 0);
            _result = 31 * _result + (this.cleared != null ? this.cleared.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "Clearing {submitted=" + String.valueOf(this.submitted) + ", cleared=" + String.valueOf(this.cleared) + "}";
        }
    }
}

