/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.confirmation.processes;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.confirmation.processes.meta.AllocationRefusedMeta;
import fpml.consolidated.doc.Allocations;
import fpml.consolidated.doc.Reason;
import fpml.consolidated.doc.TradeIdentifier;
import fpml.consolidated.doc.ValidationModel;
import fpml.consolidated.msg.CorrelationAndOptionalSequenceModel;
import fpml.consolidated.msg.ResponseMessage;
import fpml.consolidated.msg.ResponseMessageHeader;
import fpml.consolidated.shared.OnBehalfOfModel;
import fpml.consolidated.shared.PartiesAndAccountsModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="AllocationRefused", builder=AllocationRefusedBuilderImpl.class, version="1.2.2")
@RuneDataType(value="AllocationRefused", model="fpml", builder=AllocationRefusedBuilderImpl.class, version="1.2.2")
public interface AllocationRefused
extends ResponseMessage {
    public static final AllocationRefusedMeta metaData = new AllocationRefusedMeta();

    public TradeIdentifier getBlockTradeIdentifier();

    public Allocations getAllocations();

    public PartiesAndAccountsModel getPartiesAndAccountsModel();

    public List<? extends Reason> getReason();

    @Override
    public AllocationRefused build();

    @Override
    public AllocationRefusedBuilder toBuilder();

    public static AllocationRefusedBuilder builder() {
        return new AllocationRefusedBuilderImpl();
    }

    default public RosettaMetaData<? extends AllocationRefused> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends AllocationRefused> getType() {
        return AllocationRefused.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("fpmlVersion"), String.class, (Object)this.getFpmlVersion(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("expectedBuild"), Integer.class, (Object)this.getExpectedBuild(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("actualBuild"), Integer.class, (Object)this.getActualBuild(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("header"), processor, ResponseMessageHeader.class, this.getHeader(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("validationModel"), processor, ValidationModel.class, this.getValidationModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("correlationAndOptionalSequenceModel"), processor, CorrelationAndOptionalSequenceModel.class, this.getCorrelationAndOptionalSequenceModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("onBehalfOfModel"), processor, OnBehalfOfModel.class, this.getOnBehalfOfModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("blockTradeIdentifier"), processor, TradeIdentifier.class, this.getBlockTradeIdentifier(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("allocations"), processor, Allocations.class, this.getAllocations(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("partiesAndAccountsModel"), processor, PartiesAndAccountsModel.class, this.getPartiesAndAccountsModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("reason"), processor, Reason.class, this.getReason(), new AttributeMeta[0]);
    }

    public static class AllocationRefusedBuilderImpl
    extends ResponseMessage.ResponseMessageBuilderImpl
    implements AllocationRefusedBuilder {
        protected TradeIdentifier.TradeIdentifierBuilder blockTradeIdentifier;
        protected Allocations.AllocationsBuilder allocations;
        protected PartiesAndAccountsModel.PartiesAndAccountsModelBuilder partiesAndAccountsModel;
        protected List<Reason.ReasonBuilder> reason = new ArrayList<Reason.ReasonBuilder>();

        @Override
        @RosettaAttribute(value="blockTradeIdentifier")
        @RuneAttribute(value="blockTradeIdentifier")
        public TradeIdentifier.TradeIdentifierBuilder getBlockTradeIdentifier() {
            return this.blockTradeIdentifier;
        }

        @Override
        public TradeIdentifier.TradeIdentifierBuilder getOrCreateBlockTradeIdentifier() {
            TradeIdentifier.TradeIdentifierBuilder result = this.blockTradeIdentifier != null ? this.blockTradeIdentifier : (this.blockTradeIdentifier = TradeIdentifier.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="allocations")
        @RuneAttribute(value="allocations")
        public Allocations.AllocationsBuilder getAllocations() {
            return this.allocations;
        }

        @Override
        public Allocations.AllocationsBuilder getOrCreateAllocations() {
            Allocations.AllocationsBuilder result = this.allocations != null ? this.allocations : (this.allocations = Allocations.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="partiesAndAccountsModel")
        @RuneAttribute(value="partiesAndAccountsModel")
        public PartiesAndAccountsModel.PartiesAndAccountsModelBuilder getPartiesAndAccountsModel() {
            return this.partiesAndAccountsModel;
        }

        @Override
        public PartiesAndAccountsModel.PartiesAndAccountsModelBuilder getOrCreatePartiesAndAccountsModel() {
            PartiesAndAccountsModel.PartiesAndAccountsModelBuilder result = this.partiesAndAccountsModel != null ? this.partiesAndAccountsModel : (this.partiesAndAccountsModel = PartiesAndAccountsModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="reason")
        @RuneAttribute(value="reason")
        public List<? extends Reason.ReasonBuilder> getReason() {
            return this.reason;
        }

        @Override
        public Reason.ReasonBuilder getOrCreateReason(int index) {
            if (this.reason == null) {
                this.reason = new ArrayList<Reason.ReasonBuilder>();
            }
            return (Reason.ReasonBuilder)this.getIndex(this.reason, index, () -> {
                Reason.ReasonBuilder newReason = Reason.builder();
                return newReason;
            });
        }

        @Override
        @RosettaAttribute(value="fpmlVersion", isRequired=true)
        @RuneAttribute(value="fpmlVersion", isRequired=true)
        public AllocationRefusedBuilder setFpmlVersion(String _fpmlVersion) {
            this.fpmlVersion = _fpmlVersion == null ? null : _fpmlVersion;
            return this;
        }

        @Override
        @RosettaAttribute(value="expectedBuild")
        @RuneAttribute(value="expectedBuild")
        public AllocationRefusedBuilder setExpectedBuild(Integer _expectedBuild) {
            this.expectedBuild = _expectedBuild == null ? null : _expectedBuild;
            return this;
        }

        @Override
        @RosettaAttribute(value="actualBuild")
        @RuneAttribute(value="actualBuild")
        public AllocationRefusedBuilder setActualBuild(Integer _actualBuild) {
            this.actualBuild = _actualBuild == null ? null : _actualBuild;
            return this;
        }

        @Override
        @RosettaAttribute(value="header")
        @RuneAttribute(value="header")
        public AllocationRefusedBuilder setHeader(ResponseMessageHeader _header) {
            this.header = _header == null ? null : _header.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="validationModel", isRequired=true)
        @RuneAttribute(value="validationModel", isRequired=true)
        public AllocationRefusedBuilder setValidationModel(ValidationModel _validationModel) {
            this.validationModel = _validationModel == null ? null : _validationModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="correlationAndOptionalSequenceModel", isRequired=true)
        @RuneAttribute(value="correlationAndOptionalSequenceModel", isRequired=true)
        public AllocationRefusedBuilder setCorrelationAndOptionalSequenceModel(CorrelationAndOptionalSequenceModel _correlationAndOptionalSequenceModel) {
            this.correlationAndOptionalSequenceModel = _correlationAndOptionalSequenceModel == null ? null : _correlationAndOptionalSequenceModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="onBehalfOfModel")
        @RuneAttribute(value="onBehalfOfModel")
        public AllocationRefusedBuilder setOnBehalfOfModel(OnBehalfOfModel _onBehalfOfModel) {
            this.onBehalfOfModel = _onBehalfOfModel == null ? null : _onBehalfOfModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="blockTradeIdentifier")
        @RuneAttribute(value="blockTradeIdentifier")
        public AllocationRefusedBuilder setBlockTradeIdentifier(TradeIdentifier _blockTradeIdentifier) {
            this.blockTradeIdentifier = _blockTradeIdentifier == null ? null : _blockTradeIdentifier.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="allocations")
        @RuneAttribute(value="allocations")
        public AllocationRefusedBuilder setAllocations(Allocations _allocations) {
            this.allocations = _allocations == null ? null : _allocations.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="partiesAndAccountsModel")
        @RuneAttribute(value="partiesAndAccountsModel")
        public AllocationRefusedBuilder setPartiesAndAccountsModel(PartiesAndAccountsModel _partiesAndAccountsModel) {
            this.partiesAndAccountsModel = _partiesAndAccountsModel == null ? null : _partiesAndAccountsModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="reason")
        @RuneAttribute(value="reason")
        public AllocationRefusedBuilder addReason(Reason _reason) {
            if (_reason != null) {
                this.reason.add(_reason.toBuilder());
            }
            return this;
        }

        @Override
        public AllocationRefusedBuilder addReason(Reason _reason, int idx) {
            this.getIndex(this.reason, idx, () -> _reason.toBuilder());
            return this;
        }

        @Override
        public AllocationRefusedBuilder addReason(List<? extends Reason> reasons) {
            if (reasons != null) {
                for (Reason reason : reasons) {
                    this.reason.add(reason.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="reason")
        public AllocationRefusedBuilder setReason(List<? extends Reason> reasons) {
            this.reason = reasons == null ? new ArrayList<Reason.ReasonBuilder>() : (List)reasons.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public AllocationRefused build() {
            return new AllocationRefusedImpl(this);
        }

        @Override
        public AllocationRefusedBuilder toBuilder() {
            return this;
        }

        @Override
        public AllocationRefusedBuilder prune() {
            super.prune();
            if (this.blockTradeIdentifier != null && !this.blockTradeIdentifier.prune().hasData()) {
                this.blockTradeIdentifier = null;
            }
            if (this.allocations != null && !this.allocations.prune().hasData()) {
                this.allocations = null;
            }
            if (this.partiesAndAccountsModel != null && !this.partiesAndAccountsModel.prune().hasData()) {
                this.partiesAndAccountsModel = null;
            }
            this.reason = this.reason.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getBlockTradeIdentifier() != null && this.getBlockTradeIdentifier().hasData()) {
                return true;
            }
            if (this.getAllocations() != null && this.getAllocations().hasData()) {
                return true;
            }
            if (this.getPartiesAndAccountsModel() != null && this.getPartiesAndAccountsModel().hasData()) {
                return true;
            }
            return this.getReason() != null && this.getReason().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        @Override
        public AllocationRefusedBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            AllocationRefusedBuilder o = (AllocationRefusedBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getBlockTradeIdentifier(), (RosettaModelObjectBuilder)o.getBlockTradeIdentifier(), this::setBlockTradeIdentifier);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAllocations(), (RosettaModelObjectBuilder)o.getAllocations(), this::setAllocations);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPartiesAndAccountsModel(), (RosettaModelObjectBuilder)o.getPartiesAndAccountsModel(), this::setPartiesAndAccountsModel);
            merger.mergeRosetta(this.getReason(), o.getReason(), this::getOrCreateReason);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            AllocationRefused _that = (AllocationRefused)this.getType().cast(o);
            if (!Objects.equals(this.blockTradeIdentifier, _that.getBlockTradeIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.allocations, _that.getAllocations())) {
                return false;
            }
            if (!Objects.equals(this.partiesAndAccountsModel, _that.getPartiesAndAccountsModel())) {
                return false;
            }
            return ListEquals.listEquals(this.reason, _that.getReason());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.blockTradeIdentifier != null ? this.blockTradeIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.allocations != null ? this.allocations.hashCode() : 0);
            _result = 31 * _result + (this.partiesAndAccountsModel != null ? this.partiesAndAccountsModel.hashCode() : 0);
            _result = 31 * _result + (this.reason != null ? this.reason.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "AllocationRefusedBuilder {blockTradeIdentifier=" + String.valueOf(this.blockTradeIdentifier) + ", allocations=" + String.valueOf(this.allocations) + ", partiesAndAccountsModel=" + String.valueOf(this.partiesAndAccountsModel) + ", reason=" + String.valueOf(this.reason) + "} " + super.toString();
        }
    }

    public static interface AllocationRefusedBuilder
    extends AllocationRefused,
    ResponseMessage.ResponseMessageBuilder {
        public TradeIdentifier.TradeIdentifierBuilder getOrCreateBlockTradeIdentifier();

        @Override
        public TradeIdentifier.TradeIdentifierBuilder getBlockTradeIdentifier();

        public Allocations.AllocationsBuilder getOrCreateAllocations();

        @Override
        public Allocations.AllocationsBuilder getAllocations();

        public PartiesAndAccountsModel.PartiesAndAccountsModelBuilder getOrCreatePartiesAndAccountsModel();

        @Override
        public PartiesAndAccountsModel.PartiesAndAccountsModelBuilder getPartiesAndAccountsModel();

        public Reason.ReasonBuilder getOrCreateReason(int var1);

        public List<? extends Reason.ReasonBuilder> getReason();

        @Override
        public AllocationRefusedBuilder setFpmlVersion(String var1);

        @Override
        public AllocationRefusedBuilder setExpectedBuild(Integer var1);

        @Override
        public AllocationRefusedBuilder setActualBuild(Integer var1);

        @Override
        public AllocationRefusedBuilder setHeader(ResponseMessageHeader var1);

        @Override
        public AllocationRefusedBuilder setValidationModel(ValidationModel var1);

        @Override
        public AllocationRefusedBuilder setCorrelationAndOptionalSequenceModel(CorrelationAndOptionalSequenceModel var1);

        @Override
        public AllocationRefusedBuilder setOnBehalfOfModel(OnBehalfOfModel var1);

        public AllocationRefusedBuilder setBlockTradeIdentifier(TradeIdentifier var1);

        public AllocationRefusedBuilder setAllocations(Allocations var1);

        public AllocationRefusedBuilder setPartiesAndAccountsModel(PartiesAndAccountsModel var1);

        public AllocationRefusedBuilder addReason(Reason var1);

        public AllocationRefusedBuilder addReason(Reason var1, int var2);

        public AllocationRefusedBuilder addReason(List<? extends Reason> var1);

        public AllocationRefusedBuilder setReason(List<? extends Reason> var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("fpmlVersion"), String.class, (Object)this.getFpmlVersion(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("expectedBuild"), Integer.class, (Object)this.getExpectedBuild(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("actualBuild"), Integer.class, (Object)this.getActualBuild(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("header"), processor, ResponseMessageHeader.ResponseMessageHeaderBuilder.class, (RosettaModelObjectBuilder)this.getHeader(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("validationModel"), processor, ValidationModel.ValidationModelBuilder.class, (RosettaModelObjectBuilder)this.getValidationModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("correlationAndOptionalSequenceModel"), processor, CorrelationAndOptionalSequenceModel.CorrelationAndOptionalSequenceModelBuilder.class, (RosettaModelObjectBuilder)this.getCorrelationAndOptionalSequenceModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("onBehalfOfModel"), processor, OnBehalfOfModel.OnBehalfOfModelBuilder.class, (RosettaModelObjectBuilder)this.getOnBehalfOfModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("blockTradeIdentifier"), processor, TradeIdentifier.TradeIdentifierBuilder.class, this.getBlockTradeIdentifier(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("allocations"), processor, Allocations.AllocationsBuilder.class, this.getAllocations(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("partiesAndAccountsModel"), processor, PartiesAndAccountsModel.PartiesAndAccountsModelBuilder.class, this.getPartiesAndAccountsModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("reason"), processor, Reason.ReasonBuilder.class, this.getReason(), new AttributeMeta[0]);
        }

        @Override
        public AllocationRefusedBuilder prune();
    }

    public static class AllocationRefusedImpl
    extends ResponseMessage.ResponseMessageImpl
    implements AllocationRefused {
        private final TradeIdentifier blockTradeIdentifier;
        private final Allocations allocations;
        private final PartiesAndAccountsModel partiesAndAccountsModel;
        private final List<? extends Reason> reason;

        protected AllocationRefusedImpl(AllocationRefusedBuilder builder) {
            super(builder);
            this.blockTradeIdentifier = Optional.ofNullable(builder.getBlockTradeIdentifier()).map(f -> f.build()).orElse(null);
            this.allocations = Optional.ofNullable(builder.getAllocations()).map(f -> f.build()).orElse(null);
            this.partiesAndAccountsModel = Optional.ofNullable(builder.getPartiesAndAccountsModel()).map(f -> f.build()).orElse(null);
            this.reason = Optional.ofNullable(builder.getReason()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="blockTradeIdentifier")
        @RuneAttribute(value="blockTradeIdentifier")
        public TradeIdentifier getBlockTradeIdentifier() {
            return this.blockTradeIdentifier;
        }

        @Override
        @RosettaAttribute(value="allocations")
        @RuneAttribute(value="allocations")
        public Allocations getAllocations() {
            return this.allocations;
        }

        @Override
        @RosettaAttribute(value="partiesAndAccountsModel")
        @RuneAttribute(value="partiesAndAccountsModel")
        public PartiesAndAccountsModel getPartiesAndAccountsModel() {
            return this.partiesAndAccountsModel;
        }

        @Override
        @RosettaAttribute(value="reason")
        @RuneAttribute(value="reason")
        public List<? extends Reason> getReason() {
            return this.reason;
        }

        @Override
        public AllocationRefused build() {
            return this;
        }

        @Override
        public AllocationRefusedBuilder toBuilder() {
            AllocationRefusedBuilder builder = AllocationRefused.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(AllocationRefusedBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getBlockTradeIdentifier()).ifPresent(builder::setBlockTradeIdentifier);
            Optional.ofNullable(this.getAllocations()).ifPresent(builder::setAllocations);
            Optional.ofNullable(this.getPartiesAndAccountsModel()).ifPresent(builder::setPartiesAndAccountsModel);
            Optional.ofNullable(this.getReason()).ifPresent(builder::setReason);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            AllocationRefused _that = (AllocationRefused)this.getType().cast(o);
            if (!Objects.equals(this.blockTradeIdentifier, _that.getBlockTradeIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.allocations, _that.getAllocations())) {
                return false;
            }
            if (!Objects.equals(this.partiesAndAccountsModel, _that.getPartiesAndAccountsModel())) {
                return false;
            }
            return ListEquals.listEquals(this.reason, _that.getReason());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.blockTradeIdentifier != null ? this.blockTradeIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.allocations != null ? this.allocations.hashCode() : 0);
            _result = 31 * _result + (this.partiesAndAccountsModel != null ? this.partiesAndAccountsModel.hashCode() : 0);
            _result = 31 * _result + (this.reason != null ? this.reason.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "AllocationRefused {blockTradeIdentifier=" + String.valueOf(this.blockTradeIdentifier) + ", allocations=" + String.valueOf(this.allocations) + ", partiesAndAccountsModel=" + String.valueOf(this.partiesAndAccountsModel) + ", reason=" + String.valueOf(this.reason) + "} " + super.toString();
        }
    }
}

