/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.com;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.asset.CommodityClassification;
import fpml.consolidated.com.CommodityDeliveryPeriods;
import fpml.consolidated.com.CommodityPhysicalQuantity;
import fpml.consolidated.com.OilDelivery;
import fpml.consolidated.com.OilProduct;
import fpml.consolidated.com.PhysicalSwapLeg;
import fpml.consolidated.com.meta.OilPhysicalLegMeta;
import fpml.consolidated.shared.PayerReceiverModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="OilPhysicalLeg", builder=OilPhysicalLegBuilderImpl.class, version="1.2.2")
@RuneDataType(value="OilPhysicalLeg", model="fpml", builder=OilPhysicalLegBuilderImpl.class, version="1.2.2")
public interface OilPhysicalLeg
extends PhysicalSwapLeg {
    public static final OilPhysicalLegMeta metaData = new OilPhysicalLegMeta();

    public CommodityDeliveryPeriods getDeliveryPeriods();

    public OilProduct getOil();

    public OilDelivery getDeliveryConditions();

    public CommodityPhysicalQuantity getDeliveryQuantity();

    @Override
    public OilPhysicalLeg build();

    @Override
    public OilPhysicalLegBuilder toBuilder();

    public static OilPhysicalLegBuilder builder() {
        return new OilPhysicalLegBuilderImpl();
    }

    default public RosettaMetaData<? extends OilPhysicalLeg> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends OilPhysicalLeg> getType() {
        return OilPhysicalLeg.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("commodityClassification"), processor, CommodityClassification.class, this.getCommodityClassification(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("payerReceiverModel"), processor, PayerReceiverModel.class, this.getPayerReceiverModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("deliveryPeriods"), processor, CommodityDeliveryPeriods.class, this.getDeliveryPeriods(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("oil"), processor, OilProduct.class, this.getOil(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("deliveryConditions"), processor, OilDelivery.class, this.getDeliveryConditions(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("deliveryQuantity"), processor, CommodityPhysicalQuantity.class, this.getDeliveryQuantity(), new AttributeMeta[0]);
    }

    public static class OilPhysicalLegBuilderImpl
    extends PhysicalSwapLeg.PhysicalSwapLegBuilderImpl
    implements OilPhysicalLegBuilder {
        protected CommodityDeliveryPeriods.CommodityDeliveryPeriodsBuilder deliveryPeriods;
        protected OilProduct.OilProductBuilder oil;
        protected OilDelivery.OilDeliveryBuilder deliveryConditions;
        protected CommodityPhysicalQuantity.CommodityPhysicalQuantityBuilder deliveryQuantity;

        @Override
        @RosettaAttribute(value="deliveryPeriods")
        @RuneAttribute(value="deliveryPeriods")
        public CommodityDeliveryPeriods.CommodityDeliveryPeriodsBuilder getDeliveryPeriods() {
            return this.deliveryPeriods;
        }

        @Override
        public CommodityDeliveryPeriods.CommodityDeliveryPeriodsBuilder getOrCreateDeliveryPeriods() {
            CommodityDeliveryPeriods.CommodityDeliveryPeriodsBuilder result = this.deliveryPeriods != null ? this.deliveryPeriods : (this.deliveryPeriods = CommodityDeliveryPeriods.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="oil", isRequired=true)
        @RuneAttribute(value="oil", isRequired=true)
        public OilProduct.OilProductBuilder getOil() {
            return this.oil;
        }

        @Override
        public OilProduct.OilProductBuilder getOrCreateOil() {
            OilProduct.OilProductBuilder result = this.oil != null ? this.oil : (this.oil = OilProduct.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="deliveryConditions")
        @RuneAttribute(value="deliveryConditions")
        public OilDelivery.OilDeliveryBuilder getDeliveryConditions() {
            return this.deliveryConditions;
        }

        @Override
        public OilDelivery.OilDeliveryBuilder getOrCreateDeliveryConditions() {
            OilDelivery.OilDeliveryBuilder result = this.deliveryConditions != null ? this.deliveryConditions : (this.deliveryConditions = OilDelivery.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="deliveryQuantity", isRequired=true)
        @RuneAttribute(value="deliveryQuantity", isRequired=true)
        public CommodityPhysicalQuantity.CommodityPhysicalQuantityBuilder getDeliveryQuantity() {
            return this.deliveryQuantity;
        }

        @Override
        public CommodityPhysicalQuantity.CommodityPhysicalQuantityBuilder getOrCreateDeliveryQuantity() {
            CommodityPhysicalQuantity.CommodityPhysicalQuantityBuilder result = this.deliveryQuantity != null ? this.deliveryQuantity : (this.deliveryQuantity = CommodityPhysicalQuantity.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public OilPhysicalLegBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="commodityClassification")
        @RuneAttribute(value="commodityClassification")
        public OilPhysicalLegBuilder addCommodityClassification(CommodityClassification _commodityClassification) {
            if (_commodityClassification != null) {
                this.commodityClassification.add(_commodityClassification.toBuilder());
            }
            return this;
        }

        @Override
        public OilPhysicalLegBuilder addCommodityClassification(CommodityClassification _commodityClassification, int idx) {
            this.getIndex(this.commodityClassification, idx, () -> _commodityClassification.toBuilder());
            return this;
        }

        @Override
        public OilPhysicalLegBuilder addCommodityClassification(List<? extends CommodityClassification> commodityClassifications) {
            if (commodityClassifications != null) {
                for (CommodityClassification commodityClassification : commodityClassifications) {
                    this.commodityClassification.add(commodityClassification.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="commodityClassification")
        public OilPhysicalLegBuilder setCommodityClassification(List<? extends CommodityClassification> commodityClassifications) {
            this.commodityClassification = commodityClassifications == null ? new ArrayList() : (List)commodityClassifications.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="payerReceiverModel", isRequired=true)
        @RuneAttribute(value="payerReceiverModel", isRequired=true)
        public OilPhysicalLegBuilder setPayerReceiverModel(PayerReceiverModel _payerReceiverModel) {
            this.payerReceiverModel = _payerReceiverModel == null ? null : _payerReceiverModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="deliveryPeriods")
        @RuneAttribute(value="deliveryPeriods")
        public OilPhysicalLegBuilder setDeliveryPeriods(CommodityDeliveryPeriods _deliveryPeriods) {
            this.deliveryPeriods = _deliveryPeriods == null ? null : _deliveryPeriods.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="oil", isRequired=true)
        @RuneAttribute(value="oil", isRequired=true)
        public OilPhysicalLegBuilder setOil(OilProduct _oil) {
            this.oil = _oil == null ? null : _oil.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="deliveryConditions")
        @RuneAttribute(value="deliveryConditions")
        public OilPhysicalLegBuilder setDeliveryConditions(OilDelivery _deliveryConditions) {
            this.deliveryConditions = _deliveryConditions == null ? null : _deliveryConditions.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="deliveryQuantity", isRequired=true)
        @RuneAttribute(value="deliveryQuantity", isRequired=true)
        public OilPhysicalLegBuilder setDeliveryQuantity(CommodityPhysicalQuantity _deliveryQuantity) {
            this.deliveryQuantity = _deliveryQuantity == null ? null : _deliveryQuantity.toBuilder();
            return this;
        }

        @Override
        public OilPhysicalLeg build() {
            return new OilPhysicalLegImpl(this);
        }

        @Override
        public OilPhysicalLegBuilder toBuilder() {
            return this;
        }

        @Override
        public OilPhysicalLegBuilder prune() {
            super.prune();
            if (this.deliveryPeriods != null && !this.deliveryPeriods.prune().hasData()) {
                this.deliveryPeriods = null;
            }
            if (this.oil != null && !this.oil.prune().hasData()) {
                this.oil = null;
            }
            if (this.deliveryConditions != null && !this.deliveryConditions.prune().hasData()) {
                this.deliveryConditions = null;
            }
            if (this.deliveryQuantity != null && !this.deliveryQuantity.prune().hasData()) {
                this.deliveryQuantity = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getDeliveryPeriods() != null && this.getDeliveryPeriods().hasData()) {
                return true;
            }
            if (this.getOil() != null && this.getOil().hasData()) {
                return true;
            }
            if (this.getDeliveryConditions() != null && this.getDeliveryConditions().hasData()) {
                return true;
            }
            return this.getDeliveryQuantity() != null && this.getDeliveryQuantity().hasData();
        }

        @Override
        public OilPhysicalLegBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            OilPhysicalLegBuilder o = (OilPhysicalLegBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getDeliveryPeriods(), (RosettaModelObjectBuilder)o.getDeliveryPeriods(), this::setDeliveryPeriods);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getOil(), (RosettaModelObjectBuilder)o.getOil(), this::setOil);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getDeliveryConditions(), (RosettaModelObjectBuilder)o.getDeliveryConditions(), this::setDeliveryConditions);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getDeliveryQuantity(), (RosettaModelObjectBuilder)o.getDeliveryQuantity(), this::setDeliveryQuantity);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            OilPhysicalLeg _that = (OilPhysicalLeg)this.getType().cast(o);
            if (!Objects.equals(this.deliveryPeriods, _that.getDeliveryPeriods())) {
                return false;
            }
            if (!Objects.equals(this.oil, _that.getOil())) {
                return false;
            }
            if (!Objects.equals(this.deliveryConditions, _that.getDeliveryConditions())) {
                return false;
            }
            return Objects.equals(this.deliveryQuantity, _that.getDeliveryQuantity());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.deliveryPeriods != null ? this.deliveryPeriods.hashCode() : 0);
            _result = 31 * _result + (this.oil != null ? this.oil.hashCode() : 0);
            _result = 31 * _result + (this.deliveryConditions != null ? this.deliveryConditions.hashCode() : 0);
            _result = 31 * _result + (this.deliveryQuantity != null ? this.deliveryQuantity.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "OilPhysicalLegBuilder {deliveryPeriods=" + String.valueOf(this.deliveryPeriods) + ", oil=" + String.valueOf(this.oil) + ", deliveryConditions=" + String.valueOf(this.deliveryConditions) + ", deliveryQuantity=" + String.valueOf(this.deliveryQuantity) + "} " + super.toString();
        }
    }

    public static interface OilPhysicalLegBuilder
    extends OilPhysicalLeg,
    PhysicalSwapLeg.PhysicalSwapLegBuilder {
        public CommodityDeliveryPeriods.CommodityDeliveryPeriodsBuilder getOrCreateDeliveryPeriods();

        @Override
        public CommodityDeliveryPeriods.CommodityDeliveryPeriodsBuilder getDeliveryPeriods();

        public OilProduct.OilProductBuilder getOrCreateOil();

        @Override
        public OilProduct.OilProductBuilder getOil();

        public OilDelivery.OilDeliveryBuilder getOrCreateDeliveryConditions();

        @Override
        public OilDelivery.OilDeliveryBuilder getDeliveryConditions();

        public CommodityPhysicalQuantity.CommodityPhysicalQuantityBuilder getOrCreateDeliveryQuantity();

        @Override
        public CommodityPhysicalQuantity.CommodityPhysicalQuantityBuilder getDeliveryQuantity();

        @Override
        public OilPhysicalLegBuilder setId(String var1);

        @Override
        public OilPhysicalLegBuilder addCommodityClassification(CommodityClassification var1);

        @Override
        public OilPhysicalLegBuilder addCommodityClassification(CommodityClassification var1, int var2);

        @Override
        public OilPhysicalLegBuilder addCommodityClassification(List<? extends CommodityClassification> var1);

        @Override
        public OilPhysicalLegBuilder setCommodityClassification(List<? extends CommodityClassification> var1);

        @Override
        public OilPhysicalLegBuilder setPayerReceiverModel(PayerReceiverModel var1);

        public OilPhysicalLegBuilder setDeliveryPeriods(CommodityDeliveryPeriods var1);

        public OilPhysicalLegBuilder setOil(OilProduct var1);

        public OilPhysicalLegBuilder setDeliveryConditions(OilDelivery var1);

        public OilPhysicalLegBuilder setDeliveryQuantity(CommodityPhysicalQuantity var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("commodityClassification"), processor, CommodityClassification.CommodityClassificationBuilder.class, this.getCommodityClassification(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("payerReceiverModel"), processor, PayerReceiverModel.PayerReceiverModelBuilder.class, (RosettaModelObjectBuilder)this.getPayerReceiverModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("deliveryPeriods"), processor, CommodityDeliveryPeriods.CommodityDeliveryPeriodsBuilder.class, this.getDeliveryPeriods(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("oil"), processor, OilProduct.OilProductBuilder.class, this.getOil(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("deliveryConditions"), processor, OilDelivery.OilDeliveryBuilder.class, this.getDeliveryConditions(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("deliveryQuantity"), processor, CommodityPhysicalQuantity.CommodityPhysicalQuantityBuilder.class, this.getDeliveryQuantity(), new AttributeMeta[0]);
        }

        @Override
        public OilPhysicalLegBuilder prune();
    }

    public static class OilPhysicalLegImpl
    extends PhysicalSwapLeg.PhysicalSwapLegImpl
    implements OilPhysicalLeg {
        private final CommodityDeliveryPeriods deliveryPeriods;
        private final OilProduct oil;
        private final OilDelivery deliveryConditions;
        private final CommodityPhysicalQuantity deliveryQuantity;

        protected OilPhysicalLegImpl(OilPhysicalLegBuilder builder) {
            super(builder);
            this.deliveryPeriods = Optional.ofNullable(builder.getDeliveryPeriods()).map(f -> f.build()).orElse(null);
            this.oil = Optional.ofNullable(builder.getOil()).map(f -> f.build()).orElse(null);
            this.deliveryConditions = Optional.ofNullable(builder.getDeliveryConditions()).map(f -> f.build()).orElse(null);
            this.deliveryQuantity = Optional.ofNullable(builder.getDeliveryQuantity()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="deliveryPeriods")
        @RuneAttribute(value="deliveryPeriods")
        public CommodityDeliveryPeriods getDeliveryPeriods() {
            return this.deliveryPeriods;
        }

        @Override
        @RosettaAttribute(value="oil", isRequired=true)
        @RuneAttribute(value="oil", isRequired=true)
        public OilProduct getOil() {
            return this.oil;
        }

        @Override
        @RosettaAttribute(value="deliveryConditions")
        @RuneAttribute(value="deliveryConditions")
        public OilDelivery getDeliveryConditions() {
            return this.deliveryConditions;
        }

        @Override
        @RosettaAttribute(value="deliveryQuantity", isRequired=true)
        @RuneAttribute(value="deliveryQuantity", isRequired=true)
        public CommodityPhysicalQuantity getDeliveryQuantity() {
            return this.deliveryQuantity;
        }

        @Override
        public OilPhysicalLeg build() {
            return this;
        }

        @Override
        public OilPhysicalLegBuilder toBuilder() {
            OilPhysicalLegBuilder builder = OilPhysicalLeg.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(OilPhysicalLegBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getDeliveryPeriods()).ifPresent(builder::setDeliveryPeriods);
            Optional.ofNullable(this.getOil()).ifPresent(builder::setOil);
            Optional.ofNullable(this.getDeliveryConditions()).ifPresent(builder::setDeliveryConditions);
            Optional.ofNullable(this.getDeliveryQuantity()).ifPresent(builder::setDeliveryQuantity);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            OilPhysicalLeg _that = (OilPhysicalLeg)this.getType().cast(o);
            if (!Objects.equals(this.deliveryPeriods, _that.getDeliveryPeriods())) {
                return false;
            }
            if (!Objects.equals(this.oil, _that.getOil())) {
                return false;
            }
            if (!Objects.equals(this.deliveryConditions, _that.getDeliveryConditions())) {
                return false;
            }
            return Objects.equals(this.deliveryQuantity, _that.getDeliveryQuantity());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.deliveryPeriods != null ? this.deliveryPeriods.hashCode() : 0);
            _result = 31 * _result + (this.oil != null ? this.oil.hashCode() : 0);
            _result = 31 * _result + (this.deliveryConditions != null ? this.deliveryConditions.hashCode() : 0);
            _result = 31 * _result + (this.deliveryQuantity != null ? this.deliveryQuantity.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "OilPhysicalLeg {deliveryPeriods=" + String.valueOf(this.deliveryPeriods) + ", oil=" + String.valueOf(this.oil) + ", deliveryConditions=" + String.valueOf(this.deliveryConditions) + ", deliveryQuantity=" + String.valueOf(this.deliveryQuantity) + "} " + super.toString();
        }
    }
}

