/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.com;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.com.EnvironmentalProductApplicableLaw;
import fpml.consolidated.com.EnvironmentalProductComplaincePeriod;
import fpml.consolidated.com.EnvironmentalTrackingSystem;
import fpml.consolidated.com.meta.EnvironmentalProductMeta;
import fpml.consolidated.fpmlenum.EnvironmentalProductTypeEnum;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="EnvironmentalProduct", builder=EnvironmentalProductBuilderImpl.class, version="1.2.2")
@RuneDataType(value="EnvironmentalProduct", model="fpml", builder=EnvironmentalProductBuilderImpl.class, version="1.2.2")
public interface EnvironmentalProduct
extends RosettaModelObject {
    public static final EnvironmentalProductMeta metaData = new EnvironmentalProductMeta();

    public EnvironmentalProductTypeEnum getProductType();

    public EnvironmentalProductComplaincePeriod getCompliancePeriod();

    public List<String> getVintage();

    public EnvironmentalProductApplicableLaw getApplicableLaw();

    public EnvironmentalTrackingSystem getTrackingSystem();

    public EnvironmentalProduct build();

    public EnvironmentalProductBuilder toBuilder();

    public static EnvironmentalProductBuilder builder() {
        return new EnvironmentalProductBuilderImpl();
    }

    default public RosettaMetaData<? extends EnvironmentalProduct> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends EnvironmentalProduct> getType() {
        return EnvironmentalProduct.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("productType"), EnvironmentalProductTypeEnum.class, (Object)this.getProductType(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("compliancePeriod"), processor, EnvironmentalProductComplaincePeriod.class, this.getCompliancePeriod(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("vintage"), String.class, this.getVintage(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("applicableLaw"), processor, EnvironmentalProductApplicableLaw.class, this.getApplicableLaw(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("trackingSystem"), processor, EnvironmentalTrackingSystem.class, this.getTrackingSystem(), new AttributeMeta[0]);
    }

    public static class EnvironmentalProductBuilderImpl
    implements EnvironmentalProductBuilder {
        protected EnvironmentalProductTypeEnum productType;
        protected EnvironmentalProductComplaincePeriod.EnvironmentalProductComplaincePeriodBuilder compliancePeriod;
        protected List<String> vintage = new ArrayList<String>();
        protected EnvironmentalProductApplicableLaw.EnvironmentalProductApplicableLawBuilder applicableLaw;
        protected EnvironmentalTrackingSystem.EnvironmentalTrackingSystemBuilder trackingSystem;

        @Override
        @RosettaAttribute(value="productType", isRequired=true)
        @RuneAttribute(value="productType", isRequired=true)
        public EnvironmentalProductTypeEnum getProductType() {
            return this.productType;
        }

        @Override
        @RosettaAttribute(value="compliancePeriod")
        @RuneAttribute(value="compliancePeriod")
        public EnvironmentalProductComplaincePeriod.EnvironmentalProductComplaincePeriodBuilder getCompliancePeriod() {
            return this.compliancePeriod;
        }

        @Override
        public EnvironmentalProductComplaincePeriod.EnvironmentalProductComplaincePeriodBuilder getOrCreateCompliancePeriod() {
            EnvironmentalProductComplaincePeriod.EnvironmentalProductComplaincePeriodBuilder result = this.compliancePeriod != null ? this.compliancePeriod : (this.compliancePeriod = EnvironmentalProductComplaincePeriod.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="vintage")
        @RuneAttribute(value="vintage")
        public List<String> getVintage() {
            return this.vintage;
        }

        @Override
        @RosettaAttribute(value="applicableLaw")
        @RuneAttribute(value="applicableLaw")
        public EnvironmentalProductApplicableLaw.EnvironmentalProductApplicableLawBuilder getApplicableLaw() {
            return this.applicableLaw;
        }

        @Override
        public EnvironmentalProductApplicableLaw.EnvironmentalProductApplicableLawBuilder getOrCreateApplicableLaw() {
            EnvironmentalProductApplicableLaw.EnvironmentalProductApplicableLawBuilder result = this.applicableLaw != null ? this.applicableLaw : (this.applicableLaw = EnvironmentalProductApplicableLaw.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="trackingSystem")
        @RuneAttribute(value="trackingSystem")
        public EnvironmentalTrackingSystem.EnvironmentalTrackingSystemBuilder getTrackingSystem() {
            return this.trackingSystem;
        }

        @Override
        public EnvironmentalTrackingSystem.EnvironmentalTrackingSystemBuilder getOrCreateTrackingSystem() {
            EnvironmentalTrackingSystem.EnvironmentalTrackingSystemBuilder result = this.trackingSystem != null ? this.trackingSystem : (this.trackingSystem = EnvironmentalTrackingSystem.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="productType", isRequired=true)
        @RuneAttribute(value="productType", isRequired=true)
        public EnvironmentalProductBuilder setProductType(EnvironmentalProductTypeEnum _productType) {
            this.productType = _productType == null ? null : _productType;
            return this;
        }

        @Override
        @RosettaAttribute(value="compliancePeriod")
        @RuneAttribute(value="compliancePeriod")
        public EnvironmentalProductBuilder setCompliancePeriod(EnvironmentalProductComplaincePeriod _compliancePeriod) {
            this.compliancePeriod = _compliancePeriod == null ? null : _compliancePeriod.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="vintage")
        @RuneAttribute(value="vintage")
        public EnvironmentalProductBuilder addVintage(String _vintage) {
            if (_vintage != null) {
                this.vintage.add(_vintage);
            }
            return this;
        }

        @Override
        public EnvironmentalProductBuilder addVintage(String _vintage, int idx) {
            this.getIndex(this.vintage, idx, () -> _vintage);
            return this;
        }

        @Override
        public EnvironmentalProductBuilder addVintage(List<String> vintages) {
            if (vintages != null) {
                for (String toAdd : vintages) {
                    this.vintage.add(toAdd);
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="vintage")
        public EnvironmentalProductBuilder setVintage(List<String> vintages) {
            this.vintage = vintages == null ? new ArrayList<String>() : (List)vintages.stream().collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="applicableLaw")
        @RuneAttribute(value="applicableLaw")
        public EnvironmentalProductBuilder setApplicableLaw(EnvironmentalProductApplicableLaw _applicableLaw) {
            this.applicableLaw = _applicableLaw == null ? null : _applicableLaw.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="trackingSystem")
        @RuneAttribute(value="trackingSystem")
        public EnvironmentalProductBuilder setTrackingSystem(EnvironmentalTrackingSystem _trackingSystem) {
            this.trackingSystem = _trackingSystem == null ? null : _trackingSystem.toBuilder();
            return this;
        }

        @Override
        public EnvironmentalProduct build() {
            return new EnvironmentalProductImpl(this);
        }

        @Override
        public EnvironmentalProductBuilder toBuilder() {
            return this;
        }

        @Override
        public EnvironmentalProductBuilder prune() {
            if (this.compliancePeriod != null && !this.compliancePeriod.prune().hasData()) {
                this.compliancePeriod = null;
            }
            if (this.applicableLaw != null && !this.applicableLaw.prune().hasData()) {
                this.applicableLaw = null;
            }
            if (this.trackingSystem != null && !this.trackingSystem.prune().hasData()) {
                this.trackingSystem = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getProductType() != null) {
                return true;
            }
            if (this.getCompliancePeriod() != null && this.getCompliancePeriod().hasData()) {
                return true;
            }
            if (this.getVintage() != null && !this.getVintage().isEmpty()) {
                return true;
            }
            if (this.getApplicableLaw() != null && this.getApplicableLaw().hasData()) {
                return true;
            }
            return this.getTrackingSystem() != null && this.getTrackingSystem().hasData();
        }

        public EnvironmentalProductBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            EnvironmentalProductBuilder o = (EnvironmentalProductBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCompliancePeriod(), (RosettaModelObjectBuilder)o.getCompliancePeriod(), this::setCompliancePeriod);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getApplicableLaw(), (RosettaModelObjectBuilder)o.getApplicableLaw(), this::setApplicableLaw);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getTrackingSystem(), (RosettaModelObjectBuilder)o.getTrackingSystem(), this::setTrackingSystem);
            merger.mergeBasic((Object)this.getProductType(), (Object)o.getProductType(), this::setProductType, new AttributeMeta[0]);
            merger.mergeBasic(this.getVintage(), o.getVintage(), this::addVintage);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            EnvironmentalProduct _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.productType, (Object)_that.getProductType())) {
                return false;
            }
            if (!Objects.equals(this.compliancePeriod, _that.getCompliancePeriod())) {
                return false;
            }
            if (!ListEquals.listEquals(this.vintage, _that.getVintage())) {
                return false;
            }
            if (!Objects.equals(this.applicableLaw, _that.getApplicableLaw())) {
                return false;
            }
            return Objects.equals(this.trackingSystem, _that.getTrackingSystem());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.productType != null ? ((Object)((Object)this.productType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.compliancePeriod != null ? this.compliancePeriod.hashCode() : 0);
            _result = 31 * _result + (this.vintage != null ? this.vintage.hashCode() : 0);
            _result = 31 * _result + (this.applicableLaw != null ? this.applicableLaw.hashCode() : 0);
            _result = 31 * _result + (this.trackingSystem != null ? this.trackingSystem.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "EnvironmentalProductBuilder {productType=" + String.valueOf((Object)this.productType) + ", compliancePeriod=" + String.valueOf(this.compliancePeriod) + ", vintage=" + String.valueOf(this.vintage) + ", applicableLaw=" + String.valueOf(this.applicableLaw) + ", trackingSystem=" + String.valueOf(this.trackingSystem) + "}";
        }
    }

    public static interface EnvironmentalProductBuilder
    extends EnvironmentalProduct,
    RosettaModelObjectBuilder {
        public EnvironmentalProductComplaincePeriod.EnvironmentalProductComplaincePeriodBuilder getOrCreateCompliancePeriod();

        @Override
        public EnvironmentalProductComplaincePeriod.EnvironmentalProductComplaincePeriodBuilder getCompliancePeriod();

        public EnvironmentalProductApplicableLaw.EnvironmentalProductApplicableLawBuilder getOrCreateApplicableLaw();

        @Override
        public EnvironmentalProductApplicableLaw.EnvironmentalProductApplicableLawBuilder getApplicableLaw();

        public EnvironmentalTrackingSystem.EnvironmentalTrackingSystemBuilder getOrCreateTrackingSystem();

        @Override
        public EnvironmentalTrackingSystem.EnvironmentalTrackingSystemBuilder getTrackingSystem();

        public EnvironmentalProductBuilder setProductType(EnvironmentalProductTypeEnum var1);

        public EnvironmentalProductBuilder setCompliancePeriod(EnvironmentalProductComplaincePeriod var1);

        public EnvironmentalProductBuilder addVintage(String var1);

        public EnvironmentalProductBuilder addVintage(String var1, int var2);

        public EnvironmentalProductBuilder addVintage(List<String> var1);

        public EnvironmentalProductBuilder setVintage(List<String> var1);

        public EnvironmentalProductBuilder setApplicableLaw(EnvironmentalProductApplicableLaw var1);

        public EnvironmentalProductBuilder setTrackingSystem(EnvironmentalTrackingSystem var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("productType"), EnvironmentalProductTypeEnum.class, (Object)this.getProductType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("compliancePeriod"), processor, EnvironmentalProductComplaincePeriod.EnvironmentalProductComplaincePeriodBuilder.class, this.getCompliancePeriod(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("vintage"), String.class, this.getVintage(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("applicableLaw"), processor, EnvironmentalProductApplicableLaw.EnvironmentalProductApplicableLawBuilder.class, this.getApplicableLaw(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("trackingSystem"), processor, EnvironmentalTrackingSystem.EnvironmentalTrackingSystemBuilder.class, this.getTrackingSystem(), new AttributeMeta[0]);
        }

        public EnvironmentalProductBuilder prune();
    }

    public static class EnvironmentalProductImpl
    implements EnvironmentalProduct {
        private final EnvironmentalProductTypeEnum productType;
        private final EnvironmentalProductComplaincePeriod compliancePeriod;
        private final List<String> vintage;
        private final EnvironmentalProductApplicableLaw applicableLaw;
        private final EnvironmentalTrackingSystem trackingSystem;

        protected EnvironmentalProductImpl(EnvironmentalProductBuilder builder) {
            this.productType = builder.getProductType();
            this.compliancePeriod = Optional.ofNullable(builder.getCompliancePeriod()).map(f -> f.build()).orElse(null);
            this.vintage = Optional.ofNullable(builder.getVintage()).filter(_l -> !_l.isEmpty()).map(ImmutableList::copyOf).orElse(null);
            this.applicableLaw = Optional.ofNullable(builder.getApplicableLaw()).map(f -> f.build()).orElse(null);
            this.trackingSystem = Optional.ofNullable(builder.getTrackingSystem()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="productType", isRequired=true)
        @RuneAttribute(value="productType", isRequired=true)
        public EnvironmentalProductTypeEnum getProductType() {
            return this.productType;
        }

        @Override
        @RosettaAttribute(value="compliancePeriod")
        @RuneAttribute(value="compliancePeriod")
        public EnvironmentalProductComplaincePeriod getCompliancePeriod() {
            return this.compliancePeriod;
        }

        @Override
        @RosettaAttribute(value="vintage")
        @RuneAttribute(value="vintage")
        public List<String> getVintage() {
            return this.vintage;
        }

        @Override
        @RosettaAttribute(value="applicableLaw")
        @RuneAttribute(value="applicableLaw")
        public EnvironmentalProductApplicableLaw getApplicableLaw() {
            return this.applicableLaw;
        }

        @Override
        @RosettaAttribute(value="trackingSystem")
        @RuneAttribute(value="trackingSystem")
        public EnvironmentalTrackingSystem getTrackingSystem() {
            return this.trackingSystem;
        }

        @Override
        public EnvironmentalProduct build() {
            return this;
        }

        @Override
        public EnvironmentalProductBuilder toBuilder() {
            EnvironmentalProductBuilder builder = EnvironmentalProduct.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(EnvironmentalProductBuilder builder) {
            Optional.ofNullable(this.getProductType()).ifPresent(builder::setProductType);
            Optional.ofNullable(this.getCompliancePeriod()).ifPresent(builder::setCompliancePeriod);
            Optional.ofNullable(this.getVintage()).ifPresent(builder::setVintage);
            Optional.ofNullable(this.getApplicableLaw()).ifPresent(builder::setApplicableLaw);
            Optional.ofNullable(this.getTrackingSystem()).ifPresent(builder::setTrackingSystem);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            EnvironmentalProduct _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.productType, (Object)_that.getProductType())) {
                return false;
            }
            if (!Objects.equals(this.compliancePeriod, _that.getCompliancePeriod())) {
                return false;
            }
            if (!ListEquals.listEquals(this.vintage, _that.getVintage())) {
                return false;
            }
            if (!Objects.equals(this.applicableLaw, _that.getApplicableLaw())) {
                return false;
            }
            return Objects.equals(this.trackingSystem, _that.getTrackingSystem());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.productType != null ? ((Object)((Object)this.productType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.compliancePeriod != null ? this.compliancePeriod.hashCode() : 0);
            _result = 31 * _result + (this.vintage != null ? this.vintage.hashCode() : 0);
            _result = 31 * _result + (this.applicableLaw != null ? this.applicableLaw.hashCode() : 0);
            _result = 31 * _result + (this.trackingSystem != null ? this.trackingSystem.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "EnvironmentalProduct {productType=" + String.valueOf((Object)this.productType) + ", compliancePeriod=" + String.valueOf(this.compliancePeriod) + ", vintage=" + String.valueOf(this.vintage) + ", applicableLaw=" + String.valueOf(this.applicableLaw) + ", trackingSystem=" + String.valueOf(this.trackingSystem) + "}";
        }
    }
}

