/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.com;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.com.ElectricityTransmissionContingencyType;
import fpml.consolidated.com.meta.ElectricityTransmissionContingencyMeta;
import fpml.consolidated.shared.PartyReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="ElectricityTransmissionContingency", builder=ElectricityTransmissionContingencyBuilderImpl.class, version="1.2.2")
@RuneDataType(value="ElectricityTransmissionContingency", model="fpml", builder=ElectricityTransmissionContingencyBuilderImpl.class, version="1.2.2")
public interface ElectricityTransmissionContingency
extends RosettaModelObject {
    public static final ElectricityTransmissionContingencyMeta metaData = new ElectricityTransmissionContingencyMeta();

    public ElectricityTransmissionContingencyType getContingency();

    public List<? extends PartyReference> getContingentParty();

    public ElectricityTransmissionContingency build();

    public ElectricityTransmissionContingencyBuilder toBuilder();

    public static ElectricityTransmissionContingencyBuilder builder() {
        return new ElectricityTransmissionContingencyBuilderImpl();
    }

    default public RosettaMetaData<? extends ElectricityTransmissionContingency> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends ElectricityTransmissionContingency> getType() {
        return ElectricityTransmissionContingency.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("contingency"), processor, ElectricityTransmissionContingencyType.class, this.getContingency(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("contingentParty"), processor, PartyReference.class, this.getContingentParty(), new AttributeMeta[0]);
    }

    public static class ElectricityTransmissionContingencyBuilderImpl
    implements ElectricityTransmissionContingencyBuilder {
        protected ElectricityTransmissionContingencyType.ElectricityTransmissionContingencyTypeBuilder contingency;
        protected List<PartyReference.PartyReferenceBuilder> contingentParty = new ArrayList<PartyReference.PartyReferenceBuilder>();

        @Override
        @RosettaAttribute(value="contingency")
        @RuneAttribute(value="contingency")
        public ElectricityTransmissionContingencyType.ElectricityTransmissionContingencyTypeBuilder getContingency() {
            return this.contingency;
        }

        @Override
        public ElectricityTransmissionContingencyType.ElectricityTransmissionContingencyTypeBuilder getOrCreateContingency() {
            ElectricityTransmissionContingencyType.ElectricityTransmissionContingencyTypeBuilder result = this.contingency != null ? this.contingency : (this.contingency = ElectricityTransmissionContingencyType.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="contingentParty")
        @RuneAttribute(value="contingentParty")
        public List<? extends PartyReference.PartyReferenceBuilder> getContingentParty() {
            return this.contingentParty;
        }

        @Override
        public PartyReference.PartyReferenceBuilder getOrCreateContingentParty(int index) {
            if (this.contingentParty == null) {
                this.contingentParty = new ArrayList<PartyReference.PartyReferenceBuilder>();
            }
            return (PartyReference.PartyReferenceBuilder)this.getIndex(this.contingentParty, index, () -> {
                PartyReference.PartyReferenceBuilder newContingentParty = PartyReference.builder();
                return newContingentParty;
            });
        }

        @Override
        @RosettaAttribute(value="contingency")
        @RuneAttribute(value="contingency")
        public ElectricityTransmissionContingencyBuilder setContingency(ElectricityTransmissionContingencyType _contingency) {
            this.contingency = _contingency == null ? null : _contingency.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="contingentParty")
        @RuneAttribute(value="contingentParty")
        public ElectricityTransmissionContingencyBuilder addContingentParty(PartyReference _contingentParty) {
            if (_contingentParty != null) {
                this.contingentParty.add(_contingentParty.toBuilder());
            }
            return this;
        }

        @Override
        public ElectricityTransmissionContingencyBuilder addContingentParty(PartyReference _contingentParty, int idx) {
            this.getIndex(this.contingentParty, idx, () -> _contingentParty.toBuilder());
            return this;
        }

        @Override
        public ElectricityTransmissionContingencyBuilder addContingentParty(List<? extends PartyReference> contingentPartys) {
            if (contingentPartys != null) {
                for (PartyReference partyReference : contingentPartys) {
                    this.contingentParty.add(partyReference.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="contingentParty")
        public ElectricityTransmissionContingencyBuilder setContingentParty(List<? extends PartyReference> contingentPartys) {
            this.contingentParty = contingentPartys == null ? new ArrayList<PartyReference.PartyReferenceBuilder>() : (List)contingentPartys.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public ElectricityTransmissionContingency build() {
            return new ElectricityTransmissionContingencyImpl(this);
        }

        @Override
        public ElectricityTransmissionContingencyBuilder toBuilder() {
            return this;
        }

        @Override
        public ElectricityTransmissionContingencyBuilder prune() {
            if (this.contingency != null && !this.contingency.prune().hasData()) {
                this.contingency = null;
            }
            this.contingentParty = this.contingentParty.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getContingency() != null && this.getContingency().hasData()) {
                return true;
            }
            return this.getContingentParty() != null && this.getContingentParty().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        public ElectricityTransmissionContingencyBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            ElectricityTransmissionContingencyBuilder o = (ElectricityTransmissionContingencyBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getContingency(), (RosettaModelObjectBuilder)o.getContingency(), this::setContingency);
            merger.mergeRosetta(this.getContingentParty(), o.getContingentParty(), this::getOrCreateContingentParty);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ElectricityTransmissionContingency _that = this.getType().cast(o);
            if (!Objects.equals(this.contingency, _that.getContingency())) {
                return false;
            }
            return ListEquals.listEquals(this.contingentParty, _that.getContingentParty());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.contingency != null ? this.contingency.hashCode() : 0);
            _result = 31 * _result + (this.contingentParty != null ? this.contingentParty.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ElectricityTransmissionContingencyBuilder {contingency=" + String.valueOf(this.contingency) + ", contingentParty=" + String.valueOf(this.contingentParty) + "}";
        }
    }

    public static interface ElectricityTransmissionContingencyBuilder
    extends ElectricityTransmissionContingency,
    RosettaModelObjectBuilder {
        public ElectricityTransmissionContingencyType.ElectricityTransmissionContingencyTypeBuilder getOrCreateContingency();

        @Override
        public ElectricityTransmissionContingencyType.ElectricityTransmissionContingencyTypeBuilder getContingency();

        public PartyReference.PartyReferenceBuilder getOrCreateContingentParty(int var1);

        public List<? extends PartyReference.PartyReferenceBuilder> getContingentParty();

        public ElectricityTransmissionContingencyBuilder setContingency(ElectricityTransmissionContingencyType var1);

        public ElectricityTransmissionContingencyBuilder addContingentParty(PartyReference var1);

        public ElectricityTransmissionContingencyBuilder addContingentParty(PartyReference var1, int var2);

        public ElectricityTransmissionContingencyBuilder addContingentParty(List<? extends PartyReference> var1);

        public ElectricityTransmissionContingencyBuilder setContingentParty(List<? extends PartyReference> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("contingency"), processor, ElectricityTransmissionContingencyType.ElectricityTransmissionContingencyTypeBuilder.class, this.getContingency(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("contingentParty"), processor, PartyReference.PartyReferenceBuilder.class, this.getContingentParty(), new AttributeMeta[0]);
        }

        public ElectricityTransmissionContingencyBuilder prune();
    }

    public static class ElectricityTransmissionContingencyImpl
    implements ElectricityTransmissionContingency {
        private final ElectricityTransmissionContingencyType contingency;
        private final List<? extends PartyReference> contingentParty;

        protected ElectricityTransmissionContingencyImpl(ElectricityTransmissionContingencyBuilder builder) {
            this.contingency = Optional.ofNullable(builder.getContingency()).map(f -> f.build()).orElse(null);
            this.contingentParty = Optional.ofNullable(builder.getContingentParty()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="contingency")
        @RuneAttribute(value="contingency")
        public ElectricityTransmissionContingencyType getContingency() {
            return this.contingency;
        }

        @Override
        @RosettaAttribute(value="contingentParty")
        @RuneAttribute(value="contingentParty")
        public List<? extends PartyReference> getContingentParty() {
            return this.contingentParty;
        }

        @Override
        public ElectricityTransmissionContingency build() {
            return this;
        }

        @Override
        public ElectricityTransmissionContingencyBuilder toBuilder() {
            ElectricityTransmissionContingencyBuilder builder = ElectricityTransmissionContingency.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(ElectricityTransmissionContingencyBuilder builder) {
            Optional.ofNullable(this.getContingency()).ifPresent(builder::setContingency);
            Optional.ofNullable(this.getContingentParty()).ifPresent(builder::setContingentParty);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ElectricityTransmissionContingency _that = this.getType().cast(o);
            if (!Objects.equals(this.contingency, _that.getContingency())) {
                return false;
            }
            return ListEquals.listEquals(this.contingentParty, _that.getContingentParty());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.contingency != null ? this.contingency.hashCode() : 0);
            _result = 31 * _result + (this.contingentParty != null ? this.contingentParty.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ElectricityTransmissionContingency {contingency=" + String.valueOf(this.contingency) + ", contingentParty=" + String.valueOf(this.contingentParty) + "}";
        }
    }
}

