/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.com;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.com.CommodityContentModel;
import fpml.consolidated.com.CommodityFinancialOptionModel;
import fpml.consolidated.com.CommodityPhysicalOptionModel;
import fpml.consolidated.com.CommodityPremium;
import fpml.consolidated.com.CommodityWeatherOptionModel;
import fpml.consolidated.com.meta.CommodityOptionMeta;
import fpml.consolidated.fpmlenum.PutCallEnum;
import fpml.consolidated.shared.BuyerSellerModel;
import fpml.consolidated.shared.Product;
import fpml.consolidated.shared.ProductModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="CommodityOption", builder=CommodityOptionBuilderImpl.class, version="1.2.2")
@RuneDataType(value="CommodityOption", model="fpml", builder=CommodityOptionBuilderImpl.class, version="1.2.2")
public interface CommodityOption
extends Product {
    public static final CommodityOptionMeta metaData = new CommodityOptionMeta();

    public BuyerSellerModel getBuyerSellerModel();

    public PutCallEnum getOptionType();

    public CommodityFinancialOptionModel getCommodityFinancialOptionModel();

    public CommodityPhysicalOptionModel getCommodityPhysicalOptionModel();

    public CommodityWeatherOptionModel getCommodityWeatherOptionModel();

    public List<? extends CommodityPremium> getPremium();

    public CommodityContentModel getCommodityContentModel();

    @Override
    public CommodityOption build();

    @Override
    public CommodityOptionBuilder toBuilder();

    public static CommodityOptionBuilder builder() {
        return new CommodityOptionBuilderImpl();
    }

    default public RosettaMetaData<? extends CommodityOption> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends CommodityOption> getType() {
        return CommodityOption.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("productModel"), processor, ProductModel.class, this.getProductModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("buyerSellerModel"), processor, BuyerSellerModel.class, this.getBuyerSellerModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("optionType"), PutCallEnum.class, (Object)this.getOptionType(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("commodityFinancialOptionModel"), processor, CommodityFinancialOptionModel.class, this.getCommodityFinancialOptionModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("commodityPhysicalOptionModel"), processor, CommodityPhysicalOptionModel.class, this.getCommodityPhysicalOptionModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("commodityWeatherOptionModel"), processor, CommodityWeatherOptionModel.class, this.getCommodityWeatherOptionModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("premium"), processor, CommodityPremium.class, this.getPremium(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("commodityContentModel"), processor, CommodityContentModel.class, this.getCommodityContentModel(), new AttributeMeta[0]);
    }

    public static class CommodityOptionBuilderImpl
    extends Product.ProductBuilderImpl
    implements CommodityOptionBuilder {
        protected BuyerSellerModel.BuyerSellerModelBuilder buyerSellerModel;
        protected PutCallEnum optionType;
        protected CommodityFinancialOptionModel.CommodityFinancialOptionModelBuilder commodityFinancialOptionModel;
        protected CommodityPhysicalOptionModel.CommodityPhysicalOptionModelBuilder commodityPhysicalOptionModel;
        protected CommodityWeatherOptionModel.CommodityWeatherOptionModelBuilder commodityWeatherOptionModel;
        protected List<CommodityPremium.CommodityPremiumBuilder> premium = new ArrayList<CommodityPremium.CommodityPremiumBuilder>();
        protected CommodityContentModel.CommodityContentModelBuilder commodityContentModel;

        @Override
        @RosettaAttribute(value="buyerSellerModel", isRequired=true)
        @RuneAttribute(value="buyerSellerModel", isRequired=true)
        public BuyerSellerModel.BuyerSellerModelBuilder getBuyerSellerModel() {
            return this.buyerSellerModel;
        }

        @Override
        public BuyerSellerModel.BuyerSellerModelBuilder getOrCreateBuyerSellerModel() {
            BuyerSellerModel.BuyerSellerModelBuilder result = this.buyerSellerModel != null ? this.buyerSellerModel : (this.buyerSellerModel = BuyerSellerModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="optionType", isRequired=true)
        @RuneAttribute(value="optionType", isRequired=true)
        public PutCallEnum getOptionType() {
            return this.optionType;
        }

        @Override
        @RosettaAttribute(value="commodityFinancialOptionModel")
        @RuneAttribute(value="commodityFinancialOptionModel")
        public CommodityFinancialOptionModel.CommodityFinancialOptionModelBuilder getCommodityFinancialOptionModel() {
            return this.commodityFinancialOptionModel;
        }

        @Override
        public CommodityFinancialOptionModel.CommodityFinancialOptionModelBuilder getOrCreateCommodityFinancialOptionModel() {
            CommodityFinancialOptionModel.CommodityFinancialOptionModelBuilder result = this.commodityFinancialOptionModel != null ? this.commodityFinancialOptionModel : (this.commodityFinancialOptionModel = CommodityFinancialOptionModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="commodityPhysicalOptionModel")
        @RuneAttribute(value="commodityPhysicalOptionModel")
        public CommodityPhysicalOptionModel.CommodityPhysicalOptionModelBuilder getCommodityPhysicalOptionModel() {
            return this.commodityPhysicalOptionModel;
        }

        @Override
        public CommodityPhysicalOptionModel.CommodityPhysicalOptionModelBuilder getOrCreateCommodityPhysicalOptionModel() {
            CommodityPhysicalOptionModel.CommodityPhysicalOptionModelBuilder result = this.commodityPhysicalOptionModel != null ? this.commodityPhysicalOptionModel : (this.commodityPhysicalOptionModel = CommodityPhysicalOptionModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="commodityWeatherOptionModel")
        @RuneAttribute(value="commodityWeatherOptionModel")
        public CommodityWeatherOptionModel.CommodityWeatherOptionModelBuilder getCommodityWeatherOptionModel() {
            return this.commodityWeatherOptionModel;
        }

        @Override
        public CommodityWeatherOptionModel.CommodityWeatherOptionModelBuilder getOrCreateCommodityWeatherOptionModel() {
            CommodityWeatherOptionModel.CommodityWeatherOptionModelBuilder result = this.commodityWeatherOptionModel != null ? this.commodityWeatherOptionModel : (this.commodityWeatherOptionModel = CommodityWeatherOptionModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="premium")
        @RuneAttribute(value="premium")
        public List<? extends CommodityPremium.CommodityPremiumBuilder> getPremium() {
            return this.premium;
        }

        @Override
        public CommodityPremium.CommodityPremiumBuilder getOrCreatePremium(int index) {
            if (this.premium == null) {
                this.premium = new ArrayList<CommodityPremium.CommodityPremiumBuilder>();
            }
            return (CommodityPremium.CommodityPremiumBuilder)this.getIndex(this.premium, index, () -> {
                CommodityPremium.CommodityPremiumBuilder newPremium = CommodityPremium.builder();
                return newPremium;
            });
        }

        @Override
        @RosettaAttribute(value="commodityContentModel")
        @RuneAttribute(value="commodityContentModel")
        public CommodityContentModel.CommodityContentModelBuilder getCommodityContentModel() {
            return this.commodityContentModel;
        }

        @Override
        public CommodityContentModel.CommodityContentModelBuilder getOrCreateCommodityContentModel() {
            CommodityContentModel.CommodityContentModelBuilder result = this.commodityContentModel != null ? this.commodityContentModel : (this.commodityContentModel = CommodityContentModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="productModel")
        @RuneAttribute(value="productModel")
        public CommodityOptionBuilder setProductModel(ProductModel _productModel) {
            this.productModel = _productModel == null ? null : _productModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public CommodityOptionBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="buyerSellerModel", isRequired=true)
        @RuneAttribute(value="buyerSellerModel", isRequired=true)
        public CommodityOptionBuilder setBuyerSellerModel(BuyerSellerModel _buyerSellerModel) {
            this.buyerSellerModel = _buyerSellerModel == null ? null : _buyerSellerModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="optionType", isRequired=true)
        @RuneAttribute(value="optionType", isRequired=true)
        public CommodityOptionBuilder setOptionType(PutCallEnum _optionType) {
            this.optionType = _optionType == null ? null : _optionType;
            return this;
        }

        @Override
        @RosettaAttribute(value="commodityFinancialOptionModel")
        @RuneAttribute(value="commodityFinancialOptionModel")
        public CommodityOptionBuilder setCommodityFinancialOptionModel(CommodityFinancialOptionModel _commodityFinancialOptionModel) {
            this.commodityFinancialOptionModel = _commodityFinancialOptionModel == null ? null : _commodityFinancialOptionModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="commodityPhysicalOptionModel")
        @RuneAttribute(value="commodityPhysicalOptionModel")
        public CommodityOptionBuilder setCommodityPhysicalOptionModel(CommodityPhysicalOptionModel _commodityPhysicalOptionModel) {
            this.commodityPhysicalOptionModel = _commodityPhysicalOptionModel == null ? null : _commodityPhysicalOptionModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="commodityWeatherOptionModel")
        @RuneAttribute(value="commodityWeatherOptionModel")
        public CommodityOptionBuilder setCommodityWeatherOptionModel(CommodityWeatherOptionModel _commodityWeatherOptionModel) {
            this.commodityWeatherOptionModel = _commodityWeatherOptionModel == null ? null : _commodityWeatherOptionModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="premium")
        @RuneAttribute(value="premium")
        public CommodityOptionBuilder addPremium(CommodityPremium _premium) {
            if (_premium != null) {
                this.premium.add(_premium.toBuilder());
            }
            return this;
        }

        @Override
        public CommodityOptionBuilder addPremium(CommodityPremium _premium, int idx) {
            this.getIndex(this.premium, idx, () -> _premium.toBuilder());
            return this;
        }

        @Override
        public CommodityOptionBuilder addPremium(List<? extends CommodityPremium> premiums) {
            if (premiums != null) {
                for (CommodityPremium commodityPremium : premiums) {
                    this.premium.add(commodityPremium.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="premium")
        public CommodityOptionBuilder setPremium(List<? extends CommodityPremium> premiums) {
            this.premium = premiums == null ? new ArrayList<CommodityPremium.CommodityPremiumBuilder>() : (List)premiums.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="commodityContentModel")
        @RuneAttribute(value="commodityContentModel")
        public CommodityOptionBuilder setCommodityContentModel(CommodityContentModel _commodityContentModel) {
            this.commodityContentModel = _commodityContentModel == null ? null : _commodityContentModel.toBuilder();
            return this;
        }

        @Override
        public CommodityOption build() {
            return new CommodityOptionImpl(this);
        }

        @Override
        public CommodityOptionBuilder toBuilder() {
            return this;
        }

        @Override
        public CommodityOptionBuilder prune() {
            super.prune();
            if (this.buyerSellerModel != null && !this.buyerSellerModel.prune().hasData()) {
                this.buyerSellerModel = null;
            }
            if (this.commodityFinancialOptionModel != null && !this.commodityFinancialOptionModel.prune().hasData()) {
                this.commodityFinancialOptionModel = null;
            }
            if (this.commodityPhysicalOptionModel != null && !this.commodityPhysicalOptionModel.prune().hasData()) {
                this.commodityPhysicalOptionModel = null;
            }
            if (this.commodityWeatherOptionModel != null && !this.commodityWeatherOptionModel.prune().hasData()) {
                this.commodityWeatherOptionModel = null;
            }
            this.premium = this.premium.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.commodityContentModel != null && !this.commodityContentModel.prune().hasData()) {
                this.commodityContentModel = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getBuyerSellerModel() != null && this.getBuyerSellerModel().hasData()) {
                return true;
            }
            if (this.getOptionType() != null) {
                return true;
            }
            if (this.getCommodityFinancialOptionModel() != null && this.getCommodityFinancialOptionModel().hasData()) {
                return true;
            }
            if (this.getCommodityPhysicalOptionModel() != null && this.getCommodityPhysicalOptionModel().hasData()) {
                return true;
            }
            if (this.getCommodityWeatherOptionModel() != null && this.getCommodityWeatherOptionModel().hasData()) {
                return true;
            }
            if (this.getPremium() != null && this.getPremium().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getCommodityContentModel() != null && this.getCommodityContentModel().hasData();
        }

        @Override
        public CommodityOptionBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            CommodityOptionBuilder o = (CommodityOptionBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getBuyerSellerModel(), (RosettaModelObjectBuilder)o.getBuyerSellerModel(), this::setBuyerSellerModel);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCommodityFinancialOptionModel(), (RosettaModelObjectBuilder)o.getCommodityFinancialOptionModel(), this::setCommodityFinancialOptionModel);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCommodityPhysicalOptionModel(), (RosettaModelObjectBuilder)o.getCommodityPhysicalOptionModel(), this::setCommodityPhysicalOptionModel);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCommodityWeatherOptionModel(), (RosettaModelObjectBuilder)o.getCommodityWeatherOptionModel(), this::setCommodityWeatherOptionModel);
            merger.mergeRosetta(this.getPremium(), o.getPremium(), this::getOrCreatePremium);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCommodityContentModel(), (RosettaModelObjectBuilder)o.getCommodityContentModel(), this::setCommodityContentModel);
            merger.mergeBasic((Object)this.getOptionType(), (Object)o.getOptionType(), this::setOptionType, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            CommodityOption _that = (CommodityOption)this.getType().cast(o);
            if (!Objects.equals(this.buyerSellerModel, _that.getBuyerSellerModel())) {
                return false;
            }
            if (!Objects.equals((Object)this.optionType, (Object)_that.getOptionType())) {
                return false;
            }
            if (!Objects.equals(this.commodityFinancialOptionModel, _that.getCommodityFinancialOptionModel())) {
                return false;
            }
            if (!Objects.equals(this.commodityPhysicalOptionModel, _that.getCommodityPhysicalOptionModel())) {
                return false;
            }
            if (!Objects.equals(this.commodityWeatherOptionModel, _that.getCommodityWeatherOptionModel())) {
                return false;
            }
            if (!ListEquals.listEquals(this.premium, _that.getPremium())) {
                return false;
            }
            return Objects.equals(this.commodityContentModel, _that.getCommodityContentModel());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.buyerSellerModel != null ? this.buyerSellerModel.hashCode() : 0);
            _result = 31 * _result + (this.optionType != null ? ((Object)((Object)this.optionType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.commodityFinancialOptionModel != null ? this.commodityFinancialOptionModel.hashCode() : 0);
            _result = 31 * _result + (this.commodityPhysicalOptionModel != null ? this.commodityPhysicalOptionModel.hashCode() : 0);
            _result = 31 * _result + (this.commodityWeatherOptionModel != null ? this.commodityWeatherOptionModel.hashCode() : 0);
            _result = 31 * _result + (this.premium != null ? this.premium.hashCode() : 0);
            _result = 31 * _result + (this.commodityContentModel != null ? this.commodityContentModel.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "CommodityOptionBuilder {buyerSellerModel=" + String.valueOf(this.buyerSellerModel) + ", optionType=" + String.valueOf((Object)this.optionType) + ", commodityFinancialOptionModel=" + String.valueOf(this.commodityFinancialOptionModel) + ", commodityPhysicalOptionModel=" + String.valueOf(this.commodityPhysicalOptionModel) + ", commodityWeatherOptionModel=" + String.valueOf(this.commodityWeatherOptionModel) + ", premium=" + String.valueOf(this.premium) + ", commodityContentModel=" + String.valueOf(this.commodityContentModel) + "} " + super.toString();
        }
    }

    public static interface CommodityOptionBuilder
    extends CommodityOption,
    Product.ProductBuilder {
        public BuyerSellerModel.BuyerSellerModelBuilder getOrCreateBuyerSellerModel();

        @Override
        public BuyerSellerModel.BuyerSellerModelBuilder getBuyerSellerModel();

        public CommodityFinancialOptionModel.CommodityFinancialOptionModelBuilder getOrCreateCommodityFinancialOptionModel();

        @Override
        public CommodityFinancialOptionModel.CommodityFinancialOptionModelBuilder getCommodityFinancialOptionModel();

        public CommodityPhysicalOptionModel.CommodityPhysicalOptionModelBuilder getOrCreateCommodityPhysicalOptionModel();

        @Override
        public CommodityPhysicalOptionModel.CommodityPhysicalOptionModelBuilder getCommodityPhysicalOptionModel();

        public CommodityWeatherOptionModel.CommodityWeatherOptionModelBuilder getOrCreateCommodityWeatherOptionModel();

        @Override
        public CommodityWeatherOptionModel.CommodityWeatherOptionModelBuilder getCommodityWeatherOptionModel();

        public CommodityPremium.CommodityPremiumBuilder getOrCreatePremium(int var1);

        public List<? extends CommodityPremium.CommodityPremiumBuilder> getPremium();

        public CommodityContentModel.CommodityContentModelBuilder getOrCreateCommodityContentModel();

        @Override
        public CommodityContentModel.CommodityContentModelBuilder getCommodityContentModel();

        @Override
        public CommodityOptionBuilder setProductModel(ProductModel var1);

        @Override
        public CommodityOptionBuilder setId(String var1);

        public CommodityOptionBuilder setBuyerSellerModel(BuyerSellerModel var1);

        public CommodityOptionBuilder setOptionType(PutCallEnum var1);

        public CommodityOptionBuilder setCommodityFinancialOptionModel(CommodityFinancialOptionModel var1);

        public CommodityOptionBuilder setCommodityPhysicalOptionModel(CommodityPhysicalOptionModel var1);

        public CommodityOptionBuilder setCommodityWeatherOptionModel(CommodityWeatherOptionModel var1);

        public CommodityOptionBuilder addPremium(CommodityPremium var1);

        public CommodityOptionBuilder addPremium(CommodityPremium var1, int var2);

        public CommodityOptionBuilder addPremium(List<? extends CommodityPremium> var1);

        public CommodityOptionBuilder setPremium(List<? extends CommodityPremium> var1);

        public CommodityOptionBuilder setCommodityContentModel(CommodityContentModel var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("productModel"), processor, ProductModel.ProductModelBuilder.class, (RosettaModelObjectBuilder)this.getProductModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("buyerSellerModel"), processor, BuyerSellerModel.BuyerSellerModelBuilder.class, this.getBuyerSellerModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("optionType"), PutCallEnum.class, (Object)this.getOptionType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("commodityFinancialOptionModel"), processor, CommodityFinancialOptionModel.CommodityFinancialOptionModelBuilder.class, this.getCommodityFinancialOptionModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("commodityPhysicalOptionModel"), processor, CommodityPhysicalOptionModel.CommodityPhysicalOptionModelBuilder.class, this.getCommodityPhysicalOptionModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("commodityWeatherOptionModel"), processor, CommodityWeatherOptionModel.CommodityWeatherOptionModelBuilder.class, this.getCommodityWeatherOptionModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("premium"), processor, CommodityPremium.CommodityPremiumBuilder.class, this.getPremium(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("commodityContentModel"), processor, CommodityContentModel.CommodityContentModelBuilder.class, this.getCommodityContentModel(), new AttributeMeta[0]);
        }

        @Override
        public CommodityOptionBuilder prune();
    }

    public static class CommodityOptionImpl
    extends Product.ProductImpl
    implements CommodityOption {
        private final BuyerSellerModel buyerSellerModel;
        private final PutCallEnum optionType;
        private final CommodityFinancialOptionModel commodityFinancialOptionModel;
        private final CommodityPhysicalOptionModel commodityPhysicalOptionModel;
        private final CommodityWeatherOptionModel commodityWeatherOptionModel;
        private final List<? extends CommodityPremium> premium;
        private final CommodityContentModel commodityContentModel;

        protected CommodityOptionImpl(CommodityOptionBuilder builder) {
            super(builder);
            this.buyerSellerModel = Optional.ofNullable(builder.getBuyerSellerModel()).map(f -> f.build()).orElse(null);
            this.optionType = builder.getOptionType();
            this.commodityFinancialOptionModel = Optional.ofNullable(builder.getCommodityFinancialOptionModel()).map(f -> f.build()).orElse(null);
            this.commodityPhysicalOptionModel = Optional.ofNullable(builder.getCommodityPhysicalOptionModel()).map(f -> f.build()).orElse(null);
            this.commodityWeatherOptionModel = Optional.ofNullable(builder.getCommodityWeatherOptionModel()).map(f -> f.build()).orElse(null);
            this.premium = Optional.ofNullable(builder.getPremium()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.commodityContentModel = Optional.ofNullable(builder.getCommodityContentModel()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="buyerSellerModel", isRequired=true)
        @RuneAttribute(value="buyerSellerModel", isRequired=true)
        public BuyerSellerModel getBuyerSellerModel() {
            return this.buyerSellerModel;
        }

        @Override
        @RosettaAttribute(value="optionType", isRequired=true)
        @RuneAttribute(value="optionType", isRequired=true)
        public PutCallEnum getOptionType() {
            return this.optionType;
        }

        @Override
        @RosettaAttribute(value="commodityFinancialOptionModel")
        @RuneAttribute(value="commodityFinancialOptionModel")
        public CommodityFinancialOptionModel getCommodityFinancialOptionModel() {
            return this.commodityFinancialOptionModel;
        }

        @Override
        @RosettaAttribute(value="commodityPhysicalOptionModel")
        @RuneAttribute(value="commodityPhysicalOptionModel")
        public CommodityPhysicalOptionModel getCommodityPhysicalOptionModel() {
            return this.commodityPhysicalOptionModel;
        }

        @Override
        @RosettaAttribute(value="commodityWeatherOptionModel")
        @RuneAttribute(value="commodityWeatherOptionModel")
        public CommodityWeatherOptionModel getCommodityWeatherOptionModel() {
            return this.commodityWeatherOptionModel;
        }

        @Override
        @RosettaAttribute(value="premium")
        @RuneAttribute(value="premium")
        public List<? extends CommodityPremium> getPremium() {
            return this.premium;
        }

        @Override
        @RosettaAttribute(value="commodityContentModel")
        @RuneAttribute(value="commodityContentModel")
        public CommodityContentModel getCommodityContentModel() {
            return this.commodityContentModel;
        }

        @Override
        public CommodityOption build() {
            return this;
        }

        @Override
        public CommodityOptionBuilder toBuilder() {
            CommodityOptionBuilder builder = CommodityOption.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CommodityOptionBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getBuyerSellerModel()).ifPresent(builder::setBuyerSellerModel);
            Optional.ofNullable(this.getOptionType()).ifPresent(builder::setOptionType);
            Optional.ofNullable(this.getCommodityFinancialOptionModel()).ifPresent(builder::setCommodityFinancialOptionModel);
            Optional.ofNullable(this.getCommodityPhysicalOptionModel()).ifPresent(builder::setCommodityPhysicalOptionModel);
            Optional.ofNullable(this.getCommodityWeatherOptionModel()).ifPresent(builder::setCommodityWeatherOptionModel);
            Optional.ofNullable(this.getPremium()).ifPresent(builder::setPremium);
            Optional.ofNullable(this.getCommodityContentModel()).ifPresent(builder::setCommodityContentModel);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            CommodityOption _that = (CommodityOption)this.getType().cast(o);
            if (!Objects.equals(this.buyerSellerModel, _that.getBuyerSellerModel())) {
                return false;
            }
            if (!Objects.equals((Object)this.optionType, (Object)_that.getOptionType())) {
                return false;
            }
            if (!Objects.equals(this.commodityFinancialOptionModel, _that.getCommodityFinancialOptionModel())) {
                return false;
            }
            if (!Objects.equals(this.commodityPhysicalOptionModel, _that.getCommodityPhysicalOptionModel())) {
                return false;
            }
            if (!Objects.equals(this.commodityWeatherOptionModel, _that.getCommodityWeatherOptionModel())) {
                return false;
            }
            if (!ListEquals.listEquals(this.premium, _that.getPremium())) {
                return false;
            }
            return Objects.equals(this.commodityContentModel, _that.getCommodityContentModel());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.buyerSellerModel != null ? this.buyerSellerModel.hashCode() : 0);
            _result = 31 * _result + (this.optionType != null ? ((Object)((Object)this.optionType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.commodityFinancialOptionModel != null ? this.commodityFinancialOptionModel.hashCode() : 0);
            _result = 31 * _result + (this.commodityPhysicalOptionModel != null ? this.commodityPhysicalOptionModel.hashCode() : 0);
            _result = 31 * _result + (this.commodityWeatherOptionModel != null ? this.commodityWeatherOptionModel.hashCode() : 0);
            _result = 31 * _result + (this.premium != null ? this.premium.hashCode() : 0);
            _result = 31 * _result + (this.commodityContentModel != null ? this.commodityContentModel.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "CommodityOption {buyerSellerModel=" + String.valueOf(this.buyerSellerModel) + ", optionType=" + String.valueOf((Object)this.optionType) + ", commodityFinancialOptionModel=" + String.valueOf(this.commodityFinancialOptionModel) + ", commodityPhysicalOptionModel=" + String.valueOf(this.commodityPhysicalOptionModel) + ", commodityWeatherOptionModel=" + String.valueOf(this.commodityWeatherOptionModel) + ", premium=" + String.valueOf(this.premium) + ", commodityContentModel=" + String.valueOf(this.commodityContentModel) + "} " + super.toString();
        }
    }
}

