/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.business.events;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.business.events.Observation;
import fpml.consolidated.business.events.ResetCalculationElements;
import fpml.consolidated.business.events.meta.ResetCalculationDetailsMeta;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="ResetCalculationDetails", builder=ResetCalculationDetailsBuilderImpl.class, version="1.2.2")
@RuneDataType(value="ResetCalculationDetails", model="fpml", builder=ResetCalculationDetailsBuilderImpl.class, version="1.2.2")
public interface ResetCalculationDetails
extends RosettaModelObject {
    public static final ResetCalculationDetailsMeta metaData = new ResetCalculationDetailsMeta();

    public List<? extends Observation> getObservation();

    public ResetCalculationElements getCalculationElements();

    public ResetCalculationDetails build();

    public ResetCalculationDetailsBuilder toBuilder();

    public static ResetCalculationDetailsBuilder builder() {
        return new ResetCalculationDetailsBuilderImpl();
    }

    default public RosettaMetaData<? extends ResetCalculationDetails> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends ResetCalculationDetails> getType() {
        return ResetCalculationDetails.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("observation"), processor, Observation.class, this.getObservation(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("calculationElements"), processor, ResetCalculationElements.class, this.getCalculationElements(), new AttributeMeta[0]);
    }

    public static class ResetCalculationDetailsBuilderImpl
    implements ResetCalculationDetailsBuilder {
        protected List<Observation.ObservationBuilder> observation = new ArrayList<Observation.ObservationBuilder>();
        protected ResetCalculationElements.ResetCalculationElementsBuilder calculationElements;

        @Override
        @RosettaAttribute(value="observation")
        @RuneAttribute(value="observation")
        public List<? extends Observation.ObservationBuilder> getObservation() {
            return this.observation;
        }

        @Override
        public Observation.ObservationBuilder getOrCreateObservation(int index) {
            if (this.observation == null) {
                this.observation = new ArrayList<Observation.ObservationBuilder>();
            }
            return (Observation.ObservationBuilder)this.getIndex(this.observation, index, () -> {
                Observation.ObservationBuilder newObservation = Observation.builder();
                return newObservation;
            });
        }

        @Override
        @RosettaAttribute(value="calculationElements")
        @RuneAttribute(value="calculationElements")
        public ResetCalculationElements.ResetCalculationElementsBuilder getCalculationElements() {
            return this.calculationElements;
        }

        @Override
        public ResetCalculationElements.ResetCalculationElementsBuilder getOrCreateCalculationElements() {
            ResetCalculationElements.ResetCalculationElementsBuilder result = this.calculationElements != null ? this.calculationElements : (this.calculationElements = ResetCalculationElements.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="observation")
        @RuneAttribute(value="observation")
        public ResetCalculationDetailsBuilder addObservation(Observation _observation) {
            if (_observation != null) {
                this.observation.add(_observation.toBuilder());
            }
            return this;
        }

        @Override
        public ResetCalculationDetailsBuilder addObservation(Observation _observation, int idx) {
            this.getIndex(this.observation, idx, () -> _observation.toBuilder());
            return this;
        }

        @Override
        public ResetCalculationDetailsBuilder addObservation(List<? extends Observation> observations) {
            if (observations != null) {
                for (Observation observation : observations) {
                    this.observation.add(observation.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="observation")
        public ResetCalculationDetailsBuilder setObservation(List<? extends Observation> observations) {
            this.observation = observations == null ? new ArrayList<Observation.ObservationBuilder>() : (List)observations.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="calculationElements")
        @RuneAttribute(value="calculationElements")
        public ResetCalculationDetailsBuilder setCalculationElements(ResetCalculationElements _calculationElements) {
            this.calculationElements = _calculationElements == null ? null : _calculationElements.toBuilder();
            return this;
        }

        @Override
        public ResetCalculationDetails build() {
            return new ResetCalculationDetailsImpl(this);
        }

        @Override
        public ResetCalculationDetailsBuilder toBuilder() {
            return this;
        }

        @Override
        public ResetCalculationDetailsBuilder prune() {
            this.observation = this.observation.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.calculationElements != null && !this.calculationElements.prune().hasData()) {
                this.calculationElements = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getObservation() != null && this.getObservation().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getCalculationElements() != null && this.getCalculationElements().hasData();
        }

        public ResetCalculationDetailsBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            ResetCalculationDetailsBuilder o = (ResetCalculationDetailsBuilder)other;
            merger.mergeRosetta(this.getObservation(), o.getObservation(), this::getOrCreateObservation);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCalculationElements(), (RosettaModelObjectBuilder)o.getCalculationElements(), this::setCalculationElements);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ResetCalculationDetails _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.observation, _that.getObservation())) {
                return false;
            }
            return Objects.equals(this.calculationElements, _that.getCalculationElements());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.observation != null ? this.observation.hashCode() : 0);
            _result = 31 * _result + (this.calculationElements != null ? this.calculationElements.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ResetCalculationDetailsBuilder {observation=" + String.valueOf(this.observation) + ", calculationElements=" + String.valueOf(this.calculationElements) + "}";
        }
    }

    public static interface ResetCalculationDetailsBuilder
    extends ResetCalculationDetails,
    RosettaModelObjectBuilder {
        public Observation.ObservationBuilder getOrCreateObservation(int var1);

        public List<? extends Observation.ObservationBuilder> getObservation();

        public ResetCalculationElements.ResetCalculationElementsBuilder getOrCreateCalculationElements();

        @Override
        public ResetCalculationElements.ResetCalculationElementsBuilder getCalculationElements();

        public ResetCalculationDetailsBuilder addObservation(Observation var1);

        public ResetCalculationDetailsBuilder addObservation(Observation var1, int var2);

        public ResetCalculationDetailsBuilder addObservation(List<? extends Observation> var1);

        public ResetCalculationDetailsBuilder setObservation(List<? extends Observation> var1);

        public ResetCalculationDetailsBuilder setCalculationElements(ResetCalculationElements var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("observation"), processor, Observation.ObservationBuilder.class, this.getObservation(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("calculationElements"), processor, ResetCalculationElements.ResetCalculationElementsBuilder.class, this.getCalculationElements(), new AttributeMeta[0]);
        }

        public ResetCalculationDetailsBuilder prune();
    }

    public static class ResetCalculationDetailsImpl
    implements ResetCalculationDetails {
        private final List<? extends Observation> observation;
        private final ResetCalculationElements calculationElements;

        protected ResetCalculationDetailsImpl(ResetCalculationDetailsBuilder builder) {
            this.observation = Optional.ofNullable(builder.getObservation()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.calculationElements = Optional.ofNullable(builder.getCalculationElements()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="observation")
        @RuneAttribute(value="observation")
        public List<? extends Observation> getObservation() {
            return this.observation;
        }

        @Override
        @RosettaAttribute(value="calculationElements")
        @RuneAttribute(value="calculationElements")
        public ResetCalculationElements getCalculationElements() {
            return this.calculationElements;
        }

        @Override
        public ResetCalculationDetails build() {
            return this;
        }

        @Override
        public ResetCalculationDetailsBuilder toBuilder() {
            ResetCalculationDetailsBuilder builder = ResetCalculationDetails.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(ResetCalculationDetailsBuilder builder) {
            Optional.ofNullable(this.getObservation()).ifPresent(builder::setObservation);
            Optional.ofNullable(this.getCalculationElements()).ifPresent(builder::setCalculationElements);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ResetCalculationDetails _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.observation, _that.getObservation())) {
                return false;
            }
            return Objects.equals(this.calculationElements, _that.getCalculationElements());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.observation != null ? this.observation.hashCode() : 0);
            _result = 31 * _result + (this.calculationElements != null ? this.calculationElements.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ResetCalculationDetails {observation=" + String.valueOf(this.observation) + ", calculationElements=" + String.valueOf(this.calculationElements) + "}";
        }
    }
}

