/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.business.events;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.business.events.ObservationEvent;
import fpml.consolidated.business.events.ResetEvent;
import fpml.consolidated.business.events.meta.PostTradeEventsBaseModelChoiceSequenceMeta;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="PostTradeEventsBaseModelChoiceSequence", builder=PostTradeEventsBaseModelChoiceSequenceBuilderImpl.class, version="1.2.2")
@RuneDataType(value="PostTradeEventsBaseModelChoiceSequence", model="fpml", builder=PostTradeEventsBaseModelChoiceSequenceBuilderImpl.class, version="1.2.2")
public interface PostTradeEventsBaseModelChoiceSequence
extends RosettaModelObject {
    public static final PostTradeEventsBaseModelChoiceSequenceMeta metaData = new PostTradeEventsBaseModelChoiceSequenceMeta();

    public List<? extends ObservationEvent> getObservation();

    public List<? extends ResetEvent> getReset();

    public PostTradeEventsBaseModelChoiceSequence build();

    public PostTradeEventsBaseModelChoiceSequenceBuilder toBuilder();

    public static PostTradeEventsBaseModelChoiceSequenceBuilder builder() {
        return new PostTradeEventsBaseModelChoiceSequenceBuilderImpl();
    }

    default public RosettaMetaData<? extends PostTradeEventsBaseModelChoiceSequence> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends PostTradeEventsBaseModelChoiceSequence> getType() {
        return PostTradeEventsBaseModelChoiceSequence.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("observation"), processor, ObservationEvent.class, this.getObservation(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("reset"), processor, ResetEvent.class, this.getReset(), new AttributeMeta[0]);
    }

    public static class PostTradeEventsBaseModelChoiceSequenceBuilderImpl
    implements PostTradeEventsBaseModelChoiceSequenceBuilder {
        protected List<ObservationEvent.ObservationEventBuilder> observation = new ArrayList<ObservationEvent.ObservationEventBuilder>();
        protected List<ResetEvent.ResetEventBuilder> reset = new ArrayList<ResetEvent.ResetEventBuilder>();

        @Override
        @RosettaAttribute(value="observation", isRequired=true)
        @RuneAttribute(value="observation", isRequired=true)
        public List<? extends ObservationEvent.ObservationEventBuilder> getObservation() {
            return this.observation;
        }

        @Override
        public ObservationEvent.ObservationEventBuilder getOrCreateObservation(int index) {
            if (this.observation == null) {
                this.observation = new ArrayList<ObservationEvent.ObservationEventBuilder>();
            }
            return (ObservationEvent.ObservationEventBuilder)this.getIndex(this.observation, index, () -> {
                ObservationEvent.ObservationEventBuilder newObservation = ObservationEvent.builder();
                return newObservation;
            });
        }

        @Override
        @RosettaAttribute(value="reset")
        @RuneAttribute(value="reset")
        public List<? extends ResetEvent.ResetEventBuilder> getReset() {
            return this.reset;
        }

        @Override
        public ResetEvent.ResetEventBuilder getOrCreateReset(int index) {
            if (this.reset == null) {
                this.reset = new ArrayList<ResetEvent.ResetEventBuilder>();
            }
            return (ResetEvent.ResetEventBuilder)this.getIndex(this.reset, index, () -> {
                ResetEvent.ResetEventBuilder newReset = ResetEvent.builder();
                return newReset;
            });
        }

        @Override
        @RosettaAttribute(value="observation", isRequired=true)
        @RuneAttribute(value="observation", isRequired=true)
        public PostTradeEventsBaseModelChoiceSequenceBuilder addObservation(ObservationEvent _observation) {
            if (_observation != null) {
                this.observation.add(_observation.toBuilder());
            }
            return this;
        }

        @Override
        public PostTradeEventsBaseModelChoiceSequenceBuilder addObservation(ObservationEvent _observation, int idx) {
            this.getIndex(this.observation, idx, () -> _observation.toBuilder());
            return this;
        }

        @Override
        public PostTradeEventsBaseModelChoiceSequenceBuilder addObservation(List<? extends ObservationEvent> observations) {
            if (observations != null) {
                for (ObservationEvent observationEvent : observations) {
                    this.observation.add(observationEvent.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="observation")
        public PostTradeEventsBaseModelChoiceSequenceBuilder setObservation(List<? extends ObservationEvent> observations) {
            this.observation = observations == null ? new ArrayList<ObservationEvent.ObservationEventBuilder>() : (List)observations.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="reset")
        @RuneAttribute(value="reset")
        public PostTradeEventsBaseModelChoiceSequenceBuilder addReset(ResetEvent _reset) {
            if (_reset != null) {
                this.reset.add(_reset.toBuilder());
            }
            return this;
        }

        @Override
        public PostTradeEventsBaseModelChoiceSequenceBuilder addReset(ResetEvent _reset, int idx) {
            this.getIndex(this.reset, idx, () -> _reset.toBuilder());
            return this;
        }

        @Override
        public PostTradeEventsBaseModelChoiceSequenceBuilder addReset(List<? extends ResetEvent> resets) {
            if (resets != null) {
                for (ResetEvent resetEvent : resets) {
                    this.reset.add(resetEvent.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="reset")
        public PostTradeEventsBaseModelChoiceSequenceBuilder setReset(List<? extends ResetEvent> resets) {
            this.reset = resets == null ? new ArrayList<ResetEvent.ResetEventBuilder>() : (List)resets.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public PostTradeEventsBaseModelChoiceSequence build() {
            return new PostTradeEventsBaseModelChoiceSequenceImpl(this);
        }

        @Override
        public PostTradeEventsBaseModelChoiceSequenceBuilder toBuilder() {
            return this;
        }

        @Override
        public PostTradeEventsBaseModelChoiceSequenceBuilder prune() {
            this.observation = this.observation.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.reset = this.reset.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getObservation() != null && this.getObservation().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getReset() != null && this.getReset().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        public PostTradeEventsBaseModelChoiceSequenceBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            PostTradeEventsBaseModelChoiceSequenceBuilder o = (PostTradeEventsBaseModelChoiceSequenceBuilder)other;
            merger.mergeRosetta(this.getObservation(), o.getObservation(), this::getOrCreateObservation);
            merger.mergeRosetta(this.getReset(), o.getReset(), this::getOrCreateReset);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            PostTradeEventsBaseModelChoiceSequence _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.observation, _that.getObservation())) {
                return false;
            }
            return ListEquals.listEquals(this.reset, _that.getReset());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.observation != null ? this.observation.hashCode() : 0);
            _result = 31 * _result + (this.reset != null ? this.reset.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "PostTradeEventsBaseModelChoiceSequenceBuilder {observation=" + String.valueOf(this.observation) + ", reset=" + String.valueOf(this.reset) + "}";
        }
    }

    public static interface PostTradeEventsBaseModelChoiceSequenceBuilder
    extends PostTradeEventsBaseModelChoiceSequence,
    RosettaModelObjectBuilder {
        public ObservationEvent.ObservationEventBuilder getOrCreateObservation(int var1);

        public List<? extends ObservationEvent.ObservationEventBuilder> getObservation();

        public ResetEvent.ResetEventBuilder getOrCreateReset(int var1);

        public List<? extends ResetEvent.ResetEventBuilder> getReset();

        public PostTradeEventsBaseModelChoiceSequenceBuilder addObservation(ObservationEvent var1);

        public PostTradeEventsBaseModelChoiceSequenceBuilder addObservation(ObservationEvent var1, int var2);

        public PostTradeEventsBaseModelChoiceSequenceBuilder addObservation(List<? extends ObservationEvent> var1);

        public PostTradeEventsBaseModelChoiceSequenceBuilder setObservation(List<? extends ObservationEvent> var1);

        public PostTradeEventsBaseModelChoiceSequenceBuilder addReset(ResetEvent var1);

        public PostTradeEventsBaseModelChoiceSequenceBuilder addReset(ResetEvent var1, int var2);

        public PostTradeEventsBaseModelChoiceSequenceBuilder addReset(List<? extends ResetEvent> var1);

        public PostTradeEventsBaseModelChoiceSequenceBuilder setReset(List<? extends ResetEvent> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("observation"), processor, ObservationEvent.ObservationEventBuilder.class, this.getObservation(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("reset"), processor, ResetEvent.ResetEventBuilder.class, this.getReset(), new AttributeMeta[0]);
        }

        public PostTradeEventsBaseModelChoiceSequenceBuilder prune();
    }

    public static class PostTradeEventsBaseModelChoiceSequenceImpl
    implements PostTradeEventsBaseModelChoiceSequence {
        private final List<? extends ObservationEvent> observation;
        private final List<? extends ResetEvent> reset;

        protected PostTradeEventsBaseModelChoiceSequenceImpl(PostTradeEventsBaseModelChoiceSequenceBuilder builder) {
            this.observation = Optional.ofNullable(builder.getObservation()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.reset = Optional.ofNullable(builder.getReset()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="observation", isRequired=true)
        @RuneAttribute(value="observation", isRequired=true)
        public List<? extends ObservationEvent> getObservation() {
            return this.observation;
        }

        @Override
        @RosettaAttribute(value="reset")
        @RuneAttribute(value="reset")
        public List<? extends ResetEvent> getReset() {
            return this.reset;
        }

        @Override
        public PostTradeEventsBaseModelChoiceSequence build() {
            return this;
        }

        @Override
        public PostTradeEventsBaseModelChoiceSequenceBuilder toBuilder() {
            PostTradeEventsBaseModelChoiceSequenceBuilder builder = PostTradeEventsBaseModelChoiceSequence.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(PostTradeEventsBaseModelChoiceSequenceBuilder builder) {
            Optional.ofNullable(this.getObservation()).ifPresent(builder::setObservation);
            Optional.ofNullable(this.getReset()).ifPresent(builder::setReset);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            PostTradeEventsBaseModelChoiceSequence _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.observation, _that.getObservation())) {
                return false;
            }
            return ListEquals.listEquals(this.reset, _that.getReset());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.observation != null ? this.observation.hashCode() : 0);
            _result = 31 * _result + (this.reset != null ? this.reset.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "PostTradeEventsBaseModelChoiceSequence {observation=" + String.valueOf(this.observation) + ", reset=" + String.valueOf(this.reset) + "}";
        }
    }
}

