/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.business.events;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.business.events.AbstractEvent;
import fpml.consolidated.business.events.BusinessEventIdentifier;
import fpml.consolidated.business.events.ClearingInstructions;
import fpml.consolidated.business.events.OptionExerciseAmountModel;
import fpml.consolidated.business.events.OptionExerciseSequence;
import fpml.consolidated.business.events.PhysicalSettlement;
import fpml.consolidated.business.events.meta.OptionExerciseMeta;
import fpml.consolidated.doc.PartyTradeIdentifier;
import fpml.consolidated.doc.Trade;
import fpml.consolidated.fpmlenum.ExerciseSideEnum;
import fpml.consolidated.fpmlenum.ExerciseTimingEnum;
import fpml.consolidated.fpmlenum.SettlementTypeEnum;
import fpml.consolidated.shared.NonNegativePayment;
import fpml.consolidated.shared.PartyReference;
import fpml.consolidated.shared.SimplePayment;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="OptionExercise", builder=OptionExerciseBuilderImpl.class, version="1.2.2")
@RuneDataType(value="OptionExercise", model="fpml", builder=OptionExerciseBuilderImpl.class, version="1.2.2")
public interface OptionExercise
extends AbstractEvent {
    public static final OptionExerciseMeta metaData = new OptionExerciseMeta();

    public PartyReference getOptionSeller();

    public PartyReference getOptionBuyer();

    public Trade getOriginalTrade();

    public List<? extends PartyTradeIdentifier> getTradeIdentifier();

    public OptionExerciseSequence getOptionExerciseSequence();

    public ExerciseTimingEnum getExerciseTiming();

    public OptionExerciseAmountModel getOptionExerciseAmountModel();

    public ExerciseSideEnum getExerciseSide();

    public SettlementTypeEnum getSettlementType();

    public SimplePayment getCashSettlement();

    public PhysicalSettlement getPhysicalSettlement();

    public NonNegativePayment getPayment();

    public ClearingInstructions getClearingInstructions();

    @Override
    public OptionExercise build();

    @Override
    public OptionExerciseBuilder toBuilder();

    public static OptionExerciseBuilder builder() {
        return new OptionExerciseBuilderImpl();
    }

    default public RosettaMetaData<? extends OptionExercise> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends OptionExercise> getType() {
        return OptionExercise.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("eventIdentifier"), processor, BusinessEventIdentifier.class, this.getEventIdentifier(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("optionSeller"), processor, PartyReference.class, this.getOptionSeller(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("optionBuyer"), processor, PartyReference.class, this.getOptionBuyer(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("originalTrade"), processor, Trade.class, this.getOriginalTrade(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("tradeIdentifier"), processor, PartyTradeIdentifier.class, this.getTradeIdentifier(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("optionExerciseSequence"), processor, OptionExerciseSequence.class, this.getOptionExerciseSequence(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("exerciseTiming"), ExerciseTimingEnum.class, (Object)this.getExerciseTiming(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("optionExerciseAmountModel"), processor, OptionExerciseAmountModel.class, this.getOptionExerciseAmountModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("exerciseSide"), ExerciseSideEnum.class, (Object)this.getExerciseSide(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("settlementType"), SettlementTypeEnum.class, (Object)this.getSettlementType(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("cashSettlement"), processor, SimplePayment.class, this.getCashSettlement(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("physicalSettlement"), processor, PhysicalSettlement.class, this.getPhysicalSettlement(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("payment"), processor, NonNegativePayment.class, this.getPayment(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("clearingInstructions"), processor, ClearingInstructions.class, this.getClearingInstructions(), new AttributeMeta[0]);
    }

    public static class OptionExerciseBuilderImpl
    extends AbstractEvent.AbstractEventBuilderImpl
    implements OptionExerciseBuilder {
        protected PartyReference.PartyReferenceBuilder optionSeller;
        protected PartyReference.PartyReferenceBuilder optionBuyer;
        protected Trade.TradeBuilder originalTrade;
        protected List<PartyTradeIdentifier.PartyTradeIdentifierBuilder> tradeIdentifier = new ArrayList<PartyTradeIdentifier.PartyTradeIdentifierBuilder>();
        protected OptionExerciseSequence.OptionExerciseSequenceBuilder optionExerciseSequence;
        protected ExerciseTimingEnum exerciseTiming;
        protected OptionExerciseAmountModel.OptionExerciseAmountModelBuilder optionExerciseAmountModel;
        protected ExerciseSideEnum exerciseSide;
        protected SettlementTypeEnum settlementType;
        protected SimplePayment.SimplePaymentBuilder cashSettlement;
        protected PhysicalSettlement.PhysicalSettlementBuilder physicalSettlement;
        protected NonNegativePayment.NonNegativePaymentBuilder payment;
        protected ClearingInstructions.ClearingInstructionsBuilder clearingInstructions;

        @Override
        @RosettaAttribute(value="optionSeller")
        @RuneAttribute(value="optionSeller")
        public PartyReference.PartyReferenceBuilder getOptionSeller() {
            return this.optionSeller;
        }

        @Override
        public PartyReference.PartyReferenceBuilder getOrCreateOptionSeller() {
            PartyReference.PartyReferenceBuilder result = this.optionSeller != null ? this.optionSeller : (this.optionSeller = PartyReference.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="optionBuyer")
        @RuneAttribute(value="optionBuyer")
        public PartyReference.PartyReferenceBuilder getOptionBuyer() {
            return this.optionBuyer;
        }

        @Override
        public PartyReference.PartyReferenceBuilder getOrCreateOptionBuyer() {
            PartyReference.PartyReferenceBuilder result = this.optionBuyer != null ? this.optionBuyer : (this.optionBuyer = PartyReference.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="originalTrade")
        @RuneAttribute(value="originalTrade")
        public Trade.TradeBuilder getOriginalTrade() {
            return this.originalTrade;
        }

        @Override
        public Trade.TradeBuilder getOrCreateOriginalTrade() {
            Trade.TradeBuilder result = this.originalTrade != null ? this.originalTrade : (this.originalTrade = Trade.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="tradeIdentifier")
        @RuneAttribute(value="tradeIdentifier")
        public List<? extends PartyTradeIdentifier.PartyTradeIdentifierBuilder> getTradeIdentifier() {
            return this.tradeIdentifier;
        }

        @Override
        public PartyTradeIdentifier.PartyTradeIdentifierBuilder getOrCreateTradeIdentifier(int index) {
            if (this.tradeIdentifier == null) {
                this.tradeIdentifier = new ArrayList<PartyTradeIdentifier.PartyTradeIdentifierBuilder>();
            }
            return (PartyTradeIdentifier.PartyTradeIdentifierBuilder)this.getIndex(this.tradeIdentifier, index, () -> {
                PartyTradeIdentifier.PartyTradeIdentifierBuilder newTradeIdentifier = PartyTradeIdentifier.builder();
                return newTradeIdentifier;
            });
        }

        @Override
        @RosettaAttribute(value="optionExerciseSequence")
        @RuneAttribute(value="optionExerciseSequence")
        public OptionExerciseSequence.OptionExerciseSequenceBuilder getOptionExerciseSequence() {
            return this.optionExerciseSequence;
        }

        @Override
        public OptionExerciseSequence.OptionExerciseSequenceBuilder getOrCreateOptionExerciseSequence() {
            OptionExerciseSequence.OptionExerciseSequenceBuilder result = this.optionExerciseSequence != null ? this.optionExerciseSequence : (this.optionExerciseSequence = OptionExerciseSequence.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="exerciseTiming")
        @RuneAttribute(value="exerciseTiming")
        public ExerciseTimingEnum getExerciseTiming() {
            return this.exerciseTiming;
        }

        @Override
        @RosettaAttribute(value="optionExerciseAmountModel", isRequired=true)
        @RuneAttribute(value="optionExerciseAmountModel", isRequired=true)
        public OptionExerciseAmountModel.OptionExerciseAmountModelBuilder getOptionExerciseAmountModel() {
            return this.optionExerciseAmountModel;
        }

        @Override
        public OptionExerciseAmountModel.OptionExerciseAmountModelBuilder getOrCreateOptionExerciseAmountModel() {
            OptionExerciseAmountModel.OptionExerciseAmountModelBuilder result = this.optionExerciseAmountModel != null ? this.optionExerciseAmountModel : (this.optionExerciseAmountModel = OptionExerciseAmountModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="exerciseSide")
        @RuneAttribute(value="exerciseSide")
        public ExerciseSideEnum getExerciseSide() {
            return this.exerciseSide;
        }

        @Override
        @RosettaAttribute(value="settlementType")
        @RuneAttribute(value="settlementType")
        public SettlementTypeEnum getSettlementType() {
            return this.settlementType;
        }

        @Override
        @RosettaAttribute(value="cashSettlement")
        @RuneAttribute(value="cashSettlement")
        public SimplePayment.SimplePaymentBuilder getCashSettlement() {
            return this.cashSettlement;
        }

        @Override
        public SimplePayment.SimplePaymentBuilder getOrCreateCashSettlement() {
            SimplePayment.SimplePaymentBuilder result = this.cashSettlement != null ? this.cashSettlement : (this.cashSettlement = SimplePayment.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="physicalSettlement")
        @RuneAttribute(value="physicalSettlement")
        public PhysicalSettlement.PhysicalSettlementBuilder getPhysicalSettlement() {
            return this.physicalSettlement;
        }

        @Override
        public PhysicalSettlement.PhysicalSettlementBuilder getOrCreatePhysicalSettlement() {
            PhysicalSettlement.PhysicalSettlementBuilder result = this.physicalSettlement != null ? this.physicalSettlement : (this.physicalSettlement = PhysicalSettlement.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="payment")
        @RuneAttribute(value="payment")
        public NonNegativePayment.NonNegativePaymentBuilder getPayment() {
            return this.payment;
        }

        @Override
        public NonNegativePayment.NonNegativePaymentBuilder getOrCreatePayment() {
            NonNegativePayment.NonNegativePaymentBuilder result = this.payment != null ? this.payment : (this.payment = NonNegativePayment.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="clearingInstructions")
        @RuneAttribute(value="clearingInstructions")
        public ClearingInstructions.ClearingInstructionsBuilder getClearingInstructions() {
            return this.clearingInstructions;
        }

        @Override
        public ClearingInstructions.ClearingInstructionsBuilder getOrCreateClearingInstructions() {
            ClearingInstructions.ClearingInstructionsBuilder result = this.clearingInstructions != null ? this.clearingInstructions : (this.clearingInstructions = ClearingInstructions.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="eventIdentifier")
        @RuneAttribute(value="eventIdentifier")
        public OptionExerciseBuilder addEventIdentifier(BusinessEventIdentifier _eventIdentifier) {
            if (_eventIdentifier != null) {
                this.eventIdentifier.add(_eventIdentifier.toBuilder());
            }
            return this;
        }

        @Override
        public OptionExerciseBuilder addEventIdentifier(BusinessEventIdentifier _eventIdentifier, int idx) {
            this.getIndex(this.eventIdentifier, idx, () -> _eventIdentifier.toBuilder());
            return this;
        }

        @Override
        public OptionExerciseBuilder addEventIdentifier(List<? extends BusinessEventIdentifier> eventIdentifiers) {
            if (eventIdentifiers != null) {
                for (BusinessEventIdentifier businessEventIdentifier : eventIdentifiers) {
                    this.eventIdentifier.add(businessEventIdentifier.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="eventIdentifier")
        public OptionExerciseBuilder setEventIdentifier(List<? extends BusinessEventIdentifier> eventIdentifiers) {
            this.eventIdentifier = eventIdentifiers == null ? new ArrayList() : (List)eventIdentifiers.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="optionSeller")
        @RuneAttribute(value="optionSeller")
        public OptionExerciseBuilder setOptionSeller(PartyReference _optionSeller) {
            this.optionSeller = _optionSeller == null ? null : _optionSeller.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="optionBuyer")
        @RuneAttribute(value="optionBuyer")
        public OptionExerciseBuilder setOptionBuyer(PartyReference _optionBuyer) {
            this.optionBuyer = _optionBuyer == null ? null : _optionBuyer.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="originalTrade")
        @RuneAttribute(value="originalTrade")
        public OptionExerciseBuilder setOriginalTrade(Trade _originalTrade) {
            this.originalTrade = _originalTrade == null ? null : _originalTrade.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="tradeIdentifier")
        @RuneAttribute(value="tradeIdentifier")
        public OptionExerciseBuilder addTradeIdentifier(PartyTradeIdentifier _tradeIdentifier) {
            if (_tradeIdentifier != null) {
                this.tradeIdentifier.add(_tradeIdentifier.toBuilder());
            }
            return this;
        }

        @Override
        public OptionExerciseBuilder addTradeIdentifier(PartyTradeIdentifier _tradeIdentifier, int idx) {
            this.getIndex(this.tradeIdentifier, idx, () -> _tradeIdentifier.toBuilder());
            return this;
        }

        @Override
        public OptionExerciseBuilder addTradeIdentifier(List<? extends PartyTradeIdentifier> tradeIdentifiers) {
            if (tradeIdentifiers != null) {
                for (PartyTradeIdentifier partyTradeIdentifier : tradeIdentifiers) {
                    this.tradeIdentifier.add(partyTradeIdentifier.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="tradeIdentifier")
        public OptionExerciseBuilder setTradeIdentifier(List<? extends PartyTradeIdentifier> tradeIdentifiers) {
            this.tradeIdentifier = tradeIdentifiers == null ? new ArrayList<PartyTradeIdentifier.PartyTradeIdentifierBuilder>() : (List)tradeIdentifiers.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="optionExerciseSequence")
        @RuneAttribute(value="optionExerciseSequence")
        public OptionExerciseBuilder setOptionExerciseSequence(OptionExerciseSequence _optionExerciseSequence) {
            this.optionExerciseSequence = _optionExerciseSequence == null ? null : _optionExerciseSequence.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="exerciseTiming")
        @RuneAttribute(value="exerciseTiming")
        public OptionExerciseBuilder setExerciseTiming(ExerciseTimingEnum _exerciseTiming) {
            this.exerciseTiming = _exerciseTiming == null ? null : _exerciseTiming;
            return this;
        }

        @Override
        @RosettaAttribute(value="optionExerciseAmountModel", isRequired=true)
        @RuneAttribute(value="optionExerciseAmountModel", isRequired=true)
        public OptionExerciseBuilder setOptionExerciseAmountModel(OptionExerciseAmountModel _optionExerciseAmountModel) {
            this.optionExerciseAmountModel = _optionExerciseAmountModel == null ? null : _optionExerciseAmountModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="exerciseSide")
        @RuneAttribute(value="exerciseSide")
        public OptionExerciseBuilder setExerciseSide(ExerciseSideEnum _exerciseSide) {
            this.exerciseSide = _exerciseSide == null ? null : _exerciseSide;
            return this;
        }

        @Override
        @RosettaAttribute(value="settlementType")
        @RuneAttribute(value="settlementType")
        public OptionExerciseBuilder setSettlementType(SettlementTypeEnum _settlementType) {
            this.settlementType = _settlementType == null ? null : _settlementType;
            return this;
        }

        @Override
        @RosettaAttribute(value="cashSettlement")
        @RuneAttribute(value="cashSettlement")
        public OptionExerciseBuilder setCashSettlement(SimplePayment _cashSettlement) {
            this.cashSettlement = _cashSettlement == null ? null : _cashSettlement.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="physicalSettlement")
        @RuneAttribute(value="physicalSettlement")
        public OptionExerciseBuilder setPhysicalSettlement(PhysicalSettlement _physicalSettlement) {
            this.physicalSettlement = _physicalSettlement == null ? null : _physicalSettlement.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="payment")
        @RuneAttribute(value="payment")
        public OptionExerciseBuilder setPayment(NonNegativePayment _payment) {
            this.payment = _payment == null ? null : _payment.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="clearingInstructions")
        @RuneAttribute(value="clearingInstructions")
        public OptionExerciseBuilder setClearingInstructions(ClearingInstructions _clearingInstructions) {
            this.clearingInstructions = _clearingInstructions == null ? null : _clearingInstructions.toBuilder();
            return this;
        }

        @Override
        public OptionExercise build() {
            return new OptionExerciseImpl(this);
        }

        @Override
        public OptionExerciseBuilder toBuilder() {
            return this;
        }

        @Override
        public OptionExerciseBuilder prune() {
            super.prune();
            if (this.optionSeller != null && !this.optionSeller.prune().hasData()) {
                this.optionSeller = null;
            }
            if (this.optionBuyer != null && !this.optionBuyer.prune().hasData()) {
                this.optionBuyer = null;
            }
            if (this.originalTrade != null && !this.originalTrade.prune().hasData()) {
                this.originalTrade = null;
            }
            this.tradeIdentifier = this.tradeIdentifier.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.optionExerciseSequence != null && !this.optionExerciseSequence.prune().hasData()) {
                this.optionExerciseSequence = null;
            }
            if (this.optionExerciseAmountModel != null && !this.optionExerciseAmountModel.prune().hasData()) {
                this.optionExerciseAmountModel = null;
            }
            if (this.cashSettlement != null && !this.cashSettlement.prune().hasData()) {
                this.cashSettlement = null;
            }
            if (this.physicalSettlement != null && !this.physicalSettlement.prune().hasData()) {
                this.physicalSettlement = null;
            }
            if (this.payment != null && !this.payment.prune().hasData()) {
                this.payment = null;
            }
            if (this.clearingInstructions != null && !this.clearingInstructions.prune().hasData()) {
                this.clearingInstructions = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getOptionSeller() != null && this.getOptionSeller().hasData()) {
                return true;
            }
            if (this.getOptionBuyer() != null && this.getOptionBuyer().hasData()) {
                return true;
            }
            if (this.getOriginalTrade() != null && this.getOriginalTrade().hasData()) {
                return true;
            }
            if (this.getTradeIdentifier() != null && this.getTradeIdentifier().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getOptionExerciseSequence() != null && this.getOptionExerciseSequence().hasData()) {
                return true;
            }
            if (this.getExerciseTiming() != null) {
                return true;
            }
            if (this.getOptionExerciseAmountModel() != null && this.getOptionExerciseAmountModel().hasData()) {
                return true;
            }
            if (this.getExerciseSide() != null) {
                return true;
            }
            if (this.getSettlementType() != null) {
                return true;
            }
            if (this.getCashSettlement() != null && this.getCashSettlement().hasData()) {
                return true;
            }
            if (this.getPhysicalSettlement() != null && this.getPhysicalSettlement().hasData()) {
                return true;
            }
            if (this.getPayment() != null && this.getPayment().hasData()) {
                return true;
            }
            return this.getClearingInstructions() != null && this.getClearingInstructions().hasData();
        }

        @Override
        public OptionExerciseBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            OptionExerciseBuilder o = (OptionExerciseBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getOptionSeller(), (RosettaModelObjectBuilder)o.getOptionSeller(), this::setOptionSeller);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getOptionBuyer(), (RosettaModelObjectBuilder)o.getOptionBuyer(), this::setOptionBuyer);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getOriginalTrade(), (RosettaModelObjectBuilder)o.getOriginalTrade(), this::setOriginalTrade);
            merger.mergeRosetta(this.getTradeIdentifier(), o.getTradeIdentifier(), this::getOrCreateTradeIdentifier);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getOptionExerciseSequence(), (RosettaModelObjectBuilder)o.getOptionExerciseSequence(), this::setOptionExerciseSequence);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getOptionExerciseAmountModel(), (RosettaModelObjectBuilder)o.getOptionExerciseAmountModel(), this::setOptionExerciseAmountModel);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCashSettlement(), (RosettaModelObjectBuilder)o.getCashSettlement(), this::setCashSettlement);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPhysicalSettlement(), (RosettaModelObjectBuilder)o.getPhysicalSettlement(), this::setPhysicalSettlement);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPayment(), (RosettaModelObjectBuilder)o.getPayment(), this::setPayment);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getClearingInstructions(), (RosettaModelObjectBuilder)o.getClearingInstructions(), this::setClearingInstructions);
            merger.mergeBasic((Object)this.getExerciseTiming(), (Object)o.getExerciseTiming(), this::setExerciseTiming, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getExerciseSide(), (Object)o.getExerciseSide(), this::setExerciseSide, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getSettlementType(), (Object)o.getSettlementType(), this::setSettlementType, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            OptionExercise _that = (OptionExercise)this.getType().cast(o);
            if (!Objects.equals(this.optionSeller, _that.getOptionSeller())) {
                return false;
            }
            if (!Objects.equals(this.optionBuyer, _that.getOptionBuyer())) {
                return false;
            }
            if (!Objects.equals(this.originalTrade, _that.getOriginalTrade())) {
                return false;
            }
            if (!ListEquals.listEquals(this.tradeIdentifier, _that.getTradeIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.optionExerciseSequence, _that.getOptionExerciseSequence())) {
                return false;
            }
            if (!Objects.equals((Object)this.exerciseTiming, (Object)_that.getExerciseTiming())) {
                return false;
            }
            if (!Objects.equals(this.optionExerciseAmountModel, _that.getOptionExerciseAmountModel())) {
                return false;
            }
            if (!Objects.equals((Object)this.exerciseSide, (Object)_that.getExerciseSide())) {
                return false;
            }
            if (!Objects.equals((Object)this.settlementType, (Object)_that.getSettlementType())) {
                return false;
            }
            if (!Objects.equals(this.cashSettlement, _that.getCashSettlement())) {
                return false;
            }
            if (!Objects.equals(this.physicalSettlement, _that.getPhysicalSettlement())) {
                return false;
            }
            if (!Objects.equals(this.payment, _that.getPayment())) {
                return false;
            }
            return Objects.equals(this.clearingInstructions, _that.getClearingInstructions());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.optionSeller != null ? this.optionSeller.hashCode() : 0);
            _result = 31 * _result + (this.optionBuyer != null ? this.optionBuyer.hashCode() : 0);
            _result = 31 * _result + (this.originalTrade != null ? this.originalTrade.hashCode() : 0);
            _result = 31 * _result + (this.tradeIdentifier != null ? this.tradeIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.optionExerciseSequence != null ? this.optionExerciseSequence.hashCode() : 0);
            _result = 31 * _result + (this.exerciseTiming != null ? ((Object)((Object)this.exerciseTiming)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.optionExerciseAmountModel != null ? this.optionExerciseAmountModel.hashCode() : 0);
            _result = 31 * _result + (this.exerciseSide != null ? ((Object)((Object)this.exerciseSide)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.settlementType != null ? ((Object)((Object)this.settlementType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.cashSettlement != null ? this.cashSettlement.hashCode() : 0);
            _result = 31 * _result + (this.physicalSettlement != null ? this.physicalSettlement.hashCode() : 0);
            _result = 31 * _result + (this.payment != null ? this.payment.hashCode() : 0);
            _result = 31 * _result + (this.clearingInstructions != null ? this.clearingInstructions.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "OptionExerciseBuilder {optionSeller=" + String.valueOf(this.optionSeller) + ", optionBuyer=" + String.valueOf(this.optionBuyer) + ", originalTrade=" + String.valueOf(this.originalTrade) + ", tradeIdentifier=" + String.valueOf(this.tradeIdentifier) + ", optionExerciseSequence=" + String.valueOf(this.optionExerciseSequence) + ", exerciseTiming=" + String.valueOf((Object)this.exerciseTiming) + ", optionExerciseAmountModel=" + String.valueOf(this.optionExerciseAmountModel) + ", exerciseSide=" + String.valueOf((Object)this.exerciseSide) + ", settlementType=" + String.valueOf((Object)this.settlementType) + ", cashSettlement=" + String.valueOf(this.cashSettlement) + ", physicalSettlement=" + String.valueOf(this.physicalSettlement) + ", payment=" + String.valueOf(this.payment) + ", clearingInstructions=" + String.valueOf(this.clearingInstructions) + "} " + super.toString();
        }
    }

    public static interface OptionExerciseBuilder
    extends OptionExercise,
    AbstractEvent.AbstractEventBuilder {
        public PartyReference.PartyReferenceBuilder getOrCreateOptionSeller();

        @Override
        public PartyReference.PartyReferenceBuilder getOptionSeller();

        public PartyReference.PartyReferenceBuilder getOrCreateOptionBuyer();

        @Override
        public PartyReference.PartyReferenceBuilder getOptionBuyer();

        public Trade.TradeBuilder getOrCreateOriginalTrade();

        @Override
        public Trade.TradeBuilder getOriginalTrade();

        public PartyTradeIdentifier.PartyTradeIdentifierBuilder getOrCreateTradeIdentifier(int var1);

        public List<? extends PartyTradeIdentifier.PartyTradeIdentifierBuilder> getTradeIdentifier();

        public OptionExerciseSequence.OptionExerciseSequenceBuilder getOrCreateOptionExerciseSequence();

        @Override
        public OptionExerciseSequence.OptionExerciseSequenceBuilder getOptionExerciseSequence();

        public OptionExerciseAmountModel.OptionExerciseAmountModelBuilder getOrCreateOptionExerciseAmountModel();

        @Override
        public OptionExerciseAmountModel.OptionExerciseAmountModelBuilder getOptionExerciseAmountModel();

        public SimplePayment.SimplePaymentBuilder getOrCreateCashSettlement();

        @Override
        public SimplePayment.SimplePaymentBuilder getCashSettlement();

        public PhysicalSettlement.PhysicalSettlementBuilder getOrCreatePhysicalSettlement();

        @Override
        public PhysicalSettlement.PhysicalSettlementBuilder getPhysicalSettlement();

        public NonNegativePayment.NonNegativePaymentBuilder getOrCreatePayment();

        @Override
        public NonNegativePayment.NonNegativePaymentBuilder getPayment();

        public ClearingInstructions.ClearingInstructionsBuilder getOrCreateClearingInstructions();

        @Override
        public ClearingInstructions.ClearingInstructionsBuilder getClearingInstructions();

        @Override
        public OptionExerciseBuilder addEventIdentifier(BusinessEventIdentifier var1);

        @Override
        public OptionExerciseBuilder addEventIdentifier(BusinessEventIdentifier var1, int var2);

        @Override
        public OptionExerciseBuilder addEventIdentifier(List<? extends BusinessEventIdentifier> var1);

        @Override
        public OptionExerciseBuilder setEventIdentifier(List<? extends BusinessEventIdentifier> var1);

        public OptionExerciseBuilder setOptionSeller(PartyReference var1);

        public OptionExerciseBuilder setOptionBuyer(PartyReference var1);

        public OptionExerciseBuilder setOriginalTrade(Trade var1);

        public OptionExerciseBuilder addTradeIdentifier(PartyTradeIdentifier var1);

        public OptionExerciseBuilder addTradeIdentifier(PartyTradeIdentifier var1, int var2);

        public OptionExerciseBuilder addTradeIdentifier(List<? extends PartyTradeIdentifier> var1);

        public OptionExerciseBuilder setTradeIdentifier(List<? extends PartyTradeIdentifier> var1);

        public OptionExerciseBuilder setOptionExerciseSequence(OptionExerciseSequence var1);

        public OptionExerciseBuilder setExerciseTiming(ExerciseTimingEnum var1);

        public OptionExerciseBuilder setOptionExerciseAmountModel(OptionExerciseAmountModel var1);

        public OptionExerciseBuilder setExerciseSide(ExerciseSideEnum var1);

        public OptionExerciseBuilder setSettlementType(SettlementTypeEnum var1);

        public OptionExerciseBuilder setCashSettlement(SimplePayment var1);

        public OptionExerciseBuilder setPhysicalSettlement(PhysicalSettlement var1);

        public OptionExerciseBuilder setPayment(NonNegativePayment var1);

        public OptionExerciseBuilder setClearingInstructions(ClearingInstructions var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("eventIdentifier"), processor, BusinessEventIdentifier.BusinessEventIdentifierBuilder.class, this.getEventIdentifier(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("optionSeller"), processor, PartyReference.PartyReferenceBuilder.class, this.getOptionSeller(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("optionBuyer"), processor, PartyReference.PartyReferenceBuilder.class, this.getOptionBuyer(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("originalTrade"), processor, Trade.TradeBuilder.class, this.getOriginalTrade(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("tradeIdentifier"), processor, PartyTradeIdentifier.PartyTradeIdentifierBuilder.class, this.getTradeIdentifier(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("optionExerciseSequence"), processor, OptionExerciseSequence.OptionExerciseSequenceBuilder.class, this.getOptionExerciseSequence(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("exerciseTiming"), ExerciseTimingEnum.class, (Object)this.getExerciseTiming(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("optionExerciseAmountModel"), processor, OptionExerciseAmountModel.OptionExerciseAmountModelBuilder.class, this.getOptionExerciseAmountModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("exerciseSide"), ExerciseSideEnum.class, (Object)this.getExerciseSide(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("settlementType"), SettlementTypeEnum.class, (Object)this.getSettlementType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("cashSettlement"), processor, SimplePayment.SimplePaymentBuilder.class, this.getCashSettlement(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("physicalSettlement"), processor, PhysicalSettlement.PhysicalSettlementBuilder.class, this.getPhysicalSettlement(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("payment"), processor, NonNegativePayment.NonNegativePaymentBuilder.class, this.getPayment(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("clearingInstructions"), processor, ClearingInstructions.ClearingInstructionsBuilder.class, this.getClearingInstructions(), new AttributeMeta[0]);
        }

        @Override
        public OptionExerciseBuilder prune();
    }

    public static class OptionExerciseImpl
    extends AbstractEvent.AbstractEventImpl
    implements OptionExercise {
        private final PartyReference optionSeller;
        private final PartyReference optionBuyer;
        private final Trade originalTrade;
        private final List<? extends PartyTradeIdentifier> tradeIdentifier;
        private final OptionExerciseSequence optionExerciseSequence;
        private final ExerciseTimingEnum exerciseTiming;
        private final OptionExerciseAmountModel optionExerciseAmountModel;
        private final ExerciseSideEnum exerciseSide;
        private final SettlementTypeEnum settlementType;
        private final SimplePayment cashSettlement;
        private final PhysicalSettlement physicalSettlement;
        private final NonNegativePayment payment;
        private final ClearingInstructions clearingInstructions;

        protected OptionExerciseImpl(OptionExerciseBuilder builder) {
            super(builder);
            this.optionSeller = Optional.ofNullable(builder.getOptionSeller()).map(f -> f.build()).orElse(null);
            this.optionBuyer = Optional.ofNullable(builder.getOptionBuyer()).map(f -> f.build()).orElse(null);
            this.originalTrade = Optional.ofNullable(builder.getOriginalTrade()).map(f -> f.build()).orElse(null);
            this.tradeIdentifier = Optional.ofNullable(builder.getTradeIdentifier()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.optionExerciseSequence = Optional.ofNullable(builder.getOptionExerciseSequence()).map(f -> f.build()).orElse(null);
            this.exerciseTiming = builder.getExerciseTiming();
            this.optionExerciseAmountModel = Optional.ofNullable(builder.getOptionExerciseAmountModel()).map(f -> f.build()).orElse(null);
            this.exerciseSide = builder.getExerciseSide();
            this.settlementType = builder.getSettlementType();
            this.cashSettlement = Optional.ofNullable(builder.getCashSettlement()).map(f -> f.build()).orElse(null);
            this.physicalSettlement = Optional.ofNullable(builder.getPhysicalSettlement()).map(f -> f.build()).orElse(null);
            this.payment = Optional.ofNullable(builder.getPayment()).map(f -> f.build()).orElse(null);
            this.clearingInstructions = Optional.ofNullable(builder.getClearingInstructions()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="optionSeller")
        @RuneAttribute(value="optionSeller")
        public PartyReference getOptionSeller() {
            return this.optionSeller;
        }

        @Override
        @RosettaAttribute(value="optionBuyer")
        @RuneAttribute(value="optionBuyer")
        public PartyReference getOptionBuyer() {
            return this.optionBuyer;
        }

        @Override
        @RosettaAttribute(value="originalTrade")
        @RuneAttribute(value="originalTrade")
        public Trade getOriginalTrade() {
            return this.originalTrade;
        }

        @Override
        @RosettaAttribute(value="tradeIdentifier")
        @RuneAttribute(value="tradeIdentifier")
        public List<? extends PartyTradeIdentifier> getTradeIdentifier() {
            return this.tradeIdentifier;
        }

        @Override
        @RosettaAttribute(value="optionExerciseSequence")
        @RuneAttribute(value="optionExerciseSequence")
        public OptionExerciseSequence getOptionExerciseSequence() {
            return this.optionExerciseSequence;
        }

        @Override
        @RosettaAttribute(value="exerciseTiming")
        @RuneAttribute(value="exerciseTiming")
        public ExerciseTimingEnum getExerciseTiming() {
            return this.exerciseTiming;
        }

        @Override
        @RosettaAttribute(value="optionExerciseAmountModel", isRequired=true)
        @RuneAttribute(value="optionExerciseAmountModel", isRequired=true)
        public OptionExerciseAmountModel getOptionExerciseAmountModel() {
            return this.optionExerciseAmountModel;
        }

        @Override
        @RosettaAttribute(value="exerciseSide")
        @RuneAttribute(value="exerciseSide")
        public ExerciseSideEnum getExerciseSide() {
            return this.exerciseSide;
        }

        @Override
        @RosettaAttribute(value="settlementType")
        @RuneAttribute(value="settlementType")
        public SettlementTypeEnum getSettlementType() {
            return this.settlementType;
        }

        @Override
        @RosettaAttribute(value="cashSettlement")
        @RuneAttribute(value="cashSettlement")
        public SimplePayment getCashSettlement() {
            return this.cashSettlement;
        }

        @Override
        @RosettaAttribute(value="physicalSettlement")
        @RuneAttribute(value="physicalSettlement")
        public PhysicalSettlement getPhysicalSettlement() {
            return this.physicalSettlement;
        }

        @Override
        @RosettaAttribute(value="payment")
        @RuneAttribute(value="payment")
        public NonNegativePayment getPayment() {
            return this.payment;
        }

        @Override
        @RosettaAttribute(value="clearingInstructions")
        @RuneAttribute(value="clearingInstructions")
        public ClearingInstructions getClearingInstructions() {
            return this.clearingInstructions;
        }

        @Override
        public OptionExercise build() {
            return this;
        }

        @Override
        public OptionExerciseBuilder toBuilder() {
            OptionExerciseBuilder builder = OptionExercise.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(OptionExerciseBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getOptionSeller()).ifPresent(builder::setOptionSeller);
            Optional.ofNullable(this.getOptionBuyer()).ifPresent(builder::setOptionBuyer);
            Optional.ofNullable(this.getOriginalTrade()).ifPresent(builder::setOriginalTrade);
            Optional.ofNullable(this.getTradeIdentifier()).ifPresent(builder::setTradeIdentifier);
            Optional.ofNullable(this.getOptionExerciseSequence()).ifPresent(builder::setOptionExerciseSequence);
            Optional.ofNullable(this.getExerciseTiming()).ifPresent(builder::setExerciseTiming);
            Optional.ofNullable(this.getOptionExerciseAmountModel()).ifPresent(builder::setOptionExerciseAmountModel);
            Optional.ofNullable(this.getExerciseSide()).ifPresent(builder::setExerciseSide);
            Optional.ofNullable(this.getSettlementType()).ifPresent(builder::setSettlementType);
            Optional.ofNullable(this.getCashSettlement()).ifPresent(builder::setCashSettlement);
            Optional.ofNullable(this.getPhysicalSettlement()).ifPresent(builder::setPhysicalSettlement);
            Optional.ofNullable(this.getPayment()).ifPresent(builder::setPayment);
            Optional.ofNullable(this.getClearingInstructions()).ifPresent(builder::setClearingInstructions);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            OptionExercise _that = (OptionExercise)this.getType().cast(o);
            if (!Objects.equals(this.optionSeller, _that.getOptionSeller())) {
                return false;
            }
            if (!Objects.equals(this.optionBuyer, _that.getOptionBuyer())) {
                return false;
            }
            if (!Objects.equals(this.originalTrade, _that.getOriginalTrade())) {
                return false;
            }
            if (!ListEquals.listEquals(this.tradeIdentifier, _that.getTradeIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.optionExerciseSequence, _that.getOptionExerciseSequence())) {
                return false;
            }
            if (!Objects.equals((Object)this.exerciseTiming, (Object)_that.getExerciseTiming())) {
                return false;
            }
            if (!Objects.equals(this.optionExerciseAmountModel, _that.getOptionExerciseAmountModel())) {
                return false;
            }
            if (!Objects.equals((Object)this.exerciseSide, (Object)_that.getExerciseSide())) {
                return false;
            }
            if (!Objects.equals((Object)this.settlementType, (Object)_that.getSettlementType())) {
                return false;
            }
            if (!Objects.equals(this.cashSettlement, _that.getCashSettlement())) {
                return false;
            }
            if (!Objects.equals(this.physicalSettlement, _that.getPhysicalSettlement())) {
                return false;
            }
            if (!Objects.equals(this.payment, _that.getPayment())) {
                return false;
            }
            return Objects.equals(this.clearingInstructions, _that.getClearingInstructions());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.optionSeller != null ? this.optionSeller.hashCode() : 0);
            _result = 31 * _result + (this.optionBuyer != null ? this.optionBuyer.hashCode() : 0);
            _result = 31 * _result + (this.originalTrade != null ? this.originalTrade.hashCode() : 0);
            _result = 31 * _result + (this.tradeIdentifier != null ? this.tradeIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.optionExerciseSequence != null ? this.optionExerciseSequence.hashCode() : 0);
            _result = 31 * _result + (this.exerciseTiming != null ? ((Object)((Object)this.exerciseTiming)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.optionExerciseAmountModel != null ? this.optionExerciseAmountModel.hashCode() : 0);
            _result = 31 * _result + (this.exerciseSide != null ? ((Object)((Object)this.exerciseSide)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.settlementType != null ? ((Object)((Object)this.settlementType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.cashSettlement != null ? this.cashSettlement.hashCode() : 0);
            _result = 31 * _result + (this.physicalSettlement != null ? this.physicalSettlement.hashCode() : 0);
            _result = 31 * _result + (this.payment != null ? this.payment.hashCode() : 0);
            _result = 31 * _result + (this.clearingInstructions != null ? this.clearingInstructions.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "OptionExercise {optionSeller=" + String.valueOf(this.optionSeller) + ", optionBuyer=" + String.valueOf(this.optionBuyer) + ", originalTrade=" + String.valueOf(this.originalTrade) + ", tradeIdentifier=" + String.valueOf(this.tradeIdentifier) + ", optionExerciseSequence=" + String.valueOf(this.optionExerciseSequence) + ", exerciseTiming=" + String.valueOf((Object)this.exerciseTiming) + ", optionExerciseAmountModel=" + String.valueOf(this.optionExerciseAmountModel) + ", exerciseSide=" + String.valueOf((Object)this.exerciseSide) + ", settlementType=" + String.valueOf((Object)this.settlementType) + ", cashSettlement=" + String.valueOf(this.cashSettlement) + ", physicalSettlement=" + String.valueOf(this.physicalSettlement) + ", payment=" + String.valueOf(this.payment) + ", clearingInstructions=" + String.valueOf(this.clearingInstructions) + "} " + super.toString();
        }
    }
}

