/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.business.events;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.business.events.meta.NovationAmountsOldModelSequence0Meta;
import fpml.consolidated.shared.Money;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="NovationAmountsOldModelSequence0", builder=NovationAmountsOldModelSequence0BuilderImpl.class, version="1.2.2")
@RuneDataType(value="NovationAmountsOldModelSequence0", model="fpml", builder=NovationAmountsOldModelSequence0BuilderImpl.class, version="1.2.2")
public interface NovationAmountsOldModelSequence0
extends RosettaModelObject {
    public static final NovationAmountsOldModelSequence0Meta metaData = new NovationAmountsOldModelSequence0Meta();

    public List<? extends Money> getNovatedAmount();

    public List<? extends Money> getRemainingAmount();

    public NovationAmountsOldModelSequence0 build();

    public NovationAmountsOldModelSequence0Builder toBuilder();

    public static NovationAmountsOldModelSequence0Builder builder() {
        return new NovationAmountsOldModelSequence0BuilderImpl();
    }

    default public RosettaMetaData<? extends NovationAmountsOldModelSequence0> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends NovationAmountsOldModelSequence0> getType() {
        return NovationAmountsOldModelSequence0.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("novatedAmount"), processor, Money.class, this.getNovatedAmount(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("remainingAmount"), processor, Money.class, this.getRemainingAmount(), new AttributeMeta[0]);
    }

    public static class NovationAmountsOldModelSequence0BuilderImpl
    implements NovationAmountsOldModelSequence0Builder {
        protected List<Money.MoneyBuilder> novatedAmount = new ArrayList<Money.MoneyBuilder>();
        protected List<Money.MoneyBuilder> remainingAmount = new ArrayList<Money.MoneyBuilder>();

        @Override
        @RosettaAttribute(value="novatedAmount", isRequired=true)
        @RuneAttribute(value="novatedAmount", isRequired=true)
        public List<? extends Money.MoneyBuilder> getNovatedAmount() {
            return this.novatedAmount;
        }

        @Override
        public Money.MoneyBuilder getOrCreateNovatedAmount(int index) {
            if (this.novatedAmount == null) {
                this.novatedAmount = new ArrayList<Money.MoneyBuilder>();
            }
            return (Money.MoneyBuilder)this.getIndex(this.novatedAmount, index, () -> {
                Money.MoneyBuilder newNovatedAmount = Money.builder();
                return newNovatedAmount;
            });
        }

        @Override
        @RosettaAttribute(value="remainingAmount")
        @RuneAttribute(value="remainingAmount")
        public List<? extends Money.MoneyBuilder> getRemainingAmount() {
            return this.remainingAmount;
        }

        @Override
        public Money.MoneyBuilder getOrCreateRemainingAmount(int index) {
            if (this.remainingAmount == null) {
                this.remainingAmount = new ArrayList<Money.MoneyBuilder>();
            }
            return (Money.MoneyBuilder)this.getIndex(this.remainingAmount, index, () -> {
                Money.MoneyBuilder newRemainingAmount = Money.builder();
                return newRemainingAmount;
            });
        }

        @Override
        @RosettaAttribute(value="novatedAmount", isRequired=true)
        @RuneAttribute(value="novatedAmount", isRequired=true)
        public NovationAmountsOldModelSequence0Builder addNovatedAmount(Money _novatedAmount) {
            if (_novatedAmount != null) {
                this.novatedAmount.add(_novatedAmount.toBuilder());
            }
            return this;
        }

        @Override
        public NovationAmountsOldModelSequence0Builder addNovatedAmount(Money _novatedAmount, int idx) {
            this.getIndex(this.novatedAmount, idx, () -> _novatedAmount.toBuilder());
            return this;
        }

        @Override
        public NovationAmountsOldModelSequence0Builder addNovatedAmount(List<? extends Money> novatedAmounts) {
            if (novatedAmounts != null) {
                for (Money money : novatedAmounts) {
                    this.novatedAmount.add(money.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="novatedAmount")
        public NovationAmountsOldModelSequence0Builder setNovatedAmount(List<? extends Money> novatedAmounts) {
            this.novatedAmount = novatedAmounts == null ? new ArrayList<Money.MoneyBuilder>() : (List)novatedAmounts.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="remainingAmount")
        @RuneAttribute(value="remainingAmount")
        public NovationAmountsOldModelSequence0Builder addRemainingAmount(Money _remainingAmount) {
            if (_remainingAmount != null) {
                this.remainingAmount.add(_remainingAmount.toBuilder());
            }
            return this;
        }

        @Override
        public NovationAmountsOldModelSequence0Builder addRemainingAmount(Money _remainingAmount, int idx) {
            this.getIndex(this.remainingAmount, idx, () -> _remainingAmount.toBuilder());
            return this;
        }

        @Override
        public NovationAmountsOldModelSequence0Builder addRemainingAmount(List<? extends Money> remainingAmounts) {
            if (remainingAmounts != null) {
                for (Money money : remainingAmounts) {
                    this.remainingAmount.add(money.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="remainingAmount")
        public NovationAmountsOldModelSequence0Builder setRemainingAmount(List<? extends Money> remainingAmounts) {
            this.remainingAmount = remainingAmounts == null ? new ArrayList<Money.MoneyBuilder>() : (List)remainingAmounts.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public NovationAmountsOldModelSequence0 build() {
            return new NovationAmountsOldModelSequence0Impl(this);
        }

        @Override
        public NovationAmountsOldModelSequence0Builder toBuilder() {
            return this;
        }

        @Override
        public NovationAmountsOldModelSequence0Builder prune() {
            this.novatedAmount = this.novatedAmount.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.remainingAmount = this.remainingAmount.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getNovatedAmount() != null && this.getNovatedAmount().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getRemainingAmount() != null && this.getRemainingAmount().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        public NovationAmountsOldModelSequence0Builder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            NovationAmountsOldModelSequence0Builder o = (NovationAmountsOldModelSequence0Builder)other;
            merger.mergeRosetta(this.getNovatedAmount(), o.getNovatedAmount(), this::getOrCreateNovatedAmount);
            merger.mergeRosetta(this.getRemainingAmount(), o.getRemainingAmount(), this::getOrCreateRemainingAmount);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            NovationAmountsOldModelSequence0 _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.novatedAmount, _that.getNovatedAmount())) {
                return false;
            }
            return ListEquals.listEquals(this.remainingAmount, _that.getRemainingAmount());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.novatedAmount != null ? this.novatedAmount.hashCode() : 0);
            _result = 31 * _result + (this.remainingAmount != null ? this.remainingAmount.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "NovationAmountsOldModelSequence0Builder {novatedAmount=" + String.valueOf(this.novatedAmount) + ", remainingAmount=" + String.valueOf(this.remainingAmount) + "}";
        }
    }

    public static interface NovationAmountsOldModelSequence0Builder
    extends NovationAmountsOldModelSequence0,
    RosettaModelObjectBuilder {
        public Money.MoneyBuilder getOrCreateNovatedAmount(int var1);

        public List<? extends Money.MoneyBuilder> getNovatedAmount();

        public Money.MoneyBuilder getOrCreateRemainingAmount(int var1);

        public List<? extends Money.MoneyBuilder> getRemainingAmount();

        public NovationAmountsOldModelSequence0Builder addNovatedAmount(Money var1);

        public NovationAmountsOldModelSequence0Builder addNovatedAmount(Money var1, int var2);

        public NovationAmountsOldModelSequence0Builder addNovatedAmount(List<? extends Money> var1);

        public NovationAmountsOldModelSequence0Builder setNovatedAmount(List<? extends Money> var1);

        public NovationAmountsOldModelSequence0Builder addRemainingAmount(Money var1);

        public NovationAmountsOldModelSequence0Builder addRemainingAmount(Money var1, int var2);

        public NovationAmountsOldModelSequence0Builder addRemainingAmount(List<? extends Money> var1);

        public NovationAmountsOldModelSequence0Builder setRemainingAmount(List<? extends Money> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("novatedAmount"), processor, Money.MoneyBuilder.class, this.getNovatedAmount(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("remainingAmount"), processor, Money.MoneyBuilder.class, this.getRemainingAmount(), new AttributeMeta[0]);
        }

        public NovationAmountsOldModelSequence0Builder prune();
    }

    public static class NovationAmountsOldModelSequence0Impl
    implements NovationAmountsOldModelSequence0 {
        private final List<? extends Money> novatedAmount;
        private final List<? extends Money> remainingAmount;

        protected NovationAmountsOldModelSequence0Impl(NovationAmountsOldModelSequence0Builder builder) {
            this.novatedAmount = Optional.ofNullable(builder.getNovatedAmount()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.remainingAmount = Optional.ofNullable(builder.getRemainingAmount()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="novatedAmount", isRequired=true)
        @RuneAttribute(value="novatedAmount", isRequired=true)
        public List<? extends Money> getNovatedAmount() {
            return this.novatedAmount;
        }

        @Override
        @RosettaAttribute(value="remainingAmount")
        @RuneAttribute(value="remainingAmount")
        public List<? extends Money> getRemainingAmount() {
            return this.remainingAmount;
        }

        @Override
        public NovationAmountsOldModelSequence0 build() {
            return this;
        }

        @Override
        public NovationAmountsOldModelSequence0Builder toBuilder() {
            NovationAmountsOldModelSequence0Builder builder = NovationAmountsOldModelSequence0.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(NovationAmountsOldModelSequence0Builder builder) {
            Optional.ofNullable(this.getNovatedAmount()).ifPresent(builder::setNovatedAmount);
            Optional.ofNullable(this.getRemainingAmount()).ifPresent(builder::setRemainingAmount);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            NovationAmountsOldModelSequence0 _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.novatedAmount, _that.getNovatedAmount())) {
                return false;
            }
            return ListEquals.listEquals(this.remainingAmount, _that.getRemainingAmount());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.novatedAmount != null ? this.novatedAmount.hashCode() : 0);
            _result = 31 * _result + (this.remainingAmount != null ? this.remainingAmount.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "NovationAmountsOldModelSequence0 {novatedAmount=" + String.valueOf(this.novatedAmount) + ", remainingAmount=" + String.valueOf(this.remainingAmount) + "}";
        }
    }
}

