/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.asset;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.asset.CreditQuality;
import fpml.consolidated.asset.GenericAsset;
import fpml.consolidated.asset.InstrumentType;
import fpml.consolidated.asset.meta.GenericSecurityMeta;
import fpml.consolidated.shared.IdentifiedCurrency;
import fpml.consolidated.shared.InstrumentId;
import fpml.consolidated.shared.PartyReference;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="GenericSecurity", builder=GenericSecurityBuilderImpl.class, version="1.2.2")
@RuneDataType(value="GenericSecurity", model="fpml", builder=GenericSecurityBuilderImpl.class, version="1.2.2")
public interface GenericSecurity
extends GenericAsset {
    public static final GenericSecurityMeta metaData = new GenericSecurityMeta();

    public IdentifiedCurrency getCurrency();

    public PartyReference getIssuerPartyReference();

    public List<? extends CreditQuality> getCreditQuality();

    public ZonedDateTime getMaturity();

    @Override
    public GenericSecurity build();

    @Override
    public GenericSecurityBuilder toBuilder();

    public static GenericSecurityBuilder builder() {
        return new GenericSecurityBuilderImpl();
    }

    default public RosettaMetaData<? extends GenericSecurity> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends GenericSecurity> getType() {
        return GenericSecurity.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("instrumentId"), processor, InstrumentId.class, this.getInstrumentId(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("instrumentType"), processor, InstrumentType.class, this.getInstrumentType(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("description"), String.class, (Object)this.getDescription(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("currency"), processor, IdentifiedCurrency.class, this.getCurrency(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("issuerPartyReference"), processor, PartyReference.class, this.getIssuerPartyReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("creditQuality"), processor, CreditQuality.class, this.getCreditQuality(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("maturity"), ZonedDateTime.class, (Object)this.getMaturity(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class GenericSecurityBuilderImpl
    extends GenericAsset.GenericAssetBuilderImpl
    implements GenericSecurityBuilder {
        protected IdentifiedCurrency.IdentifiedCurrencyBuilder currency;
        protected PartyReference.PartyReferenceBuilder issuerPartyReference;
        protected List<CreditQuality.CreditQualityBuilder> creditQuality = new ArrayList<CreditQuality.CreditQualityBuilder>();
        protected ZonedDateTime maturity;

        @Override
        @RosettaAttribute(value="currency")
        @RuneAttribute(value="currency")
        public IdentifiedCurrency.IdentifiedCurrencyBuilder getCurrency() {
            return this.currency;
        }

        @Override
        public IdentifiedCurrency.IdentifiedCurrencyBuilder getOrCreateCurrency() {
            IdentifiedCurrency.IdentifiedCurrencyBuilder result = this.currency != null ? this.currency : (this.currency = IdentifiedCurrency.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="issuerPartyReference")
        @RuneAttribute(value="issuerPartyReference")
        public PartyReference.PartyReferenceBuilder getIssuerPartyReference() {
            return this.issuerPartyReference;
        }

        @Override
        public PartyReference.PartyReferenceBuilder getOrCreateIssuerPartyReference() {
            PartyReference.PartyReferenceBuilder result = this.issuerPartyReference != null ? this.issuerPartyReference : (this.issuerPartyReference = PartyReference.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="creditQuality")
        @RuneAttribute(value="creditQuality")
        public List<? extends CreditQuality.CreditQualityBuilder> getCreditQuality() {
            return this.creditQuality;
        }

        @Override
        public CreditQuality.CreditQualityBuilder getOrCreateCreditQuality(int index) {
            if (this.creditQuality == null) {
                this.creditQuality = new ArrayList<CreditQuality.CreditQualityBuilder>();
            }
            return (CreditQuality.CreditQualityBuilder)this.getIndex(this.creditQuality, index, () -> {
                CreditQuality.CreditQualityBuilder newCreditQuality = CreditQuality.builder();
                return newCreditQuality;
            });
        }

        @Override
        @RosettaAttribute(value="maturity")
        @RuneAttribute(value="maturity")
        public ZonedDateTime getMaturity() {
            return this.maturity;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public GenericSecurityBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="instrumentId", isRequired=true)
        @RuneAttribute(value="instrumentId", isRequired=true)
        public GenericSecurityBuilder addInstrumentId(InstrumentId _instrumentId) {
            if (_instrumentId != null) {
                this.instrumentId.add(_instrumentId.toBuilder());
            }
            return this;
        }

        @Override
        public GenericSecurityBuilder addInstrumentId(InstrumentId _instrumentId, int idx) {
            this.getIndex(this.instrumentId, idx, () -> _instrumentId.toBuilder());
            return this;
        }

        @Override
        public GenericSecurityBuilder addInstrumentId(List<? extends InstrumentId> instrumentIds) {
            if (instrumentIds != null) {
                for (InstrumentId instrumentId : instrumentIds) {
                    this.instrumentId.add(instrumentId.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="instrumentId")
        public GenericSecurityBuilder setInstrumentId(List<? extends InstrumentId> instrumentIds) {
            this.instrumentId = instrumentIds == null ? new ArrayList() : (List)instrumentIds.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="instrumentType")
        @RuneAttribute(value="instrumentType")
        public GenericSecurityBuilder addInstrumentType(InstrumentType _instrumentType) {
            if (_instrumentType != null) {
                this.instrumentType.add(_instrumentType.toBuilder());
            }
            return this;
        }

        @Override
        public GenericSecurityBuilder addInstrumentType(InstrumentType _instrumentType, int idx) {
            this.getIndex(this.instrumentType, idx, () -> _instrumentType.toBuilder());
            return this;
        }

        @Override
        public GenericSecurityBuilder addInstrumentType(List<? extends InstrumentType> instrumentTypes) {
            if (instrumentTypes != null) {
                for (InstrumentType instrumentType : instrumentTypes) {
                    this.instrumentType.add(instrumentType.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="instrumentType")
        public GenericSecurityBuilder setInstrumentType(List<? extends InstrumentType> instrumentTypes) {
            this.instrumentType = instrumentTypes == null ? new ArrayList() : (List)instrumentTypes.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="description")
        @RuneAttribute(value="description")
        public GenericSecurityBuilder setDescription(String _description) {
            this.description = _description == null ? null : _description;
            return this;
        }

        @Override
        @RosettaAttribute(value="currency")
        @RuneAttribute(value="currency")
        public GenericSecurityBuilder setCurrency(IdentifiedCurrency _currency) {
            this.currency = _currency == null ? null : _currency.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="issuerPartyReference")
        @RuneAttribute(value="issuerPartyReference")
        public GenericSecurityBuilder setIssuerPartyReference(PartyReference _issuerPartyReference) {
            this.issuerPartyReference = _issuerPartyReference == null ? null : _issuerPartyReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="creditQuality")
        @RuneAttribute(value="creditQuality")
        public GenericSecurityBuilder addCreditQuality(CreditQuality _creditQuality) {
            if (_creditQuality != null) {
                this.creditQuality.add(_creditQuality.toBuilder());
            }
            return this;
        }

        @Override
        public GenericSecurityBuilder addCreditQuality(CreditQuality _creditQuality, int idx) {
            this.getIndex(this.creditQuality, idx, () -> _creditQuality.toBuilder());
            return this;
        }

        @Override
        public GenericSecurityBuilder addCreditQuality(List<? extends CreditQuality> creditQualitys) {
            if (creditQualitys != null) {
                for (CreditQuality creditQuality : creditQualitys) {
                    this.creditQuality.add(creditQuality.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="creditQuality")
        public GenericSecurityBuilder setCreditQuality(List<? extends CreditQuality> creditQualitys) {
            this.creditQuality = creditQualitys == null ? new ArrayList<CreditQuality.CreditQualityBuilder>() : (List)creditQualitys.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="maturity")
        @RuneAttribute(value="maturity")
        public GenericSecurityBuilder setMaturity(ZonedDateTime _maturity) {
            this.maturity = _maturity == null ? null : _maturity;
            return this;
        }

        @Override
        public GenericSecurity build() {
            return new GenericSecurityImpl(this);
        }

        @Override
        public GenericSecurityBuilder toBuilder() {
            return this;
        }

        @Override
        public GenericSecurityBuilder prune() {
            super.prune();
            if (this.currency != null && !this.currency.prune().hasData()) {
                this.currency = null;
            }
            if (this.issuerPartyReference != null && !this.issuerPartyReference.prune().hasData()) {
                this.issuerPartyReference = null;
            }
            this.creditQuality = this.creditQuality.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getCurrency() != null && this.getCurrency().hasData()) {
                return true;
            }
            if (this.getIssuerPartyReference() != null && this.getIssuerPartyReference().hasData()) {
                return true;
            }
            if (this.getCreditQuality() != null && this.getCreditQuality().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getMaturity() != null;
        }

        @Override
        public GenericSecurityBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            GenericSecurityBuilder o = (GenericSecurityBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCurrency(), (RosettaModelObjectBuilder)o.getCurrency(), this::setCurrency);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getIssuerPartyReference(), (RosettaModelObjectBuilder)o.getIssuerPartyReference(), this::setIssuerPartyReference);
            merger.mergeRosetta(this.getCreditQuality(), o.getCreditQuality(), this::getOrCreateCreditQuality);
            merger.mergeBasic((Object)this.getMaturity(), (Object)o.getMaturity(), this::setMaturity, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            GenericSecurity _that = (GenericSecurity)this.getType().cast(o);
            if (!Objects.equals(this.currency, _that.getCurrency())) {
                return false;
            }
            if (!Objects.equals(this.issuerPartyReference, _that.getIssuerPartyReference())) {
                return false;
            }
            if (!ListEquals.listEquals(this.creditQuality, _that.getCreditQuality())) {
                return false;
            }
            return Objects.equals(this.maturity, _that.getMaturity());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.currency != null ? this.currency.hashCode() : 0);
            _result = 31 * _result + (this.issuerPartyReference != null ? this.issuerPartyReference.hashCode() : 0);
            _result = 31 * _result + (this.creditQuality != null ? this.creditQuality.hashCode() : 0);
            _result = 31 * _result + (this.maturity != null ? this.maturity.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "GenericSecurityBuilder {currency=" + String.valueOf(this.currency) + ", issuerPartyReference=" + String.valueOf(this.issuerPartyReference) + ", creditQuality=" + String.valueOf(this.creditQuality) + ", maturity=" + String.valueOf(this.maturity) + "} " + super.toString();
        }
    }

    public static interface GenericSecurityBuilder
    extends GenericSecurity,
    GenericAsset.GenericAssetBuilder {
        public IdentifiedCurrency.IdentifiedCurrencyBuilder getOrCreateCurrency();

        @Override
        public IdentifiedCurrency.IdentifiedCurrencyBuilder getCurrency();

        public PartyReference.PartyReferenceBuilder getOrCreateIssuerPartyReference();

        @Override
        public PartyReference.PartyReferenceBuilder getIssuerPartyReference();

        public CreditQuality.CreditQualityBuilder getOrCreateCreditQuality(int var1);

        public List<? extends CreditQuality.CreditQualityBuilder> getCreditQuality();

        @Override
        public GenericSecurityBuilder setId(String var1);

        @Override
        public GenericSecurityBuilder addInstrumentId(InstrumentId var1);

        @Override
        public GenericSecurityBuilder addInstrumentId(InstrumentId var1, int var2);

        @Override
        public GenericSecurityBuilder addInstrumentId(List<? extends InstrumentId> var1);

        @Override
        public GenericSecurityBuilder setInstrumentId(List<? extends InstrumentId> var1);

        @Override
        public GenericSecurityBuilder addInstrumentType(InstrumentType var1);

        @Override
        public GenericSecurityBuilder addInstrumentType(InstrumentType var1, int var2);

        @Override
        public GenericSecurityBuilder addInstrumentType(List<? extends InstrumentType> var1);

        @Override
        public GenericSecurityBuilder setInstrumentType(List<? extends InstrumentType> var1);

        @Override
        public GenericSecurityBuilder setDescription(String var1);

        public GenericSecurityBuilder setCurrency(IdentifiedCurrency var1);

        public GenericSecurityBuilder setIssuerPartyReference(PartyReference var1);

        public GenericSecurityBuilder addCreditQuality(CreditQuality var1);

        public GenericSecurityBuilder addCreditQuality(CreditQuality var1, int var2);

        public GenericSecurityBuilder addCreditQuality(List<? extends CreditQuality> var1);

        public GenericSecurityBuilder setCreditQuality(List<? extends CreditQuality> var1);

        public GenericSecurityBuilder setMaturity(ZonedDateTime var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("instrumentId"), processor, InstrumentId.InstrumentIdBuilder.class, this.getInstrumentId(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("instrumentType"), processor, InstrumentType.InstrumentTypeBuilder.class, this.getInstrumentType(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("description"), String.class, (Object)this.getDescription(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("currency"), processor, IdentifiedCurrency.IdentifiedCurrencyBuilder.class, this.getCurrency(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("issuerPartyReference"), processor, PartyReference.PartyReferenceBuilder.class, this.getIssuerPartyReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("creditQuality"), processor, CreditQuality.CreditQualityBuilder.class, this.getCreditQuality(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("maturity"), ZonedDateTime.class, (Object)this.getMaturity(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        @Override
        public GenericSecurityBuilder prune();
    }

    public static class GenericSecurityImpl
    extends GenericAsset.GenericAssetImpl
    implements GenericSecurity {
        private final IdentifiedCurrency currency;
        private final PartyReference issuerPartyReference;
        private final List<? extends CreditQuality> creditQuality;
        private final ZonedDateTime maturity;

        protected GenericSecurityImpl(GenericSecurityBuilder builder) {
            super(builder);
            this.currency = Optional.ofNullable(builder.getCurrency()).map(f -> f.build()).orElse(null);
            this.issuerPartyReference = Optional.ofNullable(builder.getIssuerPartyReference()).map(f -> f.build()).orElse(null);
            this.creditQuality = Optional.ofNullable(builder.getCreditQuality()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.maturity = builder.getMaturity();
        }

        @Override
        @RosettaAttribute(value="currency")
        @RuneAttribute(value="currency")
        public IdentifiedCurrency getCurrency() {
            return this.currency;
        }

        @Override
        @RosettaAttribute(value="issuerPartyReference")
        @RuneAttribute(value="issuerPartyReference")
        public PartyReference getIssuerPartyReference() {
            return this.issuerPartyReference;
        }

        @Override
        @RosettaAttribute(value="creditQuality")
        @RuneAttribute(value="creditQuality")
        public List<? extends CreditQuality> getCreditQuality() {
            return this.creditQuality;
        }

        @Override
        @RosettaAttribute(value="maturity")
        @RuneAttribute(value="maturity")
        public ZonedDateTime getMaturity() {
            return this.maturity;
        }

        @Override
        public GenericSecurity build() {
            return this;
        }

        @Override
        public GenericSecurityBuilder toBuilder() {
            GenericSecurityBuilder builder = GenericSecurity.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(GenericSecurityBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getCurrency()).ifPresent(builder::setCurrency);
            Optional.ofNullable(this.getIssuerPartyReference()).ifPresent(builder::setIssuerPartyReference);
            Optional.ofNullable(this.getCreditQuality()).ifPresent(builder::setCreditQuality);
            Optional.ofNullable(this.getMaturity()).ifPresent(builder::setMaturity);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            GenericSecurity _that = (GenericSecurity)this.getType().cast(o);
            if (!Objects.equals(this.currency, _that.getCurrency())) {
                return false;
            }
            if (!Objects.equals(this.issuerPartyReference, _that.getIssuerPartyReference())) {
                return false;
            }
            if (!ListEquals.listEquals(this.creditQuality, _that.getCreditQuality())) {
                return false;
            }
            return Objects.equals(this.maturity, _that.getMaturity());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.currency != null ? this.currency.hashCode() : 0);
            _result = 31 * _result + (this.issuerPartyReference != null ? this.issuerPartyReference.hashCode() : 0);
            _result = 31 * _result + (this.creditQuality != null ? this.creditQuality.hashCode() : 0);
            _result = 31 * _result + (this.maturity != null ? this.maturity.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "GenericSecurity {currency=" + String.valueOf(this.currency) + ", issuerPartyReference=" + String.valueOf(this.issuerPartyReference) + ", creditQuality=" + String.valueOf(this.creditQuality) + ", maturity=" + String.valueOf(this.maturity) + "} " + super.toString();
        }
    }
}

