/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.asset;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.asset.meta.FxConversionMeta;
import fpml.consolidated.shared.AmountReference;
import fpml.consolidated.shared.FxRate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="FxConversion", builder=FxConversionBuilderImpl.class, version="1.2.2")
@RuneDataType(value="FxConversion", model="fpml", builder=FxConversionBuilderImpl.class, version="1.2.2")
public interface FxConversion
extends RosettaModelObject {
    public static final FxConversionMeta metaData = new FxConversionMeta();

    public AmountReference getAmountRelativeTo();

    public List<? extends FxRate> getFxRate();

    public FxConversion build();

    public FxConversionBuilder toBuilder();

    public static FxConversionBuilder builder() {
        return new FxConversionBuilderImpl();
    }

    default public RosettaMetaData<? extends FxConversion> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends FxConversion> getType() {
        return FxConversion.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("amountRelativeTo"), processor, AmountReference.class, this.getAmountRelativeTo(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("fxRate"), processor, FxRate.class, this.getFxRate(), new AttributeMeta[0]);
    }

    public static class FxConversionBuilderImpl
    implements FxConversionBuilder {
        protected AmountReference.AmountReferenceBuilder amountRelativeTo;
        protected List<FxRate.FxRateBuilder> fxRate = new ArrayList<FxRate.FxRateBuilder>();

        @Override
        @RosettaAttribute(value="amountRelativeTo")
        @RuneAttribute(value="amountRelativeTo")
        public AmountReference.AmountReferenceBuilder getAmountRelativeTo() {
            return this.amountRelativeTo;
        }

        @Override
        public AmountReference.AmountReferenceBuilder getOrCreateAmountRelativeTo() {
            AmountReference.AmountReferenceBuilder result = this.amountRelativeTo != null ? this.amountRelativeTo : (this.amountRelativeTo = AmountReference.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="fxRate")
        @RuneAttribute(value="fxRate")
        public List<? extends FxRate.FxRateBuilder> getFxRate() {
            return this.fxRate;
        }

        @Override
        public FxRate.FxRateBuilder getOrCreateFxRate(int index) {
            if (this.fxRate == null) {
                this.fxRate = new ArrayList<FxRate.FxRateBuilder>();
            }
            return (FxRate.FxRateBuilder)this.getIndex(this.fxRate, index, () -> {
                FxRate.FxRateBuilder newFxRate = FxRate.builder();
                return newFxRate;
            });
        }

        @Override
        @RosettaAttribute(value="amountRelativeTo")
        @RuneAttribute(value="amountRelativeTo")
        public FxConversionBuilder setAmountRelativeTo(AmountReference _amountRelativeTo) {
            this.amountRelativeTo = _amountRelativeTo == null ? null : _amountRelativeTo.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="fxRate")
        @RuneAttribute(value="fxRate")
        public FxConversionBuilder addFxRate(FxRate _fxRate) {
            if (_fxRate != null) {
                this.fxRate.add(_fxRate.toBuilder());
            }
            return this;
        }

        @Override
        public FxConversionBuilder addFxRate(FxRate _fxRate, int idx) {
            this.getIndex(this.fxRate, idx, () -> _fxRate.toBuilder());
            return this;
        }

        @Override
        public FxConversionBuilder addFxRate(List<? extends FxRate> fxRates) {
            if (fxRates != null) {
                for (FxRate fxRate : fxRates) {
                    this.fxRate.add(fxRate.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="fxRate")
        public FxConversionBuilder setFxRate(List<? extends FxRate> fxRates) {
            this.fxRate = fxRates == null ? new ArrayList<FxRate.FxRateBuilder>() : (List)fxRates.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public FxConversion build() {
            return new FxConversionImpl(this);
        }

        @Override
        public FxConversionBuilder toBuilder() {
            return this;
        }

        @Override
        public FxConversionBuilder prune() {
            if (this.amountRelativeTo != null && !this.amountRelativeTo.prune().hasData()) {
                this.amountRelativeTo = null;
            }
            this.fxRate = this.fxRate.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getAmountRelativeTo() != null && this.getAmountRelativeTo().hasData()) {
                return true;
            }
            return this.getFxRate() != null && this.getFxRate().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        public FxConversionBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            FxConversionBuilder o = (FxConversionBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAmountRelativeTo(), (RosettaModelObjectBuilder)o.getAmountRelativeTo(), this::setAmountRelativeTo);
            merger.mergeRosetta(this.getFxRate(), o.getFxRate(), this::getOrCreateFxRate);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            FxConversion _that = this.getType().cast(o);
            if (!Objects.equals(this.amountRelativeTo, _that.getAmountRelativeTo())) {
                return false;
            }
            return ListEquals.listEquals(this.fxRate, _that.getFxRate());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.amountRelativeTo != null ? this.amountRelativeTo.hashCode() : 0);
            _result = 31 * _result + (this.fxRate != null ? this.fxRate.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "FxConversionBuilder {amountRelativeTo=" + String.valueOf(this.amountRelativeTo) + ", fxRate=" + String.valueOf(this.fxRate) + "}";
        }
    }

    public static interface FxConversionBuilder
    extends FxConversion,
    RosettaModelObjectBuilder {
        public AmountReference.AmountReferenceBuilder getOrCreateAmountRelativeTo();

        @Override
        public AmountReference.AmountReferenceBuilder getAmountRelativeTo();

        public FxRate.FxRateBuilder getOrCreateFxRate(int var1);

        public List<? extends FxRate.FxRateBuilder> getFxRate();

        public FxConversionBuilder setAmountRelativeTo(AmountReference var1);

        public FxConversionBuilder addFxRate(FxRate var1);

        public FxConversionBuilder addFxRate(FxRate var1, int var2);

        public FxConversionBuilder addFxRate(List<? extends FxRate> var1);

        public FxConversionBuilder setFxRate(List<? extends FxRate> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("amountRelativeTo"), processor, AmountReference.AmountReferenceBuilder.class, this.getAmountRelativeTo(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("fxRate"), processor, FxRate.FxRateBuilder.class, this.getFxRate(), new AttributeMeta[0]);
        }

        public FxConversionBuilder prune();
    }

    public static class FxConversionImpl
    implements FxConversion {
        private final AmountReference amountRelativeTo;
        private final List<? extends FxRate> fxRate;

        protected FxConversionImpl(FxConversionBuilder builder) {
            this.amountRelativeTo = Optional.ofNullable(builder.getAmountRelativeTo()).map(f -> f.build()).orElse(null);
            this.fxRate = Optional.ofNullable(builder.getFxRate()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="amountRelativeTo")
        @RuneAttribute(value="amountRelativeTo")
        public AmountReference getAmountRelativeTo() {
            return this.amountRelativeTo;
        }

        @Override
        @RosettaAttribute(value="fxRate")
        @RuneAttribute(value="fxRate")
        public List<? extends FxRate> getFxRate() {
            return this.fxRate;
        }

        @Override
        public FxConversion build() {
            return this;
        }

        @Override
        public FxConversionBuilder toBuilder() {
            FxConversionBuilder builder = FxConversion.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(FxConversionBuilder builder) {
            Optional.ofNullable(this.getAmountRelativeTo()).ifPresent(builder::setAmountRelativeTo);
            Optional.ofNullable(this.getFxRate()).ifPresent(builder::setFxRate);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            FxConversion _that = this.getType().cast(o);
            if (!Objects.equals(this.amountRelativeTo, _that.getAmountRelativeTo())) {
                return false;
            }
            return ListEquals.listEquals(this.fxRate, _that.getFxRate());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.amountRelativeTo != null ? this.amountRelativeTo.hashCode() : 0);
            _result = 31 * _result + (this.fxRate != null ? this.fxRate.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "FxConversion {amountRelativeTo=" + String.valueOf(this.amountRelativeTo) + ", fxRate=" + String.valueOf(this.fxRate) + "}";
        }
    }
}

