/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.asset;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.asset.ExchangeIdentifierModel;
import fpml.consolidated.asset.InstrumentType;
import fpml.consolidated.asset.UnderlyingAsset;
import fpml.consolidated.asset.meta.ExchangeTradedMeta;
import fpml.consolidated.shared.ClearanceSystem;
import fpml.consolidated.shared.ExchangeId;
import fpml.consolidated.shared.IdentifiedCurrency;
import fpml.consolidated.shared.InstrumentId;
import fpml.consolidated.shared.ProductReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="ExchangeTraded", builder=ExchangeTradedBuilderImpl.class, version="1.2.2")
@RuneDataType(value="ExchangeTraded", model="fpml", builder=ExchangeTradedBuilderImpl.class, version="1.2.2")
public interface ExchangeTraded
extends UnderlyingAsset {
    public static final ExchangeTradedMeta metaData = new ExchangeTradedMeta();

    public ExchangeIdentifierModel getExchangeIdentifierModel();

    @Override
    public ExchangeTraded build();

    @Override
    public ExchangeTradedBuilder toBuilder();

    public static ExchangeTradedBuilder builder() {
        return new ExchangeTradedBuilderImpl();
    }

    default public RosettaMetaData<? extends ExchangeTraded> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends ExchangeTraded> getType() {
        return ExchangeTraded.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("instrumentId"), processor, InstrumentId.class, this.getInstrumentId(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("instrumentType"), processor, InstrumentType.class, this.getInstrumentType(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("description"), String.class, (Object)this.getDescription(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("currency"), processor, IdentifiedCurrency.class, this.getCurrency(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("exchangeId"), processor, ExchangeId.class, this.getExchangeId(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("clearanceSystem"), processor, ClearanceSystem.class, this.getClearanceSystem(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("definition"), processor, ProductReference.class, this.getDefinition(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("exchangeIdentifierModel"), processor, ExchangeIdentifierModel.class, this.getExchangeIdentifierModel(), new AttributeMeta[0]);
    }

    public static class ExchangeTradedBuilderImpl
    extends UnderlyingAsset.UnderlyingAssetBuilderImpl
    implements ExchangeTradedBuilder {
        protected ExchangeIdentifierModel.ExchangeIdentifierModelBuilder exchangeIdentifierModel;

        @Override
        @RosettaAttribute(value="exchangeIdentifierModel", isRequired=true)
        @RuneAttribute(value="exchangeIdentifierModel", isRequired=true)
        public ExchangeIdentifierModel.ExchangeIdentifierModelBuilder getExchangeIdentifierModel() {
            return this.exchangeIdentifierModel;
        }

        @Override
        public ExchangeIdentifierModel.ExchangeIdentifierModelBuilder getOrCreateExchangeIdentifierModel() {
            ExchangeIdentifierModel.ExchangeIdentifierModelBuilder result = this.exchangeIdentifierModel != null ? this.exchangeIdentifierModel : (this.exchangeIdentifierModel = ExchangeIdentifierModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public ExchangeTradedBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="instrumentId", isRequired=true)
        @RuneAttribute(value="instrumentId", isRequired=true)
        public ExchangeTradedBuilder addInstrumentId(InstrumentId _instrumentId) {
            if (_instrumentId != null) {
                this.instrumentId.add(_instrumentId.toBuilder());
            }
            return this;
        }

        @Override
        public ExchangeTradedBuilder addInstrumentId(InstrumentId _instrumentId, int idx) {
            this.getIndex(this.instrumentId, idx, () -> _instrumentId.toBuilder());
            return this;
        }

        @Override
        public ExchangeTradedBuilder addInstrumentId(List<? extends InstrumentId> instrumentIds) {
            if (instrumentIds != null) {
                for (InstrumentId instrumentId : instrumentIds) {
                    this.instrumentId.add(instrumentId.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="instrumentId")
        public ExchangeTradedBuilder setInstrumentId(List<? extends InstrumentId> instrumentIds) {
            this.instrumentId = instrumentIds == null ? new ArrayList() : (List)instrumentIds.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="instrumentType")
        @RuneAttribute(value="instrumentType")
        public ExchangeTradedBuilder addInstrumentType(InstrumentType _instrumentType) {
            if (_instrumentType != null) {
                this.instrumentType.add(_instrumentType.toBuilder());
            }
            return this;
        }

        @Override
        public ExchangeTradedBuilder addInstrumentType(InstrumentType _instrumentType, int idx) {
            this.getIndex(this.instrumentType, idx, () -> _instrumentType.toBuilder());
            return this;
        }

        @Override
        public ExchangeTradedBuilder addInstrumentType(List<? extends InstrumentType> instrumentTypes) {
            if (instrumentTypes != null) {
                for (InstrumentType instrumentType : instrumentTypes) {
                    this.instrumentType.add(instrumentType.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="instrumentType")
        public ExchangeTradedBuilder setInstrumentType(List<? extends InstrumentType> instrumentTypes) {
            this.instrumentType = instrumentTypes == null ? new ArrayList() : (List)instrumentTypes.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="description")
        @RuneAttribute(value="description")
        public ExchangeTradedBuilder setDescription(String _description) {
            this.description = _description == null ? null : _description;
            return this;
        }

        @Override
        @RosettaAttribute(value="currency")
        @RuneAttribute(value="currency")
        public ExchangeTradedBuilder setCurrency(IdentifiedCurrency _currency) {
            this.currency = _currency == null ? null : _currency.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="exchangeId")
        @RuneAttribute(value="exchangeId")
        public ExchangeTradedBuilder setExchangeId(ExchangeId _exchangeId) {
            this.exchangeId = _exchangeId == null ? null : _exchangeId.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="clearanceSystem")
        @RuneAttribute(value="clearanceSystem")
        public ExchangeTradedBuilder setClearanceSystem(ClearanceSystem _clearanceSystem) {
            this.clearanceSystem = _clearanceSystem == null ? null : _clearanceSystem.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="definition")
        @RuneAttribute(value="definition")
        public ExchangeTradedBuilder setDefinition(ProductReference _definition) {
            this.definition = _definition == null ? null : _definition.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="exchangeIdentifierModel", isRequired=true)
        @RuneAttribute(value="exchangeIdentifierModel", isRequired=true)
        public ExchangeTradedBuilder setExchangeIdentifierModel(ExchangeIdentifierModel _exchangeIdentifierModel) {
            this.exchangeIdentifierModel = _exchangeIdentifierModel == null ? null : _exchangeIdentifierModel.toBuilder();
            return this;
        }

        @Override
        public ExchangeTraded build() {
            return new ExchangeTradedImpl(this);
        }

        @Override
        public ExchangeTradedBuilder toBuilder() {
            return this;
        }

        @Override
        public ExchangeTradedBuilder prune() {
            super.prune();
            if (this.exchangeIdentifierModel != null && !this.exchangeIdentifierModel.prune().hasData()) {
                this.exchangeIdentifierModel = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            return this.getExchangeIdentifierModel() != null && this.getExchangeIdentifierModel().hasData();
        }

        @Override
        public ExchangeTradedBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            ExchangeTradedBuilder o = (ExchangeTradedBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getExchangeIdentifierModel(), (RosettaModelObjectBuilder)o.getExchangeIdentifierModel(), this::setExchangeIdentifierModel);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ExchangeTraded _that = (ExchangeTraded)this.getType().cast(o);
            return Objects.equals(this.exchangeIdentifierModel, _that.getExchangeIdentifierModel());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.exchangeIdentifierModel != null ? this.exchangeIdentifierModel.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "ExchangeTradedBuilder {exchangeIdentifierModel=" + String.valueOf(this.exchangeIdentifierModel) + "} " + super.toString();
        }
    }

    public static interface ExchangeTradedBuilder
    extends ExchangeTraded,
    UnderlyingAsset.UnderlyingAssetBuilder {
        public ExchangeIdentifierModel.ExchangeIdentifierModelBuilder getOrCreateExchangeIdentifierModel();

        @Override
        public ExchangeIdentifierModel.ExchangeIdentifierModelBuilder getExchangeIdentifierModel();

        @Override
        public ExchangeTradedBuilder setId(String var1);

        @Override
        public ExchangeTradedBuilder addInstrumentId(InstrumentId var1);

        @Override
        public ExchangeTradedBuilder addInstrumentId(InstrumentId var1, int var2);

        @Override
        public ExchangeTradedBuilder addInstrumentId(List<? extends InstrumentId> var1);

        @Override
        public ExchangeTradedBuilder setInstrumentId(List<? extends InstrumentId> var1);

        @Override
        public ExchangeTradedBuilder addInstrumentType(InstrumentType var1);

        @Override
        public ExchangeTradedBuilder addInstrumentType(InstrumentType var1, int var2);

        @Override
        public ExchangeTradedBuilder addInstrumentType(List<? extends InstrumentType> var1);

        @Override
        public ExchangeTradedBuilder setInstrumentType(List<? extends InstrumentType> var1);

        @Override
        public ExchangeTradedBuilder setDescription(String var1);

        @Override
        public ExchangeTradedBuilder setCurrency(IdentifiedCurrency var1);

        @Override
        public ExchangeTradedBuilder setExchangeId(ExchangeId var1);

        @Override
        public ExchangeTradedBuilder setClearanceSystem(ClearanceSystem var1);

        @Override
        public ExchangeTradedBuilder setDefinition(ProductReference var1);

        public ExchangeTradedBuilder setExchangeIdentifierModel(ExchangeIdentifierModel var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("instrumentId"), processor, InstrumentId.InstrumentIdBuilder.class, this.getInstrumentId(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("instrumentType"), processor, InstrumentType.InstrumentTypeBuilder.class, this.getInstrumentType(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("description"), String.class, (Object)this.getDescription(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("currency"), processor, IdentifiedCurrency.IdentifiedCurrencyBuilder.class, (RosettaModelObjectBuilder)this.getCurrency(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("exchangeId"), processor, ExchangeId.ExchangeIdBuilder.class, (RosettaModelObjectBuilder)this.getExchangeId(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("clearanceSystem"), processor, ClearanceSystem.ClearanceSystemBuilder.class, (RosettaModelObjectBuilder)this.getClearanceSystem(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("definition"), processor, ProductReference.ProductReferenceBuilder.class, (RosettaModelObjectBuilder)this.getDefinition(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("exchangeIdentifierModel"), processor, ExchangeIdentifierModel.ExchangeIdentifierModelBuilder.class, this.getExchangeIdentifierModel(), new AttributeMeta[0]);
        }

        @Override
        public ExchangeTradedBuilder prune();
    }

    public static class ExchangeTradedImpl
    extends UnderlyingAsset.UnderlyingAssetImpl
    implements ExchangeTraded {
        private final ExchangeIdentifierModel exchangeIdentifierModel;

        protected ExchangeTradedImpl(ExchangeTradedBuilder builder) {
            super(builder);
            this.exchangeIdentifierModel = Optional.ofNullable(builder.getExchangeIdentifierModel()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="exchangeIdentifierModel", isRequired=true)
        @RuneAttribute(value="exchangeIdentifierModel", isRequired=true)
        public ExchangeIdentifierModel getExchangeIdentifierModel() {
            return this.exchangeIdentifierModel;
        }

        @Override
        public ExchangeTraded build() {
            return this;
        }

        @Override
        public ExchangeTradedBuilder toBuilder() {
            ExchangeTradedBuilder builder = ExchangeTraded.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(ExchangeTradedBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getExchangeIdentifierModel()).ifPresent(builder::setExchangeIdentifierModel);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ExchangeTraded _that = (ExchangeTraded)this.getType().cast(o);
            return Objects.equals(this.exchangeIdentifierModel, _that.getExchangeIdentifierModel());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.exchangeIdentifierModel != null ? this.exchangeIdentifierModel.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "ExchangeTraded {exchangeIdentifierModel=" + String.valueOf(this.exchangeIdentifierModel) + "} " + super.toString();
        }
    }
}

