/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.asset;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.asset.EquityAsset;
import fpml.consolidated.asset.ExchangeIdentifierModel;
import fpml.consolidated.asset.InstrumentType;
import fpml.consolidated.asset.meta.EquityMeta;
import fpml.consolidated.shared.ClearanceSystem;
import fpml.consolidated.shared.ExchangeId;
import fpml.consolidated.shared.IdentifiedCurrency;
import fpml.consolidated.shared.InstrumentId;
import fpml.consolidated.shared.ProductReference;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

@RosettaDataType(value="Equity", builder=EquityBuilderImpl.class, version="1.2.2")
@RuneDataType(value="Equity", model="fpml", builder=EquityBuilderImpl.class, version="1.2.2")
public interface Equity
extends EquityAsset {
    public static final EquityMeta metaData = new EquityMeta();

    @Override
    public Equity build();

    @Override
    public EquityBuilder toBuilder();

    public static EquityBuilder builder() {
        return new EquityBuilderImpl();
    }

    default public RosettaMetaData<? extends Equity> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends Equity> getType() {
        return Equity.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("instrumentId"), processor, InstrumentId.class, this.getInstrumentId(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("instrumentType"), processor, InstrumentType.class, this.getInstrumentType(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("description"), String.class, (Object)this.getDescription(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("currency"), processor, IdentifiedCurrency.class, this.getCurrency(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("exchangeId"), processor, ExchangeId.class, this.getExchangeId(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("clearanceSystem"), processor, ClearanceSystem.class, this.getClearanceSystem(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("definition"), processor, ProductReference.class, this.getDefinition(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("exchangeIdentifierModel"), processor, ExchangeIdentifierModel.class, this.getExchangeIdentifierModel(), new AttributeMeta[0]);
    }

    public static class EquityBuilderImpl
    extends EquityAsset.EquityAssetBuilderImpl
    implements EquityBuilder {
        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public EquityBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="instrumentId", isRequired=true)
        @RuneAttribute(value="instrumentId", isRequired=true)
        public EquityBuilder addInstrumentId(InstrumentId _instrumentId) {
            if (_instrumentId != null) {
                this.instrumentId.add(_instrumentId.toBuilder());
            }
            return this;
        }

        @Override
        public EquityBuilder addInstrumentId(InstrumentId _instrumentId, int idx) {
            this.getIndex(this.instrumentId, idx, () -> _instrumentId.toBuilder());
            return this;
        }

        @Override
        public EquityBuilder addInstrumentId(List<? extends InstrumentId> instrumentIds) {
            if (instrumentIds != null) {
                for (InstrumentId instrumentId : instrumentIds) {
                    this.instrumentId.add(instrumentId.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="instrumentId")
        public EquityBuilder setInstrumentId(List<? extends InstrumentId> instrumentIds) {
            this.instrumentId = instrumentIds == null ? new ArrayList() : (List)instrumentIds.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="instrumentType")
        @RuneAttribute(value="instrumentType")
        public EquityBuilder addInstrumentType(InstrumentType _instrumentType) {
            if (_instrumentType != null) {
                this.instrumentType.add(_instrumentType.toBuilder());
            }
            return this;
        }

        @Override
        public EquityBuilder addInstrumentType(InstrumentType _instrumentType, int idx) {
            this.getIndex(this.instrumentType, idx, () -> _instrumentType.toBuilder());
            return this;
        }

        @Override
        public EquityBuilder addInstrumentType(List<? extends InstrumentType> instrumentTypes) {
            if (instrumentTypes != null) {
                for (InstrumentType instrumentType : instrumentTypes) {
                    this.instrumentType.add(instrumentType.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="instrumentType")
        public EquityBuilder setInstrumentType(List<? extends InstrumentType> instrumentTypes) {
            this.instrumentType = instrumentTypes == null ? new ArrayList() : (List)instrumentTypes.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="description")
        @RuneAttribute(value="description")
        public EquityBuilder setDescription(String _description) {
            this.description = _description == null ? null : _description;
            return this;
        }

        @Override
        @RosettaAttribute(value="currency")
        @RuneAttribute(value="currency")
        public EquityBuilder setCurrency(IdentifiedCurrency _currency) {
            this.currency = _currency == null ? null : _currency.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="exchangeId")
        @RuneAttribute(value="exchangeId")
        public EquityBuilder setExchangeId(ExchangeId _exchangeId) {
            this.exchangeId = _exchangeId == null ? null : _exchangeId.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="clearanceSystem")
        @RuneAttribute(value="clearanceSystem")
        public EquityBuilder setClearanceSystem(ClearanceSystem _clearanceSystem) {
            this.clearanceSystem = _clearanceSystem == null ? null : _clearanceSystem.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="definition")
        @RuneAttribute(value="definition")
        public EquityBuilder setDefinition(ProductReference _definition) {
            this.definition = _definition == null ? null : _definition.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="exchangeIdentifierModel", isRequired=true)
        @RuneAttribute(value="exchangeIdentifierModel", isRequired=true)
        public EquityBuilder setExchangeIdentifierModel(ExchangeIdentifierModel _exchangeIdentifierModel) {
            this.exchangeIdentifierModel = _exchangeIdentifierModel == null ? null : _exchangeIdentifierModel.toBuilder();
            return this;
        }

        @Override
        public Equity build() {
            return new EquityImpl(this);
        }

        @Override
        public EquityBuilder toBuilder() {
            return this;
        }

        @Override
        public EquityBuilder prune() {
            super.prune();
            return this;
        }

        @Override
        public boolean hasData() {
            return super.hasData();
        }

        @Override
        public EquityBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            EquityBuilder o = (EquityBuilder)other;
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            return super.equals(o);
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            return _result;
        }

        @Override
        public String toString() {
            return "EquityBuilder {} " + super.toString();
        }
    }

    public static interface EquityBuilder
    extends Equity,
    EquityAsset.EquityAssetBuilder {
        @Override
        public EquityBuilder setId(String var1);

        @Override
        public EquityBuilder addInstrumentId(InstrumentId var1);

        @Override
        public EquityBuilder addInstrumentId(InstrumentId var1, int var2);

        @Override
        public EquityBuilder addInstrumentId(List<? extends InstrumentId> var1);

        @Override
        public EquityBuilder setInstrumentId(List<? extends InstrumentId> var1);

        @Override
        public EquityBuilder addInstrumentType(InstrumentType var1);

        @Override
        public EquityBuilder addInstrumentType(InstrumentType var1, int var2);

        @Override
        public EquityBuilder addInstrumentType(List<? extends InstrumentType> var1);

        @Override
        public EquityBuilder setInstrumentType(List<? extends InstrumentType> var1);

        @Override
        public EquityBuilder setDescription(String var1);

        @Override
        public EquityBuilder setCurrency(IdentifiedCurrency var1);

        @Override
        public EquityBuilder setExchangeId(ExchangeId var1);

        @Override
        public EquityBuilder setClearanceSystem(ClearanceSystem var1);

        @Override
        public EquityBuilder setDefinition(ProductReference var1);

        @Override
        public EquityBuilder setExchangeIdentifierModel(ExchangeIdentifierModel var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("instrumentId"), processor, InstrumentId.InstrumentIdBuilder.class, this.getInstrumentId(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("instrumentType"), processor, InstrumentType.InstrumentTypeBuilder.class, this.getInstrumentType(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("description"), String.class, (Object)this.getDescription(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("currency"), processor, IdentifiedCurrency.IdentifiedCurrencyBuilder.class, (RosettaModelObjectBuilder)this.getCurrency(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("exchangeId"), processor, ExchangeId.ExchangeIdBuilder.class, (RosettaModelObjectBuilder)this.getExchangeId(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("clearanceSystem"), processor, ClearanceSystem.ClearanceSystemBuilder.class, (RosettaModelObjectBuilder)this.getClearanceSystem(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("definition"), processor, ProductReference.ProductReferenceBuilder.class, (RosettaModelObjectBuilder)this.getDefinition(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("exchangeIdentifierModel"), processor, ExchangeIdentifierModel.ExchangeIdentifierModelBuilder.class, (RosettaModelObjectBuilder)this.getExchangeIdentifierModel(), new AttributeMeta[0]);
        }

        @Override
        public EquityBuilder prune();
    }

    public static class EquityImpl
    extends EquityAsset.EquityAssetImpl
    implements Equity {
        protected EquityImpl(EquityBuilder builder) {
            super(builder);
        }

        @Override
        public Equity build() {
            return this;
        }

        @Override
        public EquityBuilder toBuilder() {
            EquityBuilder builder = Equity.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(EquityBuilder builder) {
            super.setBuilderFields(builder);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            return super.equals(o);
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            return _result;
        }

        @Override
        public String toString() {
            return "Equity {} " + super.toString();
        }
    }
}

