/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.asset;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.asset.CommodityProductModel;
import fpml.consolidated.asset.IdentifiedAsset;
import fpml.consolidated.asset.InstrumentType;
import fpml.consolidated.asset.meta.CommodityMeta;
import fpml.consolidated.shared.InstrumentId;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="Commodity", builder=CommodityBuilderImpl.class, version="1.2.2")
@RuneDataType(value="Commodity", model="fpml", builder=CommodityBuilderImpl.class, version="1.2.2")
public interface Commodity
extends IdentifiedAsset {
    public static final CommodityMeta metaData = new CommodityMeta();

    public CommodityProductModel getCommodityProductModel();

    @Override
    public Commodity build();

    @Override
    public CommodityBuilder toBuilder();

    public static CommodityBuilder builder() {
        return new CommodityBuilderImpl();
    }

    default public RosettaMetaData<? extends Commodity> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends Commodity> getType() {
        return Commodity.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("instrumentId"), processor, InstrumentId.class, this.getInstrumentId(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("instrumentType"), processor, InstrumentType.class, this.getInstrumentType(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("description"), String.class, (Object)this.getDescription(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("commodityProductModel"), processor, CommodityProductModel.class, this.getCommodityProductModel(), new AttributeMeta[0]);
    }

    public static class CommodityBuilderImpl
    extends IdentifiedAsset.IdentifiedAssetBuilderImpl
    implements CommodityBuilder {
        protected CommodityProductModel.CommodityProductModelBuilder commodityProductModel;

        @Override
        @RosettaAttribute(value="commodityProductModel", isRequired=true)
        @RuneAttribute(value="commodityProductModel", isRequired=true)
        public CommodityProductModel.CommodityProductModelBuilder getCommodityProductModel() {
            return this.commodityProductModel;
        }

        @Override
        public CommodityProductModel.CommodityProductModelBuilder getOrCreateCommodityProductModel() {
            CommodityProductModel.CommodityProductModelBuilder result = this.commodityProductModel != null ? this.commodityProductModel : (this.commodityProductModel = CommodityProductModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public CommodityBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="instrumentId", isRequired=true)
        @RuneAttribute(value="instrumentId", isRequired=true)
        public CommodityBuilder addInstrumentId(InstrumentId _instrumentId) {
            if (_instrumentId != null) {
                this.instrumentId.add(_instrumentId.toBuilder());
            }
            return this;
        }

        @Override
        public CommodityBuilder addInstrumentId(InstrumentId _instrumentId, int idx) {
            this.getIndex(this.instrumentId, idx, () -> _instrumentId.toBuilder());
            return this;
        }

        @Override
        public CommodityBuilder addInstrumentId(List<? extends InstrumentId> instrumentIds) {
            if (instrumentIds != null) {
                for (InstrumentId instrumentId : instrumentIds) {
                    this.instrumentId.add(instrumentId.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="instrumentId")
        public CommodityBuilder setInstrumentId(List<? extends InstrumentId> instrumentIds) {
            this.instrumentId = instrumentIds == null ? new ArrayList() : (List)instrumentIds.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="instrumentType")
        @RuneAttribute(value="instrumentType")
        public CommodityBuilder addInstrumentType(InstrumentType _instrumentType) {
            if (_instrumentType != null) {
                this.instrumentType.add(_instrumentType.toBuilder());
            }
            return this;
        }

        @Override
        public CommodityBuilder addInstrumentType(InstrumentType _instrumentType, int idx) {
            this.getIndex(this.instrumentType, idx, () -> _instrumentType.toBuilder());
            return this;
        }

        @Override
        public CommodityBuilder addInstrumentType(List<? extends InstrumentType> instrumentTypes) {
            if (instrumentTypes != null) {
                for (InstrumentType instrumentType : instrumentTypes) {
                    this.instrumentType.add(instrumentType.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="instrumentType")
        public CommodityBuilder setInstrumentType(List<? extends InstrumentType> instrumentTypes) {
            this.instrumentType = instrumentTypes == null ? new ArrayList() : (List)instrumentTypes.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="description")
        @RuneAttribute(value="description")
        public CommodityBuilder setDescription(String _description) {
            this.description = _description == null ? null : _description;
            return this;
        }

        @Override
        @RosettaAttribute(value="commodityProductModel", isRequired=true)
        @RuneAttribute(value="commodityProductModel", isRequired=true)
        public CommodityBuilder setCommodityProductModel(CommodityProductModel _commodityProductModel) {
            this.commodityProductModel = _commodityProductModel == null ? null : _commodityProductModel.toBuilder();
            return this;
        }

        @Override
        public Commodity build() {
            return new CommodityImpl(this);
        }

        @Override
        public CommodityBuilder toBuilder() {
            return this;
        }

        @Override
        public CommodityBuilder prune() {
            super.prune();
            if (this.commodityProductModel != null && !this.commodityProductModel.prune().hasData()) {
                this.commodityProductModel = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            return this.getCommodityProductModel() != null && this.getCommodityProductModel().hasData();
        }

        @Override
        public CommodityBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            CommodityBuilder o = (CommodityBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCommodityProductModel(), (RosettaModelObjectBuilder)o.getCommodityProductModel(), this::setCommodityProductModel);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Commodity _that = (Commodity)this.getType().cast(o);
            return Objects.equals(this.commodityProductModel, _that.getCommodityProductModel());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.commodityProductModel != null ? this.commodityProductModel.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "CommodityBuilder {commodityProductModel=" + String.valueOf(this.commodityProductModel) + "} " + super.toString();
        }
    }

    public static interface CommodityBuilder
    extends Commodity,
    IdentifiedAsset.IdentifiedAssetBuilder {
        public CommodityProductModel.CommodityProductModelBuilder getOrCreateCommodityProductModel();

        @Override
        public CommodityProductModel.CommodityProductModelBuilder getCommodityProductModel();

        @Override
        public CommodityBuilder setId(String var1);

        @Override
        public CommodityBuilder addInstrumentId(InstrumentId var1);

        @Override
        public CommodityBuilder addInstrumentId(InstrumentId var1, int var2);

        @Override
        public CommodityBuilder addInstrumentId(List<? extends InstrumentId> var1);

        @Override
        public CommodityBuilder setInstrumentId(List<? extends InstrumentId> var1);

        @Override
        public CommodityBuilder addInstrumentType(InstrumentType var1);

        @Override
        public CommodityBuilder addInstrumentType(InstrumentType var1, int var2);

        @Override
        public CommodityBuilder addInstrumentType(List<? extends InstrumentType> var1);

        @Override
        public CommodityBuilder setInstrumentType(List<? extends InstrumentType> var1);

        @Override
        public CommodityBuilder setDescription(String var1);

        public CommodityBuilder setCommodityProductModel(CommodityProductModel var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("instrumentId"), processor, InstrumentId.InstrumentIdBuilder.class, this.getInstrumentId(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("instrumentType"), processor, InstrumentType.InstrumentTypeBuilder.class, this.getInstrumentType(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("description"), String.class, (Object)this.getDescription(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("commodityProductModel"), processor, CommodityProductModel.CommodityProductModelBuilder.class, this.getCommodityProductModel(), new AttributeMeta[0]);
        }

        @Override
        public CommodityBuilder prune();
    }

    public static class CommodityImpl
    extends IdentifiedAsset.IdentifiedAssetImpl
    implements Commodity {
        private final CommodityProductModel commodityProductModel;

        protected CommodityImpl(CommodityBuilder builder) {
            super(builder);
            this.commodityProductModel = Optional.ofNullable(builder.getCommodityProductModel()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="commodityProductModel", isRequired=true)
        @RuneAttribute(value="commodityProductModel", isRequired=true)
        public CommodityProductModel getCommodityProductModel() {
            return this.commodityProductModel;
        }

        @Override
        public Commodity build() {
            return this;
        }

        @Override
        public CommodityBuilder toBuilder() {
            CommodityBuilder builder = Commodity.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CommodityBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getCommodityProductModel()).ifPresent(builder::setCommodityProductModel);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Commodity _that = (Commodity)this.getType().cast(o);
            return Objects.equals(this.commodityProductModel, _that.getCommodityProductModel());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.commodityProductModel != null ? this.commodityProductModel.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "Commodity {commodityProductModel=" + String.valueOf(this.commodityProductModel) + "} " + super.toString();
        }
    }
}

