/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.asset;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.asset.Asset;
import fpml.consolidated.asset.BasketConstituent;
import fpml.consolidated.asset.BasketIdentifierModel;
import fpml.consolidated.asset.meta.BasketMeta;
import fpml.consolidated.shared.Currency;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="Basket", builder=BasketBuilderImpl.class, version="1.2.2")
@RuneDataType(value="Basket", model="fpml", builder=BasketBuilderImpl.class, version="1.2.2")
public interface Basket
extends Asset {
    public static final BasketMeta metaData = new BasketMeta();

    public BigDecimal getOpenUnits();

    public List<? extends BasketConstituent> getBasketConstituent();

    public BigDecimal getBasketDivisor();

    public Integer getBasketVersion();

    public BasketIdentifierModel getBasketIdentifierModel();

    public Currency getBasketCurrency();

    @Override
    public Basket build();

    @Override
    public BasketBuilder toBuilder();

    public static BasketBuilder builder() {
        return new BasketBuilderImpl();
    }

    default public RosettaMetaData<? extends Basket> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends Basket> getType() {
        return Basket.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("openUnits"), BigDecimal.class, (Object)this.getOpenUnits(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("basketConstituent"), processor, BasketConstituent.class, this.getBasketConstituent(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("basketDivisor"), BigDecimal.class, (Object)this.getBasketDivisor(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("basketVersion"), Integer.class, (Object)this.getBasketVersion(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("basketIdentifierModel"), processor, BasketIdentifierModel.class, this.getBasketIdentifierModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("basketCurrency"), processor, Currency.class, this.getBasketCurrency(), new AttributeMeta[0]);
    }

    public static class BasketBuilderImpl
    extends Asset.AssetBuilderImpl
    implements BasketBuilder {
        protected BigDecimal openUnits;
        protected List<BasketConstituent.BasketConstituentBuilder> basketConstituent = new ArrayList<BasketConstituent.BasketConstituentBuilder>();
        protected BigDecimal basketDivisor;
        protected Integer basketVersion;
        protected BasketIdentifierModel.BasketIdentifierModelBuilder basketIdentifierModel;
        protected Currency.CurrencyBuilder basketCurrency;

        @Override
        @RosettaAttribute(value="openUnits")
        @RuneAttribute(value="openUnits")
        public BigDecimal getOpenUnits() {
            return this.openUnits;
        }

        @Override
        @RosettaAttribute(value="basketConstituent", isRequired=true)
        @RuneAttribute(value="basketConstituent", isRequired=true)
        public List<? extends BasketConstituent.BasketConstituentBuilder> getBasketConstituent() {
            return this.basketConstituent;
        }

        @Override
        public BasketConstituent.BasketConstituentBuilder getOrCreateBasketConstituent(int index) {
            if (this.basketConstituent == null) {
                this.basketConstituent = new ArrayList<BasketConstituent.BasketConstituentBuilder>();
            }
            return (BasketConstituent.BasketConstituentBuilder)this.getIndex(this.basketConstituent, index, () -> {
                BasketConstituent.BasketConstituentBuilder newBasketConstituent = BasketConstituent.builder();
                return newBasketConstituent;
            });
        }

        @Override
        @RosettaAttribute(value="basketDivisor")
        @RuneAttribute(value="basketDivisor")
        public BigDecimal getBasketDivisor() {
            return this.basketDivisor;
        }

        @Override
        @RosettaAttribute(value="basketVersion")
        @RuneAttribute(value="basketVersion")
        public Integer getBasketVersion() {
            return this.basketVersion;
        }

        @Override
        @RosettaAttribute(value="basketIdentifierModel")
        @RuneAttribute(value="basketIdentifierModel")
        public BasketIdentifierModel.BasketIdentifierModelBuilder getBasketIdentifierModel() {
            return this.basketIdentifierModel;
        }

        @Override
        public BasketIdentifierModel.BasketIdentifierModelBuilder getOrCreateBasketIdentifierModel() {
            BasketIdentifierModel.BasketIdentifierModelBuilder result = this.basketIdentifierModel != null ? this.basketIdentifierModel : (this.basketIdentifierModel = BasketIdentifierModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="basketCurrency")
        @RuneAttribute(value="basketCurrency")
        public Currency.CurrencyBuilder getBasketCurrency() {
            return this.basketCurrency;
        }

        @Override
        public Currency.CurrencyBuilder getOrCreateBasketCurrency() {
            Currency.CurrencyBuilder result = this.basketCurrency != null ? this.basketCurrency : (this.basketCurrency = Currency.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public BasketBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="openUnits")
        @RuneAttribute(value="openUnits")
        public BasketBuilder setOpenUnits(BigDecimal _openUnits) {
            this.openUnits = _openUnits == null ? null : _openUnits;
            return this;
        }

        @Override
        @RosettaAttribute(value="basketConstituent", isRequired=true)
        @RuneAttribute(value="basketConstituent", isRequired=true)
        public BasketBuilder addBasketConstituent(BasketConstituent _basketConstituent) {
            if (_basketConstituent != null) {
                this.basketConstituent.add(_basketConstituent.toBuilder());
            }
            return this;
        }

        @Override
        public BasketBuilder addBasketConstituent(BasketConstituent _basketConstituent, int idx) {
            this.getIndex(this.basketConstituent, idx, () -> _basketConstituent.toBuilder());
            return this;
        }

        @Override
        public BasketBuilder addBasketConstituent(List<? extends BasketConstituent> basketConstituents) {
            if (basketConstituents != null) {
                for (BasketConstituent basketConstituent : basketConstituents) {
                    this.basketConstituent.add(basketConstituent.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="basketConstituent")
        public BasketBuilder setBasketConstituent(List<? extends BasketConstituent> basketConstituents) {
            this.basketConstituent = basketConstituents == null ? new ArrayList<BasketConstituent.BasketConstituentBuilder>() : (List)basketConstituents.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="basketDivisor")
        @RuneAttribute(value="basketDivisor")
        public BasketBuilder setBasketDivisor(BigDecimal _basketDivisor) {
            this.basketDivisor = _basketDivisor == null ? null : _basketDivisor;
            return this;
        }

        @Override
        @RosettaAttribute(value="basketVersion")
        @RuneAttribute(value="basketVersion")
        public BasketBuilder setBasketVersion(Integer _basketVersion) {
            this.basketVersion = _basketVersion == null ? null : _basketVersion;
            return this;
        }

        @Override
        @RosettaAttribute(value="basketIdentifierModel")
        @RuneAttribute(value="basketIdentifierModel")
        public BasketBuilder setBasketIdentifierModel(BasketIdentifierModel _basketIdentifierModel) {
            this.basketIdentifierModel = _basketIdentifierModel == null ? null : _basketIdentifierModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="basketCurrency")
        @RuneAttribute(value="basketCurrency")
        public BasketBuilder setBasketCurrency(Currency _basketCurrency) {
            this.basketCurrency = _basketCurrency == null ? null : _basketCurrency.toBuilder();
            return this;
        }

        @Override
        public Basket build() {
            return new BasketImpl(this);
        }

        @Override
        public BasketBuilder toBuilder() {
            return this;
        }

        @Override
        public BasketBuilder prune() {
            super.prune();
            this.basketConstituent = this.basketConstituent.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.basketIdentifierModel != null && !this.basketIdentifierModel.prune().hasData()) {
                this.basketIdentifierModel = null;
            }
            if (this.basketCurrency != null && !this.basketCurrency.prune().hasData()) {
                this.basketCurrency = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getOpenUnits() != null) {
                return true;
            }
            if (this.getBasketConstituent() != null && this.getBasketConstituent().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getBasketDivisor() != null) {
                return true;
            }
            if (this.getBasketVersion() != null) {
                return true;
            }
            if (this.getBasketIdentifierModel() != null && this.getBasketIdentifierModel().hasData()) {
                return true;
            }
            return this.getBasketCurrency() != null && this.getBasketCurrency().hasData();
        }

        @Override
        public BasketBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            BasketBuilder o = (BasketBuilder)other;
            merger.mergeRosetta(this.getBasketConstituent(), o.getBasketConstituent(), this::getOrCreateBasketConstituent);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getBasketIdentifierModel(), (RosettaModelObjectBuilder)o.getBasketIdentifierModel(), this::setBasketIdentifierModel);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getBasketCurrency(), (RosettaModelObjectBuilder)o.getBasketCurrency(), this::setBasketCurrency);
            merger.mergeBasic((Object)this.getOpenUnits(), (Object)o.getOpenUnits(), this::setOpenUnits, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getBasketDivisor(), (Object)o.getBasketDivisor(), this::setBasketDivisor, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getBasketVersion(), (Object)o.getBasketVersion(), this::setBasketVersion, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Basket _that = (Basket)this.getType().cast(o);
            if (!Objects.equals(this.openUnits, _that.getOpenUnits())) {
                return false;
            }
            if (!ListEquals.listEquals(this.basketConstituent, _that.getBasketConstituent())) {
                return false;
            }
            if (!Objects.equals(this.basketDivisor, _that.getBasketDivisor())) {
                return false;
            }
            if (!Objects.equals(this.basketVersion, _that.getBasketVersion())) {
                return false;
            }
            if (!Objects.equals(this.basketIdentifierModel, _that.getBasketIdentifierModel())) {
                return false;
            }
            return Objects.equals(this.basketCurrency, _that.getBasketCurrency());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.openUnits != null ? this.openUnits.hashCode() : 0);
            _result = 31 * _result + (this.basketConstituent != null ? this.basketConstituent.hashCode() : 0);
            _result = 31 * _result + (this.basketDivisor != null ? this.basketDivisor.hashCode() : 0);
            _result = 31 * _result + (this.basketVersion != null ? this.basketVersion.hashCode() : 0);
            _result = 31 * _result + (this.basketIdentifierModel != null ? this.basketIdentifierModel.hashCode() : 0);
            _result = 31 * _result + (this.basketCurrency != null ? this.basketCurrency.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "BasketBuilder {openUnits=" + String.valueOf(this.openUnits) + ", basketConstituent=" + String.valueOf(this.basketConstituent) + ", basketDivisor=" + String.valueOf(this.basketDivisor) + ", basketVersion=" + this.basketVersion + ", basketIdentifierModel=" + String.valueOf(this.basketIdentifierModel) + ", basketCurrency=" + String.valueOf(this.basketCurrency) + "} " + super.toString();
        }
    }

    public static interface BasketBuilder
    extends Basket,
    Asset.AssetBuilder {
        public BasketConstituent.BasketConstituentBuilder getOrCreateBasketConstituent(int var1);

        public List<? extends BasketConstituent.BasketConstituentBuilder> getBasketConstituent();

        public BasketIdentifierModel.BasketIdentifierModelBuilder getOrCreateBasketIdentifierModel();

        @Override
        public BasketIdentifierModel.BasketIdentifierModelBuilder getBasketIdentifierModel();

        public Currency.CurrencyBuilder getOrCreateBasketCurrency();

        @Override
        public Currency.CurrencyBuilder getBasketCurrency();

        @Override
        public BasketBuilder setId(String var1);

        public BasketBuilder setOpenUnits(BigDecimal var1);

        public BasketBuilder addBasketConstituent(BasketConstituent var1);

        public BasketBuilder addBasketConstituent(BasketConstituent var1, int var2);

        public BasketBuilder addBasketConstituent(List<? extends BasketConstituent> var1);

        public BasketBuilder setBasketConstituent(List<? extends BasketConstituent> var1);

        public BasketBuilder setBasketDivisor(BigDecimal var1);

        public BasketBuilder setBasketVersion(Integer var1);

        public BasketBuilder setBasketIdentifierModel(BasketIdentifierModel var1);

        public BasketBuilder setBasketCurrency(Currency var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("openUnits"), BigDecimal.class, (Object)this.getOpenUnits(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("basketConstituent"), processor, BasketConstituent.BasketConstituentBuilder.class, this.getBasketConstituent(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("basketDivisor"), BigDecimal.class, (Object)this.getBasketDivisor(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("basketVersion"), Integer.class, (Object)this.getBasketVersion(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("basketIdentifierModel"), processor, BasketIdentifierModel.BasketIdentifierModelBuilder.class, this.getBasketIdentifierModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("basketCurrency"), processor, Currency.CurrencyBuilder.class, this.getBasketCurrency(), new AttributeMeta[0]);
        }

        @Override
        public BasketBuilder prune();
    }

    public static class BasketImpl
    extends Asset.AssetImpl
    implements Basket {
        private final BigDecimal openUnits;
        private final List<? extends BasketConstituent> basketConstituent;
        private final BigDecimal basketDivisor;
        private final Integer basketVersion;
        private final BasketIdentifierModel basketIdentifierModel;
        private final Currency basketCurrency;

        protected BasketImpl(BasketBuilder builder) {
            super(builder);
            this.openUnits = builder.getOpenUnits();
            this.basketConstituent = Optional.ofNullable(builder.getBasketConstituent()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.basketDivisor = builder.getBasketDivisor();
            this.basketVersion = builder.getBasketVersion();
            this.basketIdentifierModel = Optional.ofNullable(builder.getBasketIdentifierModel()).map(f -> f.build()).orElse(null);
            this.basketCurrency = Optional.ofNullable(builder.getBasketCurrency()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="openUnits")
        @RuneAttribute(value="openUnits")
        public BigDecimal getOpenUnits() {
            return this.openUnits;
        }

        @Override
        @RosettaAttribute(value="basketConstituent", isRequired=true)
        @RuneAttribute(value="basketConstituent", isRequired=true)
        public List<? extends BasketConstituent> getBasketConstituent() {
            return this.basketConstituent;
        }

        @Override
        @RosettaAttribute(value="basketDivisor")
        @RuneAttribute(value="basketDivisor")
        public BigDecimal getBasketDivisor() {
            return this.basketDivisor;
        }

        @Override
        @RosettaAttribute(value="basketVersion")
        @RuneAttribute(value="basketVersion")
        public Integer getBasketVersion() {
            return this.basketVersion;
        }

        @Override
        @RosettaAttribute(value="basketIdentifierModel")
        @RuneAttribute(value="basketIdentifierModel")
        public BasketIdentifierModel getBasketIdentifierModel() {
            return this.basketIdentifierModel;
        }

        @Override
        @RosettaAttribute(value="basketCurrency")
        @RuneAttribute(value="basketCurrency")
        public Currency getBasketCurrency() {
            return this.basketCurrency;
        }

        @Override
        public Basket build() {
            return this;
        }

        @Override
        public BasketBuilder toBuilder() {
            BasketBuilder builder = Basket.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(BasketBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getOpenUnits()).ifPresent(builder::setOpenUnits);
            Optional.ofNullable(this.getBasketConstituent()).ifPresent(builder::setBasketConstituent);
            Optional.ofNullable(this.getBasketDivisor()).ifPresent(builder::setBasketDivisor);
            Optional.ofNullable(this.getBasketVersion()).ifPresent(builder::setBasketVersion);
            Optional.ofNullable(this.getBasketIdentifierModel()).ifPresent(builder::setBasketIdentifierModel);
            Optional.ofNullable(this.getBasketCurrency()).ifPresent(builder::setBasketCurrency);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Basket _that = (Basket)this.getType().cast(o);
            if (!Objects.equals(this.openUnits, _that.getOpenUnits())) {
                return false;
            }
            if (!ListEquals.listEquals(this.basketConstituent, _that.getBasketConstituent())) {
                return false;
            }
            if (!Objects.equals(this.basketDivisor, _that.getBasketDivisor())) {
                return false;
            }
            if (!Objects.equals(this.basketVersion, _that.getBasketVersion())) {
                return false;
            }
            if (!Objects.equals(this.basketIdentifierModel, _that.getBasketIdentifierModel())) {
                return false;
            }
            return Objects.equals(this.basketCurrency, _that.getBasketCurrency());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.openUnits != null ? this.openUnits.hashCode() : 0);
            _result = 31 * _result + (this.basketConstituent != null ? this.basketConstituent.hashCode() : 0);
            _result = 31 * _result + (this.basketDivisor != null ? this.basketDivisor.hashCode() : 0);
            _result = 31 * _result + (this.basketVersion != null ? this.basketVersion.hashCode() : 0);
            _result = 31 * _result + (this.basketIdentifierModel != null ? this.basketIdentifierModel.hashCode() : 0);
            _result = 31 * _result + (this.basketCurrency != null ? this.basketCurrency.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "Basket {openUnits=" + String.valueOf(this.openUnits) + ", basketConstituent=" + String.valueOf(this.basketConstituent) + ", basketDivisor=" + String.valueOf(this.basketDivisor) + ", basketVersion=" + this.basketVersion + ", basketIdentifierModel=" + String.valueOf(this.basketIdentifierModel) + ", basketCurrency=" + String.valueOf(this.basketCurrency) + "} " + super.toString();
        }
    }
}

