/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.maven;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.regnosys.rosetta.maven.RosettaLanguageAccessFactory;
import com.regnosys.rosetta.maven.RosettaMavenStandaloneBuilderModule;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;
import org.eclipse.xtext.builder.standalone.LanguageAccess;
import org.eclipse.xtext.builder.standalone.StandaloneBuilder;
import org.eclipse.xtext.builder.standalone.compiler.CompilerConfiguration;
import org.eclipse.xtext.builder.standalone.compiler.IJavaCompiler;
import org.eclipse.xtext.maven.AbstractXtextGeneratorMojo;
import org.eclipse.xtext.maven.ClusteringConfig;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public abstract class AbstractRosettaGeneratorMojo
extends AbstractXtextGeneratorMojo {
    @Parameter(defaultValue="true")
    boolean addOutputDirectoriesToCompileSourceRoots = Boolean.TRUE;
    @Parameter
    private String classPathLookupFilter;
    @Parameter(defaultValue="${project.compileSourceRoots}", required=true)
    private List<String> javaSourceRoots;
    @Parameter(defaultValue="true")
    private Boolean failOnValidationError;
    @Parameter(defaultValue="${project.build.directory}/xtext-temp")
    private String tmpClassDirectory;
    @Parameter
    private ClusteringConfig clusteringConfig;
    @Parameter(property="maven.compiler.source", defaultValue="1.6")
    private String compilerSourceLevel;
    @Parameter(property="maven.compiler.target", defaultValue="1.6")
    private String compilerTargetLevel;
    @Parameter(defaultValue="false")
    private Boolean compilerSkipAnnotationProcessing;
    @Parameter(defaultValue="false")
    private Boolean compilerPreserveInformationAboutFormalParameters;

    protected Module createModule() {
        return new RosettaMavenStandaloneBuilderModule();
    }

    protected void internalExecute() throws MojoExecutionException {
        boolean errorDetected;
        if (this.addOutputDirectoriesToCompileSourceRoots) {
            this.configureMavenOutputs();
        }
        Map<String, LanguageAccess> languages = new RosettaLanguageAccessFactory().createLanguageAccess(this.getLanguages(), ((Object)((Object)this)).getClass().getClassLoader());
        Injector injector = Guice.createInjector((Module[])new Module[]{this.createModule()});
        StandaloneBuilder builder = (StandaloneBuilder)injector.getInstance(StandaloneBuilder.class);
        builder.setBaseDir(this.getProject().getBasedir().getAbsolutePath());
        builder.setLanguages(languages);
        builder.setEncoding(this.getEncoding());
        builder.setClassPathEntries((Iterable)this.getClasspathElements());
        builder.setClassPathLookUpFilter(this.classPathLookupFilter);
        builder.setSourceDirs((Iterable)this.getSourceRoots());
        builder.setJavaSourceDirs(this.javaSourceRoots);
        builder.setFailOnValidationError(this.failOnValidationError.booleanValue());
        builder.setTempDir(this.createTempDir().getAbsolutePath());
        builder.setDebugLog(this.getLog().isDebugEnabled());
        if (this.clusteringConfig != null) {
            builder.setClusteringConfig(this.clusteringConfig.convertToStandaloneConfig());
        }
        this.configureCompiler(builder.getCompiler());
        this.logState();
        boolean bl = errorDetected = !builder.launch();
        if (errorDetected && this.failOnValidationError.booleanValue()) {
            throw new MojoExecutionException("Execution failed due to a severe validation error.");
        }
    }

    private void configureCompiler(IJavaCompiler compiler) {
        CompilerConfiguration conf = compiler.getConfiguration();
        conf.setSourceLevel(this.compilerSourceLevel);
        conf.setTargetLevel(this.compilerTargetLevel);
        conf.setVerbose(this.getLog().isDebugEnabled());
        conf.setSkipAnnotationProcessing(this.compilerSkipAnnotationProcessing.booleanValue());
        conf.setPreserveInformationAboutFormalParameters(this.compilerPreserveInformationAboutFormalParameters.booleanValue());
    }

    private File createTempDir() {
        File tmpDir = new File(this.tmpClassDirectory);
        if (!tmpDir.mkdirs() && !tmpDir.exists()) {
            throw new IllegalArgumentException("Couldn't create directory '" + this.tmpClassDirectory + "'.");
        }
        return tmpDir;
    }

    private void logState() {
        this.getLog().info((CharSequence)("Encoding: " + (this.getEncoding() == null ? "not set. Encoding provider will be used." : this.getEncoding())));
        this.getLog().info((CharSequence)("Compiler source level: " + this.compilerSourceLevel));
        this.getLog().info((CharSequence)("Compiler target level: " + this.compilerTargetLevel));
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Source dirs: " + IterableExtensions.join((Iterable)this.getSourceRoots(), (CharSequence)", ")));
            this.getLog().debug((CharSequence)("Java source dirs: " + IterableExtensions.join(this.javaSourceRoots, (CharSequence)", ")));
            this.getLog().debug((CharSequence)("Classpath entries: " + IterableExtensions.join((Iterable)this.getClasspathElements(), (CharSequence)", ")));
        }
    }
}

