/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.validation;

import com.regnosys.rosetta.rosetta.ExternalValueOperator;
import com.regnosys.rosetta.rosetta.RosettaExternalClass;
import com.regnosys.rosetta.rosetta.RosettaExternalRegularAttribute;
import com.regnosys.rosetta.rosetta.RosettaExternalRuleSource;
import com.regnosys.rosetta.rosetta.RosettaPackage;
import com.regnosys.rosetta.rosetta.RosettaReport;
import com.regnosys.rosetta.rosetta.RosettaRule;
import com.regnosys.rosetta.rosetta.simple.Data;
import com.regnosys.rosetta.rosetta.simple.SimplePackage;
import com.regnosys.rosetta.types.RAttribute;
import com.regnosys.rosetta.types.RChoiceType;
import com.regnosys.rosetta.types.RDataType;
import com.regnosys.rosetta.types.RObjectFactory;
import com.regnosys.rosetta.types.RType;
import com.regnosys.rosetta.types.TypeSystem;
import com.regnosys.rosetta.types.builtin.RBuiltinTypeService;
import com.regnosys.rosetta.utils.ExternalAnnotationUtil;
import com.regnosys.rosetta.validation.AbstractDeclarativeRosettaValidator;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.validation.Check;

public class ReportValidator
extends AbstractDeclarativeRosettaValidator {
    @Inject
    private TypeSystem ts;
    @Inject
    private RBuiltinTypeService builtins;
    @Inject
    private ExternalAnnotationUtil annotationUtil;
    @Inject
    private RObjectFactory objectFactory;

    @Check
    public void checkReport(RosettaReport report) {
        RType inputType = this.ts.typeCallToRType(report.getInputType());
        EList<RosettaRule> eligibilityRules = report.getEligibilityRules();
        for (int i = 0; i < eligibilityRules.size(); ++i) {
            RType ruleInputType;
            RosettaRule eligibilityRule = (RosettaRule)eligibilityRules.get(i);
            if (!eligibilityRule.isEligibility()) {
                this.error("Rule " + eligibilityRule.getName() + " is not an eligibility rule.", report, (EStructuralFeature)RosettaPackage.Literals.ROSETTA_REPORT__ELIGIBILITY_RULES, i);
            }
            if (this.ts.isSubtypeOf(ruleInputType = this.ts.typeCallToRType(eligibilityRule.getInput()), inputType)) continue;
            this.error("Eligibility rule " + eligibilityRule.getName() + " expects a `" + ruleInputType + "` as input, but this report is generated from a `" + inputType + "`.", report, (EStructuralFeature)RosettaPackage.Literals.ROSETTA_REPORT__ELIGIBILITY_RULES, i);
        }
        RType reportTypeInputType = this.ts.getRulesInputType(this.objectFactory.buildRDataType(report.getReportType()), Optional.ofNullable(report.getRuleSource()));
        if (reportTypeInputType != this.builtins.ANY && !this.ts.isSubtypeOf(reportTypeInputType, inputType)) {
            if (report.getRuleSource() != null) {
                this.error("Rule source " + report.getRuleSource().getName() + " expects a `" + reportTypeInputType + "` as input, but this report is generated from a `" + inputType + "`.", report, (EStructuralFeature)RosettaPackage.Literals.ROSETTA_REPORT__RULE_SOURCE);
            } else {
                this.error("Report type " + report.getReportType().getName() + " expects a `" + reportTypeInputType + "` as input, but this report is generated from a `" + inputType + "`.", report, (EStructuralFeature)RosettaPackage.Literals.ROSETTA_REPORT__REPORT_TYPE);
            }
        }
    }

    @Check
    public void checkReportType(Data data) {
        RType current;
        RDataType rData = this.objectFactory.buildRDataType(data);
        RType superType = this.ts.stripFromTypeAliases(rData.getSuperType());
        if (superType != null) {
            current = this.ts.getRulesInputType((RDataType)superType, Optional.empty());
            if (current.equals(this.builtins.NOTHING)) {
                return;
            }
        } else {
            current = this.builtins.ANY;
        }
        for (RAttribute attr : rData.getOwnAttributes()) {
            RDataType attrData;
            RType inputType;
            RosettaRule rule = attr.getRuleReference();
            if (rule != null) {
                RType inputType2 = this.ts.typeCallToRType(rule.getInput());
                RType newCurrent = this.ts.meet(current, inputType2);
                if (newCurrent.equals(this.builtins.NOTHING)) {
                    this.error("Rule `" + rule.getName() + "` expects an input of type `" + inputType2 + "`, while previous rules expect an input of type `" + current + "`.", attr.getEObject().getRuleReference(), (EStructuralFeature)SimplePackage.Literals.ROSETTA_RULE_REFERENCE__REPORTING_RULE);
                    continue;
                }
                current = newCurrent;
                continue;
            }
            RType attrType = this.ts.stripFromTypeAliases(attr.getRMetaAnnotatedType().getRType());
            if (attrType instanceof RChoiceType) {
                attrType = ((RChoiceType)attrType).asRDataType();
            }
            if (!(attrType instanceof RDataType) || (inputType = this.ts.getRulesInputType(attrData = (RDataType)attrType, Optional.empty())).equals(this.builtins.NOTHING)) continue;
            RType newCurrent = this.ts.meet(current, inputType);
            if (newCurrent.equals(this.builtins.NOTHING)) {
                this.error("Attribute `" + attr.getName() + "` contains rules that expect an input of type `" + inputType + "`, while previous rules expect an input of type `" + current + "`.", attr.getEObject(), null);
                continue;
            }
            current = newCurrent;
        }
    }

    @Check
    public void checkExternalRuleSource(RosettaExternalRuleSource source) {
        for (RosettaExternalClass externalClass : source.getExternalClasses()) {
            RDataType data = this.objectFactory.buildRDataType(externalClass.getData());
            Map<RAttribute, RosettaRule> ruleReferences = this.annotationUtil.getAllRuleReferencesForType(Optional.of(source), data);
            RType current = this.builtins.ANY;
            for (RAttribute attr : data.getOwnAttributes()) {
                RDataType attrData;
                RType inputType;
                Optional<RosettaExternalRegularAttribute> maybeExtAttr = externalClass.getRegularAttributes().stream().filter(ext -> ext.getOperator() == ExternalValueOperator.PLUS).filter(ext -> ext.getAttributeRef().equals(attr.getEObject())).findAny();
                RosettaRule rule = ruleReferences.get(attr);
                if (rule != null) {
                    RType inputType2 = this.ts.typeCallToRType(rule.getInput());
                    RType newCurrent = this.ts.meet(current, inputType2);
                    if (newCurrent.equals(this.builtins.NOTHING)) {
                        if (!maybeExtAttr.isPresent()) continue;
                        RosettaExternalRegularAttribute extAttr = maybeExtAttr.get();
                        this.error("Attribute `" + attr.getName() + "` has a rule that expects an input of type `" + inputType2 + "`, while other rules expect an input of type `" + current + "`.", extAttr, (EStructuralFeature)RosettaPackage.Literals.ROSETTA_EXTERNAL_REGULAR_ATTRIBUTE__ATTRIBUTE_REF);
                        continue;
                    }
                    current = newCurrent;
                    continue;
                }
                RType attrType = this.ts.stripFromTypeAliases(attr.getRMetaAnnotatedType().getRType());
                if (attrType instanceof RChoiceType) {
                    attrType = ((RChoiceType)attrType).asRDataType();
                }
                if (!(attrType instanceof RDataType) || (inputType = this.ts.getRulesInputType(attrData = (RDataType)attrType, Optional.of(source))).equals(this.builtins.NOTHING)) continue;
                RType newCurrent = this.ts.meet(current, inputType);
                if (newCurrent.equals(this.builtins.NOTHING)) {
                    if (maybeExtAttr.isPresent()) {
                        RosettaExternalRegularAttribute extAttr = maybeExtAttr.get();
                        this.error("Attribute `" + attr.getName() + "` contains rules that expect an input of type `" + inputType + "`, while other rules expect an input of type `" + current + "`.", extAttr, (EStructuralFeature)RosettaPackage.Literals.ROSETTA_EXTERNAL_REGULAR_ATTRIBUTE__ATTRIBUTE_REF);
                        continue;
                    }
                    this.error("Attribute `" + attr.getName() + "` contains rules that expect an input of type `" + inputType + "`, while other rules expect an input of type `" + current + "`.", externalClass, (EStructuralFeature)RosettaPackage.Literals.ROSETTA_EXTERNAL_CLASS__DATA);
                    continue;
                }
                current = newCurrent;
            }
        }
    }
}

