/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.validation;

import com.regnosys.rosetta.RosettaEcoreUtil;
import com.regnosys.rosetta.rosetta.RosettaCardinality;
import com.regnosys.rosetta.rosetta.RosettaPackage;
import com.regnosys.rosetta.rosetta.RosettaRule;
import com.regnosys.rosetta.rosetta.simple.Annotation;
import com.regnosys.rosetta.rosetta.simple.Attribute;
import com.regnosys.rosetta.rosetta.simple.ChoiceOption;
import com.regnosys.rosetta.rosetta.simple.Data;
import com.regnosys.rosetta.rosetta.simple.SimplePackage;
import com.regnosys.rosetta.types.RAttribute;
import com.regnosys.rosetta.types.RChoiceType;
import com.regnosys.rosetta.types.RDataType;
import com.regnosys.rosetta.types.RFunction;
import com.regnosys.rosetta.types.RMetaAnnotatedType;
import com.regnosys.rosetta.types.RObjectFactory;
import com.regnosys.rosetta.types.RType;
import com.regnosys.rosetta.types.RosettaTypeProvider;
import com.regnosys.rosetta.types.TypeSystem;
import com.regnosys.rosetta.validation.AbstractDeclarativeRosettaValidator;
import javax.inject.Inject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.validation.Check;

public class AttributeValidator
extends AbstractDeclarativeRosettaValidator {
    @Inject
    private RObjectFactory rObjectFactory;
    @Inject
    private RosettaTypeProvider typeProvider;
    @Inject
    private RosettaEcoreUtil ecoreUtil;
    @Inject
    private TypeSystem typeSystem;

    @Check
    public void checkAttributeNameStartsWithLowerCase(Attribute attribute) {
        if (!(attribute instanceof ChoiceOption) && !(attribute.eContainer() instanceof Annotation) && Character.isUpperCase(attribute.getName().charAt(0))) {
            this.warning("Attribute name should start with a lower case", attribute, (EStructuralFeature)RosettaPackage.Literals.ROSETTA_NAMED__NAME, "RosettaIssueCodes.invalidCase", new String[0]);
        }
    }

    @Check
    public void checkAttribute(Attribute ele) {
        RType attrType = this.typeProvider.getRTypeOfSymbol(ele).getRType();
        if (attrType instanceof RChoiceType) {
            attrType = ((RChoiceType)attrType).asRDataType();
        }
        if (attrType instanceof RDataType) {
            RDataType attrDataType = (RDataType)attrType;
            if (this.ecoreUtil.hasReferenceAnnotation(ele) && !attrDataType.hasMetaAttribute("key") && !attrDataType.getAllSuperTypes().stream().anyMatch(st -> st.hasMetaAttribute("key"))) {
                this.warning(attrDataType.getName() + " must be annotated with [metadata key] as reference annotation is used", ele, (EStructuralFeature)RosettaPackage.Literals.ROSETTA_TYPED__TYPE_CALL);
            }
        }
    }

    @Check
    public void checkAttributeOverride(Attribute attr) {
        if (attr.isOverride()) {
            EObject container = attr.eContainer();
            if (!(container instanceof Data)) {
                this.error("You can only override the attribute of a type", attr, (EStructuralFeature)SimplePackage.Literals.ATTRIBUTE__OVERRIDE);
            } else {
                RAttribute attribute = this.rObjectFactory.buildRAttribute(attr);
                RAttribute parentAttribute = attribute.getParentAttribute();
                if (parentAttribute != null) {
                    RosettaRule r;
                    this.checkDeprecatedAnnotation(parentAttribute.getEObject(), attr, (EStructuralFeature)RosettaPackage.Literals.ROSETTA_NAMED__NAME, -1);
                    RMetaAnnotatedType overriddenType = attribute.getRMetaAnnotatedType();
                    RMetaAnnotatedType parentAttrType = parentAttribute.getRMetaAnnotatedType();
                    if (!this.typeSystem.isSubtypeOf(overriddenType, parentAttrType)) {
                        this.error("The overridden type should be a subtype of the parent type " + parentAttrType, attr, (EStructuralFeature)RosettaPackage.Literals.ROSETTA_TYPED__TYPE_CALL);
                    }
                    if (!parentAttribute.getCardinality().includes(attribute.getCardinality())) {
                        this.error("Cardinality may not be broader than the cardinality of the parent attribute " + parentAttribute.getCardinality(), attr, (EStructuralFeature)SimplePackage.Literals.ATTRIBUTE__CARD);
                    }
                    if (attr.getRuleReference() == null && (r = parentAttribute.getRuleReference()) != null) {
                        RFunction rule = this.rObjectFactory.buildRFunction(r);
                        RMetaAnnotatedType ruleType = rule.getOutput().getRMetaAnnotatedType();
                        if (!this.typeSystem.isSubtypeOf(ruleType, overriddenType)) {
                            this.error("The overridden type is incompatible with the inherited rule reference `" + r.getName() + "`. Either change the type or override the rule reference", attr, (EStructuralFeature)RosettaPackage.Literals.ROSETTA_TYPED__TYPE_CALL);
                        }
                        if (!attribute.isMulti() && rule.getOutput().isMulti()) {
                            this.error("Cardinality is incompatible with the inherited rule reference `" + r.getName() + "`. Either change the cardinality or override the rule reference", attr, (EStructuralFeature)SimplePackage.Literals.ATTRIBUTE__CARD);
                        }
                    }
                } else {
                    this.error("Attribute " + attr.getName() + " does not exist in supertype", attr, (EStructuralFeature)RosettaPackage.Literals.ROSETTA_NAMED__NAME);
                }
            }
        }
    }

    @Check
    public void checkCardinality(RosettaCardinality card) {
        if (!card.isUnbounded() && card.getInf() > card.getSup()) {
            this.error("The upper bound must be greater than the lower bound", card, null);
        }
    }
}

