/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.utils;

import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.Validate;

public abstract class Interval<T extends Comparable<? super T>> {
    private final Optional<T> min;
    private final Optional<T> max;

    public Interval(Optional<T> min, Optional<T> max) {
        if (min.isPresent() && max.isPresent()) {
            Validate.isTrue((((Comparable)min.get()).compareTo(max.get()) <= 0 ? 1 : 0) != 0, (String)("The minimum (" + min.get() + ") must be less than the maximum (" + max.get() + ")"), (Object[])new Object[0]);
        }
        this.min = min;
        this.max = max;
    }

    public Optional<T> getMin() {
        return this.min;
    }

    public Optional<T> getMax() {
        return this.max;
    }

    public boolean isUnbounded() {
        return this.min.isEmpty() && this.max.isEmpty();
    }

    public boolean isUnboundedLeft() {
        return this.min.isEmpty();
    }

    public boolean isUnboundedRight() {
        return this.max.isEmpty();
    }

    public boolean includes(T x) {
        if (this.min.map(b -> b.compareTo(x) > 0).orElse(false).booleanValue()) {
            return false;
        }
        return this.max.map(b -> b.compareTo(x) < 0).orElse(false) == false;
    }

    public boolean includes(Interval<T> other) {
        if (this.min.map(b -> other.min.map(ob -> b.compareTo(ob) > 0).orElse(true)).orElse(false).booleanValue()) {
            return false;
        }
        return this.max.map(b -> other.max.map(ob -> b.compareTo(ob) < 0).orElse(true)).orElse(false) == false;
    }

    public boolean strictlyIncludes(T x) {
        if (this.min.map(b -> b.compareTo(x) >= 0).orElse(false).booleanValue()) {
            return false;
        }
        return this.max.map(b -> b.compareTo(x) <= 0).orElse(false) == false;
    }

    public boolean strictlyIncludes(Interval<T> other) {
        if (this.min.map(b -> other.min.map(ob -> b.compareTo(ob) >= 0).orElse(true)).orElse(false).booleanValue()) {
            return false;
        }
        return this.max.map(b -> other.max.map(ob -> b.compareTo(ob) <= 0).orElse(true)).orElse(false) == false;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        this.min.ifPresentOrElse(b -> builder.append("[").append(b), () -> builder.append("]-inf"));
        builder.append(", ");
        this.max.ifPresentOrElse(b -> builder.append(b).append("]"), () -> builder.append("+inf["));
        return builder.toString();
    }

    public int hashCode() {
        return Objects.hash(this.min, this.max);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Interval other = (Interval)obj;
        return Objects.equals(this.max, other.max) && Objects.equals(this.min, other.min);
    }
}

