/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.utils;

import com.regnosys.rosetta.rosetta.RosettaRule;
import com.regnosys.rosetta.rosetta.expression.ExpressionFactory;
import com.regnosys.rosetta.rosetta.expression.InlineFunction;
import com.regnosys.rosetta.rosetta.expression.RosettaFunctionalOperation;
import com.regnosys.rosetta.rosetta.expression.RosettaImplicitVariable;
import com.regnosys.rosetta.rosetta.expression.SwitchCase;
import com.regnosys.rosetta.rosetta.simple.Data;
import java.util.Optional;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.EcoreUtil2;

public class ImplicitVariableUtil {
    public RosettaImplicitVariable getDefaultImplicitVariable() {
        RosettaImplicitVariable def = ExpressionFactory.eINSTANCE.createRosettaImplicitVariable();
        def.setName("item");
        def.setGenerated(true);
        return def;
    }

    public Optional<? extends EObject> findContainerDefiningImplicitVariable(EObject context) {
        Iterable containers = EcoreUtil2.getAllContainers((EObject)context);
        EObject prev = context;
        for (EObject container : containers) {
            if (container instanceof Data) {
                return Optional.of(container);
            }
            if (container instanceof RosettaFunctionalOperation) {
                RosettaFunctionalOperation op = (RosettaFunctionalOperation)container;
                InlineFunction f = op.getFunction();
                if (f != null && f.equals(prev) && f.getParameters().size() == 0) {
                    return Optional.of(container);
                }
            } else {
                SwitchCase c;
                if (container instanceof RosettaRule) {
                    return Optional.of(container);
                }
                if (container instanceof SwitchCase && (c = (SwitchCase)container).getGuard().getChoiceOptionGuard() != null) {
                    return Optional.of(container);
                }
            }
            prev = container;
        }
        return Optional.empty();
    }

    public boolean implicitVariableExistsInContext(EObject context) {
        return this.findContainerDefiningImplicitVariable(context).isPresent();
    }
}

