/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.utils;

import com.regnosys.rosetta.rosetta.ExternalAnnotationSource;
import com.regnosys.rosetta.rosetta.ExternalValueOperator;
import com.regnosys.rosetta.rosetta.RosettaEnumeration;
import com.regnosys.rosetta.rosetta.RosettaExternalClass;
import com.regnosys.rosetta.rosetta.RosettaExternalEnum;
import com.regnosys.rosetta.rosetta.RosettaExternalEnumValue;
import com.regnosys.rosetta.rosetta.RosettaExternalRegularAttribute;
import com.regnosys.rosetta.rosetta.RosettaExternalRuleSource;
import com.regnosys.rosetta.rosetta.RosettaExternalSynonymSource;
import com.regnosys.rosetta.rosetta.RosettaReport;
import com.regnosys.rosetta.rosetta.RosettaRule;
import com.regnosys.rosetta.rosetta.simple.Attribute;
import com.regnosys.rosetta.types.RAttribute;
import com.regnosys.rosetta.types.RChoiceType;
import com.regnosys.rosetta.types.RDataType;
import com.regnosys.rosetta.types.RObjectFactory;
import com.regnosys.rosetta.types.RType;
import com.rosetta.model.lib.path.RosettaPath;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;

public class ExternalAnnotationUtil {
    @Inject
    private RObjectFactory objectFactory;

    public List<ExternalAnnotationSource> getSuperSources(ExternalAnnotationSource source) {
        if (source instanceof RosettaExternalSynonymSource) {
            RosettaExternalSynonymSource synSource = (RosettaExternalSynonymSource)source;
            return synSource.getSuperSources().stream().filter(s -> s instanceof ExternalAnnotationSource).map(s -> (ExternalAnnotationSource)((Object)s)).collect(Collectors.toList());
        }
        if (source instanceof RosettaExternalRuleSource) {
            RosettaExternalRuleSource ruleSource = (RosettaExternalRuleSource)source;
            return ruleSource.getSuperSources();
        }
        return Collections.emptyList();
    }

    public Optional<RosettaExternalClass> getExternalType(ExternalAnnotationSource source, RDataType type) {
        for (RosettaExternalClass extT : source.getExternalClasses()) {
            if (!extT.getTypeRef().equals(type.getEObject())) continue;
            return Optional.of(extT);
        }
        return Optional.empty();
    }

    public Optional<RosettaExternalEnum> getExternalEnum(ExternalAnnotationSource source, RosettaEnumeration type) {
        for (RosettaExternalEnum extT : source.getExternalEnums()) {
            if (!extT.getTypeRef().equals(type)) continue;
            return Optional.of(extT);
        }
        return Optional.empty();
    }

    public Set<RosettaExternalClass> getAllExternalTypes(ExternalAnnotationSource source, RDataType type) {
        HashSet<RosettaExternalClass> result = new HashSet<RosettaExternalClass>();
        this.getSuperSources(source).stream().map(s -> this.getAllExternalTypes((ExternalAnnotationSource)s, type)).forEach(s -> result.addAll((Collection<RosettaExternalClass>)s));
        this.getExternalType(source, type).ifPresent(extT -> result.add((RosettaExternalClass)extT));
        return result;
    }

    public Set<RosettaExternalEnum> getAllExternalEnums(ExternalAnnotationSource source, RosettaEnumeration type) {
        HashSet<RosettaExternalEnum> result = new HashSet<RosettaExternalEnum>();
        this.getSuperSources(source).stream().map(s -> this.getAllExternalEnums((ExternalAnnotationSource)s, type)).forEach(s -> result.addAll((Collection<RosettaExternalEnum>)s));
        this.getExternalEnum(source, type).ifPresent(extT -> result.add((RosettaExternalEnum)extT));
        return result;
    }

    public Set<RosettaExternalRegularAttribute> getAllExternalAttributesForType(ExternalAnnotationSource source, RDataType type) {
        HashSet<RosettaExternalRegularAttribute> result = new HashSet<RosettaExternalRegularAttribute>();
        this.getSuperSources(source).stream().map(s -> this.getAllExternalAttributesForType((ExternalAnnotationSource)s, type)).forEach(s -> result.addAll((Collection<RosettaExternalRegularAttribute>)s));
        this.getExternalType(source, type).ifPresent(extT -> {
            for (RosettaExternalRegularAttribute attr : extT.getRegularAttributes()) {
                if (attr.getOperator().equals((Object)ExternalValueOperator.MINUS)) {
                    result.removeIf(a -> a.getAttributeRef().equals(attr.getAttributeRef()));
                    continue;
                }
                result.add(attr);
            }
        });
        return result;
    }

    public Set<RosettaExternalEnumValue> getAllExternalEnumValuesForType(ExternalAnnotationSource source, RosettaEnumeration type) {
        HashSet<RosettaExternalEnumValue> result = new HashSet<RosettaExternalEnumValue>();
        this.getSuperSources(source).stream().map(s -> this.getAllExternalEnumValuesForType((ExternalAnnotationSource)s, type)).forEach(s -> result.addAll((Collection<RosettaExternalEnumValue>)s));
        this.getExternalEnum(source, type).ifPresent(extT -> {
            for (RosettaExternalEnumValue val : extT.getRegularValues()) {
                if (val.getOperator().equals((Object)ExternalValueOperator.MINUS)) {
                    result.removeIf(a -> a.getEnumRef().equals(val.getEnumRef()));
                    continue;
                }
                result.add(val);
            }
        });
        return result;
    }

    public Map<RAttribute, RosettaRule> getAllRuleReferencesForType(Optional<? extends ExternalAnnotationSource> maybeSource, RDataType type) {
        CollectRuleVisitor.Default visitor = new CollectRuleVisitor.Default(this.objectFactory);
        this.collectAllRuleReferencesForType(maybeSource, type, visitor);
        return visitor.getMap();
    }

    public <T extends CollectRuleVisitor> T collectAllRuleReferencesForType(Optional<? extends ExternalAnnotationSource> maybeSource, RDataType type, T visitor) {
        type.getAllAttributes().forEach(attr -> Optional.ofNullable(attr.getRuleReference()).ifPresent(rule -> visitor.add((RAttribute)attr, (RosettaRule)rule)));
        maybeSource.ifPresent(source -> {
            List<ExternalAnnotationSource> superSources = this.getSuperSources((ExternalAnnotationSource)source);
            Collections.reverse(superSources);
            superSources.forEach(s -> this.collectExternalRuleReferencesForType((ExternalAnnotationSource)s, type, visitor));
            this.collectExternalRuleReferencesForType((ExternalAnnotationSource)source, type, visitor);
        });
        return visitor;
    }

    private void collectExternalRuleReferencesForType(ExternalAnnotationSource source, RDataType type, CollectRuleVisitor visitor) {
        this.getExternalType(source, type).ifPresent(extT -> {
            for (RosettaExternalRegularAttribute extAttr : extT.getRegularAttributes()) {
                if (extAttr.getOperator().equals((Object)ExternalValueOperator.MINUS)) {
                    visitor.remove(extAttr);
                    continue;
                }
                if (extAttr.getExternalRuleReference() == null) continue;
                visitor.add(extAttr, extAttr.getExternalRuleReference().getReportingRule());
            }
        });
    }

    public Map<PathAttribute, RosettaRule> getAllReportingRules(RosettaReport report) {
        return this.getAllReportingRules(this.objectFactory.buildRDataType(report.getReportType()), Optional.ofNullable(report.getRuleSource()));
    }

    public Map<PathAttribute, RosettaRule> getAllReportingRules(RDataType type, Optional<RosettaExternalRuleSource> ruleSource) {
        HashMap<PathAttribute, RosettaRule> rules = new HashMap<PathAttribute, RosettaRule>();
        RosettaPath path = RosettaPath.valueOf((String)type.getName());
        this.collectReportingRules(type, path, ruleSource, rules, new HashSet<RDataType>());
        return rules;
    }

    private void collectReportingRules(RDataType dataType, RosettaPath path, Optional<RosettaExternalRuleSource> ruleSource, Map<PathAttribute, RosettaRule> visitor, Set<RDataType> collectedTypes) {
        Map<RAttribute, RosettaRule> attrRules = this.getAllRuleReferencesForType(ruleSource, dataType);
        dataType.getAllAttributes().forEach(attr -> {
            RType attrType = attr.getRMetaAnnotatedType().getRType();
            if (attrType instanceof RChoiceType) {
                attrType = ((RChoiceType)attrType).asRDataType();
            }
            RosettaRule rule = (RosettaRule)attrRules.get(attr);
            if (!(attrType instanceof RDataType)) {
                if (rule != null) {
                    visitor.put(new PathAttribute(path, (RAttribute)attr), rule);
                }
            } else {
                RDataType attrDataType;
                if (rule != null) {
                    visitor.put(new PathAttribute(path, (RAttribute)attr), rule);
                }
                if (collectedTypes.add(attrDataType = (RDataType)attrType)) {
                    RosettaPath subPath = attr.isMulti() ? path.newSubPath(attr.getName(), 0) : path.newSubPath(attr.getName());
                    this.collectReportingRules(attrDataType, subPath, ruleSource, visitor, collectedTypes);
                }
            }
        });
    }

    public static interface CollectRuleVisitor {
        public void add(RAttribute var1, RosettaRule var2);

        public void add(RosettaExternalRegularAttribute var1, RosettaRule var2);

        public void remove(RosettaExternalRegularAttribute var1);

        public static class Default
        implements CollectRuleVisitor {
            private final RObjectFactory objectFactory;
            private final Map<RAttribute, RosettaRule> map = new HashMap<RAttribute, RosettaRule>();

            public Default(RObjectFactory objectFactory) {
                this.objectFactory = objectFactory;
            }

            @Override
            public void add(RAttribute attr, RosettaRule rule) {
                this.map.put(attr, rule);
            }

            @Override
            public void add(RosettaExternalRegularAttribute extAttr, RosettaRule rule) {
                this.map.put(this.objectFactory.buildRAttribute((Attribute)extAttr.getAttributeRef()), rule);
            }

            @Override
            public void remove(RosettaExternalRegularAttribute extAttr) {
                this.map.remove(this.objectFactory.buildRAttribute((Attribute)extAttr.getAttributeRef()));
            }

            public Map<RAttribute, RosettaRule> getMap() {
                return this.map;
            }
        }
    }

    public static class PathAttribute {
        private final RosettaPath path;
        private final RAttribute attr;

        public PathAttribute(RosettaPath path, RAttribute attr) {
            this.path = path;
            this.attr = attr;
        }

        public RosettaPath getPath() {
            return this.path;
        }

        public RAttribute getAttr() {
            return this.attr;
        }

        public int hashCode() {
            return Objects.hash(this.attr, this.path);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PathAttribute other = (PathAttribute)obj;
            return Objects.equals(this.attr, other.attr) && Objects.equals(this.path, other.path);
        }
    }
}

