/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.types;

import com.regnosys.rosetta.cache.IRequestScopedCache;
import com.regnosys.rosetta.interpreter.RosettaInterpreter;
import com.regnosys.rosetta.interpreter.RosettaInterpreterContext;
import com.regnosys.rosetta.interpreter.RosettaValue;
import com.regnosys.rosetta.rosetta.RosettaBuiltinType;
import com.regnosys.rosetta.rosetta.RosettaEnumeration;
import com.regnosys.rosetta.rosetta.RosettaExternalRuleSource;
import com.regnosys.rosetta.rosetta.RosettaMetaType;
import com.regnosys.rosetta.rosetta.RosettaRule;
import com.regnosys.rosetta.rosetta.RosettaType;
import com.regnosys.rosetta.rosetta.RosettaTypeAlias;
import com.regnosys.rosetta.rosetta.TypeCall;
import com.regnosys.rosetta.rosetta.expression.ExpressionFactory;
import com.regnosys.rosetta.rosetta.expression.RosettaSymbolReference;
import com.regnosys.rosetta.rosetta.simple.Choice;
import com.regnosys.rosetta.rosetta.simple.Data;
import com.regnosys.rosetta.types.RAliasType;
import com.regnosys.rosetta.types.RAttribute;
import com.regnosys.rosetta.types.RChoiceType;
import com.regnosys.rosetta.types.RDataType;
import com.regnosys.rosetta.types.RMetaAnnotatedType;
import com.regnosys.rosetta.types.RObjectFactory;
import com.regnosys.rosetta.types.RParametrizedType;
import com.regnosys.rosetta.types.RType;
import com.regnosys.rosetta.types.RTypeFunction;
import com.regnosys.rosetta.types.SubtypeRelation;
import com.regnosys.rosetta.types.builtin.RBuiltinTypeService;
import com.regnosys.rosetta.utils.ExternalAnnotationUtil;
import com.regnosys.rosetta.utils.ModelIdProvider;
import com.regnosys.rosetta.utils.RosettaSimpleSystemSolver;
import com.rosetta.model.lib.ModelSymbolId;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Provider;
import org.apache.commons.lang3.Validate;
import org.eclipse.xtext.xbase.lib.Pair;

public class TypeSystem {
    public static String RULE_INPUT_TYPE_CACHE_KEY = TypeSystem.class.getCanonicalName() + ".RULE_INPUT_TYPE";
    @Inject
    private RObjectFactory factory;
    @Inject
    private RBuiltinTypeService builtins;
    @Inject
    private ExternalAnnotationUtil annotationUtil;
    @Inject
    private IRequestScopedCache cache;
    @Inject
    private SubtypeRelation subtypeRelation;
    @Inject
    private RosettaInterpreter interpreter;
    @Inject
    private RosettaSimpleSystemSolver systemSolver;
    @Inject
    private ModelIdProvider modelIdProvider;

    public RType getRulesInputType(RDataType data, Optional<RosettaExternalRuleSource> source) {
        return this.getRulesInputType(data, source, new HashSet<RDataType>());
    }

    private RType getRulesInputType(RDataType data, Optional<RosettaExternalRuleSource> source, Set<RDataType> visited) {
        Objects.requireNonNull(data);
        return this.getRulesInputTypeFromCache(data, source, (Provider<RType>)((Provider)() -> {
            if (!visited.add(data)) {
                return this.builtins.ANY;
            }
            Map<RAttribute, RosettaRule> ruleReferences = this.annotationUtil.getAllRuleReferencesForType(source, data);
            RType result = this.builtins.ANY;
            for (RAttribute attr : data.getOwnAttributes()) {
                RosettaRule rule = ruleReferences.get(attr);
                if (rule != null) {
                    RType inputType = this.typeCallToRType(rule.getInput());
                    result = this.meet(result, inputType);
                    continue;
                }
                RType attrType = this.stripFromTypeAliases(attr.getRMetaAnnotatedType().getRType());
                if (attrType instanceof RChoiceType) {
                    attrType = ((RChoiceType)attrType).asRDataType();
                }
                if (!(attrType instanceof RDataType)) continue;
                RDataType attrData = (RDataType)attrType;
                RType inputType = this.getRulesInputType(attrData, source, visited);
                result = this.meet(result, inputType);
            }
            return result;
        }));
    }

    private RType getRulesInputTypeFromCache(RDataType data, Optional<RosettaExternalRuleSource> source, Provider<RType> typeProvider) {
        return this.cache.get(new Pair((Object)RULE_INPUT_TYPE_CACHE_KEY, (Object)new Pair((Object)data, source)), typeProvider);
    }

    public RMetaAnnotatedType joinMetaAnnotatedTypes(RMetaAnnotatedType t1, RMetaAnnotatedType t2) {
        Objects.requireNonNull(t1);
        Objects.requireNonNull(t2);
        return this.subtypeRelation.join(t1, t2);
    }

    public RMetaAnnotatedType joinMetaAnnotatedTypes(Iterable<RMetaAnnotatedType> types) {
        Objects.requireNonNull(types);
        Validate.noNullElements(types);
        RMetaAnnotatedType acc = this.builtins.NOTHING_WITH_NO_META;
        for (RMetaAnnotatedType t : types) {
            if (!(acc = this.subtypeRelation.join(acc, t)).equals(this.builtins.ANY_WITH_NO_META)) continue;
            return acc;
        }
        return acc;
    }

    public RType join(RType t1, RType t2) {
        Objects.requireNonNull(t1);
        Objects.requireNonNull(t2);
        return this.subtypeRelation.join(t1, t2);
    }

    public RType join(Iterable<RType> types) {
        Objects.requireNonNull(types);
        Validate.noNullElements(types);
        RType acc = this.builtins.NOTHING;
        for (RType t : types) {
            if (!(acc = this.subtypeRelation.join(acc, t)).equals(this.builtins.ANY)) continue;
            return acc;
        }
        return acc;
    }

    public RType meet(RType t1, RType t2) {
        Objects.requireNonNull(t1);
        Objects.requireNonNull(t2);
        if (this.isSubtypeOf(t1, t2)) {
            return t1;
        }
        if (this.isSubtypeOf(t2, t1)) {
            return t2;
        }
        return this.builtins.NOTHING;
    }

    public RType meet(Iterable<RType> types) {
        Objects.requireNonNull(types);
        Validate.noNullElements(types);
        RType acc = this.builtins.ANY;
        for (RType t : types) {
            if (!(acc = this.meet(acc, t)).equals(this.builtins.NOTHING)) continue;
            return acc;
        }
        return acc;
    }

    public boolean isSubtypeOf(RMetaAnnotatedType sub, RMetaAnnotatedType sup) {
        return this.isSubtypeOf(sub, sup, true);
    }

    public boolean isSubtypeOf(RMetaAnnotatedType sub, RMetaAnnotatedType sup, boolean treatChoiceTypeAsData) {
        Objects.requireNonNull(sub);
        Objects.requireNonNull(sup);
        return this.subtypeRelation.isSubtypeOf(sub, sup, treatChoiceTypeAsData);
    }

    public boolean isSubtypeOf(RType sub, RType sup) {
        return this.isSubtypeOf(sub, sup, true);
    }

    public boolean isSubtypeOf(RType sub, RType sup, boolean treatChoiceTypeAsData) {
        Objects.requireNonNull(sub);
        Objects.requireNonNull(sup);
        return this.subtypeRelation.isSubtypeOf(sub, sup, treatChoiceTypeAsData);
    }

    public boolean isComparable(RMetaAnnotatedType t1, RMetaAnnotatedType t2) {
        Objects.requireNonNull(t1);
        Objects.requireNonNull(t2);
        return this.isSubtypeOf(t1, t2) || this.isSubtypeOf(t2, t1);
    }

    public RType typeCallToRType(TypeCall typeCall) {
        return this.typeCallToRType(typeCall, new RosettaInterpreterContext());
    }

    public RType typeCallToRType(TypeCall typeCall, RosettaInterpreterContext context) {
        Objects.requireNonNull(typeCall);
        Objects.requireNonNull(context);
        RosettaType t = typeCall.getType();
        if (t instanceof Choice) {
            return this.factory.buildRChoiceType((Choice)t);
        }
        if (t instanceof Data) {
            return this.factory.buildRDataType((Data)t);
        }
        if (t instanceof RosettaEnumeration) {
            return this.factory.buildREnumType((RosettaEnumeration)t);
        }
        if (t instanceof RosettaBuiltinType) {
            Map<String, RosettaValue> argMap = typeCall.getArguments().stream().collect(Collectors.toMap(arg -> arg.getParameter().getName(), arg -> this.interpreter.interpret(arg.getValue(), context)));
            return this.builtins.getType(t, argMap).orElse(this.builtins.NOTHING);
        }
        if (t instanceof RosettaMetaType) {
            Map<String, RosettaValue> argMap = typeCall.getArguments().stream().collect(Collectors.toMap(arg -> arg.getParameter().getName(), arg -> this.interpreter.interpret(arg.getValue(), context)));
            return this.builtins.getType(t, argMap).orElseGet(() -> this.typeCallToRType(((RosettaMetaType)((Object)t)).getTypeCall(), context));
        }
        if (t instanceof RosettaTypeAlias) {
            RosettaTypeAlias alias = (RosettaTypeAlias)t;
            LinkedHashMap<String, RosettaValue> args = new LinkedHashMap<String, RosettaValue>();
            HashSet absentParameters = new HashSet(((RosettaTypeAlias)t).getParameters());
            typeCall.getArguments().forEach(arg -> {
                RosettaValue eval = this.interpreter.interpret(arg.getValue(), context);
                args.put(arg.getParameter().getName(), eval);
                absentParameters.remove(arg.getParameter());
            });
            absentParameters.forEach(p -> args.put(p.getName(), RosettaValue.empty()));
            RType refersTo = this.typeCallToRType(alias.getTypeCall(), RosettaInterpreterContext.of(args));
            return new RAliasType(this.typeFunctionOfTypeAlias(alias), args, refersTo);
        }
        return this.builtins.NOTHING;
    }

    private RTypeFunction typeFunctionOfTypeAlias(final RosettaTypeAlias typeAlias) {
        if (typeAlias.getName().equals(this.builtins.INT_NAME)) {
            return this.builtins.INT_FUNCTION;
        }
        ModelSymbolId symbolId = this.modelIdProvider.getSymbolId(typeAlias);
        List<RosettaSimpleSystemSolver.Equation> equations = typeAlias.getTypeCall().getArguments().stream().map(arg -> {
            RosettaSymbolReference ref = ExpressionFactory.eINSTANCE.createRosettaSymbolReference();
            ref.setGenerated(true);
            ref.setSymbol(arg.getParameter());
            return new RosettaSimpleSystemSolver.Equation(ref, arg.getValue());
        }).collect(Collectors.toList());
        return this.systemSolver.solve(equations, new HashSet(typeAlias.getParameters())).map(solutionSet -> new RTypeFunction(symbolId.getNamespace(), symbolId.getName(), (RosettaSimpleSystemSolver.SolutionSet)solutionSet){
            final /* synthetic */ RosettaSimpleSystemSolver.SolutionSet val$solutionSet;
            {
                this.val$solutionSet = solutionSet;
                super(namespace, name);
            }

            @Override
            public RType evaluate(Map<String, RosettaValue> arguments) {
                return TypeSystem.this.typeCallToRType(typeAlias.getTypeCall(), RosettaInterpreterContext.of(arguments));
            }

            @Override
            public Optional<LinkedHashMap<String, RosettaValue>> reverse(RType type) {
                if (!(type instanceof RParametrizedType)) {
                    return Optional.empty();
                }
                RosettaInterpreterContext context = RosettaInterpreterContext.of(((RParametrizedType)type).getArguments());
                return this.val$solutionSet.getSolution(context).map(solution -> {
                    LinkedHashMap newArgs = new LinkedHashMap();
                    typeAlias.getParameters().forEach(p -> newArgs.put(p.getName(), (RosettaValue)solution.get(p)));
                    return newArgs;
                });
            }
        }).orElseGet(() -> new RTypeFunction(symbolId.getNamespace(), symbolId.getName()){

            @Override
            public RType evaluate(Map<String, RosettaValue> arguments) {
                return TypeSystem.this.typeCallToRType(typeAlias.getTypeCall(), RosettaInterpreterContext.of(arguments));
            }
        });
    }

    public RType keepTypeAliasIfPossible(RType t1, RType t2, BiFunction<RType, RType, RType> combineUnderlyingTypes) {
        Objects.requireNonNull(t1);
        Objects.requireNonNull(t2);
        Objects.requireNonNull(combineUnderlyingTypes);
        if (t1 instanceof RAliasType && t2 instanceof RAliasType) {
            RAliasType alias1 = (RAliasType)t1;
            RAliasType alias2 = (RAliasType)t2;
            if (alias1.getTypeFunction().equals((Object)alias2.getTypeFunction())) {
                RTypeFunction typeFunc = alias1.getTypeFunction();
                RType underlier = this.keepTypeAliasIfPossible(alias1.getRefersTo(), alias2.getRefersTo(), combineUnderlyingTypes);
                return typeFunc.reverse(underlier).map(args -> new RAliasType(typeFunc, (LinkedHashMap<String, RosettaValue>)args, underlier)).orElse(underlier);
            }
            ArrayList<RAliasType> superAliases = new ArrayList<RAliasType>();
            RAliasType curr = alias1;
            superAliases.add(curr);
            while (curr.getRefersTo() instanceof RAliasType) {
                curr = (RAliasType)curr.getRefersTo();
                superAliases.add(curr);
            }
            curr = alias2;
            RTypeFunction tf1 = curr.getTypeFunction();
            Optional<RAliasType> match = superAliases.stream().filter(a -> tf1.equals((Object)a.getTypeFunction())).findFirst();
            if (match.isPresent()) {
                return this.keepTypeAliasIfPossible(match.get(), curr, combineUnderlyingTypes);
            }
            while (curr.getRefersTo() instanceof RAliasType) {
                curr = (RAliasType)curr.getRefersTo();
                RTypeFunction tf2 = curr.getTypeFunction();
                match = superAliases.stream().filter(a -> tf2.equals((Object)a.getTypeFunction())).findFirst();
                if (!match.isPresent()) continue;
                return this.keepTypeAliasIfPossible(match.get(), curr, combineUnderlyingTypes);
            }
            return this.keepTypeAliasIfPossible(alias1.getRefersTo(), alias2.getRefersTo(), combineUnderlyingTypes);
        }
        if (t1 instanceof RAliasType) {
            return this.keepTypeAliasIfPossible(((RAliasType)t1).getRefersTo(), t2, combineUnderlyingTypes);
        }
        if (t2 instanceof RAliasType) {
            return this.keepTypeAliasIfPossible(t1, ((RAliasType)t2).getRefersTo(), combineUnderlyingTypes);
        }
        return combineUnderlyingTypes.apply(t1, t2);
    }

    public RType stripFromTypeAliases(RType t) {
        while (t instanceof RAliasType) {
            t = ((RAliasType)t).getRefersTo();
        }
        return t;
    }
}

