/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.types;

import com.google.common.collect.Sets;
import com.regnosys.rosetta.interpreter.RosettaValue;
import com.regnosys.rosetta.types.RAliasType;
import com.regnosys.rosetta.types.RChoiceType;
import com.regnosys.rosetta.types.RDataType;
import com.regnosys.rosetta.types.RMetaAnnotatedType;
import com.regnosys.rosetta.types.RMetaAttribute;
import com.regnosys.rosetta.types.RType;
import com.regnosys.rosetta.types.RTypeFunction;
import com.regnosys.rosetta.types.builtin.RBuiltinTypeService;
import com.regnosys.rosetta.types.builtin.RNumberType;
import com.regnosys.rosetta.types.builtin.RStringType;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.Stack;
import javax.inject.Inject;

public class SubtypeRelation {
    @Inject
    private RBuiltinTypeService builtins;

    public boolean isSubtypeOf(RMetaAnnotatedType t1, RMetaAnnotatedType t2, boolean treatChoiceTypesAsDataTypes) {
        if (t1.equals(t2)) {
            return true;
        }
        return this.isSubtypeOf(t1.getRType(), t2.getRType(), treatChoiceTypesAsDataTypes);
    }

    public boolean isSubtypeOf(RType t1, RType t2, boolean treatChoiceTypesAsDataTypes) {
        if (t1.equals(t2)) {
            return true;
        }
        return this.isSubtypeOf(t1, t2, treatChoiceTypesAsDataTypes, null);
    }

    public boolean isSubtypeOf(RType t1, RType t2, boolean treatChoiceTypesAsDataTypes, Stack<RType> visited) {
        if (treatChoiceTypesAsDataTypes) {
            if (t1 instanceof RChoiceType) {
                t1 = ((RChoiceType)t1).asRDataType();
            }
            if (t2 instanceof RChoiceType) {
                t2 = ((RChoiceType)t2).asRDataType();
            }
        }
        if (t1.equals(t2)) {
            return true;
        }
        if (t1.equals(this.builtins.NOTHING) || t2.equals(this.builtins.ANY)) {
            return true;
        }
        if (t1 instanceof RNumberType && t2 instanceof RNumberType) {
            return true;
        }
        if (t1 instanceof RStringType && t2 instanceof RStringType) {
            return true;
        }
        if (t1 instanceof RChoiceType) {
            RType t1_ = t1;
            RType t2_ = t2;
            return ((RChoiceType)t1).getOwnOptions().stream().allMatch(t -> this.safeIsSubtypeOf(t.getType().getRType(), t2_, false, t1_, visited));
        }
        if (t2 instanceof RChoiceType) {
            RType t1_ = t1;
            RType t2_ = t2;
            return ((RChoiceType)t2).getOwnOptions().stream().anyMatch(t -> this.safeIsSubtypeOf(t1_, t.getType().getRType(), false, t2_, visited));
        }
        if (t1 instanceof RDataType) {
            RDataType st = ((RDataType)t1).getSuperType();
            if (st == null) {
                return false;
            }
            return this.safeIsSubtypeOf(st, t2, treatChoiceTypesAsDataTypes, t1, visited);
        }
        if (t1 instanceof RAliasType) {
            return this.safeIsSubtypeOf(((RAliasType)t1).getRefersTo(), t2, treatChoiceTypesAsDataTypes, t1, visited);
        }
        if (t2 instanceof RAliasType) {
            return this.safeIsSubtypeOf(t1, ((RAliasType)t2).getRefersTo(), treatChoiceTypesAsDataTypes, t2, visited);
        }
        return false;
    }

    private boolean safeIsSubtypeOf(RType t1, RType t2, boolean treatChoiceTypesAsDataTypes, RType currentlyVisited, Stack<RType> visited) {
        if (visited == null) {
            visited = new Stack();
        }
        if (visited.contains(currentlyVisited)) {
            return true;
        }
        visited.add(currentlyVisited);
        boolean result = this.isSubtypeOf(t1, t2, treatChoiceTypesAsDataTypes, visited);
        visited.pop();
        return result;
    }

    public RMetaAnnotatedType join(RMetaAnnotatedType t1, RMetaAnnotatedType t2) {
        RType t2RType;
        RType t1RType = t1.getRType();
        if (t1RType.equals(t2RType = t2.getRType())) {
            return RMetaAnnotatedType.withMeta(t1RType, this.intersectMeta(t1, t2));
        }
        return RMetaAnnotatedType.withNoMeta(this.join(t1RType, t2RType));
    }

    public RType join(RType t1, RType t2) {
        if (t1 instanceof RChoiceType) {
            t1 = ((RChoiceType)t1).asRDataType();
        }
        if (t2 instanceof RChoiceType) {
            t2 = ((RChoiceType)t2).asRDataType();
        }
        if (t1.equals(t2) || t2.equals(this.builtins.NOTHING)) {
            return t1;
        }
        if (t1.equals(this.builtins.NOTHING)) {
            return t2;
        }
        if (t1 instanceof RNumberType && t2 instanceof RNumberType) {
            return this.join((RNumberType)t1, (RNumberType)t2);
        }
        if (t1 instanceof RStringType && t2 instanceof RStringType) {
            return this.join((RStringType)t1, (RStringType)t2);
        }
        if (t1 instanceof RDataType && t2 instanceof RDataType) {
            return this.join((RDataType)t1, (RDataType)t2);
        }
        if (t1 instanceof RAliasType && t2 instanceof RAliasType) {
            return this.join((RAliasType)t1, (RAliasType)t2);
        }
        if (t1 instanceof RAliasType) {
            return this.join(((RAliasType)t1).getRefersTo(), t2);
        }
        if (t2 instanceof RAliasType) {
            return this.join(t1, ((RAliasType)t2).getRefersTo());
        }
        return this.builtins.ANY;
    }

    public RNumberType join(RNumberType t1, RNumberType t2) {
        return t1.join(t2);
    }

    public RStringType join(RStringType t1, RStringType t2) {
        return t1.join(t2);
    }

    public RType join(RDataType t1, RDataType t2) {
        if (t1.equals(t2)) {
            return t1;
        }
        return this.joinByTraversingAncestorsAndAliases(t1, t2);
    }

    public RType join(RAliasType t1, RAliasType t2) {
        if (t1.equals(t2)) {
            return t1;
        }
        if (t1.getTypeFunction().equals((Object)t2.getTypeFunction())) {
            RTypeFunction typeFunc = t1.getTypeFunction();
            RType underlyingJoin = this.join(t1.getRefersTo(), t2.getRefersTo());
            Optional<LinkedHashMap<String, RosettaValue>> aliasParams = typeFunc.reverse(underlyingJoin);
            return aliasParams.map(p -> new RAliasType(typeFunc, (LinkedHashMap<String, RosettaValue>)p, underlyingJoin)).orElse(underlyingJoin);
        }
        return this.joinByTraversingAncestorsAndAliases(t1, t2);
    }

    private RType joinByTraversingAncestorsAndAliases(RType t1, RType t2) {
        ArrayList<RDataType> dataAncestors = new ArrayList<RDataType>();
        ArrayList<RAliasType> aliasAncestors = new ArrayList<RAliasType>();
        RType curr1 = t1;
        while (true) {
            if (curr1 instanceof RDataType) {
                RDataType currData = (RDataType)curr1;
                dataAncestors.add(currData);
                curr1 = currData.getSuperType();
                continue;
            }
            if (!(curr1 instanceof RAliasType)) break;
            RAliasType currAlias = (RAliasType)curr1;
            aliasAncestors.add(currAlias);
            curr1 = currAlias.getRefersTo();
        }
        RType curr2 = t2;
        while (true) {
            if (curr2 instanceof RDataType) {
                RDataType currData = (RDataType)curr2;
                if (dataAncestors.contains(currData)) {
                    return curr2;
                }
                curr2 = currData.getSuperType();
                continue;
            }
            if (!(curr2 instanceof RAliasType)) break;
            RAliasType currAlias = (RAliasType)curr2;
            RTypeFunction tf = currAlias.getTypeFunction();
            RAliasType match = aliasAncestors.stream().filter(a -> tf.equals((Object)a.getTypeFunction())).findFirst().orElse(null);
            if (match != null) {
                return this.join(match, currAlias);
            }
            curr2 = currAlias.getRefersTo();
        }
        if (curr1 == null || curr2 == null) {
            return this.builtins.ANY;
        }
        return this.join(curr1, curr2);
    }

    private List<RMetaAttribute> intersectMeta(RMetaAnnotatedType t1, RMetaAnnotatedType t2) {
        return Sets.intersection(new HashSet<RMetaAttribute>(t1.getMetaAttributes()), new HashSet<RMetaAttribute>(t2.getMetaAttributes())).immutableCopy().asList();
    }
}

