/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.types;

import com.regnosys.rosetta.rosetta.simple.AnnotationRef;
import com.regnosys.rosetta.rosetta.simple.Attribute;
import com.regnosys.rosetta.rosetta.simple.Data;
import com.regnosys.rosetta.types.RAttribute;
import com.regnosys.rosetta.types.RMetaAttribute;
import com.regnosys.rosetta.types.RObject;
import com.regnosys.rosetta.types.RObjectFactory;
import com.regnosys.rosetta.types.RType;
import com.regnosys.rosetta.types.RosettaTypeProvider;
import com.regnosys.rosetta.utils.ModelIdProvider;
import com.rosetta.model.lib.ModelSymbolId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class RDataType
extends RType
implements RObject {
    private final Data data;
    private RDataType superType = null;
    private ModelSymbolId symbolId = null;
    private List<RAttribute> ownAttributes = null;
    private List<RMetaAttribute> metaAttributes = null;
    private final ModelIdProvider modelIdProvider;
    private final RObjectFactory objectFactory;
    private final RosettaTypeProvider typeProvider;

    public RDataType(Data data, ModelIdProvider modelIdProvider, RObjectFactory objectFactory, RosettaTypeProvider typeProvider) {
        this.data = data;
        this.modelIdProvider = modelIdProvider;
        this.objectFactory = objectFactory;
        this.typeProvider = typeProvider;
    }

    @Override
    public Data getEObject() {
        return this.data;
    }

    public ModelSymbolId getSymbolId() {
        if (this.symbolId == null) {
            this.symbolId = this.modelIdProvider.getSymbolId(this.data);
        }
        return this.symbolId;
    }

    public List<RMetaAttribute> getMetaAttributes() {
        if (this.metaAttributes == null) {
            this.metaAttributes = this.typeProvider.getRMetaAttributes((List<AnnotationRef>)this.data.getAnnotations());
        }
        return this.metaAttributes;
    }

    public boolean hasMetaAttribute(String name) {
        return this.getMetaAttributes().stream().anyMatch(m -> m.getName().equals(name));
    }

    public RDataType getSuperType() {
        if (this.data.hasSuperType()) {
            if (this.superType == null) {
                this.superType = new RDataType(this.data.getSuperType(), this.modelIdProvider, this.objectFactory, this.typeProvider);
            }
            return this.superType;
        }
        return null;
    }

    public List<RDataType> getAllSuperTypes() {
        LinkedHashSet<RDataType> reversedResult = new LinkedHashSet<RDataType>();
        this.doGetAllSuperTypes(this, reversedResult);
        List result = reversedResult.stream().collect(Collectors.toCollection(ArrayList::new));
        Collections.reverse(result);
        return result;
    }

    private void doGetAllSuperTypes(RDataType current, LinkedHashSet<RDataType> superTypes) {
        RDataType s;
        if (superTypes.add(current) && (s = current.getSuperType()) != null) {
            this.doGetAllSuperTypes(s, superTypes);
        }
    }

    public List<RAttribute> getOwnAttributes() {
        if (this.ownAttributes == null) {
            this.ownAttributes = this.data.getAttributes().stream().map(s -> this.objectFactory.buildRAttribute((Attribute)s)).collect(Collectors.toList());
        }
        return this.ownAttributes;
    }

    public Collection<RAttribute> getAllAttributes() {
        LinkedHashMap result = new LinkedHashMap();
        this.getAllSuperTypes().stream().flatMap(s -> s.getOwnAttributes().stream()).forEach(a -> result.put(a.getName(), a));
        return result.values();
    }

    public int hashCode() {
        return 31 + (this.data == null ? 0 : this.data.hashCode());
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        RDataType other = (RDataType)object;
        return Objects.equals(this.data, other.data);
    }
}

