/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.resource;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.resource.DerivedStateAwareResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RosettaResource
extends DerivedStateAwareResource {
    private static Logger LOGGER = LoggerFactory.getLogger(RosettaResource.class);
    public static final String UNEXPECTED_ERROR_MESSAGE = "An unexpected parse error occured.";

    protected void doLoad(InputStream inputStream, Map<?, ?> options) throws IOException {
        try {
            super.doLoad(inputStream, options);
        }
        catch (Exception ex) {
            if (this.getParseResult() == null) {
                LOGGER.error("Unexpected error during parsing of " + this.getURI() + ".", (Throwable)ex);
                this.clearCache();
                this.clearErrorsAndWarnings();
                this.getErrors().add((Object)new Resource.Diagnostic(){

                    public String getMessage() {
                        return RosettaResource.UNEXPECTED_ERROR_MESSAGE;
                    }

                    public String getLocation() {
                        return RosettaResource.this.getURI().toString();
                    }

                    public int getLine() {
                        return 0;
                    }

                    public int getColumn() {
                        return 0;
                    }
                });
            }
            throw ex;
        }
    }
}

