/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.generator.java.types;

import com.regnosys.rosetta.generator.java.types.JavaPojoInterface;
import com.regnosys.rosetta.generator.java.types.JavaPojoProperty;
import com.regnosys.rosetta.generator.java.types.JavaTypeTranslator;
import com.regnosys.rosetta.generator.java.types.JavaTypeUtil;
import com.regnosys.rosetta.generator.java.util.ModelGeneratorUtil;
import com.regnosys.rosetta.rosetta.RosettaDocReference;
import com.regnosys.rosetta.types.RAttribute;
import com.regnosys.rosetta.types.RDataType;
import com.regnosys.rosetta.types.TypeSystem;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.metafields.MetaAndTemplateFields;
import com.rosetta.util.DottedPath;
import com.rosetta.util.types.JavaClass;
import com.rosetta.util.types.JavaType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class RJavaPojoInterface
extends JavaPojoInterface {
    private final RDataType type;
    private RJavaPojoInterface superPojo = null;
    private Map<String, JavaPojoProperty> ownProperties = null;
    private Map<String, JavaPojoProperty> allProperties = null;
    private final TypeSystem typeSystem;
    private final JavaTypeTranslator typeTranslator;
    private final JavaTypeUtil typeUtil;

    public RJavaPojoInterface(RDataType type, TypeSystem typeSystem, JavaTypeTranslator typeTranslator, JavaTypeUtil typeUtil) {
        this.type = type;
        this.typeSystem = typeSystem;
        this.typeTranslator = typeTranslator;
        this.typeUtil = typeUtil;
    }

    @Override
    public String getJavadoc() {
        return ModelGeneratorUtil.javadoc(this.type.getEObject().getDefinition(), (List<RosettaDocReference>)this.type.getEObject().getReferences(), this.getVersion());
    }

    @Override
    public String getRosettaName() {
        return this.type.getName();
    }

    @Override
    public String getVersion() {
        return this.type.getEObject().getModel().getVersion();
    }

    @Override
    public Collection<JavaPojoProperty> getOwnProperties() {
        this.initializeProperties();
        return this.ownProperties.values();
    }

    @Override
    public Collection<JavaPojoProperty> getAllProperties() {
        this.initializeProperties();
        return this.allProperties.values();
    }

    private void initializeProperties() {
        if (this.ownProperties == null) {
            RJavaPojoInterface superPojo = this.getSuperPojo();
            if (superPojo == null) {
                this.allProperties = new LinkedHashMap<String, JavaPojoProperty>();
            } else {
                superPojo.initializeProperties();
                this.allProperties = new LinkedHashMap<String, JavaPojoProperty>(superPojo.allProperties);
            }
            this.ownProperties = new LinkedHashMap<String, JavaPojoProperty>();
            this.type.getOwnAttributes().forEach(attr -> {
                String name = attr.getName();
                JavaClass<?> type = this.typeTranslator.toMetaJavaType((RAttribute)attr);
                this.addPropertyIfNecessary(name, name, (JavaType)type, ModelGeneratorUtil.javadoc(attr.getDefinition(), attr.getDocReferences(), null), (AttributeMeta)(attr.getRMetaAnnotatedType().hasMetaAttribute("id") ? AttributeMeta.GLOBAL_KEY_FIELD : null), attr.getRMetaAnnotatedType().hasMetaAttribute("location"));
            });
            if (this.type.hasMetaAttribute("key")) {
                JavaClass<MetaAndTemplateFields> metaFieldsType = this.type.hasMetaAttribute("template") ? this.typeUtil.META_AND_TEMPLATE_FIELDS : this.typeUtil.META_FIELDS;
                this.addPropertyIfNecessary("meta", "meta", (JavaType)metaFieldsType, null, null, false);
            }
        }
    }

    private void addPropertyIfNecessary(String name, String runeName, JavaType type, String javadoc, AttributeMeta meta, boolean hasLocation) {
        JavaPojoProperty parentProperty = this.allProperties.get(name);
        if (parentProperty == null) {
            JavaPojoProperty newProperty = new JavaPojoProperty(name, runeName, name, type, javadoc, meta, hasLocation);
            this.ownProperties.put(name, newProperty);
            this.allProperties.put(name, newProperty);
        } else {
            JavaType parentType = parentProperty.getType();
            if (!type.equals(parentType)) {
                String compatibilityName = type.isSubtypeOf(parentType) ? parentProperty.getName() : this.getIncompatiblePropertyName(name, parentType, type);
                JavaPojoProperty newProperty = parentProperty.specialize(compatibilityName, type, javadoc, meta, hasLocation);
                this.ownProperties.put(name, newProperty);
                this.allProperties.put(name, newProperty);
            }
        }
    }

    private String getIncompatiblePropertyName(String propertyName, JavaType parentType, JavaType specializedType) {
        if (this.typeUtil.isList(parentType) && this.typeUtil.isList(specializedType)) {
            return this.getIncompatiblePropertyName(propertyName, this.typeUtil.getItemType(parentType), this.typeUtil.getItemType(specializedType));
        }
        if (this.typeUtil.isList(parentType)) {
            JavaType parentItemType = this.typeUtil.getItemType(parentType);
            if (parentItemType.equals(specializedType)) {
                return propertyName + "OverriddenAsSingle";
            }
            return propertyName + "OverriddenAsSingle" + specializedType.getSimpleName();
        }
        return propertyName + "OverriddenAs" + specializedType.getSimpleName();
    }

    public boolean isSubtypeOf(JavaType other) {
        if (this.typeUtil.ROSETTA_MODEL_OBJECT.isSubtypeOf(other)) {
            return true;
        }
        if (other instanceof RJavaPojoInterface) {
            return this.typeSystem.isSubtypeOf(this.type, ((RJavaPojoInterface)other).type);
        }
        return false;
    }

    public String getSimpleName() {
        return this.type.getName();
    }

    @Override
    public RJavaPojoInterface getSuperPojo() {
        RDataType superType;
        if (this.superPojo == null && (superType = this.type.getSuperType()) != null) {
            this.superPojo = new RJavaPojoInterface(superType, this.typeSystem, this.typeTranslator, this.typeUtil);
        }
        return this.superPojo;
    }

    public List<JavaClass<?>> getInterfaceDeclarations() {
        ArrayList interfaces = new ArrayList();
        RJavaPojoInterface superPojo = this.getSuperPojo();
        if (superPojo == null) {
            interfaces.add(this.typeUtil.ROSETTA_MODEL_OBJECT);
        } else {
            interfaces.add(superPojo);
        }
        if (this.type.hasMetaAttribute("key")) {
            interfaces.add(this.typeUtil.GLOBAL_KEY);
        }
        if (this.type.hasMetaAttribute("template")) {
            interfaces.add(this.typeUtil.TEMPLATABLE);
        }
        return interfaces;
    }

    public List<JavaClass<?>> getInterfaces() {
        return this.getInterfaceDeclarations();
    }

    public DottedPath getPackageName() {
        return this.type.getNamespace();
    }
}

