/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.generator.java.types;

import com.regnosys.rosetta.generator.java.enums.EnumHelper;
import com.regnosys.rosetta.generator.java.types.RJavaEnumValue;
import com.regnosys.rosetta.rosetta.RosettaEnumValue;
import com.regnosys.rosetta.types.REnumType;
import com.rosetta.util.DottedPath;
import com.rosetta.util.types.JavaClass;
import com.rosetta.util.types.JavaPrimitiveType;
import com.rosetta.util.types.JavaType;
import com.rosetta.util.types.JavaTypeDeclaration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class RJavaEnum
extends JavaClass<Object> {
    private final REnumType enumeration;
    private RJavaEnum parent = null;
    private List<RJavaEnumValue> enumValues = null;

    public RJavaEnum(REnumType enumeration) {
        this.enumeration = enumeration;
    }

    public RJavaEnum getParent() {
        if (this.enumeration.getParent() != null && this.parent == null) {
            this.parent = new RJavaEnum(this.enumeration.getParent());
        }
        return this.parent;
    }

    public List<RJavaEnumValue> getEnumValues() {
        if (this.enumValues == null) {
            this.enumValues = new ArrayList<RJavaEnumValue>();
            RJavaEnum p = this.getParent();
            if (p != null) {
                for (RJavaEnumValue rJavaEnumValue : p.getEnumValues()) {
                    this.enumValues.add(new RJavaEnumValue(this, rJavaEnumValue.getName(), rJavaEnumValue.getEObject(), rJavaEnumValue));
                }
            }
            for (RosettaEnumValue rosettaEnumValue : this.enumeration.getOwnEnumValues()) {
                this.enumValues.add(new RJavaEnumValue(this, EnumHelper.convertValue(rosettaEnumValue), rosettaEnumValue, null));
            }
        }
        return this.enumValues;
    }

    public boolean isSubtypeOf(JavaType other) {
        if (other instanceof JavaPrimitiveType) {
            return false;
        }
        return other.equals(JavaClass.OBJECT);
    }

    public String getSimpleName() {
        return this.enumeration.getName();
    }

    public JavaClass<? super Object> getSuperclassDeclaration() {
        return JavaClass.OBJECT;
    }

    public JavaClass<? super Object> getSuperclass() {
        return this.getSuperclassDeclaration();
    }

    public List<JavaClass<?>> getInterfaceDeclarations() {
        return Collections.emptyList();
    }

    public List<JavaClass<?>> getInterfaces() {
        return this.getInterfaceDeclarations();
    }

    public boolean extendsDeclaration(JavaTypeDeclaration<?> other) {
        return other.equals((Object)JavaClass.OBJECT);
    }

    public boolean isFinal() {
        return true;
    }

    public Class<?> loadClass(ClassLoader classLoader) throws ClassNotFoundException {
        return Class.forName(this.getCanonicalName().toString(), true, classLoader);
    }

    public DottedPath getPackageName() {
        return this.enumeration.getNamespace();
    }
}

