/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.generator.java.statement.builder;

import com.regnosys.rosetta.generator.GeneratedIdentifier;
import com.regnosys.rosetta.generator.java.JavaScope;
import com.regnosys.rosetta.generator.java.statement.JavaAssignment;
import com.regnosys.rosetta.generator.java.statement.JavaIfThenElseStatement;
import com.regnosys.rosetta.generator.java.statement.JavaLambdaBody;
import com.regnosys.rosetta.generator.java.statement.JavaReturnStatement;
import com.regnosys.rosetta.generator.java.statement.JavaStatement;
import com.regnosys.rosetta.generator.java.statement.builder.JavaExpression;
import com.regnosys.rosetta.generator.java.statement.builder.JavaIfThenElseBuilder;
import com.regnosys.rosetta.generator.java.statement.builder.JavaStatementBuilder;
import com.regnosys.rosetta.generator.java.types.JavaTypeUtil;
import com.rosetta.util.types.JavaType;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtend2.lib.StringConcatenationClient;

public class JavaConditionalExpression
extends JavaStatementBuilder
implements JavaLambdaBody {
    private final JavaExpression condition;
    private final JavaExpression thenBranch;
    private final JavaExpression elseBranch;
    private final JavaType commonType;
    private final JavaTypeUtil typeUtil;

    public JavaConditionalExpression(JavaExpression condition, JavaExpression thenBranch, JavaExpression elseBranch, JavaType commonType, JavaTypeUtil typeUtil) {
        this.condition = condition;
        this.thenBranch = thenBranch;
        this.elseBranch = elseBranch;
        this.commonType = commonType;
        this.typeUtil = typeUtil;
    }

    public JavaConditionalExpression(JavaExpression condition, JavaExpression thenBranch, JavaExpression elseBranch, JavaTypeUtil typeUtil) {
        this(condition, thenBranch, elseBranch, typeUtil.join(thenBranch.getExpressionType(), elseBranch.getExpressionType()), typeUtil);
    }

    @Override
    public JavaType getExpressionType() {
        return this.commonType;
    }

    @Override
    public JavaStatementBuilder mapExpression(Function<JavaExpression, ? extends JavaStatementBuilder> mapper) {
        JavaStatementBuilder newThenBranch = mapper.apply(this.thenBranch);
        JavaStatementBuilder newElseBranch = mapper.apply(this.elseBranch);
        if (newThenBranch instanceof JavaExpression && newElseBranch instanceof JavaExpression) {
            return new JavaConditionalExpression(this.condition, (JavaExpression)newThenBranch, (JavaExpression)newElseBranch, this.typeUtil);
        }
        return new JavaIfThenElseBuilder(this.condition, newThenBranch, newElseBranch, this.typeUtil);
    }

    @Override
    public JavaStatementBuilder then(JavaStatementBuilder after, BiFunction<JavaExpression, JavaExpression, JavaStatementBuilder> combineExpressions, JavaScope scope) {
        return this.collapseToSingleExpression(scope).then(after, combineExpressions, scope);
    }

    @Override
    public JavaStatement complete(Function<JavaExpression, JavaStatement> completer) {
        return completer.apply(this.toExpression());
    }

    @Override
    public JavaReturnStatement completeAsReturn() {
        return this.toExpression().completeAsReturn();
    }

    @Override
    public JavaIfThenElseStatement completeAsExpressionStatement() {
        return new JavaIfThenElseBuilder(this.condition, this.thenBranch, this.elseBranch, this.commonType, this.typeUtil).completeAsExpressionStatement();
    }

    @Override
    public JavaAssignment completeAsAssignment(GeneratedIdentifier variableId) {
        return this.toExpression().completeAsAssignment(variableId);
    }

    @Override
    public JavaStatementBuilder declareAsVariable(boolean isFinal, String variableId, JavaScope scope) {
        JavaExpression expression = this.toExpression();
        JavaStatementBuilder variable = expression.declareAsVariable(isFinal, variableId, scope);
        scope.createKeySynonym(this, expression);
        return variable;
    }

    @Override
    public JavaExpression collapseToSingleExpression(JavaScope scope) {
        return JavaExpression.from(new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation target) {
                target.append((Object)"(");
                target.append((Object)JavaConditionalExpression.this);
                target.append((Object)")");
            }
        }, this.commonType);
    }

    @Override
    public JavaLambdaBody toLambdaBody() {
        return this;
    }

    @Override
    public void appendTo(StringConcatenationClient.TargetStringConcatenation target) {
        target.append((Object)this.condition);
        target.append((Object)" ? ");
        target.append((Object)this.thenBranch);
        target.append((Object)" : ");
        target.append((Object)this.elseBranch);
    }

    private JavaExpression toExpression() {
        return JavaExpression.from(new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation target) {
                target.append((Object)JavaConditionalExpression.this);
            }
        }, this.commonType);
    }

    public String toString() {
        StringConcatenation repr = new StringConcatenation();
        repr.append(new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation target) {
                JavaConditionalExpression.this.appendTo(target);
            }
        });
        return repr.toString();
    }
}

