/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.generator.java.reports;

import com.google.common.collect.Iterables;
import com.google.inject.ImplementedBy;
import com.regnosys.rosetta.RosettaEcoreUtil;
import com.regnosys.rosetta.config.RosettaConfiguration;
import com.regnosys.rosetta.generator.GeneratedIdentifier;
import com.regnosys.rosetta.generator.java.JavaScope;
import com.regnosys.rosetta.generator.java.types.JavaPojoInterface;
import com.regnosys.rosetta.generator.java.types.JavaTypeTranslator;
import com.regnosys.rosetta.generator.java.util.ImportManagerExtension;
import com.regnosys.rosetta.rosetta.RosettaExternalRuleSource;
import com.regnosys.rosetta.rosetta.RosettaReport;
import com.regnosys.rosetta.rosetta.RosettaRule;
import com.regnosys.rosetta.rosetta.simple.AnnotationRef;
import com.regnosys.rosetta.rosetta.simple.Data;
import com.regnosys.rosetta.types.RAttribute;
import com.regnosys.rosetta.types.RChoiceType;
import com.regnosys.rosetta.types.RDataType;
import com.regnosys.rosetta.types.RObjectFactory;
import com.regnosys.rosetta.types.RType;
import com.regnosys.rosetta.types.RosettaTypeProvider;
import com.regnosys.rosetta.utils.ExternalAnnotationUtil;
import com.regnosys.rosetta.utils.ModelIdProvider;
import com.rosetta.model.lib.ModelSymbolId;
import com.rosetta.model.lib.reports.Tabulator;
import com.rosetta.util.DottedPath;
import com.rosetta.util.types.JavaClass;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.text.StringEscapeUtils;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.generator.IFileSystemAccess2;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

public class TabulatorGenerator {
    @Inject
    private RosettaTypeProvider typeProvider;
    @Inject
    private RosettaConfiguration rosettaConfiguration;
    @Inject
    @Extension
    private JavaTypeTranslator typeTranslator;
    @Inject
    @Extension
    private ImportManagerExtension _importManagerExtension;
    @Inject
    @Extension
    private RosettaEcoreUtil extensions;
    @Inject
    @Extension
    private ExternalAnnotationUtil _externalAnnotationUtil;
    @Inject
    @Extension
    private ModelIdProvider _modelIdProvider;
    @Inject
    @Extension
    private RObjectFactory _rObjectFactory;

    public void generateTabulatorForReport(IFileSystemAccess2 fsa, RosettaReport report) {
        JavaClass<Tabulator<?>> tabulatorClass = this.typeTranslator.toReportTabulatorJavaClass(report);
        DottedPath _packageName = tabulatorClass.getPackageName();
        JavaScope topScope = new JavaScope(_packageName);
        RDataType inputType = this._rObjectFactory.buildRDataType(report.getReportType());
        ReportTabulatorContext context = this.getReportTabulatorContext(inputType, Optional.ofNullable(report.getRuleSource()));
        StringConcatenationClient classBody = this.mainTabulatorClassBody(inputType, context, topScope, tabulatorClass);
        String content = this._importManagerExtension.buildClass(tabulatorClass.getPackageName(), classBody, topScope);
        String _withForwardSlashes = tabulatorClass.getCanonicalName().withForwardSlashes();
        String _plus = _withForwardSlashes + ".java";
        fsa.generateFile(_plus, (CharSequence)content);
    }

    public void generateTabulatorForReportData(IFileSystemAccess2 fsa, RDataType type, Optional<RosettaExternalRuleSource> ruleSource) {
        ReportTabulatorContext context = this.getReportTabulatorContext(type, ruleSource);
        boolean _needsTabulator = context.needsTabulator(type);
        if (_needsTabulator) {
            this.recursivelyGenerateTabulators(fsa, type, context, CollectionLiterals.newHashSet());
        }
    }

    public void generateTabulatorForData(IFileSystemAccess2 fsa, RDataType type) {
        boolean _isDataTabulatable = this.isDataTabulatable(type);
        if (_isDataTabulatable) {
            DataTabulatorContext context = new DataTabulatorContext(this.typeTranslator);
            this.recursivelyGenerateTabulators(fsa, type, context, CollectionLiterals.newHashSet());
        }
    }

    public void generateTabulatorForFunction(IFileSystemAccess2 fsa, com.regnosys.rosetta.rosetta.simple.Function func) {
        boolean _isFunctionTabulatable = this.isFunctionTabulatable(func);
        if (_isFunctionTabulatable) {
            JavaClass<Tabulator<?>> tabulatorClass = this.toApplicableTabulatorClass(func);
            DottedPath _packageName = tabulatorClass.getPackageName();
            JavaScope topScope = new JavaScope(_packageName);
            RType t = this.typeProvider.getRTypeOfSymbol(func.getOutput()).getRType();
            RType _xifexpression = null;
            _xifexpression = t instanceof RChoiceType ? ((RChoiceType)t).asRDataType() : t;
            RType functionOutputType = _xifexpression;
            if (functionOutputType instanceof RDataType) {
                TabulatorContext context = this.createFunctionTabulatorContext(this.typeTranslator, func);
                StringConcatenationClient classBody = this.mainTabulatorClassBody((RDataType)functionOutputType, context, topScope, tabulatorClass);
                String content = this._importManagerExtension.buildClass(tabulatorClass.getPackageName(), classBody, topScope);
                String _withForwardSlashes = tabulatorClass.getCanonicalName().withForwardSlashes();
                String _plus = _withForwardSlashes + ".java";
                fsa.generateFile(_plus, (CharSequence)content);
                this.recursivelyGenerateTabulators(fsa, (RDataType)functionOutputType, context, CollectionLiterals.newHashSet());
            }
        }
    }

    private void recursivelyGenerateTabulators(IFileSystemAccess2 fsa, RDataType type, TabulatorContext context, Set<RDataType> visited) {
        boolean _add = visited.add(type);
        if (_add) {
            JavaClass<Tabulator<?>> tabulatorClass = context.toTabulatorJavaClass(type);
            DottedPath _packageName = tabulatorClass.getPackageName();
            JavaScope topScope = new JavaScope(_packageName);
            StringConcatenationClient classBody = this.tabulatorClassBody(type, context, topScope, tabulatorClass);
            String content = this._importManagerExtension.buildClass(tabulatorClass.getPackageName(), classBody, topScope);
            String _withForwardSlashes = tabulatorClass.getCanonicalName().withForwardSlashes();
            String _plus = _withForwardSlashes + ".java";
            fsa.generateFile(_plus, (CharSequence)content);
            Functions.Function1 _function = it -> it.getRMetaAnnotatedType();
            Functions.Function1 _function_1 = it -> it.getRType();
            Functions.Function1 _function_2 = it -> {
                RType _xifexpression = null;
                _xifexpression = it instanceof RChoiceType ? ((RChoiceType)it).asRDataType() : it;
                return _xifexpression;
            };
            Consumer<RDataType> _function_3 = it -> this.recursivelyGenerateTabulators(fsa, (RDataType)it, context, visited);
            Iterables.filter((Iterable)IterableExtensions.map((Iterable)IterableExtensions.map((Iterable)IterableExtensions.map(type.getAllAttributes(), (Functions.Function1)_function), (Functions.Function1)_function_1), (Functions.Function1)_function_2), RDataType.class).forEach(_function_3);
        }
    }

    private ReportTabulatorContext getReportTabulatorContext(RDataType type, Optional<RosettaExternalRuleSource> ruleSource) {
        ReportTabulatorContext _xblockexpression = null;
        HashMap ruleMap = CollectionLiterals.newHashMap();
        BiConsumer<ExternalAnnotationUtil.PathAttribute, RosettaRule> _function = (key, rule) -> ruleMap.put(key.getAttr(), rule);
        this._externalAnnotationUtil.getAllReportingRules(type, ruleSource).forEach(_function);
        _xblockexpression = new ReportTabulatorContext(this.extensions, this.typeTranslator, this.typeProvider, ruleMap, ruleSource);
        return _xblockexpression;
    }

    private boolean isFunctionTabulatable(com.regnosys.rosetta.rosetta.simple.Function func) {
        Functions.Function1 _function;
        boolean _xifexpression = false;
        boolean _shouldGenerateLegacyTabulator = this.shouldGenerateLegacyTabulator();
        if (_shouldGenerateLegacyTabulator) {
            return this.isAnnotatedWith(func, "projection");
        }
        boolean _xblockexpression = false;
        List<String> annotations = this.rosettaConfiguration.getGenerators().getTabulators().getAnnotations();
        String _findFirst = (String)IterableExtensions.findFirst(annotations, (Functions.Function1)(_function = it -> this.isAnnotatedWith(func, (String)it)));
        _xifexpression = _xblockexpression = _findFirst != null;
        return _xifexpression;
    }

    private boolean isDataTabulatable(RDataType type) {
        boolean _xblockexpression = false;
        List<String> types = this.rosettaConfiguration.getGenerators().getTabulators().getTypes();
        _xblockexpression = types.contains(type.getSymbolId().toString());
        return _xblockexpression;
    }

    private boolean isAnnotatedWith(com.regnosys.rosetta.rosetta.simple.Function func, String with) {
        Functions.Function1 _function = it -> {
            String _name = it.getAnnotation().getName();
            return com.google.common.base.Objects.equal((Object)_name, (Object)with);
        };
        AnnotationRef _findFirst = (AnnotationRef)IterableExtensions.findFirst((Iterable)func.getAnnotations(), (Functions.Function1)_function);
        return _findFirst != null;
    }

    private boolean shouldGenerateLegacyTabulator() {
        return this.rosettaConfiguration.getGenerators().getTabulators().getAnnotations().isEmpty();
    }

    private TabulatorContext createFunctionTabulatorContext(JavaTypeTranslator typeTranslator, com.regnosys.rosetta.rosetta.simple.Function func) {
        TabulatorContext _xifexpression = null;
        boolean _shouldGenerateLegacyTabulator = this.shouldGenerateLegacyTabulator();
        _xifexpression = _shouldGenerateLegacyTabulator ? new ProjectionTabulatorContext(typeTranslator, func) : new FunctionTabulatorContext(typeTranslator, func);
        return _xifexpression;
    }

    private JavaClass<Tabulator<?>> toApplicableTabulatorClass(com.regnosys.rosetta.rosetta.simple.Function func) {
        JavaClass<Tabulator<?>> _xifexpression = null;
        boolean _shouldGenerateLegacyTabulator = this.shouldGenerateLegacyTabulator();
        _xifexpression = _shouldGenerateLegacyTabulator ? this.typeTranslator.toProjectionTabulatorJavaClass(func) : this.typeTranslator.toTabulatorJavaClass(func);
        return _xifexpression;
    }

    private StringConcatenationClient mainTabulatorClassBody(RDataType inputType, TabulatorContext context, JavaScope topScope, final JavaClass<Tabulator<?>> tabulatorClass) {
        StringConcatenationClient _xblockexpression = null;
        final JavaPojoInterface inputClass = this.typeTranslator.toJavaReferenceType(inputType);
        JavaScope classScope = topScope.classScope(tabulatorClass.getSimpleName());
        JavaScope tabulateScope = classScope.methodScope("tabulate");
        final GeneratedIdentifier inputParam = tabulateScope.createUniqueIdentifier("input");
        StringConcatenationClient _xifexpression = null;
        boolean _needsTabulator = context.needsTabulator(inputType);
        if (_needsTabulator) {
            StringConcatenationClient _client;
            StringConcatenationClient _xblockexpression_1 = null;
            final JavaClass<Tabulator<?>> innerTabulatorClass = context.toTabulatorJavaClass(inputType);
            final GeneratedIdentifier innerTabulatorInstance = classScope.createUniqueIdentifier("tabulator");
            _xifexpression = _xblockexpression_1 = (_client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)"@");
                    _builder.append(ImplementedBy.class);
                    _builder.append((Object)"(");
                    _builder.append((Object)tabulatorClass);
                    _builder.append((Object)".Impl.class)");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"public interface ");
                    _builder.append((Object)tabulatorClass);
                    _builder.append((Object)" extends ");
                    _builder.append(Tabulator.class);
                    _builder.append((Object)"<");
                    _builder.append((Object)inputClass);
                    _builder.append((Object)"> {");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"@");
                    _builder.append(Singleton.class, "\t");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"class Impl implements ");
                    _builder.append((Object)tabulatorClass, "\t");
                    _builder.append((Object)" {");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t\t");
                    _builder.append((Object)"private final ");
                    _builder.append((Object)innerTabulatorClass, "\t\t");
                    _builder.append((Object)" ");
                    _builder.append((Object)innerTabulatorInstance, "\t\t");
                    _builder.append((Object)";");
                    _builder.newLineIfNotEmpty();
                    _builder.newLine();
                    _builder.append((Object)"\t\t");
                    _builder.append((Object)"@");
                    _builder.append(Inject.class, "\t\t");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t\t");
                    _builder.append((Object)"public Impl(");
                    _builder.append((Object)innerTabulatorClass, "\t\t");
                    _builder.append((Object)" ");
                    _builder.append((Object)innerTabulatorInstance, "\t\t");
                    _builder.append((Object)") {");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t\t\t");
                    _builder.append((Object)"this.");
                    _builder.append((Object)innerTabulatorInstance, "\t\t\t");
                    _builder.append((Object)" = ");
                    _builder.append((Object)innerTabulatorInstance, "\t\t\t");
                    _builder.append((Object)";");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t\t");
                    _builder.append((Object)"}");
                    _builder.newLine();
                    _builder.newLine();
                    _builder.append((Object)"\t\t");
                    _builder.append((Object)"@Override");
                    _builder.newLine();
                    _builder.append((Object)"\t\t");
                    _builder.append((Object)"public ");
                    _builder.append(List.class, "\t\t");
                    _builder.append((Object)"<");
                    _builder.append(Tabulator.FieldValue.class, "\t\t");
                    _builder.append((Object)"> tabulate(");
                    _builder.append((Object)inputClass, "\t\t");
                    _builder.append((Object)" ");
                    _builder.append((Object)inputParam, "\t\t");
                    _builder.append((Object)") {");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t\t\t");
                    _builder.append((Object)"return ");
                    _builder.append((Object)innerTabulatorInstance, "\t\t\t");
                    _builder.append((Object)".tabulate(");
                    _builder.append((Object)inputParam, "\t\t\t");
                    _builder.append((Object)");");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t\t");
                    _builder.append((Object)"}");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"}");
                    _builder.newLine();
                    _builder.append((Object)"}");
                    _builder.newLine();
                }
            });
        } else {
            StringConcatenationClient _client;
            _xifexpression = _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)"@");
                    _builder.append(ImplementedBy.class);
                    _builder.append((Object)"(");
                    _builder.append((Object)tabulatorClass);
                    _builder.append((Object)".Impl.class)");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"public interface ");
                    _builder.append((Object)tabulatorClass);
                    _builder.append((Object)" extends ");
                    _builder.append(Tabulator.class);
                    _builder.append((Object)"<");
                    _builder.append((Object)inputClass);
                    _builder.append((Object)"> {");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"@");
                    _builder.append(Singleton.class, "\t");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"class Impl implements ");
                    _builder.append((Object)tabulatorClass, "\t");
                    _builder.append((Object)" {");
                    _builder.newLineIfNotEmpty();
                    _builder.newLine();
                    _builder.append((Object)"\t\t");
                    _builder.append((Object)"@Override");
                    _builder.newLine();
                    _builder.append((Object)"\t\t");
                    _builder.append((Object)"public ");
                    _builder.append(List.class, "\t\t");
                    _builder.append((Object)"<");
                    _builder.append(Tabulator.FieldValue.class, "\t\t");
                    _builder.append((Object)"> tabulate(");
                    _builder.append((Object)inputClass, "\t\t");
                    _builder.append((Object)" ");
                    _builder.append((Object)inputParam, "\t\t");
                    _builder.append((Object)") {");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t\t\t");
                    _builder.append((Object)"return ");
                    _builder.append(Arrays.class, "\t\t\t");
                    _builder.append((Object)".asList();");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t\t");
                    _builder.append((Object)"}");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"}");
                    _builder.newLine();
                    _builder.append((Object)"}");
                    _builder.newLine();
                }
            };
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    private StringConcatenationClient tabulatorClassBody(final RDataType inputType, final TabulatorContext context, JavaScope topScope, final JavaClass<Tabulator<?>> tabulatorClass) {
        StringConcatenationClient _client;
        StringConcatenationClient _xblockexpression = null;
        final JavaPojoInterface inputClass = this.typeTranslator.toJavaReferenceType(inputType);
        final JavaScope classScope = topScope.classScope(tabulatorClass.getSimpleName());
        this.findTabulatedFieldsAndCreateIdentifiers(inputType, context, classScope);
        final Set<NestedTabulatorInstance> nestedTabulatorInstances = this.findNestedTabulatorsAndCreateIdentifiers(inputType, context, classScope);
        final JavaScope tabulateScope = classScope.methodScope("tabulate");
        final GeneratedIdentifier inputParam = tabulateScope.createUniqueIdentifier("input");
        _xblockexpression = _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                boolean _not_1;
                boolean _not;
                _builder.append((Object)"@");
                _builder.append(ImplementedBy.class);
                _builder.append((Object)"(");
                _builder.append((Object)tabulatorClass);
                _builder.append((Object)".Impl.class)");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"public interface ");
                _builder.append((Object)tabulatorClass);
                _builder.append((Object)" extends ");
                _builder.append(Tabulator.class);
                _builder.append((Object)"<");
                _builder.append((Object)inputClass);
                _builder.append((Object)"> {");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"@");
                _builder.append(Singleton.class, "\t");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"class Impl implements ");
                _builder.append((Object)tabulatorClass, "\t");
                _builder.append((Object)" {");
                _builder.newLineIfNotEmpty();
                Collection<RAttribute> _allAttributes = inputType.getAllAttributes();
                for (RAttribute rAttribute : _allAttributes) {
                    boolean _isTabulated = context.isTabulated(rAttribute);
                    if (!_isTabulated) continue;
                    _builder.append((Object)"\t\t");
                    GeneratedIdentifier fieldId = classScope.getIdentifierOrThrow(rAttribute);
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t\t");
                    _builder.append((Object)"private final ");
                    _builder.append(Tabulator.Field.class, "\t\t");
                    _builder.append((Object)" ");
                    _builder.append((Object)fieldId, "\t\t");
                    _builder.append((Object)";");
                    _builder.newLineIfNotEmpty();
                }
                boolean _isEmpty = nestedTabulatorInstances.isEmpty();
                boolean bl = _not = !_isEmpty;
                if (_not) {
                    _builder.newLine();
                    for (NestedTabulatorInstance tabInst : nestedTabulatorInstances) {
                        _builder.append((Object)"\t\t");
                        _builder.append((Object)"private final ");
                        JavaClass<Tabulator<?>> _tabulatorJavaClass = context.toTabulatorJavaClass(tabInst.type);
                        _builder.append(_tabulatorJavaClass, "\t\t");
                        _builder.append((Object)" ");
                        GeneratedIdentifier _identifierOrThrow = classScope.getIdentifierOrThrow(tabInst);
                        _builder.append((Object)_identifierOrThrow, "\t\t");
                        _builder.append((Object)";");
                        _builder.newLineIfNotEmpty();
                    }
                }
                _builder.newLine();
                _builder.append((Object)"\t\t");
                boolean _isEmpty_1 = nestedTabulatorInstances.isEmpty();
                boolean bl2 = _not_1 = !_isEmpty_1;
                if (_not_1) {
                    _builder.append((Object)"@");
                    _builder.append(Inject.class, "\t\t");
                }
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"public Impl(");
                boolean _hasElements = false;
                for (NestedTabulatorInstance nestedTabulatorInstance : nestedTabulatorInstances) {
                    if (!_hasElements) {
                        _hasElements = true;
                    } else {
                        _builder.appendImmediate((Object)", ", "\t\t");
                    }
                    JavaClass<Tabulator<?>> _tabulatorJavaClass_1 = context.toTabulatorJavaClass(nestedTabulatorInstance.type);
                    _builder.append(_tabulatorJavaClass_1, "\t\t");
                    _builder.append((Object)" ");
                    GeneratedIdentifier _identifierOrThrow_1 = classScope.getIdentifierOrThrow(nestedTabulatorInstance);
                    _builder.append((Object)_identifierOrThrow_1, "\t\t");
                }
                _builder.append((Object)") {");
                _builder.newLineIfNotEmpty();
                for (NestedTabulatorInstance tabInst_2 : nestedTabulatorInstances) {
                    _builder.append((Object)"\t\t\t");
                    _builder.append((Object)"this.");
                    GeneratedIdentifier generatedIdentifier = classScope.getIdentifierOrThrow(tabInst_2);
                    _builder.append((Object)generatedIdentifier, "\t\t\t");
                    _builder.append((Object)" = ");
                    GeneratedIdentifier _identifierOrThrow_3 = classScope.getIdentifierOrThrow(tabInst_2);
                    _builder.append((Object)_identifierOrThrow_3, "\t\t\t");
                    _builder.append((Object)";");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append((Object)"\t\t\t");
                StringConcatenationClient _initializeFields = TabulatorGenerator.this.initializeFields(inputType, context, classScope);
                _builder.append((Object)_initializeFields, "\t\t\t");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"@Override");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"public ");
                _builder.append(List.class, "\t\t");
                _builder.append((Object)"<");
                _builder.append(Tabulator.FieldValue.class, "\t\t");
                _builder.append((Object)"> tabulate(");
                _builder.append((Object)inputClass, "\t\t");
                _builder.append((Object)" ");
                _builder.append((Object)inputParam, "\t\t");
                _builder.append((Object)") {");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t\t");
                StringConcatenationClient _computeFieldValues = TabulatorGenerator.this.computeFieldValues(inputType, inputParam, context, tabulateScope);
                _builder.append((Object)_computeFieldValues, "\t\t\t");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)"return ");
                StringConcatenationClient stringConcatenationClient = TabulatorGenerator.this.fieldValuesAsList(inputType, context, tabulateScope);
                _builder.append((Object)stringConcatenationClient, "\t\t\t");
                _builder.append((Object)";");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"}");
                _builder.newLine();
            }
        };
        return _xblockexpression;
    }

    private List<RAttribute> findTabulatedFieldsAndCreateIdentifiers(RDataType type, TabulatorContext context, JavaScope scope) {
        Functions.Function1 _function = it -> context.isTabulated((RAttribute)it);
        Functions.Function1 _function_1 = it -> {
            RAttribute _xblockexpression = null;
            String _name = it.getName();
            String _plus = _name + "Field";
            scope.createIdentifier(it, _plus);
            _xblockexpression = it;
            return _xblockexpression;
        };
        return IterableExtensions.toList((Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter(type.getAllAttributes(), (Functions.Function1)_function), (Functions.Function1)_function_1));
    }

    private StringConcatenationClient initializeFields(final RDataType type, final TabulatorContext context, final JavaScope scope) {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                Collection<RAttribute> _allAttributes = type.getAllAttributes();
                for (RAttribute attr : _allAttributes) {
                    boolean _isTabulated = context.isTabulated(attr);
                    if (!_isTabulated) continue;
                    GeneratedIdentifier fieldId = scope.getIdentifierOrThrow(attr);
                    _builder.newLineIfNotEmpty();
                    Optional<RosettaRule> rule = context.getRule(attr);
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"this.");
                    _builder.append((Object)fieldId);
                    _builder.append((Object)" = new ");
                    _builder.append(Tabulator.FieldImpl.class);
                    _builder.append((Object)"(");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"\"");
                    String _escapeJava = StringEscapeUtils.escapeJava((String)attr.getName());
                    _builder.append((Object)_escapeJava, "\t");
                    _builder.append((Object)"\",");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    boolean _isMulti = attr.isMulti();
                    _builder.append((Object)_isMulti, "\t");
                    _builder.append((Object)",");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    Function<RosettaRule, StringConcatenationClient> _function = it -> TabulatorGenerator.this.toModelSymbolCode(TabulatorGenerator.this._modelIdProvider.getSymbolId(it));
                    StringConcatenationClient _optionalCode = TabulatorGenerator.this.toOptionalCode(rule.map(_function));
                    _builder.append((Object)_optionalCode, "\t");
                    _builder.append((Object)",");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    Function<RosettaRule, String> _function_1 = it -> it.getIdentifier();
                    Function<String, String> _function_2 = it -> "\"" + it + "\"";
                    StringConcatenationClient _optionalCode_1 = TabulatorGenerator.this.toOptionalCode(rule.map(_function_1).map(_function_2));
                    _builder.append((Object)_optionalCode_1, "\t");
                    _builder.append((Object)",");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append(Arrays.class, "\t");
                    _builder.append((Object)".asList()");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)");");
                    _builder.newLine();
                }
            }
        };
        return _client;
    }

    private Set<NestedTabulatorInstance> findNestedTabulatorsAndCreateIdentifiers(RDataType type, TabulatorContext context, JavaScope scope) {
        Set _xblockexpression = null;
        Functions.Function1 _function = it -> context.isTabulated((RAttribute)it);
        Functions.Function1 _function_1 = it -> it.getRMetaAnnotatedType();
        Functions.Function1 _function_2 = it -> it.getRType();
        Functions.Function1 _function_3 = it -> {
            RType _xifexpression = null;
            _xifexpression = it instanceof RChoiceType ? ((RChoiceType)it).asRDataType() : it;
            return _xifexpression;
        };
        Functions.Function1 _function_4 = it -> this.toNestedTabulatorInstance((RDataType)it);
        Set result = IterableExtensions.toSet((Iterable)IterableExtensions.map((Iterable)Iterables.filter((Iterable)IterableExtensions.map((Iterable)IterableExtensions.map((Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter(type.getAllAttributes(), (Functions.Function1)_function), (Functions.Function1)_function_1), (Functions.Function1)_function_2), (Functions.Function1)_function_3), RDataType.class), (Functions.Function1)_function_4));
        Consumer<NestedTabulatorInstance> _function_5 = it -> scope.createIdentifier(it, StringExtensions.toFirstLower((String)context.toTabulatorJavaClass(it.type).getSimpleName()));
        result.forEach(_function_5);
        _xblockexpression = result;
        return _xblockexpression;
    }

    private StringConcatenationClient computeFieldValues(final RDataType type, final GeneratedIdentifier inputParam, final TabulatorContext context, final JavaScope scope) {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                Collection<RAttribute> _allAttributes = type.getAllAttributes();
                for (RAttribute attr : _allAttributes) {
                    boolean _isTabulated = context.isTabulated(attr);
                    if (!_isTabulated) continue;
                    StringConcatenationClient _fieldValue = TabulatorGenerator.this.fieldValue(TabulatorGenerator.this.typeTranslator.toJavaReferenceType(type), attr, inputParam, scope);
                    _builder.append((Object)_fieldValue);
                    _builder.newLineIfNotEmpty();
                }
            }
        };
        return _client;
    }

    private StringConcatenationClient fieldValue(JavaPojoInterface javaType, final RAttribute attr, final GeneratedIdentifier inputParam, final JavaScope scope) {
        StringConcatenationClient _xblockexpression = null;
        RType rawAttr = attr.getRMetaAnnotatedType().getRType();
        RType _xifexpression = null;
        _xifexpression = rawAttr instanceof RChoiceType ? ((RChoiceType)rawAttr).asRDataType() : rawAttr;
        RType rType = _xifexpression;
        final GeneratedIdentifier resultId = scope.createIdentifier(this.toComputedField(attr), attr.getName());
        JavaScope lambdaScope = scope.lambdaScope();
        final GeneratedIdentifier lambdaParam = lambdaScope.createUniqueIdentifier("x");
        JavaScope nestedLambdaScope = lambdaScope.lambdaScope();
        final GeneratedIdentifier nestedLambdaParam = nestedLambdaScope.createUniqueIdentifier("x");
        final String getter = javaType.findProperty(attr.getName()).getGetterName();
        StringConcatenationClient _xifexpression_1 = null;
        if (rType instanceof RDataType) {
            StringConcatenationClient _client;
            StringConcatenationClient _xblockexpression_1 = null;
            final GeneratedIdentifier nestedTabulator = scope.getIdentifierOrThrow(this.toNestedTabulatorInstance((RDataType)rType));
            _xifexpression_1 = _xblockexpression_1 = (_client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append(Tabulator.FieldValue.class);
                    _builder.append((Object)" ");
                    _builder.append((Object)resultId);
                    _builder.append((Object)" = ");
                    _builder.append(Optional.class);
                    _builder.append((Object)".ofNullable(");
                    _builder.append((Object)inputParam);
                    _builder.append((Object)".");
                    _builder.append((Object)getter);
                    _builder.append((Object)"())");
                    _builder.newLineIfNotEmpty();
                    boolean _isMulti = attr.isMulti();
                    if (_isMulti) {
                        _builder.append((Object)"\t");
                        _builder.append((Object)".map(");
                        _builder.append((Object)lambdaParam, "\t");
                        _builder.append((Object)" -> ");
                        _builder.append((Object)lambdaParam, "\t");
                        _builder.append((Object)".stream()");
                        _builder.newLineIfNotEmpty();
                        boolean _hasMeta = attr.getRMetaAnnotatedType().hasMeta();
                        if (_hasMeta) {
                            _builder.append((Object)"\t");
                            _builder.append((Object)"\t");
                            _builder.append((Object)".map(");
                            _builder.append((Object)nestedLambdaParam, "\t\t");
                            _builder.append((Object)" -> ");
                            _builder.append((Object)nestedLambdaParam, "\t\t");
                            _builder.append((Object)".getValue())");
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"\t");
                            _builder.append((Object)"\t");
                            _builder.append((Object)".filter(");
                            _builder.append(Objects.class, "\t\t");
                            _builder.append((Object)"::nonNull)");
                            _builder.newLineIfNotEmpty();
                        }
                        _builder.append((Object)"\t");
                        _builder.append((Object)"\t");
                        _builder.append((Object)".map(");
                        _builder.append((Object)nestedLambdaParam, "\t\t");
                        _builder.append((Object)" -> ");
                        _builder.append((Object)nestedTabulator, "\t\t");
                        _builder.append((Object)".tabulate(");
                        _builder.append((Object)nestedLambdaParam, "\t\t");
                        _builder.append((Object)"))");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"\t");
                        _builder.append((Object)"\t");
                        _builder.append((Object)".collect(");
                        _builder.append(Collectors.class, "\t\t");
                        _builder.append((Object)".toList()))");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"\t");
                        _builder.append((Object)".map(fieldValues -> new ");
                        _builder.append(Tabulator.MultiNestedFieldValueImpl.class, "\t");
                        _builder.append((Object)"(");
                        GeneratedIdentifier _identifierOrThrow = scope.getIdentifierOrThrow(attr);
                        _builder.append((Object)_identifierOrThrow, "\t");
                        _builder.append((Object)", Optional.of(fieldValues)))");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"\t");
                        _builder.append((Object)".orElse(new ");
                        _builder.append(Tabulator.MultiNestedFieldValueImpl.class, "\t");
                        _builder.append((Object)"(");
                        GeneratedIdentifier _identifierOrThrow_1 = scope.getIdentifierOrThrow(attr);
                        _builder.append((Object)_identifierOrThrow_1, "\t");
                        _builder.append((Object)", Optional.empty()));");
                        _builder.newLineIfNotEmpty();
                    } else {
                        _builder.append((Object)"\t");
                        boolean _hasMeta_1 = attr.getRMetaAnnotatedType().hasMeta();
                        if (_hasMeta_1) {
                            _builder.append((Object)".map(");
                            _builder.append((Object)lambdaParam, "\t");
                            _builder.append((Object)" -> ");
                            _builder.append((Object)lambdaParam, "\t");
                            _builder.append((Object)".getValue())");
                        }
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"\t");
                        _builder.append((Object)".map(");
                        _builder.append((Object)lambdaParam, "\t");
                        _builder.append((Object)" -> new ");
                        _builder.append(Tabulator.NestedFieldValueImpl.class, "\t");
                        _builder.append((Object)"(");
                        GeneratedIdentifier _identifierOrThrow_2 = scope.getIdentifierOrThrow(attr);
                        _builder.append((Object)_identifierOrThrow_2, "\t");
                        _builder.append((Object)", Optional.of(");
                        _builder.append((Object)nestedTabulator, "\t");
                        _builder.append((Object)".tabulate(");
                        _builder.append((Object)lambdaParam, "\t");
                        _builder.append((Object)"))))");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"\t");
                        _builder.append((Object)".orElse(new ");
                        _builder.append(Tabulator.NestedFieldValueImpl.class, "\t");
                        _builder.append((Object)"(");
                        GeneratedIdentifier _identifierOrThrow_3 = scope.getIdentifierOrThrow(attr);
                        _builder.append((Object)_identifierOrThrow_3, "\t");
                        _builder.append((Object)", Optional.empty()));");
                        _builder.newLineIfNotEmpty();
                    }
                }
            });
        } else {
            StringConcatenationClient _client;
            _xifexpression_1 = _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    boolean _not;
                    boolean _hasMeta = attr.getRMetaAnnotatedType().hasMeta();
                    boolean bl = _not = !_hasMeta;
                    if (_not) {
                        _builder.append(Tabulator.FieldValue.class);
                        _builder.append((Object)" ");
                        _builder.append((Object)resultId);
                        _builder.append((Object)" = new ");
                        _builder.append(Tabulator.FieldValueImpl.class);
                        _builder.append((Object)"(");
                        GeneratedIdentifier _identifierOrThrow = scope.getIdentifierOrThrow(attr);
                        _builder.append((Object)_identifierOrThrow);
                        _builder.append((Object)", ");
                        _builder.append(Optional.class);
                        _builder.append((Object)".ofNullable(");
                        _builder.append((Object)inputParam);
                        _builder.append((Object)".");
                        _builder.append((Object)getter);
                        _builder.append((Object)"()));");
                        _builder.newLineIfNotEmpty();
                    } else {
                        boolean _isMulti = attr.isMulti();
                        if (_isMulti) {
                            _builder.append(Tabulator.FieldValue.class);
                            _builder.append((Object)" ");
                            _builder.append((Object)resultId);
                            _builder.append((Object)" = new ");
                            _builder.append(Tabulator.FieldValueImpl.class);
                            _builder.append((Object)"(");
                            GeneratedIdentifier _identifierOrThrow_1 = scope.getIdentifierOrThrow(attr);
                            _builder.append((Object)_identifierOrThrow_1);
                            _builder.append((Object)", ");
                            _builder.append(Optional.class);
                            _builder.append((Object)".ofNullable(");
                            _builder.append((Object)inputParam);
                            _builder.append((Object)".");
                            _builder.append((Object)getter);
                            _builder.append((Object)"())");
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"\t");
                            _builder.append((Object)".map(");
                            _builder.append((Object)lambdaParam, "\t");
                            _builder.append((Object)" -> ");
                            _builder.append((Object)lambdaParam, "\t");
                            _builder.append((Object)".stream()");
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"\t\t");
                            _builder.append((Object)".map(");
                            _builder.append((Object)nestedLambdaParam, "\t\t");
                            _builder.append((Object)" -> ");
                            _builder.append((Object)nestedLambdaParam, "\t\t");
                            _builder.append((Object)".getValue())");
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"\t\t");
                            _builder.append((Object)".filter(");
                            _builder.append(Objects.class, "\t\t");
                            _builder.append((Object)"::nonNull)");
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"\t\t");
                            _builder.append((Object)".collect(");
                            _builder.append(Collectors.class, "\t\t");
                            _builder.append((Object)".toList())));");
                            _builder.newLineIfNotEmpty();
                        } else {
                            _builder.append(Tabulator.FieldValue.class);
                            _builder.append((Object)" ");
                            _builder.append((Object)resultId);
                            _builder.append((Object)" = new ");
                            _builder.append(Tabulator.FieldValueImpl.class);
                            _builder.append((Object)"(");
                            GeneratedIdentifier _identifierOrThrow_2 = scope.getIdentifierOrThrow(attr);
                            _builder.append((Object)_identifierOrThrow_2);
                            _builder.append((Object)", ");
                            _builder.append(Optional.class);
                            _builder.append((Object)".ofNullable(");
                            _builder.append((Object)inputParam);
                            _builder.append((Object)".");
                            _builder.append((Object)getter);
                            _builder.append((Object)"())");
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"\t");
                            _builder.append((Object)".map(");
                            _builder.append((Object)lambdaParam, "\t");
                            _builder.append((Object)" -> ");
                            _builder.append((Object)lambdaParam, "\t");
                            _builder.append((Object)".getValue()));");
                            _builder.newLineIfNotEmpty();
                        }
                    }
                }
            };
        }
        _xblockexpression = _xifexpression_1;
        return _xblockexpression;
    }

    private StringConcatenationClient fieldValuesAsList(final RDataType type, final TabulatorContext context, final JavaScope scope) {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append(Arrays.class);
                _builder.append((Object)".asList(");
                _builder.newLineIfNotEmpty();
                Functions.Function1 _function = it -> context.isTabulated((RAttribute)it);
                Iterable _filter = IterableExtensions.filter(type.getAllAttributes(), (Functions.Function1)_function);
                boolean _hasElements = false;
                for (RAttribute attr : _filter) {
                    if (!_hasElements) {
                        _hasElements = true;
                    } else {
                        _builder.appendImmediate((Object)",", "\t");
                    }
                    _builder.append((Object)"\t");
                    Optional<GeneratedIdentifier> _identifier = scope.getIdentifier(TabulatorGenerator.this.toComputedField(attr));
                    _builder.append(_identifier, "\t");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append((Object)")");
            }
        };
        return _client;
    }

    private StringConcatenationClient toOptionalCode(final Optional<?> object) {
        StringConcatenationClient _client_1;
        StringConcatenationClient _client;
        StringConcatenationClient _xifexpression = null;
        boolean _isPresent = object.isPresent();
        _xifexpression = _isPresent ? (_client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append(Optional.class);
                _builder.append((Object)".of(");
                Object _get = object.get();
                _builder.append(_get);
                _builder.append((Object)")");
            }
        }) : (_client_1 = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append(Optional.class);
                _builder.append((Object)".empty()");
            }
        });
        return _xifexpression;
    }

    private StringConcatenationClient toDottedPathCode(final DottedPath path) {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append(DottedPath.class);
                _builder.append((Object)".of(\"");
                String _withSeparator = path.withSeparator((CharSequence)"\", \"");
                _builder.append((Object)_withSeparator);
                _builder.append((Object)"\")");
            }
        };
        return _client;
    }

    private StringConcatenationClient toModelSymbolCode(final ModelSymbolId symbolId) {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"new ");
                _builder.append(ModelSymbolId.class);
                _builder.append((Object)"(");
                StringConcatenationClient _dottedPathCode = TabulatorGenerator.this.toDottedPathCode(symbolId.getNamespace());
                _builder.append((Object)_dottedPathCode);
                _builder.append((Object)", \"");
                String _name = symbolId.getName();
                _builder.append((Object)_name);
                _builder.append((Object)"\")");
            }
        };
        return _client;
    }

    private NestedTabulatorInstance toNestedTabulatorInstance(RDataType type) {
        return new NestedTabulatorInstance(type);
    }

    private ComputedField toComputedField(RAttribute attr) {
        return new ComputedField(attr);
    }

    @org.eclipse.xtend.lib.annotations.Data
    private static class ReportTabulatorContext
    implements TabulatorContext {
        @Extension
        private final RosettaEcoreUtil _rosettaEcoreUtil;
        @Extension
        private final JavaTypeTranslator _javaTypeTranslator;
        @Extension
        private final RosettaTypeProvider _rosettaTypeProvider;
        private final Map<RAttribute, RosettaRule> ruleMap;
        private final Optional<RosettaExternalRuleSource> ruleSource;

        @Override
        public boolean needsTabulator(RDataType type) {
            return this.needsTabulator(type, CollectionLiterals.newHashSet());
        }

        private boolean needsTabulator(RDataType type, Set<Data> visited) {
            boolean _xifexpression = false;
            boolean _add = visited.add(type.getEObject());
            if (_add) {
                Functions.Function1 _function = it -> this.isTabulated((RAttribute)it, visited);
                _xifexpression = IterableExtensions.exists(type.getAllAttributes(), (Functions.Function1)_function);
            } else {
                _xifexpression = false;
            }
            return _xifexpression;
        }

        @Override
        public boolean isTabulated(RAttribute attr) {
            return this.isTabulated(attr, CollectionLiterals.newHashSet());
        }

        private boolean isTabulated(RAttribute attr, Set<Data> visited) {
            boolean _xblockexpression = false;
            RType rawAttrType = attr.getRMetaAnnotatedType().getRType();
            RType _xifexpression = null;
            _xifexpression = rawAttrType instanceof RChoiceType ? ((RChoiceType)rawAttrType).asRDataType() : rawAttrType;
            RType attrType = _xifexpression;
            boolean _xifexpression_1 = false;
            _xifexpression_1 = attrType instanceof RDataType && this.needsTabulator((RDataType)attrType, visited) ? true : this.ruleMap.containsKey(attr);
            _xblockexpression = _xifexpression_1;
            return _xblockexpression;
        }

        @Override
        public JavaClass<Tabulator<?>> toTabulatorJavaClass(RDataType type) {
            return this._javaTypeTranslator.toTabulatorJavaClass(type.getEObject(), this.ruleSource);
        }

        @Override
        public Optional<RosettaRule> getRule(RAttribute attr) {
            return Optional.ofNullable(this.ruleMap.get(attr));
        }

        @Override
        public com.regnosys.rosetta.rosetta.simple.Function getFunction() {
            throw new UnsupportedOperationException("getFunction not available for ReportTabulatorContext");
        }

        public ReportTabulatorContext(RosettaEcoreUtil _rosettaEcoreUtil, JavaTypeTranslator _javaTypeTranslator, RosettaTypeProvider _rosettaTypeProvider, Map<RAttribute, RosettaRule> ruleMap, Optional<RosettaExternalRuleSource> ruleSource) {
            this._rosettaEcoreUtil = _rosettaEcoreUtil;
            this._javaTypeTranslator = _javaTypeTranslator;
            this._rosettaTypeProvider = _rosettaTypeProvider;
            this.ruleMap = ruleMap;
            this.ruleSource = ruleSource;
        }

        @Pure
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._rosettaEcoreUtil == null ? 0 : this._rosettaEcoreUtil.hashCode());
            result = 31 * result + (this._javaTypeTranslator == null ? 0 : this._javaTypeTranslator.hashCode());
            result = 31 * result + (this._rosettaTypeProvider == null ? 0 : this._rosettaTypeProvider.hashCode());
            result = 31 * result + (this.ruleMap == null ? 0 : this.ruleMap.hashCode());
            return 31 * result + (this.ruleSource == null ? 0 : this.ruleSource.hashCode());
        }

        @Pure
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ReportTabulatorContext other = (ReportTabulatorContext)obj;
            if (this._rosettaEcoreUtil == null ? other._rosettaEcoreUtil != null : !this._rosettaEcoreUtil.equals(other._rosettaEcoreUtil)) {
                return false;
            }
            if (this._javaTypeTranslator == null ? other._javaTypeTranslator != null : !this._javaTypeTranslator.equals(other._javaTypeTranslator)) {
                return false;
            }
            if (this._rosettaTypeProvider == null ? other._rosettaTypeProvider != null : !this._rosettaTypeProvider.equals(other._rosettaTypeProvider)) {
                return false;
            }
            if (this.ruleMap == null ? other.ruleMap != null : !this.ruleMap.equals(other.ruleMap)) {
                return false;
            }
            return !(this.ruleSource == null ? other.ruleSource != null : !this.ruleSource.equals(other.ruleSource));
        }

        @Pure
        public String toString() {
            ToStringBuilder b = new ToStringBuilder((Object)this);
            b.add("_rosettaEcoreUtil", (Object)this._rosettaEcoreUtil);
            b.add("_javaTypeTranslator", (Object)this._javaTypeTranslator);
            b.add("_rosettaTypeProvider", (Object)this._rosettaTypeProvider);
            b.add("ruleMap", this.ruleMap);
            b.add("ruleSource", this.ruleSource);
            return b.toString();
        }

        @Pure
        public RosettaEcoreUtil get_rosettaEcoreUtil() {
            return this._rosettaEcoreUtil;
        }

        @Pure
        public JavaTypeTranslator get_javaTypeTranslator() {
            return this._javaTypeTranslator;
        }

        @Pure
        public RosettaTypeProvider get_rosettaTypeProvider() {
            return this._rosettaTypeProvider;
        }

        @Pure
        public Map<RAttribute, RosettaRule> getRuleMap() {
            return this.ruleMap;
        }

        @Pure
        public Optional<RosettaExternalRuleSource> getRuleSource() {
            return this.ruleSource;
        }
    }

    private static interface TabulatorContext {
        public boolean needsTabulator(RDataType var1);

        public boolean isTabulated(RAttribute var1);

        public JavaClass<Tabulator<?>> toTabulatorJavaClass(RDataType var1);

        public Optional<RosettaRule> getRule(RAttribute var1);

        public com.regnosys.rosetta.rosetta.simple.Function getFunction();
    }

    @org.eclipse.xtend.lib.annotations.Data
    private static class DataTabulatorContext
    implements TabulatorContext {
        @Extension
        private final JavaTypeTranslator typeTranslator;

        @Override
        public boolean needsTabulator(RDataType type) {
            return true;
        }

        @Override
        public boolean isTabulated(RAttribute attr) {
            return true;
        }

        @Override
        public JavaClass<Tabulator<?>> toTabulatorJavaClass(RDataType type) {
            return this.typeTranslator.toTabulatorJavaClass(type);
        }

        @Override
        public Optional<RosettaRule> getRule(RAttribute attr) {
            return Optional.empty();
        }

        @Override
        public com.regnosys.rosetta.rosetta.simple.Function getFunction() {
            throw new UnsupportedOperationException("TODO: remove");
        }

        public DataTabulatorContext(JavaTypeTranslator typeTranslator) {
            this.typeTranslator = typeTranslator;
        }

        @Pure
        public int hashCode() {
            return 31 + (this.typeTranslator == null ? 0 : this.typeTranslator.hashCode());
        }

        @Pure
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DataTabulatorContext other = (DataTabulatorContext)obj;
            return !(this.typeTranslator == null ? other.typeTranslator != null : !this.typeTranslator.equals(other.typeTranslator));
        }

        @Pure
        public String toString() {
            ToStringBuilder b = new ToStringBuilder((Object)this);
            b.add("typeTranslator", (Object)this.typeTranslator);
            return b.toString();
        }

        @Pure
        public JavaTypeTranslator getTypeTranslator() {
            return this.typeTranslator;
        }
    }

    @Deprecated
    @org.eclipse.xtend.lib.annotations.Data
    private static class ProjectionTabulatorContext
    implements TabulatorContext {
        @Extension
        private final JavaTypeTranslator _javaTypeTranslator;
        private final com.regnosys.rosetta.rosetta.simple.Function projection;

        @Override
        public boolean needsTabulator(RDataType type) {
            return true;
        }

        @Override
        public boolean isTabulated(RAttribute attr) {
            return true;
        }

        @Override
        public JavaClass<Tabulator<?>> toTabulatorJavaClass(RDataType type) {
            return this._javaTypeTranslator.toProjectionTabulatorJavaClass(type.getEObject(), this.projection);
        }

        @Override
        public Optional<RosettaRule> getRule(RAttribute attr) {
            return Optional.empty();
        }

        @Override
        public com.regnosys.rosetta.rosetta.simple.Function getFunction() {
            return this.projection;
        }

        public ProjectionTabulatorContext(JavaTypeTranslator _javaTypeTranslator, com.regnosys.rosetta.rosetta.simple.Function projection) {
            this._javaTypeTranslator = _javaTypeTranslator;
            this.projection = projection;
        }

        @Pure
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._javaTypeTranslator == null ? 0 : this._javaTypeTranslator.hashCode());
            return 31 * result + (this.projection == null ? 0 : this.projection.hashCode());
        }

        @Pure
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ProjectionTabulatorContext other = (ProjectionTabulatorContext)obj;
            if (this._javaTypeTranslator == null ? other._javaTypeTranslator != null : !this._javaTypeTranslator.equals(other._javaTypeTranslator)) {
                return false;
            }
            return !(this.projection == null ? other.projection != null : !this.projection.equals(other.projection));
        }

        @Pure
        public String toString() {
            ToStringBuilder b = new ToStringBuilder((Object)this);
            b.add("_javaTypeTranslator", (Object)this._javaTypeTranslator);
            b.add("projection", (Object)this.projection);
            return b.toString();
        }

        @Pure
        public JavaTypeTranslator get_javaTypeTranslator() {
            return this._javaTypeTranslator;
        }

        @Pure
        public com.regnosys.rosetta.rosetta.simple.Function getProjection() {
            return this.projection;
        }
    }

    @org.eclipse.xtend.lib.annotations.Data
    private static class FunctionTabulatorContext
    implements TabulatorContext {
        @Extension
        private final JavaTypeTranslator _javaTypeTranslator;
        private final com.regnosys.rosetta.rosetta.simple.Function function;

        @Override
        public boolean needsTabulator(RDataType type) {
            return true;
        }

        @Override
        public boolean isTabulated(RAttribute attr) {
            return true;
        }

        @Override
        public JavaClass<Tabulator<?>> toTabulatorJavaClass(RDataType type) {
            return this._javaTypeTranslator.toTabulatorJavaClass(type.getEObject(), this.function);
        }

        @Override
        public Optional<RosettaRule> getRule(RAttribute attr) {
            return Optional.empty();
        }

        public FunctionTabulatorContext(JavaTypeTranslator _javaTypeTranslator, com.regnosys.rosetta.rosetta.simple.Function function) {
            this._javaTypeTranslator = _javaTypeTranslator;
            this.function = function;
        }

        @Pure
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._javaTypeTranslator == null ? 0 : this._javaTypeTranslator.hashCode());
            return 31 * result + (this.function == null ? 0 : this.function.hashCode());
        }

        @Pure
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FunctionTabulatorContext other = (FunctionTabulatorContext)obj;
            if (this._javaTypeTranslator == null ? other._javaTypeTranslator != null : !this._javaTypeTranslator.equals(other._javaTypeTranslator)) {
                return false;
            }
            return !(this.function == null ? other.function != null : !this.function.equals(other.function));
        }

        @Pure
        public String toString() {
            ToStringBuilder b = new ToStringBuilder((Object)this);
            b.add("_javaTypeTranslator", (Object)this._javaTypeTranslator);
            b.add("function", (Object)this.function);
            return b.toString();
        }

        @Pure
        public JavaTypeTranslator get_javaTypeTranslator() {
            return this._javaTypeTranslator;
        }

        @Override
        @Pure
        public com.regnosys.rosetta.rosetta.simple.Function getFunction() {
            return this.function;
        }
    }

    @org.eclipse.xtend.lib.annotations.Data
    private static class ComputedField {
        private final RAttribute attribute;

        public ComputedField(RAttribute attribute) {
            this.attribute = attribute;
        }

        @Pure
        public int hashCode() {
            return 31 + (this.attribute == null ? 0 : this.attribute.hashCode());
        }

        @Pure
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ComputedField other = (ComputedField)obj;
            return !(this.attribute == null ? other.attribute != null : !this.attribute.equals(other.attribute));
        }

        @Pure
        public String toString() {
            ToStringBuilder b = new ToStringBuilder((Object)this);
            b.add("attribute", (Object)this.attribute);
            return b.toString();
        }

        @Pure
        public RAttribute getAttribute() {
            return this.attribute;
        }
    }

    @org.eclipse.xtend.lib.annotations.Data
    private static class NestedTabulatorInstance {
        private final RDataType type;

        public NestedTabulatorInstance(RDataType type) {
            this.type = type;
        }

        @Pure
        public int hashCode() {
            return 31 + (this.type == null ? 0 : this.type.hashCode());
        }

        @Pure
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            NestedTabulatorInstance other = (NestedTabulatorInstance)obj;
            return !(this.type == null ? other.type != null : !this.type.equals(other.type));
        }

        @Pure
        public String toString() {
            ToStringBuilder b = new ToStringBuilder((Object)this);
            b.add("type", (Object)this.type);
            return b.toString();
        }

        @Pure
        public RDataType getType() {
            return this.type;
        }
    }
}

