/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.generator.java.object;

import com.google.common.collect.Iterables;
import com.regnosys.rosetta.RosettaEcoreUtil;
import com.regnosys.rosetta.generator.java.JavaScope;
import com.regnosys.rosetta.generator.java.RosettaJavaPackages;
import com.regnosys.rosetta.generator.java.types.JavaPojoInterface;
import com.regnosys.rosetta.generator.java.types.JavaTypeTranslator;
import com.regnosys.rosetta.generator.java.util.ImportManagerExtension;
import com.regnosys.rosetta.generator.java.util.ModelGeneratorUtil;
import com.regnosys.rosetta.generator.util.RosettaFunctionExtensions;
import com.regnosys.rosetta.rosetta.RosettaModel;
import com.regnosys.rosetta.rosetta.RosettaNamed;
import com.regnosys.rosetta.rosetta.simple.Condition;
import com.regnosys.rosetta.rosetta.simple.Data;
import com.regnosys.rosetta.types.RDataType;
import com.regnosys.rosetta.utils.ModelIdProvider;
import com.regnosys.rosetta.utils.RosettaConfigExtension;
import com.rosetta.model.lib.annotations.RosettaMeta;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.qualify.QualifyFunctionFactory;
import com.rosetta.model.lib.qualify.QualifyResult;
import com.rosetta.model.lib.validation.Validator;
import com.rosetta.model.lib.validation.ValidatorFactory;
import com.rosetta.model.lib.validation.ValidatorWithArg;
import com.rosetta.util.DottedPath;
import com.rosetta.util.types.JavaClass;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import javax.inject.Inject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.generator.IFileSystemAccess2;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

public class ModelMetaGenerator {
    @Inject
    @Extension
    private ImportManagerExtension _importManagerExtension;
    @Inject
    @Extension
    private RosettaEcoreUtil _rosettaEcoreUtil;
    @Inject
    private RosettaConfigExtension confExt;
    @Inject
    private RosettaFunctionExtensions funcExt;
    @Inject
    @Extension
    private JavaTypeTranslator _javaTypeTranslator;
    @Inject
    @Extension
    private ModelIdProvider _modelIdProvider;

    public void generate(RosettaJavaPackages.RootPackage root, IFileSystemAccess2 fsa, RDataType t, String version) {
        StringConcatenation _builder = new StringConcatenation();
        String _name = t.getName();
        _builder.append(_name);
        _builder.append("Meta");
        String className = _builder.toString();
        DottedPath _meta = root.meta();
        JavaScope scope = new JavaScope(_meta);
        StringConcatenationClient classBody = this.metaClassBody(t, root, className, version);
        String javaFileContents = this._importManagerExtension.buildClass(root.meta(), classBody, scope);
        StringConcatenation _builder_1 = new StringConcatenation();
        String _withForwardSlashes = root.meta().withForwardSlashes();
        _builder_1.append(_withForwardSlashes);
        _builder_1.append("/");
        _builder_1.append(className);
        _builder_1.append(".java");
        fsa.generateFile(_builder_1.toString(), (CharSequence)javaFileContents);
    }

    private StringConcatenationClient metaClassBody(RDataType t, RosettaJavaPackages.RootPackage root, final String className, final String version) {
        StringConcatenationClient _client;
        StringConcatenationClient _xblockexpression = null;
        final JavaPojoInterface dataClass = this._javaTypeTranslator.toJavaType(t);
        final JavaClass<?> validator = this._javaTypeTranslator.toValidatorClass(dataClass);
        final JavaClass<?> typeFormatValidator = this._javaTypeTranslator.toTypeFormatValidatorClass(dataClass);
        final JavaClass<?> onlyExistsValidator = this._javaTypeTranslator.toOnlyExistsValidatorClass(dataClass);
        ResourceSet context = t.getEObject().eResource().getResourceSet();
        Functions.Function1 _function = it -> {
            EObject _head = (EObject)IterableExtensions.head((Iterable)it.getContents());
            return (RosettaModel)_head;
        };
        final Set<com.regnosys.rosetta.rosetta.simple.Function> qualifierFuncs = this.qualifyFuncs(t.getEObject(), IterableExtensions.toSet((Iterable)ListExtensions.map((List)context.getResources(), (Functions.Function1)_function)));
        Functions.Function1 _function_1 = it -> this.conditionRules((RDataType)it, (List<Condition>)it.getEObject().getConditions());
        final Iterable conditions = Iterables.concat((Iterable)ListExtensions.map(t.getAllSuperTypes(), (Functions.Function1)_function_1));
        _xblockexpression = _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                boolean _not;
                CharSequence _emptyJavadocWithVersion = ModelGeneratorUtil.emptyJavadocWithVersion(version);
                _builder.append((Object)_emptyJavadocWithVersion);
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"@");
                _builder.append(RosettaMeta.class);
                _builder.append((Object)"(model=");
                _builder.append((Object)dataClass);
                _builder.append((Object)".class)");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"public class ");
                _builder.append((Object)className);
                _builder.append((Object)" implements ");
                _builder.append(RosettaMetaData.class);
                _builder.append((Object)"<");
                _builder.append((Object)dataClass);
                _builder.append((Object)"> {");
                _builder.newLineIfNotEmpty();
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"@Override");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"public ");
                _builder.append(List.class, "\t");
                _builder.append((Object)"<");
                _builder.append(Validator.class, "\t");
                _builder.append((Object)"<? super ");
                _builder.append((Object)dataClass, "\t");
                _builder.append((Object)">> dataRules(");
                _builder.append(ValidatorFactory.class, "\t");
                _builder.append((Object)" factory) {");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"return ");
                _builder.append(Arrays.class, "\t\t");
                _builder.append((Object)".asList(");
                _builder.newLineIfNotEmpty();
                boolean _hasElements = false;
                for (ClassRule r : conditions) {
                    if (!_hasElements) {
                        _hasElements = true;
                    } else {
                        _builder.appendImmediate((Object)",", "\t\t\t");
                    }
                    _builder.append((Object)"\t\t\t");
                    DottedPath containingClassName = r.containingClassNamespace.child(r.className);
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t\t\t");
                    DottedPath conditionClassName = r.containingClassNamespace.condition().child(ModelMetaGenerator.this._rosettaEcoreUtil.toConditionJavaType(r.conditionName));
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t\t\t");
                    _builder.append((Object)"factory.<");
                    _builder.append((Object)containingClassName, "\t\t\t");
                    _builder.append((Object)">create(");
                    _builder.append((Object)conditionClassName, "\t\t\t");
                    _builder.append((Object)".class)");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append((Object)"\t\t");
                _builder.append((Object)");");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"@Override");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"public ");
                _builder.append(List.class, "\t");
                _builder.append((Object)"<");
                _builder.append(Function.class, "\t");
                _builder.append((Object)"<? super ");
                _builder.append((Object)dataClass, "\t");
                _builder.append((Object)", ");
                _builder.append(QualifyResult.class, "\t");
                _builder.append((Object)">> getQualifyFunctions(");
                _builder.append(QualifyFunctionFactory.class, "\t");
                _builder.append((Object)" factory) {");
                _builder.newLineIfNotEmpty();
                boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty((Iterable)qualifierFuncs);
                boolean bl = _not = !_isNullOrEmpty;
                if (_not) {
                    _builder.append((Object)"\t\t");
                    _builder.append((Object)"return Arrays.asList(");
                    _builder.newLine();
                    boolean _hasElements_1 = false;
                    for (com.regnosys.rosetta.rosetta.simple.Function qf : qualifierFuncs) {
                        if (!_hasElements_1) {
                            _hasElements_1 = true;
                        } else {
                            _builder.appendImmediate((Object)",", "\t\t\t");
                        }
                        _builder.append((Object)"\t\t");
                        _builder.append((Object)"\t");
                        _builder.append((Object)"factory.<");
                        _builder.append((Object)dataClass, "\t\t\t");
                        _builder.append((Object)">create(");
                        JavaClass<RosettaFunction> _functionJavaClass = ModelMetaGenerator.this._javaTypeTranslator.toFunctionJavaClass(qf);
                        _builder.append(_functionJavaClass, "\t\t\t");
                        _builder.append((Object)".class)");
                        _builder.newLineIfNotEmpty();
                    }
                    _builder.append((Object)"\t\t");
                    _builder.append((Object)");");
                    _builder.newLine();
                } else {
                    _builder.append((Object)"\t\t");
                    _builder.append((Object)"return ");
                    _builder.append(Collections.class, "\t\t");
                    _builder.append((Object)".emptyList();");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append((Object)"\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"@Override");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"public ");
                _builder.append(Validator.class, "\t");
                _builder.append((Object)"<? super ");
                _builder.append((Object)dataClass, "\t");
                _builder.append((Object)"> validator() {");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"return new ");
                _builder.append((Object)validator, "\t\t");
                _builder.append((Object)"();");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"@Override");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"public ");
                _builder.append(Validator.class, "\t");
                _builder.append((Object)"<? super ");
                _builder.append((Object)dataClass, "\t");
                _builder.append((Object)"> typeFormatValidator() {");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"return new ");
                _builder.append((Object)typeFormatValidator, "\t\t");
                _builder.append((Object)"();");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"@Override");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"public ");
                _builder.append(ValidatorWithArg.class, "\t");
                _builder.append((Object)"<? super ");
                _builder.append((Object)dataClass, "\t");
                _builder.append((Object)", ");
                _builder.append(Set.class, "\t");
                _builder.append((Object)"<String>> onlyExistsValidator() {");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"return new ");
                _builder.append((Object)onlyExistsValidator, "\t\t");
                _builder.append((Object)"();");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"}");
                _builder.newLine();
            }
        };
        return _xblockexpression;
    }

    private Set<com.regnosys.rosetta.rosetta.simple.Function> qualifyFuncs(Data type, Set<RosettaModel> models) {
        boolean _not;
        boolean _isRootEventOrProduct = this.confExt.isRootEventOrProduct(type);
        boolean bl = _not = !_isRootEventOrProduct;
        if (_not) {
            return CollectionLiterals.emptySet();
        }
        Functions.Function1 _function = it -> it.getElements();
        Set funcs = IterableExtensions.toSet((Iterable)Iterables.filter((Iterable)IterableExtensions.flatMap(models, (Functions.Function1)_function), com.regnosys.rosetta.rosetta.simple.Function.class));
        Functions.Function1 _function_1 = it -> this.funcExt.isQualifierFunctionFor((com.regnosys.rosetta.rosetta.simple.Function)it, type);
        return IterableExtensions.toSet((Iterable)IterableExtensions.filter((Iterable)funcs, (Functions.Function1)_function_1));
    }

    private List<ClassRule> conditionRules(RDataType t, List<Condition> elements) {
        DottedPath _dottedPath = this._modelIdProvider.toDottedPath(t.getEObject().getModel());
        RosettaJavaPackages.RootPackage dataNamespace = new RosettaJavaPackages.RootPackage(_dottedPath);
        Functions.Function1 _function = it -> {
            EObject _eContainer = it.eContainer();
            String _name = ((RosettaNamed)_eContainer).getName();
            String _conditionName = this._rosettaEcoreUtil.conditionName((Condition)it, t);
            return new ClassRule(_name, _conditionName, dataNamespace);
        };
        return IterableExtensions.toList((Iterable)ListExtensions.map(elements, (Functions.Function1)_function));
    }

    @org.eclipse.xtend.lib.annotations.Data
    public static class ClassRule {
        private final String className;
        private final String conditionName;
        private final RosettaJavaPackages.RootPackage containingClassNamespace;

        public ClassRule(String className, String conditionName, RosettaJavaPackages.RootPackage containingClassNamespace) {
            this.className = className;
            this.conditionName = conditionName;
            this.containingClassNamespace = containingClassNamespace;
        }

        @Pure
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.className == null ? 0 : this.className.hashCode());
            result = 31 * result + (this.conditionName == null ? 0 : this.conditionName.hashCode());
            return 31 * result + (this.containingClassNamespace == null ? 0 : this.containingClassNamespace.hashCode());
        }

        @Pure
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ClassRule other = (ClassRule)obj;
            if (this.className == null ? other.className != null : !this.className.equals(other.className)) {
                return false;
            }
            if (this.conditionName == null ? other.conditionName != null : !this.conditionName.equals(other.conditionName)) {
                return false;
            }
            return !(this.containingClassNamespace == null ? other.containingClassNamespace != null : !this.containingClassNamespace.equals((Object)other.containingClassNamespace));
        }

        @Pure
        public String toString() {
            ToStringBuilder b = new ToStringBuilder((Object)this);
            b.add("className", (Object)this.className);
            b.add("conditionName", (Object)this.conditionName);
            b.add("containingClassNamespace", (Object)this.containingClassNamespace);
            return b.toString();
        }

        @Pure
        public String getClassName() {
            return this.className;
        }

        @Pure
        public String getConditionName() {
            return this.conditionName;
        }

        @Pure
        public RosettaJavaPackages.RootPackage getContainingClassNamespace() {
            return this.containingClassNamespace;
        }
    }
}

