/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.generator.java;

import com.regnosys.rosetta.generator.GeneratedIdentifier;
import com.regnosys.rosetta.generator.GeneratorScope;
import com.rosetta.util.DottedPath;
import com.rosetta.util.types.JavaClass;
import com.rosetta.util.types.JavaType;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import javax.lang.model.SourceVersion;

public class JavaScope
extends GeneratorScope<JavaScope> {
    private final Set<DottedPath> defaultPackages = new HashSet<DottedPath>();

    public JavaScope(DottedPath packageName) {
        super("Package[" + packageName.withDots() + "]");
        this.defaultPackages.add(DottedPath.of((String[])new String[]{"java", "lang"}));
        this.defaultPackages.add(packageName);
    }

    protected JavaScope(String description, JavaScope parent) {
        super(description, parent);
    }

    @Override
    public JavaScope childScope(String description) {
        return new JavaScope(description, this);
    }

    public JavaScope classScope(String className) {
        return this.childScope("Class[" + className + "]");
    }

    public JavaScope methodScope(String methodName) {
        return this.childScope("Method[" + methodName + "]");
    }

    public JavaScope lambdaScope() {
        return this.childScope("Lambda[]");
    }

    @Override
    public boolean isValidIdentifier(String name) {
        return SourceVersion.isName(name);
    }

    @Override
    public Optional<GeneratedIdentifier> getIdentifier(Object obj) {
        return super.getIdentifier(obj).or(() -> {
            JavaType t = JavaType.from((Object)obj);
            if (t != null && t instanceof JavaClass) {
                JavaClass clazz = (JavaClass)t;
                String desiredName = clazz.getSimpleName();
                if (this.getIdentifiers().stream().anyMatch(id -> id.getDesiredName().equals(desiredName))) {
                    return Optional.of(this.overwriteIdentifier(clazz, clazz.getCanonicalName().withDots()));
                }
                if (this.defaultPackages.contains(clazz.getPackageName())) {
                    return Optional.of(this.overwriteIdentifier(clazz, clazz.getSimpleName()));
                }
                return Optional.empty();
            }
            return Optional.empty();
        });
    }
}

