/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.config;

import com.google.inject.ProvidedBy;
import com.regnosys.rosetta.config.RosettaConfiguration;
import com.regnosys.rosetta.config.RosettaTabulatorConfiguration;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import javax.inject.Inject;

@ProvidedBy(value=Provider.class)
public class RosettaGeneratorsConfiguration {
    private final Predicate<String> namespaceFilter;
    private final RosettaTabulatorConfiguration rosettaTabulatorConfiguration;

    public RosettaGeneratorsConfiguration() {
        this(n -> true, new RosettaTabulatorConfiguration(List.of(), List.of()));
    }

    public RosettaGeneratorsConfiguration(Predicate<String> namespaceFilter, RosettaTabulatorConfiguration tabulators) {
        Objects.requireNonNull(namespaceFilter);
        Objects.requireNonNull(tabulators);
        this.namespaceFilter = namespaceFilter;
        this.rosettaTabulatorConfiguration = tabulators;
    }

    public Predicate<String> getNamespaceFilter() {
        return this.namespaceFilter;
    }

    public RosettaTabulatorConfiguration getTabulators() {
        return this.rosettaTabulatorConfiguration;
    }

    public static class Provider
    implements javax.inject.Provider<RosettaGeneratorsConfiguration> {
        private final RosettaConfiguration config;

        @Inject
        public Provider(RosettaConfiguration config) {
            this.config = config;
        }

        public RosettaGeneratorsConfiguration get() {
            return this.config.getGenerators();
        }
    }
}

