/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.tests.util;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.regnosys.rosetta.rosetta.expression.RosettaExpression;
import com.regnosys.rosetta.validation.AbstractRosettaValidator;
import com.regnosys.rosetta.validation.ReportValidator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.util.IAcceptor;
import org.eclipse.xtext.validation.IDiagnosticConverter;
import org.eclipse.xtext.validation.Issue;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.junit.jupiter.api.Assertions;

public class ExpressionValidationHelper {
    @Inject
    @Extension
    private ReportValidator _reportValidator;
    @Inject
    @Named(value="languageName")
    private String languageName;
    @Inject
    private IDiagnosticConverter converter;

    public List<Issue> validateExpression(RosettaExpression expr) {
        boolean _not;
        BasicDiagnostic diagnostic = new BasicDiagnostic();
        Pair _mappedTo = Pair.of((Object)AbstractRosettaValidator.CURRENT_LANGUAGE_NAME, (Object)this.languageName);
        this._reportValidator.validate((EObject)expr, (DiagnosticChain)diagnostic, Collections.unmodifiableMap(CollectionLiterals.newHashMap((Pair[])new Pair[]{_mappedTo})));
        final ArrayList issues = CollectionLiterals.newArrayList();
        IAcceptor<Issue> acc = new IAcceptor<Issue>(){

            public void accept(Issue t) {
                issues.add(t);
            }
        };
        boolean _isEmpty = diagnostic.getChildren().isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            List _children = diagnostic.getChildren();
            for (Diagnostic childDiagnostic : _children) {
                this.converter.convertValidatorDiagnostic(childDiagnostic, (IAcceptor)acc);
            }
        } else {
            this.converter.convertValidatorDiagnostic((Diagnostic)diagnostic, (IAcceptor)acc);
        }
        return issues;
    }

    public void assertNoIssues(RosettaExpression expr) {
        boolean _not;
        List<Issue> issues = this.validateExpression(expr);
        boolean _isEmpty = Iterables.isEmpty(issues);
        boolean bl = _not = !_isEmpty;
        if (_not) {
            StringBuilder _stringBuilder = new StringBuilder();
            StringBuilder _issuesAsString = this.getIssuesAsString(issues, _stringBuilder);
            String _plus = "Expected no issues, but got :" + _issuesAsString;
            Assertions.fail((String)_plus);
        }
    }

    public void assertWarning(RosettaExpression expr, String code, String message) {
        this.assertIssue(Severity.WARNING, expr, code, message);
    }

    public void assertError(RosettaExpression expr, String code, String message) {
        this.assertIssue(Severity.ERROR, expr, code, message);
    }

    public void assertIssue(Severity severity, RosettaExpression expr, String code, String message) {
        Functions.Function1 _function;
        List<Issue> allIssues = this.validateExpression(expr);
        Iterable matchingIssues = IterableExtensions.filter(allIssues, (Functions.Function1)(_function = it -> Objects.equal((Object)it.getCode(), (Object)code) && Objects.equal((Object)it.getSeverity(), (Object)severity) && Objects.equal((Object)it.getMessage(), (Object)message)));
        boolean _isEmpty = Iterables.isEmpty((Iterable)matchingIssues);
        if (_isEmpty) {
            StringBuilder errMessage = new StringBuilder("Expected [").append(severity).append(" (").append(code).append(") '").append(message).append("'] but got\n");
            this.getIssuesAsString(allIssues, errMessage);
            Assertions.fail((String)errMessage.toString());
        }
    }

    protected StringBuilder getIssuesAsString(Iterable<Issue> issues, StringBuilder result) {
        boolean _isEmpty = Iterables.isEmpty(issues);
        if (_isEmpty) {
            result.append("(no issues)\n");
        }
        for (Issue issue : issues) {
            result.append(issue.getSeverity());
            result.append(" (");
            result.append(issue.getCode());
            result.append(") '");
            result.append(issue.getMessage());
            result.append("'");
            Integer _offset = issue.getOffset();
            String _plus = ", offset " + _offset;
            String _plus_1 = _plus + ", length ";
            Integer _length = issue.getLength();
            String _plus_2 = _plus_1 + _length;
            result.append(_plus_2);
            result.append("\n");
        }
        return result;
    }
}

