/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.tests.util;

import com.google.common.collect.Iterables;
import com.regnosys.rosetta.rosetta.RosettaModel;
import com.regnosys.rosetta.rosetta.expression.RosettaExpression;
import com.regnosys.rosetta.rosetta.simple.Attribute;
import com.regnosys.rosetta.scoping.RosettaScopeProvider;
import com.regnosys.rosetta.services.RosettaGrammarAccess;
import com.regnosys.rosetta.tests.util.ModelHelper;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Provider;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.diagnostics.IDiagnosticConsumer;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.linking.ILinkingService;
import org.eclipse.xtext.linking.impl.DefaultLinkingService;
import org.eclipse.xtext.linking.lazy.LazyLinker;
import org.eclipse.xtext.linking.lazy.LazyLinkingResource;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.parser.IParser;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.resource.impl.ListBasedDiagnosticConsumer;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.IScopeProvider;
import org.eclipse.xtext.scoping.Scopes;
import org.eclipse.xtext.scoping.impl.ImportNormalizer;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.junit.jupiter.api.Assertions;

public class ExpressionParser {
    @Inject
    private IParser parser;
    @Inject
    private RosettaGrammarAccess grammar;
    @Inject
    private ModelHelper modelHelper;
    @Inject
    private Provider<XtextResource> resourceProvider;
    @Inject
    private RosettaStaticLinker linker;

    public RosettaExpression parseExpression(CharSequence expr) {
        return this.parseExpression(expr, CollectionLiterals.emptyList());
    }

    public RosettaExpression parseExpression(CharSequence expr, Collection<? extends CharSequence> attrs) {
        return this.parseExpression(expr, (List<RosettaModel>)CollectionLiterals.emptyList(), attrs);
    }

    public RosettaExpression parseExpression(CharSequence expr, List<RosettaModel> context, Collection<? extends CharSequence> attrs) {
        Functions.Function1 _function = it -> this.parseAttribute((CharSequence)it, context);
        List attributes = IterableExtensions.toList((Iterable)IterableExtensions.map(attrs, (Functions.Function1)_function));
        return this.parseExpression(expr, context, (Attribute[])Conversions.unwrapArray((Object)attributes, Attribute.class));
    }

    public RosettaExpression parseExpression(CharSequence expr, Attribute ... attributes) {
        return this.parseExpression(expr, (List<RosettaModel>)CollectionLiterals.emptyList(), attributes);
    }

    public RosettaExpression parseExpression(CharSequence expr, List<RosettaModel> context, Attribute ... attributes) {
        List<RosettaModel> _xifexpression = null;
        boolean _isEmpty = context.isEmpty();
        _xifexpression = _isEmpty ? this.defaultContext() : context;
        List<RosettaModel> cont = _xifexpression;
        ParserRule _rosettaCalcExpressionRule = this.grammar.getRosettaCalcExpressionRule();
        String _string = expr.toString();
        StringReader _stringReader = new StringReader(_string);
        IParseResult result = this.parser.parse(_rosettaCalcExpressionRule, (Reader)_stringReader);
        Assertions.assertFalse((boolean)result.hasSyntaxErrors());
        EObject _rootASTElement = result.getRootASTElement();
        RosettaExpression expression = (RosettaExpression)_rootASTElement;
        this.createResource("expr", (EObject)expression, cont);
        this.link((EObject)expression, cont, (Collection)Conversions.doWrapArray((Object)attributes));
        return expression;
    }

    public Attribute parseAttribute(CharSequence attr) {
        return this.parseAttribute(attr, this.defaultContext());
    }

    public Attribute parseAttribute(CharSequence attr, List<RosettaModel> context) {
        List<RosettaModel> _xifexpression = null;
        boolean _isEmpty = context.isEmpty();
        _xifexpression = _isEmpty ? this.defaultContext() : context;
        List<RosettaModel> cont = _xifexpression;
        ParserRule _attributeRule = this.grammar.getAttributeRule();
        String _string = attr.toString();
        StringReader _stringReader = new StringReader(_string);
        IParseResult result = this.parser.parse(_attributeRule, (Reader)_stringReader);
        Assertions.assertFalse((boolean)result.hasSyntaxErrors());
        EObject _rootASTElement = result.getRootASTElement();
        Attribute attribute = (Attribute)_rootASTElement;
        this.createResource("attribute", (EObject)attribute, cont);
        this.link((EObject)attribute, context, CollectionLiterals.emptyList());
        return attribute;
    }

    private Resource createResource(String name, EObject content, List<RosettaModel> context) {
        XtextResource _xblockexpression = null;
        ResourceSet resourceSet = ((RosettaModel)IterableExtensions.head(context)).eResource().getResourceSet();
        int nr = 0;
        int _plusPlus = nr++;
        String _plus = "synthetic://" + name + Integer.valueOf(_plusPlus);
        URI uniqueURI = URI.createURI((String)_plus);
        while (resourceSet.getResource(uniqueURI, false) != null) {
            int _plusPlus_1 = nr++;
            String _plus_1 = "synthetic://" + name + Integer.valueOf(_plusPlus_1);
            uniqueURI = URI.createURI((String)_plus_1);
        }
        XtextResource resource = (XtextResource)this.resourceProvider.get();
        resource.setURI(uniqueURI);
        resource.getContents().add((Object)content);
        resourceSet.getResources().add((Object)resource);
        _xblockexpression = resource;
        return _xblockexpression;
    }

    private List<RosettaModel> defaultContext() {
        Functions.Function1 _function = it -> {
            EObject _head = (EObject)IterableExtensions.head((Iterable)it.getContents());
            return (RosettaModel)_head;
        };
        return CollectionLiterals.newArrayList((Object[])((RosettaModel[])Conversions.unwrapArray((Object)ListExtensions.map((List)this.modelHelper.testResourceSet().getResources(), (Functions.Function1)_function), RosettaModel.class)));
    }

    private void link(EObject obj, List<RosettaModel> context, Collection<? extends EObject> globals) {
        this.linker.setStateForNextLink(context, globals);
        ListBasedDiagnosticConsumer consumer = new ListBasedDiagnosticConsumer();
        this.linker.linkModel(obj, (IDiagnosticConsumer)consumer);
        obj.eResource().getErrors().addAll((Collection)consumer.getResult(Severity.ERROR));
    }

    private static class RosettaStaticLinker
    extends LazyLinker {
        @Inject
        private RosettaContextBasedScopeProvider scopeProvider;
        private IScope staticScope = IScope.NULLSCOPE;

        private RosettaStaticLinker() {
        }

        public void setStateForNextLink(List<RosettaModel> context, Collection<? extends EObject> globals) {
            this.scopeProvider.setContext(context);
            this.staticScope = Scopes.scopeFor(globals);
        }

        private void clearState() {
            this.scopeProvider.setContext(CollectionLiterals.emptyList());
            this.staticScope = IScope.NULLSCOPE;
        }

        protected void doLinkModel(EObject root, IDiagnosticConsumer consumer) {
            Resource _eResource = root.eResource();
            ILinkingService _linkingService = ((LazyLinkingResource)_eResource).getLinkingService();
            ((DefaultLinkingService)_linkingService).setScopeProvider((IScopeProvider)this.scopeProvider);
            super.doLinkModel(root, consumer);
            EcoreUtil2.resolveAll((EObject)root);
            this.clearState();
        }

        protected void createAndSetProxy(EObject obj, INode node, EReference eRef) {
            String varName = NodeModelUtils.getTokenText((INode)node);
            IEObjectDescription staticElement = this.staticScope.getSingleElement(QualifiedName.create((String)varName));
            if (staticElement != null) {
                EObject resolved = staticElement.getEObjectOrProxy();
                boolean _isMany = eRef.isMany();
                if (_isMany) {
                    Object _eGet = obj.eGet((EStructuralFeature)eRef, false);
                    ((InternalEList)_eGet).addUnique((Object)resolved);
                } else {
                    obj.eSet((EStructuralFeature)eRef, (Object)resolved);
                }
            } else {
                super.createAndSetProxy(obj, node, eRef);
            }
        }
    }

    private static class RosettaContextBasedScopeProvider
    extends RosettaScopeProvider {
        private List<RosettaModel> context = CollectionLiterals.emptyList();

        private RosettaContextBasedScopeProvider() {
        }

        public void setContext(List<RosettaModel> context) {
            this.context = context;
        }

        protected List<ImportNormalizer> getImplicitImports(boolean ignoreCase) {
            List _implicitImports = super.getImplicitImports(ignoreCase);
            Functions.Function1 _function = it -> it.getName();
            Functions.Function1 _function_1 = it -> this.createImportedNamespaceResolver(it + ".*", ignoreCase);
            Iterable _map = IterableExtensions.map((Iterable)IterableExtensions.toSet((Iterable)ListExtensions.map(this.context, (Functions.Function1)_function)), (Functions.Function1)_function_1);
            return IterableExtensions.toList((Iterable)Iterables.concat((Iterable)_implicitImports, (Iterable)_map));
        }
    }
}

