/*
 * Decompiled with CFR 0.152.
 */
package com.rosetta.util;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public class BreadthFirstSearch {
    public static <T> List<T> search(T start, Function<T, Collection<T>> nextFunction, Predicate<T> matcher) {
        HashSet<Object> visited = new HashSet<Object>();
        ArrayDeque searchList = new ArrayDeque();
        searchList.add(new SearchState(Collections.emptyList(), start));
        while (!searchList.isEmpty()) {
            SearchState state = (SearchState)searchList.removeFirst();
            if (visited.contains(state.current)) continue;
            visited.add(state.current);
            ArrayList<Object> newPath = new ArrayList<Object>(state.path);
            newPath.add(state.current);
            if (matcher.apply(state.current)) {
                return newPath;
            }
            Collection nexts = (Collection)nextFunction.apply(state.current);
            for (Object next : nexts) {
                searchList.add(new SearchState(newPath, next));
            }
        }
        return null;
    }

    static class SearchState<T> {
        private final List<T> path;
        private final T current;

        public SearchState(List<T> path, T current) {
            this.path = path;
            this.current = current;
        }

        public String toString() {
            return this.path.toString() + this.current.toString();
        }
    }
}

