/*
 * Decompiled with CFR 0.152.
 */
package com.rosetta.model.lib.qualify;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.qualify.QualifyResult;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

public class QualifyResultsExtractor<T extends RosettaModelObject> {
    private final List<Function<? super T, QualifyResult>> qualifyFunctions;
    private final T model;

    public QualifyResultsExtractor(List<Function<? super T, QualifyResult>> qualifyFunctions, T model) {
        this.qualifyFunctions = qualifyFunctions;
        this.model = model;
    }

    public T getModelObject() {
        return this.model;
    }

    public List<QualifyResult> getAllResults() {
        List<QualifyResult> allResults = this.qualifyFunctions.stream().map(x -> (QualifyResult)x.apply(this.model)).collect(Collectors.toList());
        Collections.sort(allResults);
        return allResults;
    }

    public Optional<QualifyResult> getOnlySuccessResult() {
        List matchedResults = this.getAllResults().stream().filter(x -> x.isSuccess()).collect(Collectors.toList());
        return matchedResults.size() == 1 ? Optional.of((QualifyResult)matchedResults.get(0)) : Optional.empty();
    }
}

