/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.testing.transform;

import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.io.Resources;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.regnosys.rosetta.common.serialisation.RosettaObjectMapper;
import com.regnosys.rosetta.common.transform.PipelineModel;
import com.regnosys.rosetta.common.transform.TestPackModel;
import com.regnosys.rosetta.common.transform.TestPackUtils;
import com.regnosys.rosetta.common.util.UrlUtils;
import com.regnosys.testing.TestingExpectationUtil;
import com.regnosys.testing.pipeline.PipelineFunctionResult;
import com.regnosys.testing.pipeline.PipelineFunctionRunner;
import com.regnosys.testing.pipeline.PipelineFunctionRunnerProvider;
import com.regnosys.testing.transform.TransformExpectationUtil;
import com.regnosys.testing.transform.TransformTestResult;
import jakarta.inject.Inject;
import java.net.URL;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.params.provider.Arguments;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class TransformTestExtension<T>
implements BeforeAllCallback,
AfterAllCallback {
    public static final String EMPTY_OUTPUT = "";
    private static final Logger LOGGER = LoggerFactory.getLogger(TransformTestExtension.class);
    private static final ObjectMapper JSON_OBJECT_MAPPER = RosettaObjectMapper.getNewRosettaObjectMapper();
    private final String modelId;
    private final Module runtimeModule;
    private final Path configPath;
    private final Class<T> funcType;
    @Inject
    PipelineFunctionRunnerProvider functionRunnerProvider;
    private ObjectWriter jsonObjectWriter = JSON_OBJECT_MAPPER.configure(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY, true).writerWithDefaultPrettyPrinter();
    private Validator outputXsdValidator;
    private boolean includeAllPipelinesForFunction;
    private List<PipelineModel> functionPipelineModels;
    private Multimap<String, TransformTestResult> actualExpectation;
    private final Map<String, PipelineFunctionRunner> pipelineIdFunctionRunnerMap = new HashMap<String, PipelineFunctionRunner>();

    public TransformTestExtension(Module runtimeModule, Path configPath, Class<T> funcType) {
        this.runtimeModule = runtimeModule;
        this.configPath = configPath;
        this.funcType = funcType;
        this.modelId = null;
        this.includeAllPipelinesForFunction = false;
    }

    public TransformTestExtension(String modelId, Module runtimeModule, Path configPath, Class<T> funcType) {
        this.modelId = modelId;
        this.runtimeModule = runtimeModule;
        this.configPath = configPath;
        this.funcType = funcType;
        this.includeAllPipelinesForFunction = false;
    }

    public TransformTestExtension<T> withSortJsonPropertiesAlphabetically(boolean sortJsonPropertiesAlphabetically) {
        this.jsonObjectWriter = JSON_OBJECT_MAPPER.configure(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY, sortJsonPropertiesAlphabetically).writerWithDefaultPrettyPrinter();
        return this;
    }

    public TransformTestExtension<T> withSchemaValidation(URL outputXsdSchema) {
        try {
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            schemaFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", false);
            Schema schema = schemaFactory.newSchema(outputXsdSchema);
            this.outputXsdValidator = schema.newValidator();
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    public TransformTestExtension<T> withIncludeAllPipelinesForFunction(boolean includeAllPipelinesForFunction) {
        this.includeAllPipelinesForFunction = includeAllPipelinesForFunction;
        return this;
    }

    @BeforeAll
    public void beforeAll(ExtensionContext context) {
        Injector injector = Guice.createInjector((Module[])new Module[]{this.runtimeModule});
        injector.injectMembers((Object)this);
        ClassLoader classLoader = this.getClass().getClassLoader();
        List allPipelineModels = TestPackUtils.getPipelineModels((Path)this.configPath, (ClassLoader)classLoader, (ObjectMapper)JSON_OBJECT_MAPPER);
        this.functionPipelineModels = this.includeAllPipelinesForFunction ? TestPackUtils.getPipelineModels((List)allPipelineModels, (String)this.funcType.getName()) : Collections.singletonList(TestPackUtils.getPipelineModel((List)allPipelineModels, (String)this.funcType.getName(), (String)this.modelId));
        this.functionPipelineModels.forEach(m -> {
            Class<?> inputType = this.toClass(classLoader, m.getTransform().getInputType());
            PipelineFunctionRunner pipelineFunctionRunner = this.functionRunnerProvider.create(m.getTransform().getType(), inputType, this.funcType, m.getInputSerialisation(), m.getOutputSerialisation(), JSON_OBJECT_MAPPER, this.jsonObjectWriter, this.outputXsdValidator);
            this.pipelineIdFunctionRunnerMap.put(m.getId(), pipelineFunctionRunner);
        });
        this.actualExpectation = ArrayListMultimap.create();
    }

    private Class<?> toClass(ClassLoader classLoader, String type) {
        try {
            return classLoader.loadClass(type);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Failed to load class " + type, e);
        }
    }

    @AfterAll
    public void afterAll(ExtensionContext context) throws Exception {
        this.writeExpectations(this.actualExpectation);
    }

    public void runTransformAndAssert(String testPackId, TestPackModel.SampleModel sampleModel) {
        if (this.includeAllPipelinesForFunction) {
            throw new IllegalArgumentException("To test with option includeAllPipelinesForFunction, use method runTransformAndAssert(pipelineId, testPackId, sampleModel)");
        }
        PipelineFunctionRunner pipelineFunctionRunner = this.pipelineIdFunctionRunnerMap.values().iterator().next();
        this.runTransformAndAssert(testPackId, sampleModel, pipelineFunctionRunner);
    }

    public void runTransformAndAssert(String pipelineId, String testPackId, TestPackModel.SampleModel sampleModel) {
        PipelineFunctionRunner pipelineFunctionRunner = this.pipelineIdFunctionRunnerMap.get(pipelineId);
        this.runTransformAndAssert(testPackId, sampleModel, pipelineFunctionRunner);
    }

    private void runTransformAndAssert(String testPackId, TestPackModel.SampleModel sampleModel, PipelineFunctionRunner pipelineFunctionRunner) {
        URL inputPath = this.getInputFileUrl(sampleModel.getInputPath());
        Assertions.assertNotNull((Object)inputPath);
        PipelineFunctionResult result = pipelineFunctionRunner.run(UrlUtils.toPath((URL)inputPath));
        String actualOutput = result.getSerialisedOutput();
        TestPackModel.SampleModel.Assertions actualAssertions = result.getAssertions();
        if (TestingExpectationUtil.WRITE_EXPECTATIONS) {
            this.actualExpectation.put((Object)testPackId, (Object)new TransformTestResult(actualOutput, this.updateSampleModel(sampleModel, actualAssertions)));
        }
        String expectedOutput = TestingExpectationUtil.readStringFromResources(Path.of(sampleModel.getOutputPath(), new String[0]));
        Assertions.assertEquals((Object)expectedOutput, (Object)actualOutput);
        TestPackModel.SampleModel.Assertions expectedAssertions = sampleModel.getAssertions();
        Assertions.assertEquals((Object)expectedAssertions, (Object)actualAssertions);
    }

    private URL getInputFileUrl(String inputFile) {
        try {
            return Resources.getResource((String)inputFile);
        }
        catch (IllegalArgumentException e) {
            LOGGER.error("Failed to load input file {}", (Object)inputFile);
            return null;
        }
    }

    public Stream<Arguments> getArguments() {
        ClassLoader classLoader = this.getClass().getClassLoader();
        List testPackModels = this.functionPipelineModels.stream().map(p -> TestPackUtils.getTestPackModels((List)TestPackUtils.getTestPackModels((Path)this.configPath, (ClassLoader)classLoader, (ObjectMapper)JSON_OBJECT_MAPPER), (String)p.getId())).flatMap(Collection::stream).toList();
        return testPackModels.stream().flatMap(testPackModel -> testPackModel.getSamples().stream().map(sampleModel -> Arguments.of((Object[])new Object[]{String.format("%s | %s", testPackModel.getName(), sampleModel.getId()), testPackModel.getId(), sampleModel, testPackModel.getPipelineId()})));
    }

    protected void writeExpectations(Multimap<String, TransformTestResult> actualExpectation) throws Exception {
        TransformExpectationUtil.writeExpectations(actualExpectation, this.configPath);
    }

    private TestPackModel.SampleModel updateSampleModel(TestPackModel.SampleModel sampleModel, TestPackModel.SampleModel.Assertions assertions) {
        return new TestPackModel.SampleModel(sampleModel.getId(), sampleModel.getName(), sampleModel.getInputPath(), sampleModel.getOutputPath(), assertions);
    }
}

