/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.testing.schemeimport;

import com.regnosys.rosetta.rosetta.RosettaEnumValue;
import com.regnosys.rosetta.rosetta.RosettaEnumeration;
import com.regnosys.rosetta.rosetta.RosettaModel;
import com.regnosys.testing.schemeimport.AnnotatedRosettaEnumReader;
import com.regnosys.testing.schemeimport.RosettaResourceWriter;
import com.regnosys.testing.schemeimport.SchemeEnumReader;
import jakarta.inject.Inject;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.resource.Resource;

public class SchemeImporter {
    @Inject
    private AnnotatedRosettaEnumReader enumReader;
    @Inject
    private RosettaResourceWriter rosettaResourceWriter;

    public Map<String, String> generateRosettaEnums(List<RosettaEnumeration> enums) {
        Map<Resource, List<RosettaEnumeration>> enumsGroupedByRosettaResource = enums.stream().collect(Collectors.groupingBy(x -> x.eContainer().eResource()));
        return this.rosettaResourceWriter.generateRosettaFiles(enumsGroupedByRosettaResource.keySet());
    }

    public List<RosettaEnumValue> getEnumValuesFromCodingScheme(RosettaEnumeration annotatedEnum, SchemeEnumReader schemeEnumReader) {
        return this.enumReader.getSchemaLocationForEnum(annotatedEnum).map(schemaLocationForEnum -> {
            try {
                return schemeEnumReader.generateEnumFromScheme(new URL((String)schemaLocationForEnum));
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }).orElse(List.of());
    }

    public List<RosettaEnumeration> getRosettaEnumsFromModel(List<RosettaModel> models, String body, String corpus) {
        return this.enumReader.getAnnotatedEnum(models, body, corpus);
    }
}

