/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.testing.reports;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import com.google.inject.Injector;
import com.regnosys.rosetta.common.util.ClassPathUtils;
import com.regnosys.rosetta.common.util.UrlUtils;
import com.regnosys.rosetta.generator.java.types.JavaTypeTranslator;
import com.regnosys.rosetta.generator.java.types.RGeneratedJavaClass;
import com.regnosys.rosetta.rosetta.RosettaModel;
import com.regnosys.rosetta.rosetta.RosettaReport;
import com.regnosys.rosetta.transgest.ModelLoader;
import com.regnosys.rosetta.types.RAttribute;
import com.regnosys.rosetta.types.RDataType;
import com.regnosys.rosetta.types.RFunction;
import com.regnosys.rosetta.types.RObjectFactory;
import com.regnosys.rosetta.types.RType;
import com.regnosys.rosetta.utils.ModelIdProvider;
import com.rosetta.model.lib.ModelReportId;
import com.rosetta.model.lib.functions.LabelProvider;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.util.DottedPath;
import jakarta.inject.Inject;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportTypeSummariser {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReportTypeSummariser.class);
    private final ModelLoader modelLoader;
    private final Injector injector;
    private final RObjectFactory rObjectFactory;
    private final JavaTypeTranslator javaTypeTranslator;
    private final ModelIdProvider modelIdProvider;

    @Inject
    public ReportTypeSummariser(ModelLoader modelLoader, Injector injector, RObjectFactory rObjectFactory, JavaTypeTranslator javaTypeTranslator) {
        this.modelLoader = modelLoader;
        this.injector = injector;
        this.rObjectFactory = rObjectFactory;
        this.javaTypeTranslator = javaTypeTranslator;
        this.modelIdProvider = new ModelIdProvider();
    }

    public void createTypeSummaryForReports(String classpathDir, DottedPath namespace, Set<String> excludedReportsFilter, String version, Path basePath) {
        List<RosettaModel> models = this.getModels(classpathDir);
        this.findReports(models, namespace, excludedReportsFilter).forEach(report -> {
            ModelReportId reportId = this.modelIdProvider.getReportId(report);
            LOGGER.info("Creating report type summary for {}", (Object)reportId);
            RDataType rReportType = this.rObjectFactory.buildRDataType(report.getReportType());
            RFunction rFunction = this.rObjectFactory.buildRFunction(report);
            LabelProvider labelProvider = this.getLabelProvider(rFunction);
            ArrayListMultimap collectedTypeAttributes = ArrayListMultimap.create();
            this.collectTypeAttributes(rReportType, null, labelProvider, (Multimap<RType, Data>)collectedTypeAttributes);
            String content = this.writeReportTypeSummary((Multimap<RType, Data>)collectedTypeAttributes);
            this.writeFile(basePath.resolve(this.getFileName((RosettaReport)report, version)), content);
        });
    }

    public void mergeTypeSummaryForReports(String classpathDir, DottedPath namespace, Set<String> excludedReportsFilter, String branch1, String branch2, Path basePath) {
        List<RosettaModel> models = this.getModels(classpathDir);
        for (RosettaReport report : this.findReports(models, namespace, excludedReportsFilter)) {
            ModelReportId reportId = this.modelIdProvider.getReportId(report);
            LOGGER.info("Merging report type data for {}", (Object)reportId);
            Path file1 = basePath.resolve(this.getFileName(report, branch1));
            if (!Files.exists(file1, new LinkOption[0])) {
                LOGGER.info("{} not found for {} version {}", new Object[]{file1, reportId, branch1});
                continue;
            }
            Path file2 = basePath.resolve(this.getFileName(report, branch2));
            if (!Files.exists(file2, new LinkOption[0])) {
                LOGGER.info("{} not found for {} version {}", new Object[]{file2, reportId, branch2});
                continue;
            }
            Multimap<String, Data> content1 = this.getLabelToDataMap(file1);
            Multimap<String, Data> content2 = this.getLabelToDataMap(file2);
            Set keys = Stream.of(content1.keySet(), content2.keySet()).flatMap(Collection::stream).sorted().collect(Collectors.toCollection(LinkedHashSet::new));
            StringBuilder sb = new StringBuilder();
            sb.append(String.format("%s||||%s||\n", branch1, branch2));
            sb.append("Label|Path|Type||Label|Path|Type\n");
            for (String key : keys) {
                Iterator data1 = content1.get((Object)key).iterator();
                Iterator data2 = content2.get((Object)key).iterator();
                while (data1.hasNext() || data2.hasNext()) {
                    sb.append(data1.hasNext() ? ((Data)data1.next()).toExcelFormat() : "||");
                    sb.append("||");
                    sb.append(data2.hasNext() ? ((Data)data2.next()).toExcelFormat() : "||");
                    sb.append("\n");
                }
            }
            this.writeFile(basePath.resolve(this.getFileName(report, "merged")), sb.toString());
        }
    }

    public void mergeTypeSummaryForReport(String classpathDir, ModelReportId reportId1, String branch1, ModelReportId reportId2, String branch2, Path basePath) {
        List<RosettaModel> models = this.getModels(classpathDir);
        RosettaReport report1 = this.findReport(models, reportId1);
        LOGGER.info("Merging report type data for {}", (Object)reportId1);
        Path file1 = basePath.resolve(this.getFileName(report1, branch1));
        if (!Files.exists(file1, new LinkOption[0])) {
            LOGGER.info("{} not found for {} version {}", new Object[]{file1, reportId1, branch1});
            return;
        }
        RosettaReport report2 = this.findReport(models, reportId2);
        Path file2 = basePath.resolve(this.getFileName(report2, branch2));
        if (!Files.exists(file2, new LinkOption[0])) {
            LOGGER.info("{} not found for {} version {}", new Object[]{file2, report2, branch2});
            return;
        }
        Multimap<String, Data> content1 = this.getLabelToDataMap(file1);
        Multimap<String, Data> content2 = this.getLabelToDataMap(file2);
        Set keys = Stream.of(content1.keySet(), content2.keySet()).flatMap(Collection::stream).sorted().collect(Collectors.toCollection(LinkedHashSet::new));
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("%s||||%s||\n", file1.getFileName(), file2.getFileName()));
        sb.append("Label|Path|Type||Label|Path|Type\n");
        for (String key : keys) {
            Iterator data1 = content1.get((Object)key).iterator();
            Iterator data2 = content2.get((Object)key).iterator();
            while (data1.hasNext() || data2.hasNext()) {
                sb.append(data1.hasNext() ? ((Data)data1.next()).toExcelFormat() : "||");
                sb.append("||");
                sb.append(data2.hasNext() ? ((Data)data2.next()).toExcelFormat() : "||");
                sb.append("\n");
            }
        }
        this.writeFile(basePath.resolve(this.getFileName(report2, "merged")), sb.toString());
    }

    @NotNull
    private String getFileName(RosettaReport report, String version) {
        ModelReportId reportId = this.modelIdProvider.getReportId(report);
        return String.format("%s-%s.csv", reportId.joinRegulatoryReference("-"), version);
    }

    private String writeReportTypeSummary(Multimap<RType, Data> typeAttributeMap) {
        StringBuilder sb = new StringBuilder();
        typeAttributeMap.values().stream().filter(x -> x.label != null).map(Data::toExcelFormat).sorted().forEach(s -> sb.append((String)s).append("\n"));
        return sb.toString();
    }

    private List<RosettaModel> getModels(String classpathDir) {
        List<URL> urls = ClassPathUtils.findPathsFromClassPath((Collection)ImmutableList.of((Object)"model", (Object)classpathDir), (String)".*\\.rosetta", Optional.empty(), (ClassLoader)this.getClass().getClassLoader()).stream().map(UrlUtils::toUrl).toList();
        List models = this.modelLoader.loadRosettaModels(urls.stream());
        if (models.size() <= 2) {
            throw new IllegalArgumentException("No model rosetta files found.  Only found basic types and annotations rosetta files.");
        }
        return models;
    }

    private LabelProvider getLabelProvider(RFunction rFunction) {
        try {
            RGeneratedJavaClass labelProviderJavaClass = this.javaTypeTranslator.toLabelProviderJavaClass(rFunction);
            Class<?> labelProviderClass = this.getClass().getClassLoader().loadClass(labelProviderJavaClass.getCanonicalName().toString());
            return (LabelProvider)this.injector.getInstance(labelProviderClass);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private Set<RosettaReport> findReports(List<RosettaModel> models, DottedPath namespace, Set<String> excludedReportsFilter) {
        return models.stream().map(RosettaModel::getElements).flatMap(Collection::stream).filter(RosettaReport.class::isInstance).map(RosettaReport.class::cast).filter(r -> this.modelIdProvider.toDottedPath(r.getModel()).startsWith(namespace)).filter(r -> Arrays.stream(this.modelIdProvider.getReportId(r).getCorpusList()).noneMatch(excludedReportsFilter::contains)).collect(Collectors.toSet());
    }

    private RosettaReport findReport(List<RosettaModel> models, ModelReportId reportId) {
        return models.stream().map(RosettaModel::getElements).flatMap(Collection::stream).filter(RosettaReport.class::isInstance).map(RosettaReport.class::cast).filter(r -> this.modelIdProvider.getReportId(r).equals((Object)reportId)).findFirst().orElseThrow();
    }

    private void collectTypeAttributes(RDataType parentDataType, RosettaPath path, LabelProvider labelProvider, Multimap<RType, Data> visitor) {
        parentDataType.getAllAttributes().forEach(attribute -> {
            RosettaPath.Element pathElement = this.getPathElement((RAttribute)attribute);
            RosettaPath attributePath = Optional.ofNullable(path).map(p -> p.newSubPath(pathElement)).orElse(RosettaPath.createPath((RosettaPath.Element)pathElement));
            RType attributeType = attribute.getRMetaAnnotatedType().getRType();
            if (attributeType instanceof RDataType) {
                RDataType childDataType = (RDataType)attributeType;
                this.collectTypeAttributes(childDataType, attributePath, labelProvider, visitor);
            } else {
                String label = labelProvider.getLabel(attributePath);
                if (label != null) {
                    visitor.put((Object)parentDataType, (Object)Data.of(label, attributePath, attribute));
                }
            }
        });
    }

    private RosettaPath.Element getPathElement(RAttribute attribute) {
        String name = attribute.getName();
        return RosettaPath.Element.create((String)name, (OptionalInt)(attribute.isMulti() ? OptionalInt.of(0) : OptionalInt.empty()), Map.of());
    }

    private void writeFile(Path writePath, String content) {
        try {
            Files.createDirectories(writePath.getParent(), new FileAttribute[0]);
            Files.write(writePath, content.getBytes(), new OpenOption[0]);
            LOGGER.info("Wrote output to {}", (Object)writePath);
        }
        catch (IOException e) {
            LOGGER.error("Failed to write output to {}", (Object)writePath, (Object)e);
        }
    }

    @NotNull
    private Multimap<String, Data> getLabelToDataMap(Path path) {
        ArrayListMultimap labelToDataMap = ArrayListMultimap.create();
        try {
            Files.readAllLines(path).stream().map(Data::parseExcelFormat).forEach(arg_0 -> ReportTypeSummariser.lambda$getLabelToDataMap$8((Multimap)labelToDataMap, arg_0));
            return labelToDataMap;
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to read line from path " + String.valueOf(path), e);
        }
    }

    private static /* synthetic */ void lambda$getLabelToDataMap$8(Multimap labelToDataMap, Data d) {
        labelToDataMap.put((Object)d.getLabel(), (Object)d);
    }

    private static class Data {
        private final String label;
        private final String path;
        private final String type;

        private Data(String label, String path, String type) {
            this.label = label;
            this.path = path;
            this.type = type;
        }

        static Data of(String label, RosettaPath path, RAttribute rAttribute) {
            return new Data(label, path.buildPath().replace("(0)", "[]"), rAttribute.getRMetaAnnotatedType().getRType().getName());
        }

        static Data parseExcelFormat(String excelRow) {
            String[] parts = excelRow.split("\\|");
            return new Data(parts[0], parts[1], parts[2]);
        }

        public String getLabel() {
            return this.label;
        }

        String toExcelFormat() {
            return String.format("%s|%s|%s", this.label, this.path, this.type);
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Data data = (Data)o;
            return Objects.equals(this.label, data.label) && Objects.equals(this.path, data.path) && Objects.equals(this.type, data.type);
        }

        public int hashCode() {
            return Objects.hash(this.label, this.path, this.type);
        }

        public String toString() {
            return "Data{label='" + this.label + "', path='" + this.path + "', type='" + this.type + "'}";
        }
    }
}

